/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDODataFactoryDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;

public class SDOHelperContext
implements HelperContext {
    private CopyHelper copyHelper = new SDOCopyHelper(this);
    private DataFactory dataFactory = new SDODataFactoryDelegate(this);
    private DataHelper dataHelper = new SDODataHelper(this);
    private EqualityHelper equalityHelper = new SDOEqualityHelper(this);
    private XMLHelper xmlHelper;
    private TypeHelper typeHelper;
    private XSDHelper xsdHelper;
    private static Map<Object, HelperContext> helperContexts = new WeakHashMap<Object, HelperContext>();
    private static String OC4J_CLASSLOADER_NAME = "oracle";
    private static String WLS_CLASSLOADER_NAME = "weblogic";
    private static MBeanServer wlsMBeanServer = null;
    private static ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final Class[] PARAMETER_TYPES = new Class[0];

    public SDOHelperContext() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(ClassLoader aClassLoader) {
        this.xmlHelper = new SDOXMLHelperDelegate(this, aClassLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public void reset() {
        ((SDOTypeHelper)this.getTypeHelper()).reset();
        ((SDOXMLHelper)this.getXMLHelper()).reset();
        ((SDOXSDHelper)this.getXSDHelper()).reset();
    }

    public CopyHelper getCopyHelper() {
        return this.copyHelper;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public DataHelper getDataHelper() {
        return this.dataHelper;
    }

    public EqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public XMLHelper getXMLHelper() {
        return this.xmlHelper;
    }

    public XSDHelper getXSDHelper() {
        return this.xsdHelper;
    }

    public ExternalizableDelegator.Resolvable createResolvable() {
        return new SDOResolvable(this);
    }

    public ExternalizableDelegator.Resolvable createResolvable(Object target) {
        return new SDOResolvable(target, this);
    }

    public static HelperContext getHelperContext() {
        Object key = SDOHelperContext.getDelegateMapKey();
        HelperContext hCtx = helperContexts.get(key);
        if (hCtx == null) {
            hCtx = new SDOHelperContext();
            helperContexts.put(key, hCtx);
        }
        return hCtx;
    }

    private static Object getDelegateMapKey() {
        Object executeThread;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String classLoaderName = classLoader.getClass().getName();
        Object delegateKey = classLoader;
        if (classLoaderName.startsWith(OC4J_CLASSLOADER_NAME)) {
            if (classLoader.getParent() != null && (classLoader.toString().indexOf(".web.") != -1 || classLoader.toString().indexOf(".wrappers") != -1)) {
                classLoader = classLoader.getParent();
            }
            delegateKey = classLoader;
        } else if (classLoaderName.contains(WLS_CLASSLOADER_NAME) && (executeThread = SDOHelperContext.getExecuteThread()) != null) {
            try {
                Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), (String)WLS_APPLICATION_NAME_GET_METHOD_NAME, (Class[])PARAMETER_TYPES, (boolean)false);
                delegateKey = PrivilegedAccessHelper.invokeMethod((Method)getMethod, (Object)executeThread);
                if (delegateKey == null) {
                    delegateKey = classLoader;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return delegateKey;
    }

    private static Object getExecuteThread() {
        if (wlsMBeanServer == null) {
            InitialContext weblogicContext = null;
            try {
                weblogicContext = new InitialContext();
                try {
                    wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_ENV_CONTEXT_LOOKUP);
                }
                catch (NamingException e) {
                    try {
                        wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_CONTEXT_LOOKUP);
                    }
                    catch (NamingException namingException) {}
                }
            }
            catch (NamingException nex) {
                // empty catch block
            }
        }
        if (wlsMBeanServer != null) {
            if (wlsThreadPoolRuntime == null) {
                try {
                    ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                    ObjectName serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                    wlsThreadPoolRuntime = (ObjectName)wlsMBeanServer.getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (wlsThreadPoolRuntime != null) {
                try {
                    return wlsMBeanServer.invoke(wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

