/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDODataFactoryDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;

public class SDOHelperContext
implements HelperContext {
    protected CopyHelper copyHelper;
    protected DataFactory dataFactory;
    protected DataHelper dataHelper;
    protected EqualityHelper equalityHelper;
    protected XMLHelper xmlHelper;
    protected TypeHelper typeHelper;
    protected XSDHelper xsdHelper;
    private static ConcurrentHashMap<Object, HelperContext> helperContexts = new ConcurrentHashMap();
    private static WeakHashMap<ClassLoader, HelperContext> userSetHelperContexts = new WeakHashMap();
    private static String OC4J_CLASSLOADER_NAME = "oracle";
    private static String WLS_CLASSLOADER_NAME = "weblogic";
    private static MBeanServer wlsMBeanServer = null;
    private static ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_APP_RUNTIMES = "ApplicationRuntimes";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME = "ApplicationName";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final String WLS_ACTIVE_VERSION_STATE = "ActiveVersionState";
    private static final Class[] PARAMETER_TYPES = new Class[0];

    public SDOHelperContext() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(ClassLoader aClassLoader) {
        this.initialize(aClassLoader);
    }

    protected void initialize(ClassLoader aClassLoader) {
        this.copyHelper = new SDOCopyHelper(this);
        this.dataFactory = new SDODataFactoryDelegate(this);
        this.dataHelper = new SDODataHelper(this);
        this.equalityHelper = new SDOEqualityHelper(this);
        this.xmlHelper = new SDOXMLHelperDelegate(this, aClassLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public void reset() {
        ((SDOTypeHelper)this.getTypeHelper()).reset();
        ((SDOXMLHelper)this.getXMLHelper()).reset();
        ((SDOXSDHelper)this.getXSDHelper()).reset();
    }

    public CopyHelper getCopyHelper() {
        return this.copyHelper;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public DataHelper getDataHelper() {
        return this.dataHelper;
    }

    public EqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public XMLHelper getXMLHelper() {
        return this.xmlHelper;
    }

    public XSDHelper getXSDHelper() {
        return this.xsdHelper;
    }

    public ExternalizableDelegator.Resolvable createResolvable() {
        return new SDOResolvable(this);
    }

    public ExternalizableDelegator.Resolvable createResolvable(Object target) {
        return new SDOResolvable(target, this);
    }

    public static void putHelperContext(ClassLoader key, HelperContext value) {
        if (key == null || value == null) {
            return;
        }
        userSetHelperContexts.put(key, value);
    }

    public static void removeHelperContext(ClassLoader key) {
        if (key == null) {
            return;
        }
        userSetHelperContexts.remove(key);
    }

    public static HelperContext getHelperContext() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        HelperContext hCtx = userSetHelperContexts.get(contextClassLoader);
        if (hCtx != null) {
            return hCtx;
        }
        Object key = SDOHelperContext.getDelegateMapKey(contextClassLoader);
        hCtx = helperContexts.get(key);
        if (hCtx == null) {
            hCtx = new SDOHelperContext();
            HelperContext existingCtx = helperContexts.putIfAbsent(key, hCtx);
            if (existingCtx != null) {
                hCtx = existingCtx;
            }
            SDOHelperContext.addNotificationListener(key);
        }
        return hCtx;
    }

    private static void resetHelperContext(Object key) {
        HelperContext hCtx = helperContexts.get(key);
        if (hCtx != null) {
            helperContexts.remove(key);
        }
    }

    private static Object getDelegateMapKey(ClassLoader classLoader) {
        Object executeThread;
        String classLoaderName = classLoader.getClass().getName();
        Object delegateKey = classLoader;
        if (classLoaderName.startsWith(OC4J_CLASSLOADER_NAME)) {
            if (classLoader.getParent() != null && (classLoader.toString().indexOf(".web.") != -1 || classLoader.toString().indexOf(".wrappers") != -1)) {
                classLoader = classLoader.getParent();
            }
            delegateKey = classLoader;
        } else if (classLoaderName.contains(WLS_CLASSLOADER_NAME) && (executeThread = SDOHelperContext.getExecuteThread()) != null) {
            try {
                Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), (String)WLS_APPLICATION_NAME_GET_METHOD_NAME, (Class[])PARAMETER_TYPES, (boolean)false);
                delegateKey = PrivilegedAccessHelper.invokeMethod((Method)getMethod, (Object)executeThread);
                if (delegateKey == null) {
                    delegateKey = classLoader;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return delegateKey;
    }

    private static MBeanServer getWLSMBeanServer() {
        if (wlsMBeanServer == null) {
            InitialContext weblogicContext = null;
            try {
                weblogicContext = new InitialContext();
                try {
                    wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_ENV_CONTEXT_LOOKUP);
                }
                catch (NamingException e) {
                    try {
                        wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_CONTEXT_LOOKUP);
                    }
                    catch (NamingException namingException) {}
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return wlsMBeanServer;
    }

    private static Object getExecuteThread() {
        if (SDOHelperContext.getWLSMBeanServer() != null) {
            if (wlsThreadPoolRuntime == null) {
                try {
                    ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                    ObjectName serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                    wlsThreadPoolRuntime = (ObjectName)wlsMBeanServer.getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception x) {
                    return null;
                }
            }
            try {
                return wlsMBeanServer.invoke(wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void addNotificationListener(Object mapKey) {
        if (Thread.currentThread().getContextClassLoader().getClass().getName().contains(WLS_CLASSLOADER_NAME) && SDOHelperContext.getWLSMBeanServer() != null) {
            try {
                ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                ObjectName serverRuntime = (ObjectName)wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                ObjectName[] appRuntimes = (ObjectName[])wlsMBeanServer.getAttribute(serverRuntime, WLS_APP_RUNTIMES);
                for (int i = 0; i < appRuntimes.length; ++i) {
                    try {
                        ObjectName appRuntime = appRuntimes[i];
                        Object appName = wlsMBeanServer.getAttribute(appRuntime, WLS_APPLICATION_NAME);
                        if (appName == null || !appName.toString().equals(mapKey)) continue;
                        wlsMBeanServer.addNotificationListener(appRuntime, new MyNotificationListener(appName.toString()), null, null);
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class MyNotificationListener
    implements NotificationListener {
        Object mapKey;

        public MyNotificationListener(Object mapKey) {
            this.mapKey = mapKey;
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AttributeChangeNotification) {
                try {
                    AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                    if (acn.getAttributeName().equals(SDOHelperContext.WLS_ACTIVE_VERSION_STATE) && acn.getNewValue().equals(new Integer(0))) {
                        SDOHelperContext.resetHelperContext(this.mapKey);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

