/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.types.SDOChangeSummaryType;
import org.eclipse.persistence.sdo.types.SDODataObjectType;
import org.eclipse.persistence.sdo.types.SDODataType;
import org.eclipse.persistence.sdo.types.SDOOpenSequencedType;
import org.eclipse.persistence.sdo.types.SDOTypeType;
import org.eclipse.persistence.sdo.types.SDOWrapperType;
import org.eclipse.persistence.sdo.types.SDOXMLHelperLoadOptionsType;
import org.eclipse.persistence.sessions.Project;

public class SDOTypeHelperDelegate
implements SDOTypeHelper {
    private Map typesHashMap;
    private Map<QName, SDOType> wrappersHashMap;
    private Map<Class, SDOType> interfacesToSDOTypeHashMap = new HashMap<Class, SDOType>();
    private final Map commonjHashMap = new HashMap();
    private final Map commonjJavaHashMap = new HashMap();
    private static final Map sdoTypeForSimpleJavaType = new HashMap();
    private final Map sdoToXSDTypes = new HashMap();
    private final Map xsdToSDOType = new HashMap();
    private Map openContentProperties;
    private List anonymousTypes;
    private HelperContext aHelperContext;
    private NamespaceResolver namespaceResolver;
    private SDOWrapperType SDO_BOOLEAN_WRAPPER;
    private SDOWrapperType SDO_BYTE_WRAPPER;
    private SDOWrapperType SDO_BYTES_WRAPPER;
    private SDOWrapperType SDO_CHARACTER_WRAPPER;
    private SDOWrapperType SDO_DATE_WRAPPER;
    private SDOWrapperType SDO_DATETIME_WRAPPER;
    private SDOWrapperType SDO_DAY_WRAPPER;
    private SDOWrapperType SDO_DECIMAL_WRAPPER;
    private SDOWrapperType SDO_DOUBLE_WRAPPER;
    private SDOWrapperType SDO_DURATION_WRAPPER;
    private SDOWrapperType SDO_FLOAT_WRAPPER;
    private SDOWrapperType SDO_INT_WRAPPER;
    private SDOWrapperType SDO_INTEGER_WRAPPER;
    private SDOWrapperType SDO_LONG_WRAPPER;
    private SDOWrapperType SDO_MONTH_WRAPPER;
    private SDOWrapperType SDO_MONTHDAY_WRAPPER;
    private SDOWrapperType SDO_OBJECT_WRAPPER;
    private SDOWrapperType SDO_SHORT_WRAPPER;
    private SDOWrapperType SDO_STRING_WRAPPER;
    private SDOWrapperType SDO_STRINGS_WRAPPER;
    private SDOWrapperType SDO_TIME_WRAPPER;
    private SDOWrapperType SDO_URI_WRAPPER;
    private SDOWrapperType SDO_YEAR_WRAPPER;
    private SDOWrapperType SDO_YEARMONTH_WRAPPER;
    private SDOWrapperType SDO_YEARMONTHDAY_WRAPPER;
    private SDOWrapperType SDO_BOOLEANOBJECT_WRAPPER;
    private SDOWrapperType SDO_BYTEOBJECT_WRAPPER;
    private SDOWrapperType SDO_CHARACTEROBJECT_WRAPPER;
    private SDOWrapperType SDO_DOUBLEOBJECT_WRAPPER;
    private SDOWrapperType SDO_FLOATOBJECT_WRAPPER;
    private SDOWrapperType SDO_INTOBJECT_WRAPPER;
    private SDOWrapperType SDO_LONGOBJECT_WRAPPER;
    private SDOWrapperType SDO_SHORTOBJECT_WRAPPER;

    public SDOTypeHelperDelegate(HelperContext helperContext) {
        this.aHelperContext = helperContext;
        this.initWrapperTypes();
        this.initTypesHashMap();
        this.initCommonjHashMap();
        this.initCommonjJavaHashMap();
        this.initXsdToSDOType();
        this.initSdoToXSDType();
        this.initOpenProps();
    }

    public void initWrapperTypes() {
        this.SDO_BOOLEAN_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BOOLEAN, "Boolean", (SDOTypeHelper)this, XMLConstants.BOOLEAN_QNAME);
        this.SDO_BYTE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTE, "Byte", (SDOTypeHelper)this, XMLConstants.BYTE_QNAME);
        this.SDO_BYTES_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTES, "Bytes", (SDOTypeHelper)this, new QName[]{XMLConstants.BASE_64_BINARY_QNAME, XMLConstants.HEX_BINARY_QNAME});
        this.SDO_CHARACTER_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_CHARACTER, "Character", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_DATE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DATE, "Date", (SDOTypeHelper)this, XMLConstants.DATE_QNAME);
        this.SDO_DATETIME_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DATETIME, "DateTime", (SDOTypeHelper)this, XMLConstants.DATE_TIME_QNAME);
        this.SDO_DAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DAY, "Day", (SDOTypeHelper)this, XMLConstants.G_DAY_QNAME);
        this.SDO_DECIMAL_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DECIMAL, "Decimal", (SDOTypeHelper)this, XMLConstants.DECIMAL_QNAME);
        this.SDO_DOUBLE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DOUBLE, "Double", (SDOTypeHelper)this, XMLConstants.DOUBLE_QNAME);
        this.SDO_DURATION_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DURATION, "Duration", (SDOTypeHelper)this, XMLConstants.DURATION_QNAME);
        this.SDO_FLOAT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_FLOAT, "Float", (SDOTypeHelper)this, XMLConstants.FLOAT_QNAME);
        this.SDO_INT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INT, "Int", (SDOTypeHelper)this, XMLConstants.INT_QNAME);
        this.SDO_INTEGER_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INTEGER, "Integer", (SDOTypeHelper)this, XMLConstants.INTEGER_QNAME);
        this.SDO_LONG_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_LONG, "Long", (SDOTypeHelper)this, XMLConstants.LONG_QNAME);
        this.SDO_MONTH_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_MONTH, "Month", (SDOTypeHelper)this, XMLConstants.G_MONTH_QNAME);
        this.SDO_MONTHDAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_MONTHDAY, "MonthDay", (SDOTypeHelper)this, XMLConstants.G_MONTH_DAY_QNAME);
        this.SDO_OBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_OBJECT, "Object", (SDOTypeHelper)this, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        this.SDO_SHORT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_SHORT, "Short", (SDOTypeHelper)this, XMLConstants.SHORT_QNAME);
        this.SDO_STRING_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_STRING, "String", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_STRINGS_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_STRINGS, "Strings", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_TIME_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_TIME, "Time", (SDOTypeHelper)this, XMLConstants.TIME_QNAME);
        this.SDO_URI_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_URI, "URI", (SDOTypeHelper)this, XMLConstants.ANY_URI_QNAME);
        this.SDO_YEAR_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEAR, "Year", (SDOTypeHelper)this, XMLConstants.G_YEAR_QNAME);
        this.SDO_YEARMONTH_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEARMONTH, "YearMonth", (SDOTypeHelper)this, XMLConstants.G_YEAR_MONTH_QNAME);
        this.SDO_YEARMONTHDAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEARMONTHDAY, "YearMonthDay", (SDOTypeHelper)this, XMLConstants.DATE_QNAME);
        this.SDO_BOOLEANOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BOOLEANOBJECT, "BooleanObject", (SDOTypeHelper)this, XMLConstants.BOOLEAN_QNAME);
        this.SDO_BYTEOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTEOBJECT, "ByteObject", (SDOTypeHelper)this, XMLConstants.BYTE_QNAME);
        this.SDO_CHARACTEROBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_CHARACTEROBJECT, "CharacterObject", (SDOTypeHelper)this, XMLConstants.STRING_QNAME);
        this.SDO_DOUBLEOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DOUBLEOBJECT, "DoubleObject", (SDOTypeHelper)this, XMLConstants.DOUBLE_QNAME);
        this.SDO_FLOATOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_FLOATOBJECT, "FloatObject", (SDOTypeHelper)this, XMLConstants.FLOAT_QNAME);
        this.SDO_INTOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INTOBJECT, "IntObject", (SDOTypeHelper)this, XMLConstants.INT_QNAME);
        this.SDO_LONGOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_LONGOBJECT, "LongObject", (SDOTypeHelper)this, XMLConstants.LONG_QNAME);
        this.SDO_SHORTOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_SHORTOBJECT, "ShortObject", (SDOTypeHelper)this, XMLConstants.SHORT_QNAME);
    }

    public void addWrappersToProject(Project project) {
        this.SDO_BOOLEAN_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTE_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTES_WRAPPER.addDescriptorToProject(project);
        this.SDO_CHARACTER_WRAPPER.addDescriptorToProject(project);
        this.SDO_DATE_WRAPPER.addDescriptorToProject(project);
        this.SDO_DATETIME_WRAPPER.addDescriptorToProject(project);
        this.SDO_DAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_DECIMAL_WRAPPER.addDescriptorToProject(project);
        this.SDO_DOUBLE_WRAPPER.addDescriptorToProject(project);
        this.SDO_DURATION_WRAPPER.addDescriptorToProject(project);
        this.SDO_FLOAT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INTEGER_WRAPPER.addDescriptorToProject(project);
        this.SDO_LONG_WRAPPER.addDescriptorToProject(project);
        this.SDO_MONTH_WRAPPER.addDescriptorToProject(project);
        this.SDO_MONTHDAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_OBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_SHORT_WRAPPER.addDescriptorToProject(project);
        this.SDO_STRING_WRAPPER.addDescriptorToProject(project);
        this.SDO_STRINGS_WRAPPER.addDescriptorToProject(project);
        this.SDO_TIME_WRAPPER.addDescriptorToProject(project);
        this.SDO_URI_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEAR_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEARMONTH_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEARMONTHDAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_BOOLEANOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTEOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_CHARACTEROBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_DOUBLEOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_FLOATOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INTOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_LONGOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_SHORTOBJECT_WRAPPER.addDescriptorToProject(project);
    }

    private void initCommonjHashMap() {
        this.commonjHashMap.put("Boolean", SDOConstants.SDO_BOOLEAN);
        this.commonjHashMap.put("Byte", SDOConstants.SDO_BYTE);
        this.commonjHashMap.put("Bytes", SDOConstants.SDO_BYTES);
        this.commonjHashMap.put("Character", SDOConstants.SDO_CHARACTER);
        SDODataObjectType sDODataObjectType = new SDODataObjectType(this);
        this.commonjHashMap.put(((SDOType)sDODataObjectType).getName(), sDODataObjectType);
        this.commonjHashMap.put("Date", SDOConstants.SDO_DATE);
        this.commonjHashMap.put("DateTime", SDOConstants.SDO_DATETIME);
        this.commonjHashMap.put("Day", SDOConstants.SDO_DAY);
        this.commonjHashMap.put("Decimal", SDOConstants.SDO_DECIMAL);
        this.commonjHashMap.put("Double", SDOConstants.SDO_DOUBLE);
        this.commonjHashMap.put("Duration", SDOConstants.SDO_DURATION);
        this.commonjHashMap.put("Float", SDOConstants.SDO_FLOAT);
        this.commonjHashMap.put("Int", SDOConstants.SDO_INT);
        this.commonjHashMap.put("Integer", SDOConstants.SDO_INTEGER);
        this.commonjHashMap.put("Long", SDOConstants.SDO_LONG);
        this.commonjHashMap.put("Month", SDOConstants.SDO_MONTH);
        this.commonjHashMap.put("MonthDay", SDOConstants.SDO_MONTHDAY);
        this.commonjHashMap.put("Object", SDOConstants.SDO_OBJECT);
        this.commonjHashMap.put("Short", SDOConstants.SDO_SHORT);
        this.commonjHashMap.put("String", SDOConstants.SDO_STRING);
        this.commonjHashMap.put("Strings", SDOConstants.SDO_STRINGS);
        this.commonjHashMap.put("Time", SDOConstants.SDO_TIME);
        this.commonjHashMap.put("Year", SDOConstants.SDO_YEAR);
        this.commonjHashMap.put("YearMonth", SDOConstants.SDO_YEARMONTH);
        this.commonjHashMap.put("YearMonthDay", SDOConstants.SDO_YEARMONTHDAY);
        this.commonjHashMap.put("URI", SDOConstants.SDO_URI);
        SDOChangeSummaryType sDOChangeSummaryType = new SDOChangeSummaryType(this);
        this.commonjHashMap.put(((SDOType)sDOChangeSummaryType).getName(), sDOChangeSummaryType);
        SDOTypeType sDOTypeType = new SDOTypeType(this);
        this.commonjHashMap.put(((SDOType)sDOTypeType).getName(), sDOTypeType);
    }

    private void initCommonjJavaHashMap() {
        this.commonjJavaHashMap.put("BooleanObject", SDOConstants.SDO_BOOLEANOBJECT);
        this.commonjJavaHashMap.put("ByteObject", SDOConstants.SDO_BYTEOBJECT);
        this.commonjJavaHashMap.put("CharacterObject", SDOConstants.SDO_CHARACTEROBJECT);
        this.commonjJavaHashMap.put("DoubleObject", SDOConstants.SDO_DOUBLEOBJECT);
        this.commonjJavaHashMap.put("FloatObject", SDOConstants.SDO_FLOATOBJECT);
        this.commonjJavaHashMap.put("IntObject", SDOConstants.SDO_INTOBJECT);
        this.commonjJavaHashMap.put("LongObject", SDOConstants.SDO_LONGOBJECT);
        this.commonjJavaHashMap.put("ShortObject", SDOConstants.SDO_SHORTOBJECT);
    }

    private void initTypesHashMap() {
        this.typesHashMap = new HashMap();
        SDOType sDOType = this.getType("commonj.sdo", "Type");
        SDOXMLHelperLoadOptionsType sDOXMLHelperLoadOptionsType = new SDOXMLHelperLoadOptionsType(this, sDOType);
        this.typesHashMap.put(sDOXMLHelperLoadOptionsType.getQName(), sDOXMLHelperLoadOptionsType);
        SDOOpenSequencedType sDOOpenSequencedType = new SDOOpenSequencedType(this);
        this.typesHashMap.put(sDOOpenSequencedType.getQName(), sDOOpenSequencedType);
        this.typesHashMap.put(this.SDO_BOOLEAN_WRAPPER.getQName(), this.SDO_BOOLEAN_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTE_WRAPPER.getQName(), this.SDO_BYTE_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTES_WRAPPER.getQName(), this.SDO_BYTES_WRAPPER);
        this.typesHashMap.put(this.SDO_CHARACTER_WRAPPER.getQName(), this.SDO_CHARACTER_WRAPPER);
        this.typesHashMap.put(this.SDO_DATE_WRAPPER.getQName(), this.SDO_DATE_WRAPPER);
        this.typesHashMap.put(this.SDO_DATETIME_WRAPPER.getQName(), this.SDO_DATETIME_WRAPPER);
        this.typesHashMap.put(this.SDO_DAY_WRAPPER.getQName(), this.SDO_DAY_WRAPPER);
        this.typesHashMap.put(this.SDO_DECIMAL_WRAPPER.getQName(), this.SDO_DECIMAL_WRAPPER);
        this.typesHashMap.put(this.SDO_DOUBLE_WRAPPER.getQName(), this.SDO_DOUBLE_WRAPPER);
        this.typesHashMap.put(this.SDO_DURATION_WRAPPER.getQName(), this.SDO_DURATION_WRAPPER);
        this.typesHashMap.put(this.SDO_FLOAT_WRAPPER.getQName(), this.SDO_FLOAT_WRAPPER);
        this.typesHashMap.put(this.SDO_INT_WRAPPER.getQName(), this.SDO_INT_WRAPPER);
        this.typesHashMap.put(this.SDO_INTEGER_WRAPPER.getQName(), this.SDO_INTEGER_WRAPPER);
        this.typesHashMap.put(this.SDO_LONG_WRAPPER.getQName(), this.SDO_LONG_WRAPPER);
        this.typesHashMap.put(this.SDO_MONTH_WRAPPER.getQName(), this.SDO_MONTH_WRAPPER);
        this.typesHashMap.put(this.SDO_MONTHDAY_WRAPPER.getQName(), this.SDO_MONTHDAY_WRAPPER);
        this.typesHashMap.put(this.SDO_OBJECT_WRAPPER.getQName(), this.SDO_OBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_SHORT_WRAPPER.getQName(), this.SDO_SHORT_WRAPPER);
        this.typesHashMap.put(this.SDO_STRING_WRAPPER.getQName(), this.SDO_STRING_WRAPPER);
        this.typesHashMap.put(this.SDO_STRINGS_WRAPPER.getQName(), this.SDO_STRINGS_WRAPPER);
        this.typesHashMap.put(this.SDO_TIME_WRAPPER.getQName(), this.SDO_TIME_WRAPPER);
        this.typesHashMap.put(this.SDO_URI_WRAPPER.getQName(), this.SDO_URI_WRAPPER);
        this.typesHashMap.put(this.SDO_YEAR_WRAPPER.getQName(), this.SDO_YEAR_WRAPPER);
        this.typesHashMap.put(this.SDO_YEARMONTH_WRAPPER.getQName(), this.SDO_YEARMONTH_WRAPPER);
        this.typesHashMap.put(this.SDO_YEARMONTHDAY_WRAPPER.getQName(), this.SDO_YEARMONTHDAY_WRAPPER);
        this.typesHashMap.put(this.SDO_BOOLEANOBJECT_WRAPPER.getQName(), this.SDO_BOOLEANOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTEOBJECT_WRAPPER.getQName(), this.SDO_BYTEOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_CHARACTEROBJECT_WRAPPER.getQName(), this.SDO_CHARACTEROBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_DOUBLEOBJECT_WRAPPER.getQName(), this.SDO_DOUBLEOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_FLOATOBJECT_WRAPPER.getQName(), this.SDO_FLOATOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_INTOBJECT_WRAPPER.getQName(), this.SDO_INTOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_LONGOBJECT_WRAPPER.getQName(), this.SDO_LONGOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_SHORTOBJECT_WRAPPER.getQName(), this.SDO_SHORTOBJECT_WRAPPER);
    }

    private void initWrappersHashMap() {
        this.wrappersHashMap = new HashMap<QName, SDOType>();
        this.wrappersHashMap.put(SDOConstants.SDO_BOOLEAN.getQName(), this.SDO_BOOLEAN_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTE.getQName(), this.SDO_BYTE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTES.getQName(), this.SDO_BYTES_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_CHARACTER.getQName(), this.SDO_CHARACTER_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DATE.getQName(), this.SDO_DATE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DATETIME.getQName(), this.SDO_DATETIME_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DAY.getQName(), this.SDO_DAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DECIMAL.getQName(), this.SDO_DECIMAL_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DOUBLE.getQName(), this.SDO_DOUBLE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DURATION.getQName(), this.SDO_DURATION_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_FLOAT.getQName(), this.SDO_FLOAT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INT.getQName(), this.SDO_INT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INTEGER.getQName(), this.SDO_INTEGER_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_LONG.getQName(), this.SDO_LONG_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_MONTH.getQName(), this.SDO_MONTH_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_MONTHDAY.getQName(), this.SDO_MONTHDAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_OBJECT.getQName(), this.SDO_OBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_SHORT.getQName(), this.SDO_SHORT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_STRING.getQName(), this.SDO_STRING_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_STRINGS.getQName(), this.SDO_STRINGS_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_TIME.getQName(), this.SDO_TIME_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_URI.getQName(), this.SDO_URI_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEAR.getQName(), this.SDO_YEAR_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEARMONTH.getQName(), this.SDO_YEARMONTH_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEARMONTHDAY.getQName(), this.SDO_YEARMONTHDAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BOOLEANOBJECT.getQName(), this.SDO_BOOLEANOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTEOBJECT.getQName(), this.SDO_BYTEOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_CHARACTEROBJECT.getQName(), this.SDO_CHARACTEROBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DOUBLEOBJECT.getQName(), this.SDO_DOUBLEOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_FLOATOBJECT.getQName(), this.SDO_FLOATOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INTOBJECT.getQName(), this.SDO_INTOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_LONGOBJECT.getQName(), this.SDO_LONGOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_SHORTOBJECT.getQName(), this.SDO_SHORTOBJECT_WRAPPER);
        for (SDOWrapperType sDOWrapperType : this.wrappersHashMap.values()) {
            for (XMLDescriptor xMLDescriptor : sDOWrapperType.getDescriptorsMap().values()) {
                this.interfacesToSDOTypeHashMap.put((Class)xMLDescriptor.getInterfacePolicy().getParentInterfaces().firstElement(), sDOWrapperType);
            }
        }
    }

    private void initSdoToXSDType() {
        this.sdoToXSDTypes.put(SDOConstants.SDO_BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTE, XMLConstants.BYTE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTES, XMLConstants.HEX_BINARY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_CHARACTER, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DATE, XMLConstants.DATE_TIME_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DATETIME, XMLConstants.DATE_TIME_QNAME);
        SDOType sDOType = this.getType("commonj.sdo", "DataObject");
        this.sdoToXSDTypes.put(sDOType, SDOConstants.ANY_TYPE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DAY, SDOConstants.GDAY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DECIMAL, XMLConstants.DECIMAL_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DOUBLE, XMLConstants.DOUBLE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DURATION, SDOConstants.DURATION_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_FLOAT, XMLConstants.FLOAT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INT, XMLConstants.INT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INTEGER, XMLConstants.INTEGER_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_LONG, XMLConstants.LONG_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_MONTH, SDOConstants.GMONTH_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_MONTHDAY, SDOConstants.GMONTHDAY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_OBJECT, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_SHORT, XMLConstants.SHORT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_STRING, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_STRINGS, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_TIME, XMLConstants.TIME_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEAR, SDOConstants.GYEAR_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTH, SDOConstants.GYEARMONTH_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTHDAY, XMLConstants.DATE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_URI, SDOConstants.ANY_URI_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BOOLEANOBJECT, XMLConstants.BOOLEAN_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTEOBJECT, XMLConstants.BYTE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_CHARACTEROBJECT, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DOUBLEOBJECT, XMLConstants.DOUBLE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_FLOATOBJECT, XMLConstants.FLOAT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INTOBJECT, XMLConstants.INT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_LONGOBJECT, XMLConstants.LONG_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_SHORTOBJECT, XMLConstants.SHORT_QNAME);
    }

    private void initXsdToSDOType() {
        this.xsdToSDOType.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, SDOConstants.SDO_OBJECT);
        SDOType sDOType = this.getType("commonj.sdo", "DataObject");
        this.xsdToSDOType.put(SDOConstants.ANY_TYPE_QNAME, sDOType);
        this.xsdToSDOType.put(SDOConstants.ANY_URI_QNAME, SDOConstants.SDO_URI);
        this.xsdToSDOType.put(XMLConstants.BASE_64_BINARY_QNAME, SDOConstants.SDO_BYTES);
        this.xsdToSDOType.put(XMLConstants.BOOLEAN_QNAME, SDOConstants.SDO_BOOLEAN);
        this.xsdToSDOType.put(XMLConstants.BYTE_QNAME, SDOConstants.SDO_BYTE);
        this.xsdToSDOType.put(XMLConstants.DATE_QNAME, SDOConstants.SDO_YEARMONTHDAY);
        this.xsdToSDOType.put(XMLConstants.DATE_TIME_QNAME, SDOConstants.SDO_DATETIME);
        this.xsdToSDOType.put(XMLConstants.DECIMAL_QNAME, SDOConstants.SDO_DECIMAL);
        this.xsdToSDOType.put(XMLConstants.DOUBLE_QNAME, SDOConstants.SDO_DOUBLE);
        this.xsdToSDOType.put(SDOConstants.DURATION_QNAME, SDOConstants.SDO_DURATION);
        this.xsdToSDOType.put(SDOConstants.ENTITIES_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(SDOConstants.ENTITY_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.FLOAT_QNAME, SDOConstants.SDO_FLOAT);
        this.xsdToSDOType.put(SDOConstants.GDAY_QNAME, SDOConstants.SDO_DAY);
        this.xsdToSDOType.put(SDOConstants.GMONTH_QNAME, SDOConstants.SDO_MONTH);
        this.xsdToSDOType.put(SDOConstants.GMONTHDAY_QNAME, SDOConstants.SDO_MONTHDAY);
        this.xsdToSDOType.put(SDOConstants.GYEAR_QNAME, SDOConstants.SDO_YEAR);
        this.xsdToSDOType.put(SDOConstants.GYEARMONTH_QNAME, SDOConstants.SDO_YEARMONTH);
        this.xsdToSDOType.put(XMLConstants.HEX_BINARY_QNAME, SDOConstants.SDO_BYTES);
        this.xsdToSDOType.put(SDOConstants.ID_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.IDREF_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.IDREFS_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(XMLConstants.INT_QNAME, SDOConstants.SDO_INT);
        this.xsdToSDOType.put(XMLConstants.INTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.LANGUAGE_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.LONG_QNAME, SDOConstants.SDO_LONG);
        this.xsdToSDOType.put(SDOConstants.NAME_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NCNAME_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NMTOKEN_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NMTOKENS_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(SDOConstants.NONNEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NONPOSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NORMALIZEDSTRING_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NOTATION_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.POSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(XMLConstants.QNAME_QNAME, SDOConstants.SDO_URI);
        this.xsdToSDOType.put(XMLConstants.SHORT_QNAME, SDOConstants.SDO_SHORT);
        this.xsdToSDOType.put(XMLConstants.STRING_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.TIME_QNAME, SDOConstants.SDO_TIME);
        this.xsdToSDOType.put(SDOConstants.TOKEN_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_BYTE_QNAME, SDOConstants.SDO_SHORT);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_INT_QNAME, SDOConstants.SDO_LONG);
        this.xsdToSDOType.put(SDOConstants.UNSIGNEDLONG_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_SHORT_QNAME, SDOConstants.SDO_INT);
    }

    private static void initSDOTypeForSimpleJavaTypeMap() {
        sdoTypeForSimpleJavaType.put(ClassConstants.STRING, SDOConstants.SDO_STRING);
        sdoTypeForSimpleJavaType.put(ClassConstants.BOOLEAN, SDOConstants.SDO_BOOLEANOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBOOLEAN, SDOConstants.SDO_BOOLEAN);
        sdoTypeForSimpleJavaType.put(ClassConstants.BYTE, SDOConstants.SDO_BYTEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBYTE, SDOConstants.SDO_BYTE);
        sdoTypeForSimpleJavaType.put(ClassConstants.ABYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.APBYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.CHAR, SDOConstants.SDO_CHARACTEROBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PCHAR, SDOConstants.SDO_CHARACTER);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGDECIMAL, SDOConstants.SDO_DECIMAL);
        sdoTypeForSimpleJavaType.put(ClassConstants.UTILDATE, SDOConstants.SDO_DATE);
        sdoTypeForSimpleJavaType.put(ClassConstants.DOUBLE, SDOConstants.SDO_DOUBLEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PDOUBLE, SDOConstants.SDO_DOUBLE);
        sdoTypeForSimpleJavaType.put(ClassConstants.FLOAT, SDOConstants.SDO_FLOATOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PFLOAT, SDOConstants.SDO_FLOAT);
        sdoTypeForSimpleJavaType.put(ClassConstants.INTEGER, SDOConstants.SDO_INTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PINT, SDOConstants.SDO_INT);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGINTEGER, SDOConstants.SDO_INTEGER);
        sdoTypeForSimpleJavaType.put(ClassConstants.LONG, SDOConstants.SDO_LONGOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PLONG, SDOConstants.SDO_LONG);
        sdoTypeForSimpleJavaType.put(ClassConstants.SHORT, SDOConstants.SDO_SHORTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PSHORT, SDOConstants.SDO_SHORT);
    }

    public Class getJavaWrapperTypeForSDOType(Type type) {
        if (type.getInstanceClass() != null) {
            return type.getInstanceClass();
        }
        Class clazz = null;
        if (type.getBaseTypes() != null) {
            for (int i = 0; i < type.getBaseTypes().size(); ++i) {
                Type type2 = (Type)type.getBaseTypes().get(i);
                clazz = this.getJavaWrapperTypeForSDOType(type2);
                if (clazz == null) continue;
                return clazz;
            }
        }
        return clazz;
    }

    public SDOType getType(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string != null && string.equals("commonj.sdo")) {
            return (SDOType)this.commonjHashMap.get(string2);
        }
        if (string != null && string.equals("commonj.sdo/java")) {
            return (SDOType)this.commonjJavaHashMap.get(string2);
        }
        QName qName = new QName(string, string2);
        return (SDOType)this.getTypesHashMap().get(qName);
    }

    public void addType(SDOType sDOType) {
        if ("commonj.sdo".equals(sDOType.getURI())) {
            this.commonjHashMap.put(sDOType.getName(), sDOType);
        } else if ("commonj.sdo/java".equals(sDOType.getURI())) {
            this.commonjJavaHashMap.put(sDOType.getName(), sDOType);
        } else {
            this.getTypesHashMap().put(sDOType.getQName(), sDOType);
        }
    }

    public SDOType getType(Class clazz) {
        SDOType sDOType;
        SDOType sDOType2 = (SDOType)this.getInterfacesToSDOTypeHashMap().get(clazz);
        if (sDOType2 != null) {
            return sDOType2;
        }
        sDOType2 = this.getTypeForSimpleJavaType(clazz);
        if (sDOType2 != null) {
            return sDOType2;
        }
        for (Object object : this.getTypesHashMap().keySet()) {
            sDOType = (SDOType)this.getTypesHashMap().get(object);
            if (sDOType.getInstanceClass() != clazz) continue;
            return sDOType;
        }
        for (Object object : this.getAnonymousTypes()) {
            if (((SDOType)object).getInstanceClass() != clazz) continue;
            return object;
        }
        for (Object object : this.commonjHashMap.keySet()) {
            sDOType = (SDOType)this.commonjHashMap.get(object);
            if (sDOType.getInstanceClass() != clazz) continue;
            return sDOType;
        }
        return null;
    }

    public SDOType getTypeForSimpleJavaType(Class clazz) {
        return (SDOType)SDOTypeHelperDelegate.getSDOTypeForSimpleJavaTypeMap().get(clazz);
    }

    public synchronized Type define(DataObject dataObject) {
        ArrayList arrayList = new ArrayList();
        Type type = this.define(dataObject, arrayList);
        this.initializeTypes(arrayList);
        return type;
    }

    private void initializeTypes(List list) {
        SDOType sDOType;
        int n;
        ArrayList<SDOType> arrayList = new ArrayList<SDOType>(list);
        for (n = 0; n < list.size(); ++n) {
            sDOType = (SDOType)list.get(n);
            if (sDOType.isDataType()) continue;
            sDOType.postInitialize();
        }
        for (n = 0; n < list.size(); ++n) {
            sDOType = (SDOType)list.get(n);
            if ((!sDOType.isDataType() && sDOType.getBaseTypes() == null || sDOType.getBaseTypes().size() == 0) && sDOType.getSubTypes().size() > 0) {
                sDOType.setupInheritance(null);
                continue;
            }
            if (sDOType.isDataType() || sDOType.getBaseTypes().size() <= 0 || list.contains(sDOType.getBaseTypes().get(0))) continue;
            SDOType sDOType2 = (SDOType)sDOType.getBaseTypes().get(0);
            while (sDOType2 != null && !sDOType2.isDataType()) {
                arrayList.add(sDOType2);
                if (sDOType2.getBaseTypes().size() == 0) {
                    arrayList.add(sDOType2);
                    sDOType2.setupInheritance(null);
                    sDOType2 = null;
                    continue;
                }
                sDOType2 = (SDOType)sDOType2.getBaseTypes().get(0);
            }
        }
        ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(arrayList);
    }

    public synchronized Type define(DataObject dataObject, List list) {
        Object object;
        Object object2;
        SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        if (dataObject == null || dataObject.getType() == null || !dataObject.getType().getURI().equals("commonj.sdo") || !dataObject.getType().getName().equals("Type")) {
            throw new IllegalArgumentException((Throwable)SDOException.errorDefiningType());
        }
        String string = dataObject.getString("uri");
        String string2 = dataObject.getString("name");
        if (string2 == null) {
            throw new IllegalArgumentException((Throwable)SDOException.errorDefiningTypeNoName());
        }
        SDOType sDOType = (SDOType)sDOTypeHelper.getType(string, string2);
        if (null != sDOType) {
            return sDOType;
        }
        boolean bl = dataObject.getBoolean("dataType");
        if (bl) {
            sDOType = new SDODataType(string, string2, this);
        } else {
            sDOType = new SDOType(string, string2, this);
            if (dataObject.getBoolean("sequenced")) {
                sDOType.setSequenced(true);
                sDOType.setMixed(true);
            }
        }
        sDOType.setDataType(bl);
        this.addType(sDOType);
        list.add(sDOType);
        sDOType.setAbstract(dataObject.getBoolean("abstract"));
        List list2 = dataObject.getList("baseType");
        for (int i = 0; i < list2.size(); ++i) {
            SDOType sDOType2 = (SDOType)this.getValueFromObject(list2.get(i), list);
            sDOType.addBaseType(sDOType2);
        }
        List list3 = dataObject.getList("aliasName");
        for (int i = 0; i < list3.size(); ++i) {
            Object e = list3.get(i);
            sDOType.getAliasNames().add(e);
        }
        List list4 = ((SDODataObject)dataObject)._getOpenContentProperties();
        for (int i = 0; i < list4.size(); ++i) {
            SDOProperty sDOProperty = (SDOProperty)list4.get(i);
            object2 = this.getValueFromObject(dataObject.get((Property)sDOProperty), list);
            sDOType.setInstanceProperty(sDOProperty, object2);
        }
        List list5 = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        for (int i = 0; i < list5.size(); ++i) {
            object2 = (SDOProperty)list5.get(i);
            object = this.getValueFromObject(dataObject.get((Property)object2), list);
            sDOType.setInstanceProperty((Property)object2, object);
        }
        if (!sDOType.isDataType()) {
            sDOType.preInitialize(null, null);
        }
        List list6 = dataObject.getList("property");
        for (int i = 0; i < list6.size(); ++i) {
            object = list6.get(i);
            if (!(object instanceof DataObject)) continue;
            this.buildPropertyFromDataObject((DataObject)object, sDOType, list);
        }
        sDOType.setOpen(dataObject.getBoolean("open"));
        if (sDOType.isDataType()) {
            SDOType sDOType3;
            QName qName = new QName("http://www.w3.org/2001/XMLSchema", string2);
            if (sDOTypeHelper.getWrappersHashMap().get(qName) != null) {
                return sDOType;
            }
            object = null;
            if (!sDOType.getBaseTypes().isEmpty()) {
                sDOType3 = (SDOType)sDOType.getBaseTypes().get(0);
                object = new QName("http://www.w3.org/2001/XMLSchema", sDOType3.getName());
            }
            sDOType3 = new SDOWrapperType((Type)sDOType, string2, (SDOTypeHelper)this, (QName)object);
            sDOTypeHelper.getWrappersHashMap().put(qName, sDOType3);
            sDOTypeHelper.getTypesHashMap().put(qName, sDOType3);
            sDOTypeHelper.getInterfacesToSDOTypeHashMap().put(sDOType3.getXmlDescriptor().getInterfacePolicy().getParentInterfaces().firstElement(), sDOType3);
            ArrayList<SDOType> arrayList = new ArrayList<SDOType>(1);
            arrayList.add(sDOType3);
            ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(arrayList);
        }
        return sDOType;
    }

    private boolean isBaseTypeBytes(Type type) {
        List list = type.getBaseTypes();
        if (list.size() > 0) {
            Type type2 = (Type)list.get(0);
            if (type2 == SDOConstants.SDO_BYTES) {
                return true;
            }
            return this.isBaseTypeBytes(type2);
        }
        return false;
    }

    private Object getValueFromObject(Object object, List list) {
        if (object instanceof SDODataObject && ((SDODataObject)object).getType().isTypeType()) {
            return this.define((DataObject)object, list);
        }
        return object;
    }

    private SDOProperty buildPropertyFromDataObject(DataObject dataObject, Type type, List list) {
        Object object;
        Object object2;
        String string = dataObject.getString("name");
        Object object3 = dataObject.get("type");
        SDOProperty sDOProperty = new SDOProperty(this.aHelperContext);
        sDOProperty.setName(string);
        Type type2 = (Type)this.getValueFromObject(object3, list);
        sDOProperty.setType(type2);
        if (type2 != null) {
            if (type2 == SDOConstants.SDO_BYTES) {
                sDOProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            } else if (type2.isDataType() && this.isBaseTypeBytes(type2)) {
                sDOProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            }
        }
        if (dataObject.isSet("containment")) {
            sDOProperty.setContainment(dataObject.getBoolean("containment"));
        } else if (type2 != null) {
            sDOProperty.setContainment(!type2.isDataType());
        }
        sDOProperty.setReadOnly(dataObject.getBoolean("readOnly"));
        sDOProperty.setMany(dataObject.getBoolean("many"));
        sDOProperty.setNullable(dataObject.getBoolean("nullable"));
        List list2 = dataObject.getList("aliasName");
        for (int i = 0; i < list2.size(); ++i) {
            object2 = list2.get(i);
            sDOProperty.getAliasNames().add(object2);
        }
        Object object4 = dataObject.get("opposite");
        if (object4 != null) {
            if (object4 instanceof SDOProperty) {
                sDOProperty.setOpposite((SDOProperty)object4);
                ((SDOProperty)object4).setOpposite(sDOProperty);
            } else if (object4 instanceof DataObject && (object2 = (SDOProperty)type2.getProperty(((DataObject)object4).getString("name"))) != null) {
                sDOProperty.setOpposite((Property)object2);
                ((SDOProperty)object2).setOpposite(sDOProperty);
            }
        }
        if (dataObject.isSet("default")) {
            sDOProperty.setDefault(dataObject.get("default"));
        }
        object2 = ((SDODataObject)dataObject)._getOpenContentProperties();
        for (int i = 0; i < object2.size(); ++i) {
            SDOProperty sDOProperty2 = (SDOProperty)object2.get(i);
            object = this.getValueFromObject(dataObject.get((Property)sDOProperty2), list);
            sDOProperty.setInstanceProperty(sDOProperty2, object);
        }
        List list3 = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        for (int i = 0; i < list3.size(); ++i) {
            object = (SDOProperty)list3.get(i);
            Object object5 = this.getValueFromObject(dataObject.get((Property)object), list);
            sDOProperty.setInstanceProperty((Property)object, object5);
        }
        if (sDOProperty.getType() == null) {
            throw SDOException.noTypeSpecifiedForProperty((String)sDOProperty.getName());
        }
        if (type != null) {
            ((SDOType)type).addDeclaredProperty(sDOProperty);
            if (this.aHelperContext.getXSDHelper().isElement((Property)sDOProperty) || sDOProperty.getType().isChangeSummaryType()) {
                sDOProperty.setNamespaceQualified(true);
            }
            sDOProperty.buildMapping(type.getURI());
        }
        return sDOProperty;
    }

    public synchronized List define(List list) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < list.size(); ++i) {
            Type type = this.define((DataObject)list.get(i));
            arrayList.add(type);
        }
        return arrayList;
    }

    public QName getXSDTypeFromSDOType(Type type) {
        return (QName)this.sdoToXSDTypes.get(type);
    }

    public SDOType getSDOTypeFromXSDType(QName qName) {
        return (SDOType)this.xsdToSDOType.get(qName);
    }

    public void setTypesHashMap(Map map) {
        this.typesHashMap = map;
    }

    public Map getTypesHashMap() {
        if (this.typesHashMap == null) {
            this.initTypesHashMap();
        }
        return this.typesHashMap;
    }

    public Map getWrappersHashMap() {
        if (this.wrappersHashMap == null) {
            this.initWrappersHashMap();
        }
        return this.wrappersHashMap;
    }

    public void setWrappersHashMap(Map map) {
        this.wrappersHashMap = map;
    }

    public void reset() {
        this.interfacesToSDOTypeHashMap = new HashMap<Class, SDOType>();
        this.initWrapperTypes();
        this.initWrappersHashMap();
        this.initTypesHashMap();
        this.namespaceResolver = new NamespaceResolver();
        this.initOpenProps();
        SDOType sDOType = (SDOType)this.typesHashMap.get(new QName("org.eclipse.persistence.sdo", "OpenSequencedType"));
        sDOType.getXmlDescriptor().setNamespaceResolver(null);
        this.initSdoToXSDType();
        this.initXsdToSDOType();
    }

    public Property defineOpenContentProperty(String string, DataObject dataObject) {
        Object object;
        String string2 = dataObject.getString("name");
        Property property = this.aHelperContext.getXSDHelper().getGlobalProperty(string, string2, true);
        if (property == null) {
            property = this.aHelperContext.getXSDHelper().getGlobalProperty(string, string2, false);
        }
        if (property == null || !(property instanceof Property)) {
            object = new ArrayList();
            property = this.buildPropertyFromDataObject(dataObject, null, (List)object);
            this.initializeTypes((List)object);
            this.defineOpenContentProperty(string, string2, property);
        }
        if (property != null) {
            DataObject dataObject2;
            object = dataObject.get("type");
            SDOType sDOType = (SDOType)property.getType();
            boolean bl = false;
            if (object instanceof SDOType) {
                SDOType sDOType2 = (SDOType)object;
                if (!sDOType2.getQName().equals(sDOType.getQName())) {
                    bl = true;
                }
            } else if (!(!(object instanceof DataObject) || (dataObject2 = (DataObject)object).get("name").equals(sDOType.getName()) && dataObject2.get("uri").equals(sDOType.getURI()))) {
                bl = true;
            }
            if (bl) {
                throw new IllegalArgumentException("Should not be able to redefine a Property with a different Type.");
            }
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineOpenContentProperty(String string, String string2, Property property) {
        if (string != null) {
            QName qName = new QName(string, string2);
            this.openContentProperties.put(qName, property);
            boolean bl = this.aHelperContext.getXSDHelper().isElement(property);
            ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(qName, property, bl);
            ((SDOProperty)property).setUri(string);
            if (property.getType().isDataType()) {
                SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
                SDOWrapperType sDOWrapperType = (SDOWrapperType)sDOTypeHelper.getWrappersHashMap().get(((SDOProperty)property).getType().getQName());
                if (sDOWrapperType != null) {
                    QName qName2 = new QName(string, string2);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().addDescriptorByQName(qName2, sDOWrapperType.getXmlDescriptor(((SDOProperty)property).getXsdType()));
                }
                return;
            }
            XMLDescriptor xMLDescriptor = ((SDOType)property.getType()).getXmlDescriptor();
            if (xMLDescriptor != null) {
                XMLDescriptor xMLDescriptor2 = xMLDescriptor;
                synchronized (xMLDescriptor2) {
                    String string3 = string2;
                    String string4 = xMLDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(string);
                    if (string4 == null || string4.equals("")) {
                        string4 = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(string);
                        xMLDescriptor.getNonNullNamespaceResolver().put(string4, string);
                    }
                    if (string4 != null && !string4.equals("")) {
                        string3 = string4 + ":" + string3;
                    }
                    xMLDescriptor.setDefaultRootElement(string3);
                    QName qName3 = new QName(string, string3);
                    xMLDescriptor.setDefaultRootElementType(qName3);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().storeXMLDescriptorByQName(xMLDescriptor);
                }
            }
        }
    }

    public Property getOpenContentProperty(String string, String string2) {
        QName qName = new QName(string, string2);
        return (Property)this.openContentProperties.get(qName);
    }

    private static Map getSDOTypeForSimpleJavaTypeMap() {
        return sdoTypeForSimpleJavaType;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        String string2 = namespaceResolver.resolveNamespaceURI(string);
        if (string2 == null || string2.equals("")) {
            String string3 = this.generatePrefix(string);
            namespaceResolver.put(string3, string);
            return string3;
        }
        return string2;
    }

    private String generatePrefix(String string) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (string.equals("commonj.sdo")) {
            return namespaceResolver.generatePrefix("sdo");
        }
        if (string.equals("commonj.sdo/xml")) {
            return namespaceResolver.generatePrefix("sdoXML");
        }
        if (string.equals("commonj.sdo/java")) {
            return namespaceResolver.generatePrefix("sdoJava");
        }
        return namespaceResolver.generatePrefix();
    }

    public String addNamespace(String string, String string2) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        String string3 = namespaceResolver.resolveNamespaceURI(string2);
        if (string3 != null && !string3.equals("")) {
            return string3;
        }
        String string4 = namespaceResolver.resolveNamespacePrefix(string);
        if (string4 == null) {
            namespaceResolver.put(string, string2);
            return string;
        }
        string = this.generatePrefix(string2);
        namespaceResolver.put(string, string2);
        return string;
    }

    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    public Map getOpenContentProperties() {
        return this.openContentProperties;
    }

    private void initOpenProps() {
        SDOType sDOType = this.getType("commonj.sdo", "Type");
        this.openContentProperties = new HashMap();
        this.openContentProperties.put(SDOConstants.MIME_TYPE_QNAME, SDOConstants.MIME_TYPE_PROPERTY);
        this.openContentProperties.put(SDOConstants.MIME_TYPE_PROPERTY_QNAME, SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        this.openContentProperties.put(SDOConstants.SCHEMA_TYPE_QNAME, new SDOProperty(this.aHelperContext, "org.eclipse.persistence.sdo", "xmlSchemaType", sDOType));
        this.openContentProperties.put(SDOConstants.JAVA_CLASS_QNAME, SDOConstants.JAVA_CLASS_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_ELEMENT_QNAME, SDOConstants.XMLELEMENT_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_DATATYPE_QNAME, new SDOProperty(this.aHelperContext, "commonj.sdo/xml", "dataType", sDOType));
        this.openContentProperties.put(SDOConstants.XML_ID_PROPERTY_QNAME, SDOConstants.ID_PROPERTY);
        this.openContentProperties.put(SDOConstants.DOCUMENTATION_PROPERTY_QNAME, SDOConstants.DOCUMENTATION_PROPERTY);
    }

    public Map getInterfacesToSDOTypeHashMap() {
        return this.interfacesToSDOTypeHashMap;
    }

    public List getAnonymousTypes() {
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new ArrayList();
        }
        return this.anonymousTypes;
    }

    static {
        SDOTypeHelperDelegate.initSDOTypeForSimpleJavaTypeMap();
    }
}

