/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBListWrapper;
import org.eclipse.persistence.sessions.Session;

public class JAXBValueStore
implements ValueStore {
    private JAXBHelperContext jaxbHelperContext;
    private Object entity;
    private XMLDescriptor descriptor;
    private SDODataObject dataObject;
    private Map<Property, ListWrapper> listWrappers;

    public JAXBValueStore(JAXBHelperContext jAXBHelperContext, SDOType sDOType) {
        this.jaxbHelperContext = jAXBHelperContext;
        QName qName = sDOType.getXsdType();
        if (null == qName) {
            qName = sDOType.getQName();
        }
        this.listWrappers = new WeakHashMap<Property, ListWrapper>();
        XPathFragment xPathFragment = new XPathFragment(qName.getLocalPart());
        xPathFragment.setNamespaceURI(qName.getNamespaceURI());
        JAXBContext jAXBContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = jAXBContext.getXMLContext().getDescriptorByGlobalType(xPathFragment);
        if (null == this.descriptor) {
            this.descriptor = jAXBContext.getXMLContext().getDescriptor(qName);
            if (null == this.descriptor) {
                throw SDOException.sdoJaxbNoDescriptorForType((QName)sDOType.getQName(), (QName)qName);
            }
        }
        this.entity = this.descriptor.getInstantiationPolicy().buildNewInstance();
    }

    public JAXBValueStore(JAXBHelperContext jAXBHelperContext, Object object) {
        this.jaxbHelperContext = jAXBHelperContext;
        this.listWrappers = new WeakHashMap<Property, ListWrapper>();
        JAXBContext jAXBContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = (XMLDescriptor)jAXBContext.getXMLContext().getSession(object).getDescriptor(object);
        this.entity = object;
    }

    SDODataObject getDataObject() {
        return this.dataObject;
    }

    Object getEntity() {
        return this.entity;
    }

    XMLDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    JAXBHelperContext getJAXBHelperContext() {
        return this.jaxbHelperContext;
    }

    public void initialize(DataObject dataObject) {
        this.dataObject = (SDODataObject)dataObject;
    }

    public Object getDeclaredProperty(int n) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        Object object = databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (null == object || sDOProperty.getType().isDataType()) {
            if (sDOProperty.isMany()) {
                return new JAXBListWrapper(this, sDOProperty);
            }
            return object;
        }
        if (sDOProperty.isMany()) {
            ListWrapper listWrapper = this.listWrappers.get(sDOProperty);
            if (null != listWrapper) {
                return listWrapper;
            }
            listWrapper = new JAXBListWrapper(this, sDOProperty);
            this.listWrappers.put(sDOProperty, listWrapper);
            return listWrapper;
        }
        if (sDOProperty.isContainment()) {
            return this.jaxbHelperContext.wrap(object, (Property)sDOProperty, (DataObject)this.dataObject);
        }
        return this.jaxbHelperContext.wrap(object);
    }

    public void setDeclaredProperty(int n, Object object) {
        Object object2;
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        Object object3 = object;
        Object object4 = databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (sDOProperty.getType().isDataType()) {
            if (!sDOProperty.isMany()) {
                object2 = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)databaseMapping;
                if (xMLDirectMapping.hasConverter()) {
                    object3 = xMLDirectMapping.getConverter().convertDataValueToObjectValue(object3, (Session)object2);
                } else {
                    DatabaseField databaseField = databaseMapping.getField();
                    object3 = object2.getDatasourcePlatform().getConversionManager().convertObject(object3, this.descriptor.getObjectBuilder().getFieldClassification(databaseField));
                }
            }
            databaseMapping.setAttributeValueInObject(this.entity, object3);
        } else if (sDOProperty.isMany()) {
            object2 = (ListWrapper)this.getDeclaredProperty(n);
            ((ListWrapper)object2).setCurrentElements((List)object3);
        } else {
            Object object5;
            PropertyChangeListener propertyChangeListener;
            if (databaseMapping.isAbstractCompositeObjectMapping()) {
                object2 = (XMLCompositeObjectMapping)databaseMapping;
                if (object4 != null && object2.getContainerAccessor() != null) {
                    if (object4 instanceof ChangeTracker && null != (propertyChangeListener = ((ChangeTracker)object4)._persistence_getPropertyChangeListener())) {
                        object5 = object2.getContainerAccessor().getAttributeValueFromObject(object4);
                        propertyChangeListener.propertyChange(new PropertyChangeEvent(object4, object2.getContainerAttributeName(), null, object5));
                    }
                    object2.getContainerAccessor().setAttributeValueInObject(object4, null);
                }
            }
            object3 = this.jaxbHelperContext.unwrap((DataObject)object);
            databaseMapping.getAttributeAccessor().setAttributeValueInObject(this.entity, object3);
            if (databaseMapping.isAbstractCompositeObjectMapping()) {
                object2 = (XMLCompositeObjectMapping)databaseMapping;
                if (object != null && object2.getContainerAccessor() != null) {
                    if (object3 instanceof ChangeTracker && null != (propertyChangeListener = ((ChangeTracker)object3)._persistence_getPropertyChangeListener())) {
                        object5 = object2.getContainerAccessor().getAttributeValueFromObject(object3);
                        propertyChangeListener.propertyChange(new PropertyChangeEvent(object3, object2.getContainerAttributeName(), this.entity, object5));
                    }
                    object2.getContainerAccessor().setAttributeValueInObject(object3, this.entity);
                }
            }
        }
        if (this.entity instanceof ChangeTracker && (object2 = ((ChangeTracker)this.entity)._persistence_getPropertyChangeListener()) != null) {
            object2.propertyChange(new PropertyChangeEvent(this.entity, databaseMapping.getAttributeName(), object3, object4));
        }
    }

    public boolean isSetDeclaredProperty(int n) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        if (sDOProperty.isMany()) {
            Collection collection = (Collection)databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (null == collection) {
                return false;
            }
            return !collection.isEmpty();
        }
        return null != databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
    }

    public void unsetDeclaredProperty(int n) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        if (sDOProperty.isMany()) {
            Object object;
            Object object2;
            ContainerMapping containerMapping = (ContainerMapping)databaseMapping;
            ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
            if (databaseMapping.isAbstractCompositeCollectionMapping() && (object2 = (XMLCompositeCollectionMapping)databaseMapping).getContainerAccessor() != null && (object = databaseMapping.getAttributeValueFromObject(this.entity)) != null) {
                AbstractSession abstractSession = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                Object object3 = containerPolicy.iteratorFor(object);
                while (containerPolicy.hasNext(object3)) {
                    Object object4 = containerPolicy.next(object3, abstractSession);
                    object2.getContainerAccessor().setAttributeValueInObject(object4, null);
                }
            }
            object2 = containerPolicy.containerInstance();
            databaseMapping.getAttributeAccessor().setAttributeValueInObject(this.entity, object2);
        } else {
            Object object;
            Object object5 = databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (databaseMapping.isAbstractCompositeObjectMapping() && (object = (XMLCompositeObjectMapping)databaseMapping).getContainerAccessor() != null && object5 != null) {
                PropertyChangeListener propertyChangeListener;
                if (object5 instanceof ChangeTracker && (propertyChangeListener = ((ChangeTracker)object5)._persistence_getPropertyChangeListener()) != null) {
                    Object object6 = object.getContainerAccessor().getAttributeValueFromObject(object5);
                    propertyChangeListener.propertyChange(new PropertyChangeEvent(object5, object.getContainerAttributeName(), null, object6));
                }
                object.getContainerAccessor().setAttributeValueInObject(object5, null);
            }
            if (this.entity instanceof ChangeTracker && (object = ((ChangeTracker)this.entity)._persistence_getPropertyChangeListener()) != null) {
                object.propertyChange(new PropertyChangeEvent(this.entity, databaseMapping.getAttributeName(), null, object5));
            }
            databaseMapping.getAttributeAccessor().setAttributeValueInObject(this.entity, null);
        }
    }

    public Object getOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    public void setOpenContentProperty(Property property, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean isSetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    public void unsetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    public void setManyProperty(Property property, Object object) {
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty((SDOProperty)property);
        ContainerMapping containerMapping = (ContainerMapping)databaseMapping;
        ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
        AbstractSession abstractSession = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
        List<Object> list = (List<Object>)object;
        if (!property.getType().isDataType()) {
            list = this.getJAXBHelperContext().unwrap((Collection<DataObject>)list);
        }
        Iterator iterator = list.iterator();
        Object object2 = containerMapping.getContainerPolicy().containerInstance();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            containerPolicy.addInto(e, object2, abstractSession);
        }
        databaseMapping.setAttributeValueInObject(this.entity, object2);
    }

    public ValueStore copy() {
        throw new UnsupportedOperationException();
    }

    DatabaseMapping getJAXBMappingForProperty(SDOProperty sDOProperty) {
        Map map;
        XMLField xMLField;
        XMLObjectReferenceMapping xMLObjectReferenceMapping;
        DatabaseMapping databaseMapping = sDOProperty.getXmlMapping();
        if (databaseMapping instanceof XMLObjectReferenceMapping) {
            xMLObjectReferenceMapping = (XMLObjectReferenceMapping)databaseMapping;
            xMLField = (XMLField)xMLObjectReferenceMapping.getFields().get(0);
        } else {
            xMLField = (XMLField)databaseMapping.getField();
        }
        xMLObjectReferenceMapping = (TreeObjectBuilder)this.descriptor.getObjectBuilder();
        Object object = xMLObjectReferenceMapping.getRootXPathNode();
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        while (object != null && xPathFragment != null) {
            if (xPathFragment.isAttribute()) {
                if (sDOProperty.isMany() && !sDOProperty.isContainment() && !sDOProperty.getType().isDataType()) {
                    xPathFragment = null;
                    break;
                }
                map = object.getAttributeChildrenMap();
                object = null == map ? null : (XPathNode)object.getAttributeChildrenMap().get(xPathFragment);
            } else {
                map = object.getNonAttributeChildrenMap();
                object = null == map ? null : (XPathNode)object.getNonAttributeChildrenMap().get(xPathFragment);
            }
            if ((xPathFragment = xPathFragment.getNextFragment()) == null || !xPathFragment.nameIsText() || !sDOProperty.isMany() || sDOProperty.isContainment()) continue;
            xPathFragment = null;
            break;
        }
        if (null == xPathFragment && object != null && object.getNodeValue().isMappingNodeValue()) {
            map = (MappingNodeValue)object.getNodeValue();
            return map.getMapping();
        }
        throw SDOException.sdoJaxbNoMappingForProperty((String)sDOProperty.getName(), (String)xMLField.getXPath());
    }
}

