/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;

public class JAXBListWrapper
extends ListWrapper {
    private JAXBValueStore jaxbValueStore;
    private DatabaseMapping mapping;
    private ContainerPolicy containerPolicy;
    private AbstractSession session;
    private Object elements;

    public JAXBListWrapper(JAXBValueStore jAXBValueStore, SDOProperty sDOProperty) {
        super(jAXBValueStore.getDataObject(), sDOProperty);
        this.jaxbValueStore = jAXBValueStore;
        JAXBContext jAXBContext = (JAXBContext)this.jaxbValueStore.getJAXBHelperContext().getJAXBContext();
        this.session = jAXBContext.getXMLContext().getSession(this.jaxbValueStore.getEntity().getClass());
        this.mapping = this.jaxbValueStore.getJAXBMappingForProperty(sDOProperty);
        this.containerPolicy = this.mapping.getContainerPolicy();
        this.elements = this.mapping.getAttributeValueFromObject(this.jaxbValueStore.getEntity());
        if (this.elements == null) {
            this.elements = this.containerPolicy.containerInstance();
            this.mapping.setAttributeValueInObject(this.jaxbValueStore.getEntity(), this.elements);
        }
    }

    public JAXBListWrapper(JAXBValueStore jAXBValueStore, SDOProperty sDOProperty, List list) {
        this(jAXBValueStore, sDOProperty);
        this.elements = list;
    }

    private List getEmptyList() {
        if (this.containerPolicy == null) {
            return null;
        }
        return (List)this.containerPolicy.containerInstance();
    }

    public boolean add(Object object, boolean bl) {
        Property property;
        if (object == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        Object object2 = object;
        if (!this.property.getType().isDataType()) {
            object2 = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        boolean bl2 = this.containerPolicy.addInto(object2, this.elements, this.session);
        this.updateContainment(object, bl);
        if (this.property != null && object != null && (property = this.property.getOpposite()) != null) {
            ((DataObject)object).set(property, (Object)this.dataObject);
            this.dataObject.set(property, null);
        }
        return bl2;
    }

    public void add(int n, Object object, boolean bl) {
        if (object == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        if (n < 0 || n > this.size()) {
            return;
        }
        this.copyElements();
        Object object2 = object;
        if (!this.property.getType().isDataType()) {
            object2 = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        Vector vector = this.containerPolicy.vectorFor(this.elements, this.session);
        vector.add(n, object2);
        this.containerPolicy.clear(this.elements);
        Property property = vector.iterator();
        while (property.hasNext()) {
            Object e = property.next();
            this.containerPolicy.addInto(e, this.elements, this.session);
        }
        this.updateContainment(object, bl);
        if (this.property != null && object != null && (property = this.property.getOpposite()) != null) {
            ((DataObject)object).set(property, (Object)this.dataObject);
            this.dataObject.set(property, null);
        }
    }

    protected void copyElements() {
        if (this.isLogging() && !((SDOChangeSummary)this.dataObject.getChangeSummary()).isDirty(this)) {
            ((SDOChangeSummary)this.dataObject.getChangeSummary()).getOriginalElements().put(this, this.getCurrentElements());
        }
    }

    private boolean isLogging() {
        return this.dataObject != null && this.dataObject.getChangeSummary() != null && this.dataObject.getChangeSummary().isLogging();
    }

    public List getCurrentElements() {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session);
        }
        if (this.property.isContainment()) {
            return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session), this.property, (DataObject)this.jaxbValueStore.getDataObject());
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session));
    }

    public void setCurrentElements(List list) {
        if (list == null || list.size() == 0) {
            this.elements = this.containerPolicy.containerInstance();
        }
        this.elements = this.containerPolicy.containerInstance(list.size());
        List<Object> list2 = list;
        if (!this.property.getType().isDataType()) {
            list2 = this.jaxbValueStore.getJAXBHelperContext().unwrap((Collection<DataObject>)list);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (this.property.getType().isDataType()) continue;
            this.containerPolicy.addInto(list2.get(i), this.elements, this.session);
        }
        this.mapping.setAttributeValueInObject(this.jaxbValueStore.getEntity(), this.elements);
    }

    public void undoChanges(SDOChangeSummary sDOChangeSummary) {
        if (null == sDOChangeSummary) {
            return;
        }
        if (sDOChangeSummary.isDirty(this)) {
            this.setCurrentElements((List)sDOChangeSummary.getOriginalElements().get(this));
            sDOChangeSummary.getOriginalElements().remove(this);
        }
    }

    public boolean remove(Object object, boolean bl, boolean bl2) {
        this.copyElements();
        this.removeContainment(object, bl, bl2);
        Object object2 = object;
        if (!this.property.getType().isDataType()) {
            object2 = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        return this.containerPolicy.removeFrom(object2, this.elements, this.session);
    }

    public boolean addAll(Collection collection, boolean bl) {
        Property property;
        if (collection.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean bl2 = false;
        if (collection != null && collection.size() != 0) {
            bl2 = true;
            property = collection.iterator();
            while (property.hasNext()) {
                Object object = property.next();
                if (!this.property.getType().isDataType()) {
                    object = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
                }
                this.containerPolicy.addInto(object, this.elements, this.session);
            }
        }
        this.dataObject._getCurrentValueStore().setManyProperty(this.property, this);
        this.dataObject.updateContainment(this.property, collection, bl);
        if (this.property != null && (property = this.property.getOpposite()) != null) {
            for (Object e : collection) {
                if (e == null) continue;
                ((DataObject)e).set(property, (Object)this.dataObject);
                this.dataObject.set(property, null);
            }
        }
        this.updateSequence(this.property, collection, bl);
        return bl2;
    }

    public boolean addAll(int n, Collection list, boolean bl) {
        if (n < 0 || n > this.size()) {
            return false;
        }
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        boolean bl2 = true;
        this.copyElements();
        Vector vector = this.containerPolicy.vectorFor(this.elements, this.session);
        List<Object> list2 = list;
        if (!this.property.getType().isDataType()) {
            list2 = this.jaxbValueStore.getJAXBHelperContext().unwrap(list);
        }
        vector.addAll(n, list2);
        this.containerPolicy.clear(this.elements);
        Property property = vector.iterator();
        while (property.hasNext()) {
            Object e = property.next();
            this.containerPolicy.addInto(e, this.elements, this.session);
        }
        this.dataObject.updateContainment(this.property, list);
        if (this.property != null && (property = this.property.getOpposite()) != null) {
            for (Object e : list) {
                if (e == null) continue;
                ((DataObject)e).set(property, (Object)this.dataObject);
                this.dataObject.set(property, null);
            }
        }
        this.updateSequence(this.property, list, bl);
        return bl2;
    }

    public int size() {
        return this.containerPolicy.sizeFor(this.elements);
    }

    public boolean isEmpty() {
        return this.containerPolicy.isEmpty(this.elements);
    }

    public boolean contains(Object object) {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.contains(object, this.elements, this.session);
        }
        return this.containerPolicy.contains(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object), this.elements, this.session);
    }

    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public Object remove(int n, boolean bl) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        this.copyElements();
        Object object = this.get(n);
        int n2 = this.getOccurrenceIndex(object);
        this.removeContainment(n2, object, false, bl);
        if (!this.property.getType().isDataType()) {
            object = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
        }
        return this.containerPolicy.removeFrom(object, this.elements, this.session);
    }

    public Object get(int n) {
        Object object = this.containerPolicy.vectorFor(this.elements, this.session).elementAt(n);
        if (!this.property.getType().isDataType()) {
            object = this.property.isContainment() ? this.jaxbValueStore.getJAXBHelperContext().wrap(object, this.property, (DataObject)this.jaxbValueStore.getDataObject()) : this.jaxbValueStore.getJAXBHelperContext().wrap(object);
        }
        return object;
    }

    private int getOccurrenceIndex(Object object) {
        int n = 0;
        boolean bl = true;
        Vector vector = this.containerPolicy.vectorFor(this.elements, this.session);
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Object e = vector.get(i);
            if (object != e) continue;
            if (bl) {
                bl = false;
                continue;
            }
            ++n;
        }
        return n;
    }

    public ListIterator listIterator() {
        List<Object> list = this.containerPolicy.vectorFor(this.elements, this.session);
        if (!this.property.getType().isDataType()) {
            list = this.jaxbValueStore.getJAXBHelperContext().wrap(list);
        }
        return list.listIterator();
    }

    public ListIterator listIterator(int n) {
        List<Object> list = this.containerPolicy.vectorFor(this.elements, this.session);
        if (!this.property.getType().isDataType()) {
            list = this.jaxbValueStore.getJAXBHelperContext().wrap(list);
        }
        return list.listIterator(n);
    }

    public int indexOf(Object object) {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session).indexOf(object);
        }
        return this.containerPolicy.vectorFor(this.elements, this.session).indexOf(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object));
    }

    public int lastIndexOf(Object object) {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session).lastIndexOf(object);
        }
        return this.containerPolicy.vectorFor(this.elements, this.session).lastIndexOf(this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object));
    }

    public Object writeReplace() {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session);
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session));
    }

    public Iterator iterator() {
        if (this.property.getType().isDataType()) {
            return this.containerPolicy.vectorFor(this.elements, this.session).iterator();
        }
        return this.jaxbValueStore.getJAXBHelperContext().wrap(this.containerPolicy.vectorFor(this.elements, this.session)).iterator();
    }

    protected void updateContainment(Object object, boolean bl) {
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping;
        if (this.mapping.isAbstractCompositeCollectionMapping() && null != object && (xMLCompositeCollectionMapping = (XMLCompositeCollectionMapping)this.mapping).getContainerAccessor() != null) {
            PropertyChangeListener propertyChangeListener;
            Object object2 = this.jaxbValueStore.getJAXBHelperContext().unwrap((DataObject)object);
            if (object2 instanceof ChangeTracker && (propertyChangeListener = ((ChangeTracker)object2)._persistence_getPropertyChangeListener()) != null) {
                Object object3 = xMLCompositeCollectionMapping.getContainerAccessor().getAttributeValueFromObject(object2);
                propertyChangeListener.propertyChange(new PropertyChangeEvent(object2, xMLCompositeCollectionMapping.getContainerAttributeName(), this.jaxbValueStore.getEntity(), object3));
            }
            xMLCompositeCollectionMapping.getContainerAccessor().setAttributeValueInObject(object2, this.jaxbValueStore.getEntity());
        }
        super.updateContainment(object, bl);
    }
}

