/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.DefaultValueStore;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOExternalizableDelegator;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.XPathEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDODataObject
implements DataObject,
SequencedObject {
    private SDOType type;
    private DataObject container;
    private ValueStore currentValueStore;
    private List openContentProperties;
    private List openContentPropertiesAttributes;
    private Map openContentAliasNames;
    private String containmentPropertyName;
    private ChangeSummary changeSummary;
    private List instanceProperties;
    private String sdoRef;
    private Sequence sequence;
    private DataGraph dataGraph;
    private HelperContext aHelperContext;
    private String text;

    public SDODataObject() {
        this._setCurrentValueStore(new DefaultValueStore());
    }

    public void _setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
        if (this.getChangeSummary() != null) {
            ((SDOChangeSummary)this.getChangeSummary()).setHelperContext(this.aHelperContext);
        }
    }

    public Object get(String string) {
        try {
            return XPathEngine.getInstance().get(string, this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void set(String string, Object object) throws ClassCastException, UnsupportedOperationException, IllegalArgumentException {
        XPathEngine.getInstance().set(string, object, this, false);
    }

    public boolean isSet(String string) {
        return XPathEngine.getInstance().isSet(string, (DataObject)this);
    }

    public void unset(String string) {
        XPathEngine.getInstance().unset(string, this);
    }

    public boolean getBoolean(String string) throws ClassCastException {
        try {
            Boolean bl = (Boolean)XPathEngine.getInstance().convertObjectToValueByPath(string, Boolean.class, this);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte getByte(String string) {
        try {
            Byte by = (Byte)XPathEngine.getInstance().convertObjectToValueByPath(string, Byte.class, this);
            if (by == null) {
                return 0;
            }
            return by;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public char getChar(String string) {
        try {
            Character c = (Character)XPathEngine.getInstance().convertObjectToValueByPath(string, Character.class, this);
            if (c == null) {
                return '\u0000';
            }
            return c.charValue();
        }
        catch (Exception exception) {
            return '\u0000';
        }
    }

    public double getDouble(String string) {
        try {
            Double d = (Double)XPathEngine.getInstance().convertObjectToValueByPath(string, Double.class, this);
            if (d == null) {
                return 0.0;
            }
            return d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public float getFloat(String string) {
        try {
            Float f = (Float)XPathEngine.getInstance().convertObjectToValueByPath(string, Float.class, this);
            if (f == null) {
                return 0.0f;
            }
            return f.floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public int getInt(String string) {
        try {
            Integer n = (Integer)XPathEngine.getInstance().convertObjectToValueByPath(string, Integer.class, this);
            if (n == null) {
                return 0;
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getLong(String string) {
        try {
            Long l = (Long)XPathEngine.getInstance().convertObjectToValueByPath(string, Long.class, this);
            if (l == null) {
                return 0L;
            }
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public short getShort(String string) {
        try {
            Short s = (Short)XPathEngine.getInstance().convertObjectToValueByPath(string, Short.class, this);
            if (s == null) {
                return 0;
            }
            return s;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public byte[] getBytes(String string) {
        try {
            byte[] byArray = (byte[])XPathEngine.getInstance().convertObjectToValueByPath(string, byte[].class, this);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(String string) {
        try {
            BigDecimal bigDecimal = (BigDecimal)XPathEngine.getInstance().convertObjectToValueByPath(string, BigDecimal.class, this);
            return bigDecimal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigInteger getBigInteger(String string) {
        try {
            BigInteger bigInteger = (BigInteger)XPathEngine.getInstance().convertObjectToValueByPath(string, BigInteger.class, this);
            return bigInteger;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataObject getDataObject(String string) throws ClassCastException {
        Object object = this.get(string);
        if (object instanceof ListWrapper) {
            return (DataObject)((ListWrapper)object).get(0);
        }
        return (DataObject)object;
    }

    public Date getDate(String string) {
        try {
            Date date = (Date)XPathEngine.getInstance().convertObjectToValueByPath(string, Date.class, this);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getString(String string) {
        try {
            String string2 = (String)XPathEngine.getInstance().convertObjectToValueByPath(string, String.class, this);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List getList(String string) {
        try {
            return (List)XPathEngine.getInstance().convertObjectToValueByPath(string, List.class, this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setBoolean(String string, boolean bl) {
        this.convertValueAndSet(string, (Object)new Boolean(bl));
    }

    public void setByte(String string, byte by) {
        this.convertValueAndSet(string, (Object)new Byte(by));
    }

    public void setChar(String string, char c) {
        this.convertValueAndSet(string, (Object)new Character(c));
    }

    public void setDouble(String string, double d) {
        this.convertValueAndSet(string, (Object)new Double(d));
    }

    public void setFloat(String string, float f) {
        this.convertValueAndSet(string, (Object)new Float(f));
    }

    public void setInt(String string, int n) {
        this.convertValueAndSet(string, (Object)new Integer(n));
    }

    public void setLong(String string, long l) {
        this.convertValueAndSet(string, (Object)new Long(l));
    }

    public void setShort(String string, short s) {
        this.convertValueAndSet(string, (Object)new Short(s));
    }

    public void setBytes(String string, byte[] byArray) {
        this.convertValueAndSet(string, (Object)byArray);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) {
        this.convertValueAndSet(string, (Object)bigDecimal);
    }

    public void setBigInteger(String string, BigInteger bigInteger) {
        this.convertValueAndSet(string, (Object)bigInteger);
    }

    public void setDataObject(String string, DataObject dataObject) {
        this.set(string, (Object)dataObject);
    }

    public void setDate(String string, Date date) {
        this.convertValueAndSet(string, (Object)date);
    }

    public void setString(String string, String string2) {
        this.convertValueAndSet(string, (Object)string2);
    }

    public void setList(String string, List list) {
        this.convertValueAndSet(string, (Object)list);
    }

    public Object get(int n) throws IllegalArgumentException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.get(sDOProperty);
    }

    public void set(int n, Object object) {
        try {
            SDOProperty sDOProperty = this.getInstanceProperty(n);
            this.set(sDOProperty, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("PropertyIndex invalid.");
        }
    }

    public boolean isSet(int n) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.isSet(sDOProperty);
    }

    public void unset(int n) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        this.unset(sDOProperty);
    }

    public boolean getBoolean(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getBoolean(sDOProperty);
    }

    public byte getByte(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getByte(sDOProperty);
    }

    public char getChar(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getChar(sDOProperty);
    }

    public double getDouble(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getDouble(sDOProperty);
    }

    public float getFloat(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getFloat(sDOProperty);
    }

    public int getInt(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getInt(sDOProperty);
    }

    public long getLong(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getLong(sDOProperty);
    }

    public short getShort(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getShort(sDOProperty);
    }

    public byte[] getBytes(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getBytes(sDOProperty);
    }

    public BigDecimal getBigDecimal(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getBigDecimal(sDOProperty);
    }

    public BigInteger getBigInteger(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getBigInteger(sDOProperty);
    }

    public DataObject getDataObject(int n) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getDataObject(sDOProperty);
    }

    public Date getDate(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getDate(sDOProperty);
    }

    public String getString(int n) throws IllegalArgumentException, ClassCastException {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getString(sDOProperty);
    }

    public List getList(int n) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getList(sDOProperty);
    }

    public Sequence getSequence(String string) {
        Object object = this.get(string);
        if (null == object || !(object instanceof DataObject)) {
            throw SDOException.sequenceNotFoundForPath((String)string);
        }
        return ((DataObject)object).getSequence();
    }

    public Sequence getSequence(int n) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.getSequencePrivate(sDOProperty);
    }

    public Sequence getSequence(Property property) {
        return this.getSequencePrivate(property);
    }

    private Sequence getSequencePrivate(Property property) {
        if (property != null && property.getType().isSequenced() && this.isSet(property) && !property.getType().isDataType() && !property.isMany()) {
            return ((DataObject)this.get(property)).getSequence();
        }
        throw SDOException.sequenceNotSupportedForProperty((String)property.getName());
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setBoolean(int n, boolean bl) {
        this.convertValueAndSet(n, (Object)new Boolean(bl));
    }

    public void setByte(int n, byte by) {
        this.convertValueAndSet(n, (Object)new Byte(by));
    }

    public void setChar(int n, char c) {
        this.convertValueAndSet(n, (Object)new Character(c));
    }

    public void setDouble(int n, double d) {
        this.convertValueAndSet(n, (Object)new Double(d));
    }

    public void setFloat(int n, float f) {
        this.convertValueAndSet(n, (Object)new Float(f));
    }

    public void setInt(int n, int n2) {
        this.convertValueAndSet(n, (Object)new Integer(n2));
    }

    public void setLong(int n, long l) {
        this.convertValueAndSet(n, (Object)new Long(l));
    }

    public void setShort(int n, short s) {
        this.convertValueAndSet(n, (Object)new Short(s));
    }

    public void setBytes(int n, byte[] byArray) {
        this.convertValueAndSet(n, (Object)byArray);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.convertValueAndSet(n, (Object)bigDecimal);
    }

    public void setBigInteger(int n, BigInteger bigInteger) {
        this.convertValueAndSet(n, (Object)bigInteger);
    }

    public void setDataObject(int n, DataObject dataObject) {
        this.set(n, (Object)dataObject);
    }

    public void setDate(int n, Date date) {
        this.convertValueAndSet(n, (Object)date);
    }

    public void setString(int n, String string) {
        this.convertValueAndSet(n, (Object)string);
    }

    public void setList(int n, List list) {
        this.convertValueAndSet(n, (Object)list);
    }

    public Object get(Property property) throws IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (null != this.type && !this.type.isOpen() && property.isOpenContent()) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (property.isMany()) {
            return this.getList(property);
        }
        if (this.isSet(property)) {
            return this.getPropertyInternal(property);
        }
        return property.getDefault();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Property defineOpenContentProperty(String string, Object object) throws UnsupportedOperationException, IllegalArgumentException {
        DataObject dataObject = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        dataObject.set("name", (Object)string);
        Type type = null;
        boolean bl = false;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            if (((Collection)object).size() <= 0) return null;
            Object e = ((Collection)object).iterator().next();
            if (e == null) return null;
            clazz = e.getClass();
            if (e instanceof DataObject) {
                if (((DataObject)e).getContainer() == null) {
                    bl2 = true;
                }
                type = ((DataObject)e).getType();
            } else {
                type = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(clazz);
            }
            bl = true;
        } else if (object instanceof DataObject) {
            if (((DataObject)object).getContainer() == null) {
                bl2 = true;
            }
            type = ((DataObject)object).getType();
        } else {
            Property property = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "xmlElement");
            dataObject.set(property, (Object)Boolean.TRUE);
            type = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(clazz);
        }
        dataObject.set("type", (Object)type);
        dataObject.set("many", (Object)bl);
        dataObject.set("containment", (Object)bl2);
        return this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, dataObject);
    }

    public Property defineOpenContentProperty(String string, Object object, Type type) throws UnsupportedOperationException, IllegalArgumentException {
        if (type == null) {
            return this.defineOpenContentProperty(string, object);
        }
        DataObject dataObject = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        dataObject.set("name", (Object)string);
        boolean bl = false;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Object e;
            if (((Collection)object).size() > 0 && (e = ((Collection)object).iterator().next()) != null) {
                clazz = e.getClass();
                if (e instanceof DataObject) {
                    if (((DataObject)e).getContainer() == null) {
                        bl2 = true;
                    }
                    type = ((DataObject)e).getType();
                } else {
                    type = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(clazz);
                }
            }
            bl = true;
        } else if (object instanceof DataObject) {
            if (((DataObject)object).getContainer() == null) {
                bl2 = true;
            }
            type = ((DataObject)object).getType();
        } else {
            type = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(clazz);
        }
        dataObject.set("type", (Object)type);
        dataObject.set("many", (Object)bl);
        dataObject.set("containment", (Object)bl2);
        return this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, dataObject);
    }

    public void set(Property property, Object object) throws UnsupportedOperationException, IllegalArgumentException {
        this.set((SDOProperty)property, object, true);
    }

    public void setInternal(SDOProperty sDOProperty, Object object, boolean bl) throws UnsupportedOperationException, IllegalArgumentException {
        if (null == this.getType()) {
            throw new UnsupportedOperationException("Type is null");
        }
        if (sDOProperty.isOpenContent() && !this.getType().isOpen()) {
            throw new IllegalArgumentException("DataObject " + this + " is not Open for property " + sDOProperty.getName());
        }
        Object object2 = this.get(sDOProperty);
        boolean bl2 = this.isSet(sDOProperty);
        if (bl2 && object2 == object) {
            return;
        }
        this._setModified(true);
        if (sDOProperty.isMany()) {
            List list;
            if (null == object) {
                list = new ListWrapper(this, sDOProperty);
            } else {
                try {
                    list = (List)object;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Properties with isMany = true can only be set on list values.");
                }
            }
            if (sDOProperty.isContainment() || this.isContainedByDataGraph(sDOProperty)) {
                for (Object e : list) {
                    if (!(e instanceof SDODataObject) || !this.parentContains((SDODataObject)e)) continue;
                    throw new IllegalArgumentException("Circular reference.");
                }
            }
            ListWrapper listWrapper = (ListWrapper)object2;
            listWrapper.clear(bl);
            listWrapper.addAll((Collection)object, bl);
        } else {
            if (sDOProperty.isContainment() || this.isContainedByDataGraph(sDOProperty)) {
                SDODataObject sDODataObject;
                if (this.parentContains(object)) {
                    throw new IllegalArgumentException("Circular reference.");
                }
                if (null != object2) {
                    this.detach(sDOProperty, object2);
                }
                if ((sDODataObject = (SDODataObject)object) != null) {
                    this.updateContainment((Property)sDOProperty, sDODataObject);
                }
            }
            this.setPropertyInternal(sDOProperty, object, bl);
        }
        if (this.getType().isOpen() && sDOProperty.isOpenContent()) {
            this.addOpenContentProperty(sDOProperty);
        }
    }

    public void set(SDOProperty sDOProperty, Object object, boolean bl) throws UnsupportedOperationException, IllegalArgumentException {
        if (null == sDOProperty) {
            throw new IllegalArgumentException("Illegal Argument.");
        }
        if (sDOProperty.isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + sDOProperty.getName() + "  " + this.getType().getName());
        }
        if (object == null && !sDOProperty.isNullable()) {
            this.unset(sDOProperty, false, bl);
        } else {
            this.setInternal(sDOProperty, object, bl);
        }
    }

    public boolean isSet(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"isSet");
        }
        if (property.isMany()) {
            List list = this.getList(property);
            return !list.isEmpty();
        }
        return this.isSetInternal(property);
    }

    public void unset(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"unset");
        }
        this.unset(property, false);
    }

    private void unset(Property property, boolean bl) {
        this.unset(property, bl, true);
    }

    public void unset(Property property, boolean bl, boolean bl2) {
        Object object;
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"unset");
        }
        if (property.isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + property.getName() + "  " + this.getType().getName());
        }
        boolean bl3 = this.isSet(property);
        if (bl3) {
            if (!bl) {
                this._setModified(true);
            }
        } else {
            return;
        }
        if ((property.isContainment() || this.isContainedByDataGraph(property)) && (object = this.get(property)) != null) {
            if (property.isMany()) {
                int n = ((List)object).size();
                for (int i = 0; i < n; ++i) {
                    SDODataObject sDODataObject = (SDODataObject)((List)object).get(i);
                    if (sDODataObject == null) continue;
                    sDODataObject.detachOrDelete(bl);
                }
            } else {
                ((SDODataObject)object).detachOrDelete(bl);
            }
        }
        if (bl3) {
            this.unsetInternal(property, bl2);
        }
    }

    public boolean getBoolean(Property property) throws IllegalArgumentException, ClassCastException {
        Boolean bl = (Boolean)this.convertObjectToValue(property, Boolean.class);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public byte getByte(Property property) throws IllegalArgumentException, ClassCastException {
        Byte by = (Byte)this.convertObjectToValue(property, Byte.class);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public char getChar(Property property) throws IllegalArgumentException {
        Character c = (Character)this.convertObjectToValue(property, Character.class);
        if (c == null) {
            return '\u0000';
        }
        return c.charValue();
    }

    public double getDouble(Property property) throws IllegalArgumentException {
        Double d = (Double)this.convertObjectToValue(property, Double.class);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public float getFloat(Property property) throws IllegalArgumentException {
        Float f = (Float)this.convertObjectToValue(property, Float.class);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public int getInt(Property property) throws IllegalArgumentException {
        Integer n = (Integer)this.convertObjectToValue(property, Integer.class);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public long getLong(Property property) throws IllegalArgumentException {
        Long l = (Long)this.convertObjectToValue(property, Long.class);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public short getShort(Property property) throws IllegalArgumentException {
        Short s = (Short)this.convertObjectToValue(property, Short.class);
        if (s == null) {
            return 0;
        }
        return s;
    }

    public byte[] getBytes(Property property) throws IllegalArgumentException {
        byte[] byArray = (byte[])this.convertObjectToValue(property, byte[].class);
        return byArray;
    }

    public BigDecimal getBigDecimal(Property property) throws IllegalArgumentException {
        BigDecimal bigDecimal = (BigDecimal)this.convertObjectToValue(property, BigDecimal.class);
        return bigDecimal;
    }

    public BigInteger getBigInteger(Property property) throws IllegalArgumentException {
        BigInteger bigInteger = (BigInteger)this.convertObjectToValue(property, BigInteger.class);
        return bigInteger;
    }

    public DataObject getDataObject(Property property) throws IllegalArgumentException, ClassCastException {
        if (property != null && property.isMany()) {
            List list = (List)this.get(property);
            if (list.size() > 0) {
                return (DataObject)list.get(0);
            }
            return null;
        }
        return (DataObject)this.get(property);
    }

    public Date getDate(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"getDate");
        }
        if (property.getType().equals(SDOConstants.SDO_STRING)) {
            DataHelper dataHelper = this.aHelperContext.getDataHelper();
            String string = (String)this.get(property);
            return dataHelper.toDate(string);
        }
        Date date = (Date)this.convertObjectToValue(property, Date.class);
        return date;
    }

    public String getString(Property property) {
        String string = (String)this.convertObjectToValue(property, String.class);
        return string;
    }

    public List getList(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"getList");
        }
        if (this.type != null && !this.type.isOpen() && property.isOpenContent()) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (!property.isMany()) {
            throw new ClassCastException("can not call getList for a property that has isMany false.");
        }
        Object object = this.getPropertyInternal(property);
        if (object != null && object instanceof List) {
            return (List)object;
        }
        ListWrapper listWrapper = new ListWrapper(this, property);
        if (this.getType().isOpen() && property.isOpenContent()) {
            this.addOpenContentProperty(property);
        }
        this.setPropertyInternal((SDOProperty)property, listWrapper, false);
        return listWrapper;
    }

    public void setBoolean(Property property, boolean bl) {
        this.convertValueAndSet(property, (Object)new Boolean(bl));
    }

    public void setByte(Property property, byte by) {
        this.convertValueAndSet(property, (Object)new Byte(by));
    }

    public void setChar(Property property, char c) {
        this.convertValueAndSet(property, (Object)new Character(c));
    }

    public void setDouble(Property property, double d) {
        this.convertValueAndSet(property, (Object)new Double(d));
    }

    public void setFloat(Property property, float f) {
        this.convertValueAndSet(property, (Object)new Float(f));
    }

    public void setInt(Property property, int n) {
        this.convertValueAndSet(property, (Object)new Integer(n));
    }

    public void setLong(Property property, long l) {
        this.convertValueAndSet(property, (Object)new Long(l));
    }

    public void setShort(Property property, short s) {
        this.convertValueAndSet(property, (Object)new Short(s));
    }

    public void setBytes(Property property, byte[] byArray) {
        this.convertValueAndSet(property, (Object)byArray);
    }

    public void setBigDecimal(Property property, BigDecimal bigDecimal) {
        this.convertValueAndSet(property, (Object)bigDecimal);
    }

    public void setBigInteger(Property property, BigInteger bigInteger) {
        this.convertValueAndSet(property, (Object)bigInteger);
    }

    public void setDataObject(Property property, DataObject dataObject) {
        this.set(property, (Object)dataObject);
    }

    public void setDate(Property property, Date date) {
        this.convertValueAndSet(property, (Object)date);
    }

    public void setString(Property property, String string) {
        this.convertValueAndSet(property, (Object)string);
    }

    public void setList(Property property, List list) {
        this.convertValueAndSet(property, (Object)list);
    }

    public DataObject createDataObject(String string) {
        SDOProperty sDOProperty = this.getInstanceProperty(string);
        return this.createDataObject(sDOProperty);
    }

    public DataObject createDataObject(int n) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        return this.createDataObject(sDOProperty);
    }

    public DataObject createDataObject(Property property) {
        Type type;
        if (property.isContainment() && (type = property.getType()) != null) {
            return this.createDataObject(property, type);
        }
        return null;
    }

    public DataObject createDataObject(String string, String string2, String string3) {
        SDOProperty sDOProperty = this.getInstanceProperty(string);
        Type type = this.aHelperContext.getTypeHelper().getType(string2, string3);
        return this.createDataObject(sDOProperty, type);
    }

    public DataObject createDataObject(int n, String string, String string2) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        Type type = this.aHelperContext.getTypeHelper().getType(string, string2);
        return this.createDataObject(sDOProperty, type);
    }

    public DataObject createDataObject(Property property, Type type) {
        DataObject dataObject = this.aHelperContext.getDataFactory().create(type);
        if (property.isMany()) {
            ((ListWrapper)this.getList(property)).add(dataObject, true);
        } else {
            this.set(property, (Object)dataObject);
        }
        this._setModified(true);
        ((SDODataObject)dataObject)._setCreated(true);
        return dataObject;
    }

    private void detach(Property property, Object object) {
        if (property.isMany()) {
            int n = ((List)object).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((List)object).get(i);
                if (e == null || !(e instanceof SDODataObject)) continue;
                ((SDODataObject)e).detachOrDelete(false);
            }
        } else if (object != null && object instanceof SDODataObject) {
            ((SDODataObject)object).detachOrDelete(false);
        }
    }

    public void detachOrDelete(boolean bl) {
        boolean bl2;
        if (null == this.getContainer() && !bl) {
            return;
        }
        boolean bl3 = bl2 = null != this.getChangeSummary() && this.getChangeSummary().getRootObject() == this;
        if (!bl && bl2) {
            return;
        }
        this.detachDeleteRecursivePrivate(bl, !bl2, true);
    }

    private void detachDeleteRecursivePrivate(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = bl2;
        if (null == this.getContainer()) {
            bl2 = false;
        }
        if ((bl3 || bl) && null != this.getContainer()) {
            ((SDODataObject)this.getContainer())._setModified(true);
            this._setContainer(null);
            this._setContainmentPropertyName(null);
        }
        this._setDeleted(true);
        DataGraph dataGraph = this.getDataGraph();
        this.setDataGraph(null);
        List list = this.getInstanceProperties();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SDOProperty sDOProperty = (SDOProperty)list.get(i);
            Object object = this.get(sDOProperty);
            if (sDOProperty.getType().isChangeSummaryType()) continue;
            if (sDOProperty.isContainment() || this.isContainedByDataGraph(dataGraph, sDOProperty)) {
                if (sDOProperty.isMany()) {
                    int n2 = ((List)object).size();
                    for (int j = 0; j < n2; ++j) {
                        Object e = ((List)object).get(j);
                        this.detachDeleteRecursivePrivateHelper((SDODataObject)e, bl, bl2);
                    }
                } else {
                    this.detachDeleteRecursivePrivateHelper((SDODataObject)object, bl, bl2);
                }
            }
            if (!bl || sDOProperty.isReadOnly()) continue;
            this.unset(sDOProperty, bl);
        }
        if (bl2 || bl4) {
            this._setChangeSummary(null);
        }
    }

    private void detachDeleteRecursivePrivateHelper(SDODataObject sDODataObject, boolean bl, boolean bl2) {
        if (sDODataObject != null) {
            ChangeSummary changeSummary;
            boolean bl3;
            boolean bl4 = bl3 = sDODataObject.getChangeSummary() != null && sDODataObject.getChangeSummary().getRootObject() == sDODataObject;
            if (bl3) {
                bl2 = false;
            } else if (sDODataObject.getContainer() != null && (changeSummary = sDODataObject.getContainer().getChangeSummary()) == null) {
                bl2 = true;
            }
            sDODataObject.detachDeleteRecursivePrivate(bl, bl2, false);
        }
    }

    public void detach() {
        this.detachWithSequenceUpdate();
    }

    private void detachWithSequenceUpdate() {
        this.detach(false, true);
    }

    private void deleteWithSequenceUpdate() {
        this.detach(true, true);
    }

    private void detach(boolean bl, boolean bl2) {
        SDOProperty sDOProperty = this.getContainmentProperty();
        if (sDOProperty != null && sDOProperty.isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + sDOProperty.getName() + "  " + this.getType().getName());
        }
        if (sDOProperty != null) {
            if (this.getContainmentProperty().isMany()) {
                List list = this.getContainer().getList((Property)sDOProperty);
                ((ListWrapper)list).remove(this, bl, bl2);
            } else {
                ((SDODataObject)this.getContainer()).unset(sDOProperty, bl, bl2);
            }
        } else {
            this._setDeleted(true);
            this.detachOrDelete(bl);
        }
    }

    public void delete() {
        this.deleteWithSequenceUpdate();
    }

    public DataObject getContainer() {
        return this.container;
    }

    public SDOProperty getContainmentProperty() {
        if (this.container != null && this.containmentPropertyName != null) {
            return (SDOProperty)this.container.getInstanceProperty(this.containmentPropertyName);
        }
        return null;
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    public void setDataGraph(DataGraph dataGraph) {
        this.dataGraph = dataGraph;
    }

    public SDOType getType() {
        return this.type;
    }

    public List getInstanceProperties() {
        if (null == this.instanceProperties) {
            this.instanceProperties = new ArrayList();
        }
        return this.instanceProperties;
    }

    public Property getProperty(String string) {
        return this.getInstanceProperty(string);
    }

    public SDOProperty getInstanceProperty(String string) {
        if (this.getType() == null) {
            throw new UnsupportedOperationException("Type is null");
        }
        SDOProperty sDOProperty = this.getType().getProperty(string);
        if (null == sDOProperty && null == (sDOProperty = (SDOProperty)this._getOpenContentAliasNamesMap().get(string))) {
            SDOProperty sDOProperty2;
            int n;
            for (n = 0; n < this._getOpenContentProperties().size(); ++n) {
                sDOProperty2 = (SDOProperty)this._getOpenContentProperties().get(n);
                if (!sDOProperty2.getName().equals(string)) continue;
                return sDOProperty2;
            }
            if (null == sDOProperty) {
                for (n = 0; n < this._getOpenContentPropertiesAttributes().size(); ++n) {
                    sDOProperty2 = (SDOProperty)this._getOpenContentPropertiesAttributes().get(n);
                    if (!sDOProperty2.getName().equals(string)) continue;
                    return sDOProperty2;
                }
            }
        }
        return sDOProperty;
    }

    SDOProperty getInstanceProperty(String string, Object object) {
        SDOProperty sDOProperty = this.getInstanceProperty(string);
        if (null == sDOProperty) {
            sDOProperty = (SDOProperty)this.defineOpenContentProperty(string, object);
        }
        return sDOProperty;
    }

    public SDOProperty getInstanceProperty(int n) throws IllegalArgumentException {
        try {
            SDOProperty sDOProperty = this.getInstancePropertiesArray()[n];
            return sDOProperty;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SDOException.propertyNotFoundAtIndex((Exception)indexOutOfBoundsException, (int)n);
        }
    }

    public DataObject getRootObject() {
        if (this.getContainer() != null) {
            return this.getContainer().getRootObject();
        }
        return this;
    }

    public ChangeSummary getChangeSummary() {
        return this.changeSummary;
    }

    public void _setCreated(boolean bl) {
        if (this.changeSummary != null) {
            ((SDOChangeSummary)this.changeSummary).setCreated(this, bl);
        }
    }

    public void _setModified(boolean bl) {
        if (this.changeSummary != null && this.isLogging()) {
            this.updateChangeSummaryWithOriginalValues();
        }
    }

    private void _setDeleted(boolean bl) {
        boolean bl2;
        if (this.changeSummary != null && (bl2 = ((SDOChangeSummary)this.changeSummary).setDeleted(this, bl)) && this.isLogging()) {
            this.updateChangeSummaryWithOriginalValues();
        }
    }

    private void setChangeSummaryNonRecursive(ChangeSummary changeSummary) {
        SDOProperty sDOProperty;
        this.changeSummary = changeSummary;
        if (this.getType() != null && (sDOProperty = this.getType().getChangeSummaryProperty()) != null) {
            this.setChangeSummaryProperty(sDOProperty, changeSummary);
        }
    }

    public void _setChangeSummary(ChangeSummary changeSummary) {
        this.updateChangeSummaryAndDataGraph(changeSummary, this.getDataGraph());
    }

    private void updateChangeSummaryAndDataGraph(ChangeSummary changeSummary, DataGraph dataGraph) {
        Iterator iterator = this.getInstanceProperties().iterator();
        this.setDataGraph(dataGraph);
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.isContainment() && !this.isContainedByDataGraph(property)) continue;
            Object object = this.get(property);
            if (object instanceof SDODataObject) {
                ((SDODataObject)object).updateChangeSummaryAndDataGraph(changeSummary, dataGraph);
            }
            if (!(object instanceof ListWrapper)) continue;
            for (Object e : (ListWrapper)object) {
                if (!(e instanceof SDODataObject)) continue;
                ((SDODataObject)e).updateChangeSummaryAndDataGraph(changeSummary, dataGraph);
            }
        }
        this.setChangeSummaryNonRecursive(changeSummary);
    }

    private void updateDataGraph(DataGraph dataGraph) {
        Iterator iterator = this.getInstanceProperties().iterator();
        this.setDataGraph(dataGraph);
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.isContainment() && !this.isContainedByDataGraph(property)) continue;
            Object object = this.get(property);
            if (object instanceof SDODataObject) {
                ((SDODataObject)object).updateDataGraph(dataGraph);
            }
            if (!(object instanceof ListWrapper)) continue;
            for (Object e : (ListWrapper)object) {
                if (!(e instanceof SDODataObject)) continue;
                ((SDODataObject)e).updateDataGraph(dataGraph);
            }
        }
    }

    private void setChangeSummaryProperty(SDOProperty sDOProperty, ChangeSummary changeSummary) {
        if (sDOProperty.isOpenContent()) {
            throw new IllegalArgumentException("ChangeSummary can not be on an open content property.");
        }
        if (sDOProperty.isMany()) {
            throw new IllegalArgumentException("ChangeSummary can not be on a property with many set to true.");
        }
        if (this.isLogging()) {
            this._setModified(true);
        }
        this.setPropertyInternal(sDOProperty, changeSummary, true);
    }

    public void undoChanges(boolean bl, ChangeSummary changeSummary, SDODataObject sDODataObject, String string) {
        List list;
        if (null == changeSummary) {
            return;
        }
        if (((SDOChangeSummary)changeSummary).isDirty(this)) {
            if (!bl) {
                if (null == this.changeSummary) {
                    this.changeSummary = changeSummary;
                }
                if (null == this.container) {
                    this._setContainer(sDODataObject);
                }
                if (null == this.containmentPropertyName) {
                    this._setContainmentPropertyName(string);
                }
            }
            this._setCurrentValueStore((ValueStore)((SDOChangeSummary)changeSummary).getOriginalValueStores().get(this));
            ((SDOChangeSummary)changeSummary).getOriginalValueStores().remove(this);
        }
        if (this.getType().isSequenced() && ((SDOChangeSummary)changeSummary).isDirty((SDOSequence)this.sequence)) {
            list = this.sequence;
            Sequence sequence = (Sequence)((SDOChangeSummary)changeSummary).getOriginalSequences().get(this);
            if (null == sequence && null != list) {
                throw SDOException.oldSequenceNotFound();
            }
            this.sequence = sequence;
            ((SDOChangeSummary)changeSummary).getOldSequences().remove(this);
            ((SDOChangeSummary)changeSummary).getOriginalSequences().remove(this);
        }
        list = ((SDOChangeSummary)changeSummary).getUnsetOCProperties(this);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addOpenContentProperty((Property)list.get(0));
        }
        for (SDOProperty sDOProperty : this.getInstanceProperties()) {
            Object object;
            if (sDOProperty.getType().isChangeSummaryType() || null == (object = this.get(sDOProperty)) && null != this.getChangeSummary()) continue;
            if (sDOProperty.isMany()) {
                if (null == object) continue;
                ((ListWrapper)object).undoChanges((SDOChangeSummary)this.getChangeSummary());
                if (sDOProperty.getType().isDataType()) continue;
                for (Object e : (List)object) {
                    if (null == e) continue;
                    ((SDODataObject)e).undoChanges(false, this.changeSummary, this, sDOProperty.getName());
                }
                continue;
            }
            if (sDOProperty.getType().isDataType() || null == object) continue;
            ((SDODataObject)object).undoChanges(false, this.changeSummary, this, sDOProperty.getName());
        }
    }

    private void updateChangeSummaryWithOriginalValues() {
        if (this.isLogging() && !((SDOChangeSummary)this.getChangeSummary()).isDirty(this) && !((SDOChangeSummary)this.getChangeSummary()).isCreated(this)) {
            ((SDOChangeSummary)this.getChangeSummary()).getOriginalValueStores().put(this, this._getCurrentValueStore());
            this.currentValueStore = this._getCurrentValueStore().copy();
            if (this.getType().isSequenced()) {
                SDOSequence sDOSequence = ((SDOSequence)this.getSequence()).copy();
                ((SDOChangeSummary)this.getChangeSummary()).getOriginalSequences().put(this, sDOSequence);
            }
        }
    }

    public void resetChanges() {
        if (this.container != null && this.containmentPropertyName != null && this.changeSummary != null) {
            ((SDOChangeSummary)this.changeSummary).setOldContainer(this, this.container);
            ((SDOChangeSummary)this.changeSummary).setOldContainmentProperty(this, this.container.getInstanceProperty(this.containmentPropertyName));
        }
        for (SDOProperty sDOProperty : this.getInstanceProperties()) {
            Object object = this.get(sDOProperty);
            if ((sDOProperty.isContainment() || this.isContainedByDataGraph(sDOProperty)) && !sDOProperty.isMany() && object != null && !sDOProperty.getType().isChangeSummaryType()) {
                ((SDODataObject)object).resetChanges();
                continue;
            }
            if (!sDOProperty.isMany() || null == object) continue;
            for (Object e : (ListWrapper)object) {
                if (!sDOProperty.isContainment() && !this.isContainedByDataGraph(sDOProperty) || e == null || sDOProperty.getType().isChangeSummaryType()) continue;
                ((SDODataObject)e).resetChanges();
            }
        }
    }

    public void _setType(Type type) {
        this.type = (SDOType)type;
        if (this.getInstanceProperties().isEmpty()) {
            if (this.type != null) {
                this.getInstanceProperties().addAll(this.type.getProperties());
            }
            this.getInstanceProperties().addAll(this._getOpenContentProperties());
        }
        if (this.type != null) {
            SDOProperty sDOProperty;
            this._getCurrentValueStore().initialize(this);
            if (this.type.isSequenced()) {
                this.sequence = new SDOSequence(this);
            }
            if ((sDOProperty = this.type.getChangeSummaryProperty()) != null) {
                SDOChangeSummary sDOChangeSummary = new SDOChangeSummary(this, this.aHelperContext);
                sDOChangeSummary.endLogging();
                this._setChangeSummary(sDOChangeSummary);
            }
        }
    }

    public void _setCurrentValueStore(ValueStore valueStore) {
        this.currentValueStore = valueStore;
    }

    public ValueStore _getCurrentValueStore() {
        return this.currentValueStore;
    }

    public void _setContainer(DataObject dataObject) {
        this.container = dataObject;
    }

    public Map _getOpenContentPropertiesAttributesMap() {
        HashMap<QName, Object> hashMap = new HashMap<QName, Object>();
        int n = this._getOpenContentPropertiesAttributes().size();
        for (int i = 0; i < n; ++i) {
            Property property = (Property)this._getOpenContentPropertiesAttributes().get(i);
            QName qName = new QName(((SDOProperty)property).getUri(), property.getName());
            hashMap.put(qName, this.get(property));
        }
        return hashMap;
    }

    public void _setOpenContentPropertiesAttributesMap(Map map) {
        for (QName qName : map.keySet()) {
            if (qName.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && qName.getLocalPart().equals("type")) continue;
            Object v = map.get(qName);
            SDOProperty sDOProperty = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(qName.getNamespaceURI(), qName.getLocalPart(), false);
            if (sDOProperty == null) {
                DataObject dataObject = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
                dataObject.set("name", (Object)qName.getLocalPart());
                dataObject.set("type", (Object)SDOConstants.SDO_STRING);
                dataObject.set("many", (Object)false);
                sDOProperty = (SDOProperty)this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, dataObject);
                sDOProperty.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.FALSE);
                sDOProperty.setUri(qName.getNamespaceURI());
                this.set(sDOProperty, v);
                continue;
            }
            this.set(sDOProperty, v);
        }
    }

    public void _setOpenContentPropertiesWithXMLRoots(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object e = list.get(i);
            Object object2 = null;
            String string = null;
            Object object3 = null;
            Type type = null;
            if (e instanceof XMLRoot) {
                object = (XMLRoot)e;
                object3 = object.getObject();
                object2 = object.getLocalName();
                string = object.getNamespaceURI();
                type = object3 instanceof DataObject ? ((DataObject)object3).getType() : ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(object3.getClass());
            } else if (e instanceof DataObject) {
                object3 = e;
                object = ((SDOType)((DataObject)e).getType()).getXmlDescriptor().getDefaultRootElement();
                int n2 = ((String)object).indexOf(":");
                if (n2 > -1) {
                    String string2 = ((String)object).substring(0, n2);
                    if (string2 != null && !string2.equals("")) {
                        string = ((SDOType)((DataObject)e).getType()).getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespacePrefix(string2);
                    }
                    object2 = ((String)object).substring(n2 + 1, ((String)object).length());
                } else {
                    object2 = object;
                }
                type = ((DataObject)e).getType();
            } else {
                type = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(object3.getClass());
            }
            if (object2 == null) continue;
            object = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(string, (String)object2, true);
            if (object == null) {
                object = this.getInstanceProperty((String)object2);
                if (object != null) {
                    if (((SDOProperty)object).getUri() == null && string != null) {
                        object = this.createNewProperty((String)object2, string, type);
                    } else if (((SDOProperty)object).getUri() != null) {
                        if (string == null) {
                            object = this.createNewProperty((String)object2, string, type);
                        } else if (!((SDOProperty)object).getUri().equals(string)) {
                            object = this.createNewProperty((String)object2, string, type);
                        }
                    }
                } else {
                    object = this.createNewProperty((String)object2, string, type);
                }
            }
            if (((SDOProperty)object).isMany()) {
                ((ListWrapper)this.getList((Property)object)).add(object3, false);
                continue;
            }
            this.set((SDOProperty)object, object3, false);
        }
    }

    private SDOProperty createNewProperty(String string, String string2, Type type) {
        DataObject dataObject = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        dataObject.set("name", (Object)string);
        dataObject.set("type", (Object)type);
        dataObject.set("many", (Object)true);
        SDOProperty sDOProperty = (SDOProperty)this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, dataObject);
        sDOProperty.setUri(string2);
        return sDOProperty;
    }

    public List _getOpenContentPropertiesWithXMLRoots() {
        ArrayList<XMLRoot> arrayList = new ArrayList<XMLRoot>();
        int n = this.openContentProperties.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Property property = (Property)this.openContentProperties.get(i);
            XMLRoot xMLRoot = new XMLRoot();
            String string = ((SDOProperty)property).getXPath();
            if (property.getType() != null) {
                if (!property.getType().isDataType()) {
                    object = ((SDOProperty)property).getUri();
                    xMLRoot.setNamespaceURI((String)object);
                } else {
                    object = ((SDOProperty)property).getUri();
                    xMLRoot.setNamespaceURI((String)object);
                }
            }
            xMLRoot.setLocalName(string);
            object = this.get(property);
            if (property.isMany()) {
                int n2 = ((List)object).size();
                for (int j = 0; j < n2; ++j) {
                    XMLRoot xMLRoot2 = new XMLRoot();
                    xMLRoot2.setNamespaceURI(xMLRoot.getNamespaceURI());
                    xMLRoot2.setLocalName(xMLRoot.getLocalName());
                    Object object2 = ((List)object).get(j);
                    if (property.getType() != null && ((SDOType)property.getType()).getXmlDescriptor() == null) {
                        object2 = XMLConversionManager.getDefaultXMLManager().convertObject(object2, String.class);
                    }
                    xMLRoot2.setObject(object2);
                    arrayList.add(xMLRoot2);
                }
                continue;
            }
            if (property.getType() != null && ((SDOType)property.getType()).getXmlDescriptor() == null) {
                object = XMLConversionManager.getDefaultXMLManager().convertObject(object, String.class);
            }
            xMLRoot.setObject(object);
            arrayList.add(xMLRoot);
        }
        return arrayList;
    }

    public List _getOpenContentProperties() {
        if (this.openContentProperties == null) {
            this.openContentProperties = new ArrayList();
        }
        return this.openContentProperties;
    }

    private Map<String, Property> _getOpenContentAliasNamesMap() {
        if (this.openContentAliasNames == null) {
            this.openContentAliasNames = new HashMap();
        }
        return this.openContentAliasNames;
    }

    private void convertValueAndSet(Property property, Object object) {
        Object object2;
        if (property.isMany()) {
            if (object == null) {
                object2 = new ArrayList();
            } else if (object instanceof List) {
                object2 = this.aHelperContext.getDataHelper().convert(property, object);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object);
                object2 = this.aHelperContext.getDataHelper().convert(property, arrayList);
            }
        } else {
            object2 = this.aHelperContext.getDataHelper().convert(property, object);
        }
        this.set(property, object2);
    }

    private void convertValueAndSet(int n, Object object) {
        SDOProperty sDOProperty = this.getInstanceProperty(n);
        Object object2 = this.aHelperContext.getDataHelper().convert((Property)sDOProperty, object);
        this.set(sDOProperty, object2);
    }

    private void convertValueAndSet(String string, Object object) {
        XPathEngine.getInstance().set(string, object, this, true);
    }

    public Object convertObjectToValue(Property property, Class clazz) throws ClassCastException, IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationOnNullArgument((String)"convertObjectToValue"));
        }
        Object object = this.unwrapListValue(property, this.get(property));
        try {
            return ((SDODataHelper)this.aHelperContext.getDataHelper()).convertValueToClass(property, object, clazz);
        }
        catch (Exception exception) {
            throw new ClassCastException("An error occurred during converison or an unsupported conversion was attempted.");
        }
    }

    public Object convertObjectToValue(Property property, int n, Class clazz) throws ClassCastException, IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationOnNullArgument((String)"convertObjectToValue"));
        }
        if (clazz == ClassConstants.List_Class && !property.isMany()) {
            throw new ClassCastException("can not call getList for a property that has isMany false.");
        }
        Object object = n == -1 ? (clazz == ClassConstants.List_Class ? this.get(property) : this.unwrapListValue(property, this.get(property))) : this.getList(property).get(n);
        try {
            return ((SDODataHelper)this.aHelperContext.getDataHelper()).convertValueToClass(property, object, clazz);
        }
        catch (Exception exception) {
            throw new ClassCastException("An error occurred during conversion or an unsupported conversion was attempted.");
        }
    }

    public void _setContainmentPropertyName(String string) {
        this.containmentPropertyName = string;
    }

    public String _getContainmentPropertyName() {
        return this.containmentPropertyName;
    }

    public boolean parentContains(Object object) {
        if (object == null || !(object instanceof DataObject)) {
            return false;
        }
        if (this.getContainer() != null && this.getContainmentProperty() != null) {
            if (object.equals(this.getContainer())) {
                return true;
            }
            return ((SDODataObject)this.getContainer()).parentContains(object);
        }
        return false;
    }

    private boolean isContainedByDataGraph(Property property) {
        return this.isContainedByDataGraph(this.getDataGraph(), property);
    }

    private boolean isContainedByDataGraph(DataGraph dataGraph, Property property) {
        return null != dataGraph && null != property.getType() && !property.getType().isDataType();
    }

    public void updateContainment(Property property, Collection collection, boolean bl) {
        if (property.isContainment() || this.isContainedByDataGraph(property)) {
            Object[] objectArray = collection.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof SDODataObject)) continue;
                this.updateContainment(property, (SDODataObject)object, bl);
            }
        }
    }

    public void updateContainment(Property property, Collection collection) {
        this.updateContainment(property, collection, true);
    }

    public void updateContainment(Property property, SDODataObject sDODataObject, boolean bl) {
        if (property.isContainment() || this.isContainedByDataGraph(property)) {
            boolean bl2;
            boolean bl3 = bl2 = this.getChangeSummary() != null && sDODataObject.getChangeSummary() != null && this.getChangeSummary().equals(sDODataObject.getChangeSummary());
            if (sDODataObject.getContainer() != null) {
                sDODataObject.detach(false, bl);
            }
            boolean bl4 = false;
            if (this.getChangeSummary() != null) {
                bl4 = this.getChangeSummary().isDeleted((DataObject)sDODataObject);
            }
            if (this.getChangeSummary() != null && sDODataObject.getType() != null && sDODataObject.getType().getChangeSummaryProperty() == null) {
                sDODataObject.updateChangeSummaryAndDataGraph(this.getChangeSummary(), this.getDataGraph());
            } else if (sDODataObject.getDataGraph() != this.getDataGraph()) {
                sDODataObject.updateDataGraph(this.getDataGraph());
            }
            sDODataObject._setContainer(this);
            sDODataObject._setContainmentPropertyName(property.getName());
            if (!bl2 && this.getChangeSummary() != null && !this.getChangeSummary().isDeleted((DataObject)sDODataObject)) {
                sDODataObject._setCreated(true);
            }
            if (this.getChangeSummary() != null && this.getChangeSummary().isDeleted((DataObject)sDODataObject)) {
                sDODataObject._setDeleted(false);
            }
            this._setModified(true);
            if (bl4) {
                ValueStore valueStore;
                DataObject dataObject;
                Map map = ((SDOChangeSummary)this.getChangeSummary()).getOriginalValueStores();
                ValueStore valueStore2 = (ValueStore)map.get(sDODataObject);
                if (valueStore2.equals(sDODataObject._getCurrentValueStore())) {
                    map.remove(sDODataObject);
                }
                if ((dataObject = this.getChangeSummary().getOldContainer((DataObject)sDODataObject)) == this && (valueStore = (ValueStore)map.get(dataObject)).equals(this._getCurrentValueStore())) {
                    Map map2 = ((SDOChangeSummary)this.getChangeSummary()).getOriginalElements();
                    List list = dataObject.getInstanceProperties();
                    for (int i = 0; i < list.size(); ++i) {
                        Object object = valueStore.getDeclaredProperty(i);
                        Object v = map2.get(object);
                        if (v == null) continue;
                        List list2 = (List)v;
                        List list3 = ((ListWrapper)object).getCurrentElements();
                        if (list2.size() != list3.size()) {
                            return;
                        }
                        Iterator iterator = list3.iterator();
                        Iterator iterator2 = list2.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next() == iterator2.next()) continue;
                            return;
                        }
                    }
                    map.remove(dataObject);
                }
            }
        }
    }

    public void updateContainment(Property property, SDODataObject sDODataObject) {
        this.updateContainment(property, sDODataObject, true);
    }

    private boolean isLogging() {
        return this.changeSummary != null && this.changeSummary.isLogging();
    }

    public Object writeReplace() {
        return new SDOExternalizableDelegator(this, this.aHelperContext);
    }

    private String getPathPrivate(String string, SDODataObject sDODataObject, String string2) {
        SDODataObject sDODataObject2 = (SDODataObject)sDODataObject.getContainer();
        if (sDODataObject2 == null) {
            return string;
        }
        String string3 = sDODataObject._getContainmentPropertyName();
        SDOProperty sDOProperty = sDODataObject2.getInstanceProperty(string3);
        if (sDOProperty.isMany()) {
            int n = sDODataObject2.getList(sDOProperty).indexOf(sDODataObject);
            return this.getPathPrivate(string3 + "[" + (1 + n) + "]" + string2 + string, sDODataObject2, "/");
        }
        return this.getPathPrivate(string3 + string2 + string, sDODataObject2, "/");
    }

    public String _getPath() {
        if (this.getContainer() == null) {
            return "/";
        }
        return this.getPathPrivate("", this, "");
    }

    private SDOProperty[] getInstancePropertiesArray() {
        int n;
        if (this.openContentProperties == null || this.openContentProperties.isEmpty()) {
            return this.getType().getPropertiesArray();
        }
        SDOProperty[] sDOPropertyArray = this.getType().getPropertiesArray();
        SDOProperty[] sDOPropertyArray2 = new SDOProperty[this.openContentProperties.size() + sDOPropertyArray.length];
        for (n = 0; n < sDOPropertyArray.length; ++n) {
            sDOPropertyArray2[n] = sDOPropertyArray[n];
        }
        for (n = sDOPropertyArray.length; n < sDOPropertyArray2.length; ++n) {
            sDOPropertyArray2[n] = (SDOProperty)this.openContentProperties.get(n - sDOPropertyArray.length);
        }
        return sDOPropertyArray2;
    }

    public Object getPropertyInternal(Property property) {
        int n = ((SDOProperty)property).getIndexInType();
        if (n == -1) {
            return this._getCurrentValueStore().getOpenContentProperty(property);
        }
        return this._getCurrentValueStore().getDeclaredProperty(n);
    }

    public void setPropertyInternal(SDOProperty sDOProperty, Object object, boolean bl) {
        int n;
        Object object2 = this.getPropertyInternal(sDOProperty);
        if (this.type.isSequenced() && bl && !sDOProperty.getType().isChangeSummaryType() && !this.aHelperContext.getXSDHelper().isAttribute((Property)sDOProperty)) {
            if (sDOProperty.isMany()) {
                ((SDOSequence)this.sequence).addSettingWithoutModifyingDataObject(sDOProperty, object);
            } else if (this.isSet(sDOProperty)) {
                ((SDOSequence)this.sequence).updateSettingWithoutModifyingDataObject(sDOProperty, this.get(sDOProperty), object);
            } else {
                ((SDOSequence)this.sequence).addSettingWithoutModifyingDataObject(sDOProperty, object);
            }
        }
        if ((n = sDOProperty.getIndexInType()) == -1) {
            this._getCurrentValueStore().setOpenContentProperty(sDOProperty, object);
        } else {
            this._getCurrentValueStore().setDeclaredProperty(n, object);
            SDOProperty sDOProperty2 = (SDOProperty)sDOProperty.getOpposite();
            if (null != sDOProperty2) {
                SDODataObject sDODataObject;
                Object object3;
                Object object4;
                if (null != object) {
                    if (sDOProperty.isMany()) {
                        object4 = (List)object;
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            sDODataObject = (SDODataObject)object3.next();
                            if (this == sDODataObject.get(sDOProperty2)) continue;
                            sDODataObject.setInternal(sDOProperty2, this, true);
                        }
                    } else {
                        object4 = (SDODataObject)object;
                        if (sDOProperty2.isMany()) {
                            object3 = ((SDODataObject)object4).getList(sDOProperty2);
                            if (!object3.contains(this)) {
                                object3.add(this);
                            }
                        } else if (this != ((SDODataObject)object4).get(sDOProperty2)) {
                            ((SDODataObject)object4).setInternal(sDOProperty2, this, true);
                        }
                    }
                }
                if (null != object2) {
                    if (sDOProperty.isMany()) {
                        object4 = (List)object2;
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            sDODataObject = (SDODataObject)object3.next();
                            if (null == sDODataObject.get(sDOProperty2)) continue;
                            sDODataObject.set(sDOProperty2, null);
                        }
                    } else {
                        object4 = (DataObject)object2;
                        if (sDOProperty2.isMany()) {
                            object3 = object4.getList((Property)sDOProperty2);
                            if (object3.contains(this)) {
                                object3.remove(this);
                            }
                        } else if (null != object4.get((Property)sDOProperty2)) {
                            object4.set((Property)sDOProperty2, null);
                        }
                    }
                }
            }
        }
    }

    public void addOpenContentProperty(Property property) {
        List list = null;
        list = this.aHelperContext.getXSDHelper().isAttribute(property) ? this._getOpenContentPropertiesAttributes() : this._getOpenContentProperties();
        if (!list.contains(property)) {
            if (this.isLogging()) {
                ((SDOChangeSummary)this.getChangeSummary()).removeUnsetOCProperty(this, property);
            }
            list.add(property);
            this.getInstanceProperties().add(property);
            int n = property.getAliasNames().size();
            for (int i = 0; i < n; ++i) {
                this._getOpenContentAliasNamesMap().put((String)property.getAliasNames().get(i), property);
            }
        }
    }

    public void removeOpenContentProperty(Property property) {
        if (this.isLogging()) {
            ((SDOChangeSummary)this.getChangeSummary()).setUnsetOCProperty(this, property);
        }
        this._getOpenContentProperties().remove(property);
        this._getOpenContentPropertiesAttributes().remove(property);
        this.getInstanceProperties().remove(property);
        int n = property.getAliasNames().size();
        for (int i = 0; i < n; ++i) {
            this._getOpenContentAliasNamesMap().remove(property.getAliasNames().get(i));
        }
    }

    public boolean isSetInternal(Property property) {
        int n = ((SDOProperty)property).getIndexInType();
        if (n == -1) {
            return this._getCurrentValueStore().isSetOpenContentProperty(property);
        }
        return this._getCurrentValueStore().isSetDeclaredProperty(n);
    }

    private void unsetInternal(Property property, boolean bl) {
        if (property.isMany()) {
            this.getList(property).clear();
            if (property.isOpenContent()) {
                this.removeOpenContentProperty(property);
            } else {
                this._getCurrentValueStore().unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
            }
        } else if (property.isOpenContent()) {
            this._getCurrentValueStore().unsetOpenContentProperty(property);
            this.removeOpenContentProperty(property);
        } else {
            this._getCurrentValueStore().unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
        }
        if (this.type.isSequenced() && this.sequence != null && bl && this.aHelperContext.getXSDHelper().isElement(property)) {
            ((SDOSequence)this.sequence).removeSettingWithoutModifyingDataObject(property);
        }
    }

    public String _getSdoRef() {
        return this.sdoRef;
    }

    public void _setOpenContentPropertiesAttributes(List list) {
        this.openContentPropertiesAttributes = list;
    }

    public List _getOpenContentPropertiesAttributes() {
        if (this.openContentPropertiesAttributes == null) {
            this.openContentPropertiesAttributes = new ArrayList();
        }
        return this.openContentPropertiesAttributes;
    }

    public List<Setting> getSettings() {
        if (null != this.sequence) {
            return ((SDOSequence)this.sequence).getSettings();
        }
        return null;
    }

    public void _setSdoRef(String string) {
        this.sdoRef = string;
    }

    private Object unwrapListValue(Property property, Object object) {
        if (property == null || object == null) {
            return null;
        }
        if (!property.isMany() || !(object instanceof ListWrapper)) {
            return object;
        }
        ListWrapper listWrapper = (ListWrapper)object;
        if (listWrapper.size() == 0) {
            return null;
        }
        return listWrapper.get(0);
    }
}

