/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;

public class SDOUtil {
    private static final String HEXADECIMAL_DIGITS = "0123456789abcdefABCDEF";
    private static final String INVALID_URI_WARNING = "SDOUtil: The URI [{0}] used for java package name generation is invalid - generating [{1}].";
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static boolean asWordSeparator = false;

    private static void preProcessJavaReservedNames(String string) {
        SDOUtil.preProcessReservedNames(string, SDOConstants.javaReservedWordsList, "sdo_type_generation_warning_class_name_violates_java_spec");
    }

    private static void preProcessSDOReservedNames(String string) {
        SDOUtil.preProcessReservedNames(string, SDOConstants.sdoInterfaceReservedWordsList, "sdo_type_generation_warning_class_name_violates_sdo_spec");
    }

    private static void preProcessReservedNames(String string, String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            AbstractSessionLog.getLog().log(6, string2, new Object[]{"SDOUtil", string, stringArray[i]});
        }
    }

    public static String getDefaultPackageName() {
        return SDOUtil.getPackageNameFromURI("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPackageNameFromURI(String string) {
        String string2;
        ArrayList<String> arrayList;
        Object object;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (null == string || string.equals("")) {
            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string, "defaultPackage"}, false);
            return "defaultPackage";
        }
        String string3 = string;
        boolean bl2 = false;
        boolean bl = false;
        try {
            int n;
            block59: {
                try {
                    URI uRI = new URI(string);
                    String string4 = uRI.getScheme();
                    if (null == string4) break block59;
                    if (string4.equalsIgnoreCase("http") || string4.equalsIgnoreCase("urn")) {
                        string = uRI.getSchemeSpecificPart();
                    } else {
                        bl = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    String string6;
                    int n6;
                    Object object2;
                    AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{"null", "defaultPackage"}, false);
                    String string7 = "defaultPackage";
                    Object var13_9 = null;
                    int n7 = string.lastIndexOf(47);
                    int n8 = string.indexOf(47);
                    int n9 = string.lastIndexOf(46);
                    if ((bl && n9 != -1 || n9 != -1 && n7 != -1 && n8 != -1 && n7 - n8 > 1) && (((String)(object2 = string.substring(n9))).length() == 3 || ((String)object2).length() == 4 || ((String)object2).equalsIgnoreCase(".html"))) {
                        string = string.substring(0, n9);
                    }
                    if ((n6 = ((StringTokenizer)(object2 = new StringTokenizer(string, "/:"))).countTokens()) == 0) {
                        return "defaultPackage";
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>(n6);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string6 = ((StringTokenizer)object2).nextToken();
                        arrayList2.add(SDOUtil.decodeUriHexadecimalEscapeSequence(string6));
                    }
                    string6 = ((String)arrayList2.remove(0)).toLowerCase();
                    object2 = new StringTokenizer(string6, ".");
                    if (((StringTokenizer)object2).countTokens() < 1) {
                        AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string, "defaultPackage"}, false);
                        return "defaultPackage";
                    }
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string6 = ((StringTokenizer)object2).nextToken();
                        if (string6.equals("www")) continue;
                        arrayList2.add(0, string6);
                    }
                    n2 = 0;
                    for (String string8 : arrayList2) {
                        arrayList2.set(n2++, string8.toLowerCase());
                    }
                    n2 = 0;
                    Iterator iterator = arrayList2.iterator();
                    while (true) {
                        String string8;
                        if (!iterator.hasNext()) {
                            if (!bl2) return string7;
                            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string3, stringBuffer}, false);
                            return string7;
                        }
                        string8 = (String)iterator.next();
                        StringBuffer stringBuffer3 = new StringBuffer();
                        for (int i = 0; i < string8.length(); ++i) {
                            char c = string8.charAt(i);
                            if (Character.isJavaIdentifierPart(c)) {
                                stringBuffer3.append(c);
                                continue;
                            }
                            stringBuffer3.append('_');
                        }
                        if (!Character.isJavaIdentifierStart(stringBuffer3.charAt(0))) {
                            stringBuffer3.insert(0, '_');
                        }
                        if (n2++ != 0) {
                            stringBuffer3.insert(0, '.');
                        }
                        stringBuffer.append(stringBuffer3.toString());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    String string9;
                    int n10;
                    Object object3;
                    bl2 = true;
                    if (string.length() > 4) {
                        String string10 = string.substring(0, 4);
                        if (string10.equalsIgnoreCase("urn:")) {
                            string = string.substring(4);
                        } else {
                            string10 = string.substring(0, 5);
                            if (string10.equalsIgnoreCase("http:")) {
                                string = string.substring(5);
                            }
                        }
                    }
                    Object var13_10 = null;
                    int n11 = string.lastIndexOf(47);
                    int n12 = string.indexOf(47);
                    int n13 = string.lastIndexOf(46);
                    if ((bl && n13 != -1 || n13 != -1 && n11 != -1 && n12 != -1 && n11 - n12 > 1) && (((String)(object3 = string.substring(n13))).length() == 3 || ((String)object3).length() == 4 || ((String)object3).equalsIgnoreCase(".html"))) {
                        string = string.substring(0, n13);
                    }
                    if ((n10 = ((StringTokenizer)(object3 = new StringTokenizer(string, "/:"))).countTokens()) == 0) {
                        return "defaultPackage";
                    }
                    ArrayList<String> arrayList3 = new ArrayList<String>(n10);
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        string9 = ((StringTokenizer)object3).nextToken();
                        arrayList3.add(SDOUtil.decodeUriHexadecimalEscapeSequence(string9));
                    }
                    string9 = ((String)arrayList3.remove(0)).toLowerCase();
                    object3 = new StringTokenizer(string9, ".");
                    if (((StringTokenizer)object3).countTokens() < 1) {
                        AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string, "defaultPackage"}, false);
                        return "defaultPackage";
                    }
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        string9 = ((StringTokenizer)object3).nextToken();
                        if (string9.equals("www")) continue;
                        arrayList3.add(0, string9);
                    }
                    n2 = 0;
                    for (String string13 : arrayList3) {
                        arrayList3.set(n2++, string13.toLowerCase());
                    }
                    n2 = 0;
                    Iterator iterator = arrayList3.iterator();
                    while (true) {
                        String string13;
                        if (!iterator.hasNext()) {
                            if (!bl2) return stringBuffer.toString();
                            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string3, stringBuffer}, false);
                            return stringBuffer.toString();
                        }
                        string13 = (String)iterator.next();
                        StringBuffer stringBuffer5 = new StringBuffer();
                        for (int i = 0; i < string13.length(); ++i) {
                            char c = string13.charAt(i);
                            if (Character.isJavaIdentifierPart(c)) {
                                stringBuffer5.append(c);
                                continue;
                            }
                            stringBuffer5.append('_');
                        }
                        if (!Character.isJavaIdentifierStart(stringBuffer5.charAt(0))) {
                            stringBuffer5.insert(0, '_');
                        }
                        if (n2++ != 0) {
                            stringBuffer5.insert(0, '.');
                        }
                        stringBuffer.append(stringBuffer5.toString());
                    }
                }
            }
            Object var13_8 = null;
            int n3 = string.lastIndexOf(47);
            int n4 = string.indexOf(47);
            int n5 = string.lastIndexOf(46);
            if ((bl && n5 != -1 || n5 != -1 && n3 != -1 && n4 != -1 && n3 - n4 > 1) && (((String)(object = string.substring(n5))).length() == 3 || ((String)object).length() == 4 || ((String)object).equalsIgnoreCase(".html"))) {
                string = string.substring(0, n5);
            }
            if ((n = ((StringTokenizer)(object = new StringTokenizer(string, "/:"))).countTokens()) == 0) {
                return "defaultPackage";
            }
            arrayList = new ArrayList<String>(n);
        }
        catch (Throwable throwable) {
            String string11;
            int n14;
            Object object4;
            Object var13_11 = null;
            int n15 = string.lastIndexOf(47);
            int n16 = string.indexOf(47);
            int n17 = string.lastIndexOf(46);
            if ((bl && n17 != -1 || n17 != -1 && n15 != -1 && n16 != -1 && n15 - n16 > 1) && (((String)(object4 = string.substring(n17))).length() == 3 || ((String)object4).length() == 4 || ((String)object4).equalsIgnoreCase(".html"))) {
                string = string.substring(0, n17);
            }
            if ((n14 = ((StringTokenizer)(object4 = new StringTokenizer(string, "/:"))).countTokens()) == 0) {
                return "defaultPackage";
            }
            ArrayList<String> arrayList4 = new ArrayList<String>(n14);
            while (((StringTokenizer)object4).hasMoreTokens()) {
                string11 = ((StringTokenizer)object4).nextToken();
                arrayList4.add(SDOUtil.decodeUriHexadecimalEscapeSequence(string11));
            }
            string11 = ((String)arrayList4.remove(0)).toLowerCase();
            object4 = new StringTokenizer(string11, ".");
            if (((StringTokenizer)object4).countTokens() < 1) {
                AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string, "defaultPackage"}, false);
                return "defaultPackage";
            }
            while (((StringTokenizer)object4).hasMoreTokens()) {
                string11 = ((StringTokenizer)object4).nextToken();
                if (string11.equals("www")) continue;
                arrayList4.add(0, string11);
            }
            n2 = 0;
            for (String string12 : arrayList4) {
                arrayList4.set(n2++, string12.toLowerCase());
            }
            n2 = 0;
            Iterator iterator = arrayList4.iterator();
            while (true) {
                String string12;
                if (!iterator.hasNext()) {
                    if (!bl2) throw throwable;
                    AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string3, stringBuffer}, false);
                    throw throwable;
                }
                string12 = (String)iterator.next();
                StringBuffer stringBuffer4 = new StringBuffer();
                for (int i = 0; i < string12.length(); ++i) {
                    char c = string12.charAt(i);
                    if (Character.isJavaIdentifierPart(c)) {
                        stringBuffer4.append(c);
                        continue;
                    }
                    stringBuffer4.append('_');
                }
                if (!Character.isJavaIdentifierStart(stringBuffer4.charAt(0))) {
                    stringBuffer4.insert(0, '_');
                }
                if (n2++ != 0) {
                    stringBuffer4.insert(0, '.');
                }
                stringBuffer.append(stringBuffer4.toString());
            }
        }
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            arrayList.add(SDOUtil.decodeUriHexadecimalEscapeSequence(string2));
        }
        string2 = ((String)arrayList.remove(0)).toLowerCase();
        object = new StringTokenizer(string2, ".");
        if (((StringTokenizer)object).countTokens() < 1) {
            AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string, "defaultPackage"}, false);
            return "defaultPackage";
        }
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            if (string2.equals("www")) continue;
            arrayList.add(0, string2);
        }
        n2 = 0;
        for (String string5 : arrayList) {
            arrayList.set(n2++, string5.toLowerCase());
        }
        n2 = 0;
        for (String string5 : arrayList) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < string5.length(); ++i) {
                char c = string5.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    stringBuffer2.append(c);
                    continue;
                }
                stringBuffer2.append('_');
            }
            if (!Character.isJavaIdentifierStart(stringBuffer2.charAt(0))) {
                stringBuffer2.insert(0, '_');
            }
            if (n2++ != 0) {
                stringBuffer2.insert(0, '.');
            }
            stringBuffer.append(stringBuffer2.toString());
        }
        if (!bl2) return stringBuffer.toString();
        AbstractSessionLog.getLog().log(1, INVALID_URI_WARNING, new Object[]{string3, stringBuffer}, false);
        return stringBuffer.toString();
    }

    private static String decodeUriHexadecimalEscapeSequence(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (i + 2 < string.length() && HEXADECIMAL_DIGITS.indexOf(string.charAt(i + 1)) >= 0 && HEXADECIMAL_DIGITS.indexOf(string.charAt(i + 2)) >= 0) {
                    String string2 = string.substring(i + 1, i + 3);
                    stringBuffer.append((char)Integer.parseInt(string2, 16));
                    i += 2;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String className(String string, boolean bl) {
        return SDOUtil.className(string, true, bl, true);
    }

    public static String className(String string, boolean bl, boolean bl2, boolean bl3) {
        SDOUtil.preProcessJavaReservedNames(string);
        SDOUtil.preProcessSDOReservedNames(string);
        String[] stringArray = SDOUtil.getWordList(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringArray.length == 0) {
            return stringBuffer.toString();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            char[] cArray = stringArray[i].toCharArray();
            if (Character.isLowerCase(cArray[0])) {
                cArray[0] = Character.toUpperCase(cArray[0]);
            }
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] >= ' ' && cArray[j] < '\u007f') {
                    if (cArray[j] == '_' && asWordSeparator) continue;
                    stringBuffer.append(cArray[j]);
                    continue;
                }
                if (bl) {
                    stringBuffer.append(SDOUtil.escapeUnicode(stringBuffer2, cArray[j]));
                    continue;
                }
                stringBuffer.append(cArray[j]);
            }
        }
        String string2 = stringBuffer.toString();
        if (!string.equals(string2) && bl3) {
            int n = !string.equalsIgnoreCase(string2) ? 5 : 2;
            if (bl2) {
                AbstractSessionLog.getLog().log(n, "sdo_type_generation_modified_class_naming_format_to", new Object[]{"SDOUtil", string, string2});
            } else {
                AbstractSessionLog.getLog().log(n, "sdo_type_generation_modified_function_naming_format_to", new Object[]{"SDOUtil", string, string2});
            }
        }
        return string2;
    }

    public static String methodName(String string) {
        return SDOUtil.methodName(string, true);
    }

    public static String methodName(String string, boolean bl) {
        return SDOUtil.className(string, bl, false, true);
    }

    public static String setMethodName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SET).append(SDOUtil.methodName(string));
        return stringBuffer.toString();
    }

    public static String getMethodName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GET).append(SDOUtil.className(string, true, false, false));
        return stringBuffer.toString();
    }

    public static String getMethodName(String string, String string2) {
        if (string2.equals(ClassConstants.PBOOLEAN.getName()) || string2.equals(ClassConstants.BOOLEAN.getName())) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(IS).append(SDOUtil.className(string, true, false, false));
            return stringBuffer.toString();
        }
        return SDOUtil.getMethodName(string);
    }

    public static String constantName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = SDOUtil.getWordList(string);
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[0].toUpperCase());
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append('_');
                stringBuffer.append(stringArray[i].toUpperCase());
            }
        }
        return stringBuffer.toString();
    }

    private static String[] getWordList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            while (n2 < n && SDOUtil.isPunct(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n) break;
            int n3 = SDOUtil.nextBreak(string, n2);
            String string2 = n3 != -1 ? string.substring(n2, n3) : string.substring(n2);
            arrayList.add(SDOUtil.escape(string2));
            if (n3 == -1) break;
            n2 = n3;
        }
        return arrayList.toArray(new String[0]);
    }

    private static boolean isPunct(char c) {
        if (c == '-' || c == '.' || c == ':' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de') {
            return true;
        }
        return c == '_' && asWordSeparator;
    }

    private static boolean isUncased(char c) {
        return Character.isLetter(c) && !Character.isUpperCase(c) && !Character.isLowerCase(c);
    }

    private static int nextBreak(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == '_' && !asWordSeparator || i >= n2 - 1 || (c = string.charAt(i + 1)) == '_' && !asWordSeparator) continue;
            if (SDOUtil.isPunct(c)) {
                return i + 1;
            }
            if (Character.isDigit(c2) && !Character.isDigit(c)) {
                return i + 1;
            }
            if (!Character.isDigit(c2) && Character.isDigit(c)) {
                return i + 1;
            }
            if (Character.isLowerCase(c2) && !Character.isLowerCase(c)) {
                return i + 1;
            }
            if (i < n2 - 2) {
                char c3 = string.charAt(i + 2);
                if (c3 == '_' && !asWordSeparator) continue;
                if (Character.isUpperCase(c2) && Character.isUpperCase(c) && Character.isLowerCase(c3)) {
                    return i + 1;
                }
            }
            if (Character.isLetter(c2) && !Character.isLetter(c)) {
                return i + 1;
            }
            if (!Character.isLetter(c2) && Character.isLetter(c)) {
                return i + 1;
            }
            if (SDOUtil.isUncased(c2) && !SDOUtil.isUncased(c)) {
                return i + 1;
            }
            if (SDOUtil.isUncased(c2) || !SDOUtil.isUncased(c)) continue;
            return i + 1;
        }
        return -1;
    }

    private static String escape(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            SDOUtil.escape(stringBuffer, string, i);
            return stringBuffer.toString();
        }
        return string;
    }

    private static void escape(StringBuffer stringBuffer, String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("_");
            if (c <= '\u000f') {
                stringBuffer.append("000");
            } else if (c <= '\u00ff') {
                stringBuffer.append("00");
            } else if (c <= '\u0fff') {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(c, 16));
        }
    }

    private static String escapeUnicode(StringBuffer stringBuffer, char c) {
        String string = Integer.toString(c, 16);
        int n = string.length();
        stringBuffer.setLength(6);
        stringBuffer.setCharAt(0, '\\');
        stringBuffer.setCharAt(1, 'u');
        int n2 = 2;
        int n3 = n;
        while (n3 < 4) {
            stringBuffer.setCharAt(n2, '0');
            ++n3;
            ++n2;
        }
        stringBuffer.replace(n2, 6, string);
        return stringBuffer.toString();
    }
}

