/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;

public class BasicTypeHelperImpl {
    private static Set integralTypes = new HashSet();
    private static Set floatingPointTypes = new HashSet();
    private static Set dateClasses = new HashSet();
    private static Map primitiveToWrapper = new HashMap();
    private static Map wrapperToPrimitive = new HashMap();
    private static final BasicTypeHelperImpl singleton;

    public static BasicTypeHelperImpl getInstance() {
        return singleton;
    }

    public String getTypeName(Object type) {
        Class clazz = this.getJavaClass(type);
        return clazz == null ? null : clazz.getName();
    }

    public Class getJavaClass(Object type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ClassDescriptor) {
            clazz = ((ClassDescriptor)type).getJavaClass();
        }
        return clazz;
    }

    public Object getObjectType() {
        return Object.class;
    }

    public Object getBooleanType() {
        return Boolean.TYPE;
    }

    public Object getBooleanClassType() {
        return Boolean.class;
    }

    public Object getCharType() {
        return Character.TYPE;
    }

    public Object getCharacterClassType() {
        return Character.class;
    }

    public Object getByteType() {
        return Byte.TYPE;
    }

    public Object getByteClassType() {
        return Byte.class;
    }

    public Object getShortType() {
        return Short.TYPE;
    }

    public Object getShortClassType() {
        return Short.class;
    }

    public Object getIntType() {
        return Integer.TYPE;
    }

    public Object getIntegerClassType() {
        return Integer.class;
    }

    public Object getLongType() {
        return Long.TYPE;
    }

    public Object getLongClassType() {
        return Long.class;
    }

    public Object getFloatType() {
        return Float.TYPE;
    }

    public Object getFloatClassType() {
        return Float.class;
    }

    public Object getDoubleType() {
        return Double.TYPE;
    }

    public Object getDoubleClassType() {
        return Double.class;
    }

    public Object getStringType() {
        return String.class;
    }

    public Object getBigIntegerType() {
        return BigInteger.class;
    }

    public Object getBigDecimalType() {
        return BigDecimal.class;
    }

    public Object getDateType() {
        return Date.class;
    }

    public boolean isEnumType(Object type) {
        Class clazz = this.getJavaClass(type);
        return clazz != null && clazz.isEnum();
    }

    public boolean isNumericType(Object type) {
        return this.isIntegralType(type) || this.isFloatingPointType(type) || this.isBigIntegerType(type) || this.isBigDecimalType(type);
    }

    public boolean isIntegralType(Object type) {
        return integralTypes.contains(type);
    }

    public boolean isFloatingPointType(Object type) {
        return floatingPointTypes.contains(type);
    }

    public boolean isWrapperClass(Object type) {
        return wrapperToPrimitive.containsKey(type);
    }

    public boolean isBooleanType(Object type) {
        return type == this.getBooleanType() || type == this.getBooleanClassType();
    }

    public boolean isCharacterType(Object type) {
        return type == this.getCharType() || type == this.getCharacterClassType();
    }

    public boolean isByteType(Object type) {
        return type == this.getByteType() || type == this.getByteClassType();
    }

    public boolean isShortType(Object type) {
        return type == this.getShortType() || type == this.getShortClassType();
    }

    public boolean isIntType(Object type) {
        return type == this.getIntType() || type == this.getIntegerClassType();
    }

    public boolean isLongType(Object type) {
        return type == this.getLongType() || type == this.getLongClassType();
    }

    public boolean isFloatType(Object type) {
        return type == this.getFloatType() || type == this.getFloatClassType();
    }

    public boolean isDoubleType(Object type) {
        return type == this.getDoubleType() || type == this.getDoubleClassType();
    }

    public boolean isStringType(Object type) {
        return type == this.getStringType();
    }

    public boolean isDateClass(Object type) {
        return dateClasses.contains(type);
    }

    public boolean isBigIntegerType(Object type) {
        return type == this.getBigIntegerType();
    }

    public boolean isBigDecimalType(Object type) {
        return type == this.getBigDecimalType();
    }

    public boolean isOrderableType(Object type) {
        return this.isNumericType(type) || this.isStringType(type) || this.isDateClass(type) || this.isEnumType(type);
    }

    public boolean isAssignableFrom(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        Object promoted = this.extendedBinaryNumericPromotion(left, right);
        if (promoted != null) {
            return true;
        }
        if (this.isDateClass(left) && this.isDateClass(right)) {
            return true;
        }
        if (this.isBooleanType(left) && this.isBooleanType(right)) {
            return true;
        }
        return this.getJavaClass(left).isAssignableFrom(this.getJavaClass(right));
    }

    public Object extendedBinaryNumericPromotion(Object left, Object right) {
        if (left == null || right == null || !this.isNumericType(left) || !this.isNumericType(right)) {
            return null;
        }
        if (this.isBigDecimalType(left) || this.isBigDecimalType(right)) {
            return this.getBigDecimalType();
        }
        if (this.isBigIntegerType(left)) {
            return this.isFloatingPointType(right) ? right : this.getBigIntegerType();
        }
        if (this.isBigIntegerType(right)) {
            return this.isFloatingPointType(left) ? left : this.getBigIntegerType();
        }
        boolean wrapper = false;
        if (this.isWrapperClass(left)) {
            wrapper = true;
            left = this.getPrimitiveType(left);
        }
        if (this.isWrapperClass(right)) {
            wrapper = true;
            right = this.getPrimitiveType(right);
        }
        Object promoted = this.binaryNumericPromotion(left, right);
        if (wrapper && promoted != null) {
            promoted = this.getWrapperClass(promoted);
        }
        return promoted;
    }

    protected Object getPrimitiveType(Object wrapper) {
        return wrapperToPrimitive.get(wrapper);
    }

    protected Object getWrapperClass(Object primitive) {
        return primitiveToWrapper.get(primitive);
    }

    protected Object binaryNumericPromotion(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        Object type = null;
        if (left == this.getDoubleType() || right == this.getDoubleType()) {
            type = this.getDoubleType();
        } else if (left == this.getFloatType() || right == this.getFloatType()) {
            type = this.getFloatType();
        } else if (left == this.getLongType() || right == this.getLongType()) {
            type = this.getLongType();
        } else if (this.isIntegralType(left) && this.isIntegralType(right)) {
            type = this.getIntType();
        }
        return type;
    }

    static {
        integralTypes.add(Byte.TYPE);
        integralTypes.add(Byte.class);
        integralTypes.add(Short.TYPE);
        integralTypes.add(Short.class);
        integralTypes.add(Character.TYPE);
        integralTypes.add(Character.class);
        integralTypes.add(Integer.TYPE);
        integralTypes.add(Integer.class);
        integralTypes.add(Long.TYPE);
        integralTypes.add(Long.class);
        floatingPointTypes.add(Float.TYPE);
        floatingPointTypes.add(Float.class);
        floatingPointTypes.add(Double.TYPE);
        floatingPointTypes.add(Double.class);
        dateClasses.add(Date.class);
        dateClasses.add(Calendar.class);
        dateClasses.add(java.sql.Date.class);
        dateClasses.add(Time.class);
        dateClasses.add(Timestamp.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
        singleton = new BasicTypeHelperImpl();
    }
}

