/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class OrderedListContainerPolicy
extends ListContainerPolicy {
    public OrderedListContainerPolicy() {
    }

    public OrderedListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public OrderedListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    protected void addIntoAtIndex(Integer index, Object object, Object container, AbstractSession session) {
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().wrapObject(object, session);
        }
        try {
            if (index == null || index > this.sizeFor(container)) {
                ((List)container).add(object);
            } else {
                ((List)container).add(index, object);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(object, container, ex1);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotAddElement(object, container, ex2);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotAddElement(object, container, ex3);
        }
    }

    public void compareCollectionsForChange(Object oldList, Object newList, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        ListIterator iterator;
        Vector orderedObjectsToAdd = new Vector();
        Hashtable<Integer, Integer> indicesToRemove = new Hashtable<Integer, Integer>();
        Hashtable oldListIndexValue = new Hashtable();
        IdentityHashMap oldListValueIndex = new IdentityHashMap();
        IdentityHashMap objectsToAdd = new IdentityHashMap();
        IdentityHashMap newListValueIndex = new IdentityHashMap();
        if (oldList != null) {
            iterator = (ListIterator)this.iteratorFor(oldList);
            while (iterator.hasNext()) {
                Integer index = new Integer(iterator.nextIndex());
                Object value = iterator.next();
                oldListValueIndex.put(value, index);
                oldListIndexValue.put(index, value);
                indicesToRemove.put(index, index);
            }
        }
        if (newList != null) {
            iterator = (ListIterator)this.iteratorFor(newList);
            while (iterator.hasNext()) {
                newListValueIndex.put(iterator.next(), new Integer(iterator.previousIndex()));
            }
            int index = 0;
            int offset = 0;
            iterator = (ListIterator)this.iteratorFor(newList);
            while (iterator.hasNext()) {
                index = iterator.nextIndex();
                Object currentObject = iterator.next();
                if (currentObject != null) {
                    if (oldListValueIndex.containsKey(currentObject)) {
                        int oldIndex = (Integer)oldListValueIndex.get(currentObject);
                        oldListValueIndex.remove(currentObject);
                        if (index == oldIndex) {
                            indicesToRemove.remove(new Integer(oldIndex));
                            offset = 0;
                            continue;
                        }
                        if (index == oldIndex + offset) {
                            indicesToRemove.remove(new Integer(oldIndex));
                            continue;
                        }
                        int movedObjects = 0;
                        int deletedObjects = 0;
                        boolean moved = true;
                        if (oldIndex < index) {
                            ++offset;
                        } else {
                            for (int i = oldIndex - 1; i >= index; --i) {
                                Object oldObject = oldListIndexValue.get(new Integer(i));
                                if (newListValueIndex.containsKey(oldObject)) {
                                    ++movedObjects;
                                    continue;
                                }
                                ++deletedObjects;
                            }
                            if (index == oldIndex + offset - deletedObjects) {
                                offset -= deletedObjects;
                                moved = false;
                            } else if (movedObjects > 1) {
                                ++offset;
                            } else {
                                Object oldObject = oldListIndexValue.get(new Integer(index));
                                if (newListValueIndex.containsKey(oldObject) && (Integer)newListValueIndex.get(oldObject) - index > 1) {
                                    moved = false;
                                    --offset;
                                }
                            }
                        }
                        if (moved) {
                            orderedObjectsToAdd.add(currentObject);
                            continue;
                        }
                        indicesToRemove.remove(new Integer(oldIndex));
                        continue;
                    }
                    ++offset;
                    objectsToAdd.put(currentObject, currentObject);
                    orderedObjectsToAdd.add(currentObject);
                    continue;
                }
                --offset;
            }
        }
        Vector orderedIndicesToRemove = new Vector(indicesToRemove.values());
        Collections.sort(orderedIndicesToRemove);
        changeRecord.addAdditionChange(objectsToAdd, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(oldListValueIndex, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedAdditionChange(orderedObjectsToAdd, newListValueIndex, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedRemoveChange(orderedIndicesToRemove, oldListIndexValue, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public Object iteratorFor(Object container) {
        return ((List)container).listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession parentSession) {
        Object synchronizedValueOfTarget = valueOfTarget;
        if (valueOfTarget instanceof IndirectCollection) {
            synchronizedValueOfTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
        }
        Object object = synchronizedValueOfTarget;
        synchronized (object) {
            ObjectChangeSet objectChanges2;
            Vector removedIndices = changeRecord.getOrderedRemoveObjectIndices();
            if (removedIndices.isEmpty()) {
                for (ObjectChangeSet objectChanges2 : changeRecord.getRemoveObjectList().keySet()) {
                    this.removeFrom(objectChanges2.getOldKey(), objectChanges2.getTargetVersionOfSourceObject(mergeManager.getSession()), valueOfTarget, parentSession);
                    this.registerRemoveNewObjectIfRequired(objectChanges2, mergeManager);
                }
            } else {
                for (int i = removedIndices.size() - 1; i >= 0; --i) {
                    Integer index = (int)((Integer)removedIndices.elementAt(i));
                    objectChanges2 = (ObjectChangeSet)changeRecord.getOrderedRemoveObject(index);
                    this.removeFromAtIndex(index, valueOfTarget);
                    if (!changeRecord.getRemoveObjectList().containsKey(objectChanges2)) continue;
                    this.registerRemoveNewObjectIfRequired(objectChanges2, mergeManager);
                }
            }
            Enumeration addObjects = changeRecord.getOrderedAddObjects().elements();
            while (addObjects.hasMoreElements()) {
                objectChanges2 = (ObjectChangeSet)addObjects.nextElement();
                boolean objectAdded = changeRecord.getAddObjectList().containsKey(objectChanges2);
                Object object2 = null;
                if (objectAdded && shouldMergeCascadeParts) {
                    object2 = this.mergeCascadeParts(objectChanges2, mergeManager, parentSession);
                }
                if (object2 == null) {
                    object2 = objectChanges2.getTargetVersionOfSourceObject(mergeManager.getSession());
                }
                if (objectAdded && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object2, valueOfTarget, mergeManager.getSession())) continue;
                    this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges2), object2, valueOfTarget, mergeManager.getSession());
                    continue;
                }
                this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges2), object2, valueOfTarget, mergeManager.getSession());
            }
        }
    }

    protected void registerRemoveNewObjectIfRequired(ObjectChangeSet objectChanges, MergeManager mergeManager) {
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
        }
    }

    protected void removeFromAtIndex(int index, Object container) {
        try {
            ((List)container).remove(index);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotRemoveFromContainer(new Integer(index), container, this);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotRemoveFromContainer(new Integer(index), container, this);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotRemoveFromContainer(new Integer(index), container, this);
        }
    }
}

