/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.ExistenceType;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDescriptor {
    private static final String FIELD = "FIELD";
    private static final String PROPERTY = "PROPERTY";
    private Class m_javaClass;
    private ClassAccessor m_accessor;
    private ClassDescriptor m_descriptor;
    private DatabaseTable m_primaryTable;
    private Enum m_existenceChecking;
    private MetadataDescriptor m_inheritanceRootDescriptor = null;
    private MetadataDescriptor m_inheritanceParentDescriptor = null;
    private boolean m_isCascadePersist = false;
    private boolean m_ignoreAnnotations = false;
    private boolean m_ignoreDefaultMappings = false;
    private boolean m_hasCache = false;
    private boolean m_hasCacheInterceptor = false;
    private boolean m_hasDefaultRedirectors = false;
    private boolean m_hasChangeTracking = false;
    private boolean m_hasCustomizer = false;
    private boolean m_hasReadOnly = false;
    private boolean m_hasCopyPolicy = false;
    private boolean m_usesPropertyAccess = false;
    private Boolean m_usesCascadedOptimisticLocking;
    private String m_xmlAccess = null;
    private String m_xmlSchema = null;
    private String m_xmlCatalog = null;
    private String m_embeddedIdAttributeName;
    private List<String> m_idAttributeNames = new ArrayList<String>();
    private List<String> m_orderByAttributeNames = new ArrayList<String>();
    private List<String> m_idOrderByAttributeNames = new ArrayList<String>();
    private List<MetadataDescriptor> m_embeddableDescriptors = new ArrayList<MetadataDescriptor>();
    private List<RelationshipAccessor> m_relationshipAccessors = new ArrayList<RelationshipAccessor>();
    private List<BasicCollectionAccessor> m_basicCollectionAccessors = new ArrayList<BasicCollectionAccessor>();
    private Map<String, Type> m_pkClassIDs = new HashMap<String, Type>();
    private Map<String, Type> m_genericTypes = new HashMap<String, Type>();
    private Map<String, MappingAccessor> m_accessors = new HashMap<String, MappingAccessor>();
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();
    private Map<String, String> m_pkJoinColumnAssociations = new HashMap<String, String>();
    private Map<String, AttributeOverrideMetadata> m_attributeOverrides = new HashMap<String, AttributeOverrideMetadata>();
    private Map<String, AssociationOverrideMetadata> m_associationOverrides = new HashMap<String, AssociationOverrideMetadata>();
    private Map<String, Map<String, MetadataAccessor>> m_biDirectionalManyToManyAccessors = new HashMap<String, Map<String, MetadataAccessor>>();

    public MetadataDescriptor(Class javaClass) {
        this.m_descriptor = new RelationalDescriptor();
        this.m_descriptor.setAlias("");
        this.m_descriptor.getQueryManager().checkDatabaseForDoesExist();
        this.setJavaClass(javaClass);
    }

    public MetadataDescriptor(Class javaClass, ClassAccessor classAccessor) {
        this(javaClass);
        this.setClassAccessor(classAccessor);
    }

    public void addAccessor(MappingAccessor accessor) {
        this.m_accessors.put(accessor.getAttributeName(), accessor);
    }

    public void addAssociationOverride(AssociationOverrideMetadata associationOverride) {
        this.m_associationOverrides.put(associationOverride.getName(), associationOverride);
    }

    public void addAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        this.m_attributeOverrides.put(attributeOverride.getName(), attributeOverride);
    }

    public void addBasicCollectionAccessor(MetadataAccessor accessor) {
        this.m_basicCollectionAccessors.add((BasicCollectionAccessor)accessor);
    }

    public void addClassIndicator(Class entityClass, String value) {
        if (this.isInheritanceSubclass()) {
            this.getInheritanceRootDescriptor().addClassIndicator(entityClass, value);
        } else {
            this.m_descriptor.getInheritancePolicy().addClassNameIndicator(entityClass.getName(), (Object)value);
        }
    }

    public void addDefaultEventListener(EntityListener listener) {
        this.m_descriptor.getEventManager().addDefaultEventListener((DescriptorEventListener)listener);
    }

    public void addEmbeddableDescriptor(MetadataDescriptor embeddableDescriptor) {
        this.m_embeddableDescriptors.add(embeddableDescriptor);
    }

    public void addEntityListenerEventListener(EntityListener listener) {
        this.m_descriptor.getEventManager().addEntityListenerEventListener((DescriptorEventListener)listener);
    }

    public void addFieldForInsert(DatabaseField field) {
        this.getReturningPolicy().addFieldForInsert(field);
    }

    public void addFieldForInsertReturnOnly(DatabaseField field) {
        this.getReturningPolicy().addFieldForInsertReturnOnly(field);
    }

    public void addFieldForUpdate(DatabaseField field) {
        this.getReturningPolicy().addFieldForUpdate(field);
    }

    public void addIdAttributeName(String idAttributeName) {
        this.m_idAttributeNames.add(idAttributeName);
    }

    public void addMapping(DatabaseMapping mapping) {
        this.m_descriptor.addMapping(mapping);
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField fkField, DatabaseField pkField) {
        this.m_descriptor.addForeignKeyFieldForMultipleTable(fkField, pkField);
        this.m_pkJoinColumnAssociations.put(fkField.getName(), pkField.getName());
    }

    public void addGenericType(String genericName, Type type) {
        this.m_genericTypes.put(genericName, type);
    }

    public void addPKClassId(String attributeName, Type type) {
        this.m_pkClassIDs.put(attributeName, type);
    }

    public void addProperty(PropertyMetadata property) {
        if (property.shouldOverride(this.m_properties.get(property.getName()))) {
            this.m_properties.put(property.getName(), property);
            this.m_descriptor.getProperties().put(property.getName(), property.getConvertedValue());
        }
    }

    public void addPrimaryKeyField(DatabaseField field) {
        this.m_descriptor.addPrimaryKeyField(field);
    }

    public void addRelationshipAccessor(MappingAccessor accessor) {
        String mappedBy;
        this.m_relationshipAccessors.add((RelationshipAccessor)accessor);
        if (accessor.isManyToMany() && (mappedBy = ((ManyToManyAccessor)accessor).getMappedBy()) != null && !mappedBy.equals("")) {
            String referenceClassName = ((ManyToManyAccessor)accessor).getReferenceClassName();
            if (!this.m_biDirectionalManyToManyAccessors.containsKey(referenceClassName)) {
                this.m_biDirectionalManyToManyAccessors.put(referenceClassName, new HashMap());
            }
            this.m_biDirectionalManyToManyAccessors.get(referenceClassName).put(mappedBy, accessor);
        }
        this.m_accessor.getProject().addAccessorWithRelationships(this.m_accessor);
    }

    public void addTable(DatabaseTable table) {
        this.m_descriptor.addTable(table);
    }

    public boolean excludeSuperclassListeners() {
        return this.m_descriptor.getEventManager().excludeSuperclassListeners();
    }

    public MappingAccessor getAccessorFor(String fieldOrPropertyName) {
        MappingAccessor accessor = this.m_accessors.get(fieldOrPropertyName);
        if (accessor == null && (accessor = this.m_accessors.get(MetadataMethod.getAttributeNameFromMethodName(fieldOrPropertyName))) == null && this.isInheritanceSubclass()) {
            accessor = this.getInheritanceParentDescriptor().getAccessorFor(fieldOrPropertyName);
        }
        return accessor;
    }

    public String getAlias() {
        return this.m_descriptor.getAlias();
    }

    public AssociationOverrideMetadata getAssociationOverrideFor(String attributeName) {
        return this.m_associationOverrides.get(attributeName);
    }

    public AttributeOverrideMetadata getAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.get(attributeName);
    }

    public List<BasicCollectionAccessor> getBasicCollectionAccessors() {
        return this.m_basicCollectionAccessors;
    }

    public String getDefaultTableName() {
        String defaultTableName = this.getAlias().toUpperCase();
        if (this.isInheritanceSubclass() && this.getInheritanceRootDescriptor().usesSingleTableInheritanceStrategy()) {
            defaultTableName = this.getInheritanceRootDescriptor().getPrimaryTableName();
        }
        return defaultTableName;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_accessor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_descriptor;
    }

    public String getEmbeddedIdAttributeName() {
        return this.m_embeddedIdAttributeName;
    }

    public Type getGenericType(String genericName) {
        return this.m_genericTypes.get(genericName);
    }

    public String getIdAttributeName() {
        if (this.getIdAttributeNames().isEmpty()) {
            if (this.isInheritanceSubclass()) {
                return this.getInheritanceRootDescriptor().getIdAttributeName();
            }
            return "";
        }
        return this.getIdAttributeNames().get(0);
    }

    public List<String> getIdAttributeNames() {
        return this.m_idAttributeNames;
    }

    public List<String> getIdOrderByAttributeNames() {
        if (this.m_idOrderByAttributeNames.isEmpty()) {
            this.m_idOrderByAttributeNames = this.m_idAttributeNames.isEmpty() ? (this.isInheritanceSubclass() ? this.getInheritanceRootDescriptor().getIdAttributeNames() : this.getAccessorFor(this.getEmbeddedIdAttributeName()).getReferenceDescriptor().getOrderByAttributeNames()) : this.m_idAttributeNames;
        }
        return this.m_idOrderByAttributeNames;
    }

    public MetadataAccessor getBiDirectionalManyToManyAccessor(String className, String attributeName) {
        return this.m_biDirectionalManyToManyAccessors.get(className).get(attributeName);
    }

    public List<String> getOrderByAttributeNames() {
        if (this.m_orderByAttributeNames.isEmpty()) {
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.isDirectToFieldMapping()) continue;
                this.m_orderByAttributeNames.add(mapping.getAttributeName());
            }
        }
        return this.m_orderByAttributeNames;
    }

    public Class getJavaClass() {
        return this.m_javaClass;
    }

    public String getJavaClassName() {
        return this.m_descriptor.getJavaClassName();
    }

    public MetadataLogger getLogger() {
        return this.getProject().getLogger();
    }

    public MetadataDescriptor getInheritanceParentDescriptor() {
        return this.m_inheritanceParentDescriptor;
    }

    public MetadataDescriptor getInheritanceRootDescriptor() {
        return this.m_inheritanceRootDescriptor;
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        return this.getMappingForAttributeName(attributeName, null);
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName, MetadataAccessor referencingAccessor) {
        MappingAccessor accessor = this.getAccessorFor(attributeName);
        if (accessor != null) {
            if (accessor.isRelationship()) {
                RelationshipAccessor relationshipAccessor = (RelationshipAccessor)accessor;
                if (referencingAccessor != null && (relationshipAccessor.isOneToOne() || relationshipAccessor.isCollectionAccessor())) {
                    String mappedBy = null;
                    mappedBy = relationshipAccessor.isOneToOne() ? ((OneToOneAccessor)relationshipAccessor).getMappedBy() : ((CollectionAccessor)relationshipAccessor).getMappedBy();
                    if (mappedBy != null && mappedBy.equals(referencingAccessor.getAttributeName())) {
                        throw ValidationException.circularMappedByReferences((Class)referencingAccessor.getJavaClass(), (String)referencingAccessor.getAttributeName(), (Class)this.getJavaClass(), (String)attributeName);
                    }
                }
                relationshipAccessor.processRelationship();
            }
            return accessor.getDescriptor().getClassDescriptor().getMappingForAttributeName(attributeName);
        }
        for (MetadataDescriptor embeddableDescriptor : this.m_embeddableDescriptors) {
            DatabaseMapping mapping = embeddableDescriptor.getMappingForAttributeName(attributeName, referencingAccessor);
            if (mapping == null) continue;
            return mapping;
        }
        if (this.isInheritanceSubclass()) {
            return this.getInheritanceParentDescriptor().getMappingForAttributeName(attributeName, referencingAccessor);
        }
        return null;
    }

    public List<DatabaseMapping> getMappings() {
        return this.m_descriptor.getMappings();
    }

    public String getPKClassName() {
        String pkClassName = null;
        if (this.m_descriptor.hasCMPPolicy()) {
            pkClassName = ((CMP3Policy)this.m_descriptor.getCMPPolicy()).getPKClassName();
        }
        return pkClassName;
    }

    public String getPrimaryKeyFieldName() {
        return this.getPrimaryKeyFields().iterator().next().getName();
    }

    public List<String> getPrimaryKeyFieldNames() {
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        ArrayList<String> primaryKeyFieldNames = new ArrayList<String>(primaryKeyFields.size());
        for (DatabaseField primaryKeyField : primaryKeyFields) {
            primaryKeyFieldNames.add(primaryKeyField.getName());
        }
        return primaryKeyFieldNames;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        List<DatabaseField> primaryKeyFields = this.m_descriptor.getPrimaryKeyFields();
        if (primaryKeyFields.isEmpty() && this.isInheritanceSubclass()) {
            primaryKeyFields = this.getInheritanceRootDescriptor().getPrimaryKeyFields();
        }
        return primaryKeyFields;
    }

    public String getPrimaryKeyJoinColumnAssociation(String foreignKeyName) {
        String primaryKeyName = this.m_pkJoinColumnAssociations.get(foreignKeyName);
        if (primaryKeyName == null || !this.isInheritanceSubclass()) {
            return foreignKeyName;
        }
        return this.getInheritanceParentDescriptor().getPrimaryKeyJoinColumnAssociation(primaryKeyName);
    }

    public DatabaseTable getPrimaryKeyTable() {
        return this.getPrimaryKeyFields().iterator().next().getTable();
    }

    public DatabaseTable getPrimaryTable() {
        if (this.m_primaryTable == null && this.isInheritanceSubclass()) {
            return this.getInheritanceRootDescriptor().getPrimaryTable();
        }
        if (this.m_descriptor.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return this.m_primaryTable;
    }

    public String getPrimaryTableName() {
        return this.getPrimaryTable().getName();
    }

    public MetadataProject getProject() {
        return this.getClassAccessor().getProject();
    }

    public List<RelationshipAccessor> getRelationshipAccessors() {
        return this.m_relationshipAccessors;
    }

    protected ReturningPolicy getReturningPolicy() {
        if (!this.m_descriptor.hasReturningPolicy()) {
            this.m_descriptor.setReturningPolicy(new ReturningPolicy());
        }
        return this.m_descriptor.getReturningPolicy();
    }

    public DatabaseField getSequenceNumberField() {
        return this.m_descriptor.getSequenceNumberField();
    }

    public String getXMLAccess() {
        return this.m_xmlAccess;
    }

    public String getXMLCatalog() {
        return this.m_xmlCatalog;
    }

    public String getXMLSchema() {
        return this.m_xmlSchema;
    }

    public boolean hasAccessorFor(String attributeName) {
        return this.getAccessorFor(attributeName) != null;
    }

    public boolean hasAssociationOverrideFor(String attributeName) {
        return this.m_associationOverrides.containsKey(attributeName);
    }

    public boolean hasAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.containsKey(attributeName);
    }

    public boolean hasCompositePrimaryKey() {
        return this.getPrimaryKeyFields().size() > 1 || this.getPKClassName() != null;
    }

    public boolean hasEmbeddedIdAttribute() {
        return this.m_embeddedIdAttributeName != null;
    }

    public boolean hasExistenceChecking() {
        return this.m_existenceChecking != null;
    }

    public boolean hasInheritance() {
        return this.m_descriptor.hasInheritance();
    }

    public boolean hasBiDirectionalManyToManyAccessorFor(String className, String attributeName) {
        if (this.m_biDirectionalManyToManyAccessors.containsKey(className)) {
            return this.m_biDirectionalManyToManyAccessors.get(className).containsKey(attributeName);
        }
        return false;
    }

    public boolean hasCache() {
        return this.m_hasCache;
    }

    public boolean hasCacheInterceptor() {
        return this.m_hasCacheInterceptor;
    }

    public boolean hasDefaultRedirectors() {
        return this.m_hasDefaultRedirectors;
    }

    public boolean hasChangeTracking() {
        return this.m_hasChangeTracking;
    }

    public boolean hasCopyPolicy() {
        return this.m_hasCopyPolicy;
    }

    public boolean hasCustomizer() {
        return this.m_hasCustomizer;
    }

    public boolean hasReadOnly() {
        return this.m_hasReadOnly;
    }

    public boolean hasMappingForAttributeName(String attributeName) {
        return this.m_descriptor.getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasPrimaryKeyFields() {
        return this.m_descriptor.getPrimaryKeyFields().size() > 0;
    }

    public boolean ignoreAnnotations() {
        return this.m_ignoreAnnotations;
    }

    public boolean ignoreDefaultMappings() {
        return this.m_ignoreDefaultMappings;
    }

    public boolean isCascadePersist() {
        return this.m_isCascadePersist;
    }

    public boolean isEmbeddable() {
        return this.m_descriptor.isAggregateDescriptor();
    }

    public boolean isEmbeddableCollection() {
        return this.m_descriptor.isAggregateCollectionDescriptor();
    }

    public boolean isInheritanceSubclass() {
        return this.m_inheritanceParentDescriptor != null;
    }

    public boolean isXmlFieldAccess() {
        return this.m_xmlAccess != null && this.m_xmlAccess.equals(FIELD);
    }

    public boolean isXmlPropertyAccess() {
        return this.m_xmlAccess != null && this.m_xmlAccess.equals(PROPERTY);
    }

    public boolean pkClassWasNotValidated() {
        return !this.m_pkClassIDs.isEmpty();
    }

    public void setAlias(String alias) {
        this.m_descriptor.setAlias(alias);
    }

    public void setClassAccessor(ClassAccessor accessor) {
        this.m_accessor = accessor;
        accessor.setDescriptor(this);
    }

    public void setClassIndicatorField(DatabaseField field) {
        this.m_descriptor.getInheritancePolicy().setClassIndicatorField(field);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setEmbeddedIdAttributeName(String embeddedIdAttributeName) {
        this.m_embeddedIdAttributeName = embeddedIdAttributeName;
    }

    public void setEntityEventListener(EntityListener listener) {
        this.m_descriptor.getEventManager().setEntityEventListener((DescriptorEventListener)listener);
    }

    public void setExcludeDefaultListeners(boolean excludeDefaultListeners) {
        this.m_descriptor.getEventManager().setExcludeDefaultListeners(excludeDefaultListeners);
    }

    public void setExcludeSuperclassListeners(boolean excludeSuperclassListeners) {
        this.m_descriptor.getEventManager().setExcludeSuperclassListeners(excludeSuperclassListeners);
    }

    public void setExistenceChecking(Enum existenceChecking) {
        this.m_existenceChecking = existenceChecking;
        if (existenceChecking.name().equals(ExistenceType.CHECK_CACHE.name())) {
            this.m_descriptor.getQueryManager().checkCacheForDoesExist();
        } else if (existenceChecking.name().equals(ExistenceType.CHECK_DATABASE.name())) {
            this.m_descriptor.getQueryManager().checkDatabaseForDoesExist();
        } else if (existenceChecking.name().equals(ExistenceType.ASSUME_EXISTENCE.name())) {
            this.m_descriptor.getQueryManager().assumeExistenceForDoesExist();
        } else if (existenceChecking.name().equals(ExistenceType.ASSUME_NON_EXISTENCE.name())) {
            this.m_descriptor.getQueryManager().assumeNonExistenceForDoesExist();
        }
    }

    public void setHasCache() {
        this.m_hasCache = true;
    }

    public void setHasCacheInterceptor() {
        this.m_hasCacheInterceptor = true;
    }

    public void setHasDefaultRedirectors() {
        this.m_hasDefaultRedirectors = true;
    }

    public void setHasChangeTracking() {
        this.m_hasChangeTracking = true;
    }

    public void setHasCopyPolicy() {
        this.m_hasCopyPolicy = true;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.m_ignoreAnnotations = ignoreAnnotations;
    }

    public void setIgnoreDefaultMappings(boolean ignoreDefaultMappings) {
        this.m_ignoreDefaultMappings = ignoreDefaultMappings;
    }

    public void setInheritanceParentDescriptor(MetadataDescriptor inheritanceParentDescriptor) {
        this.m_inheritanceParentDescriptor = inheritanceParentDescriptor;
    }

    public void setInheritanceRootDescriptor(MetadataDescriptor inheritanceRootDescriptor) {
        this.m_inheritanceRootDescriptor = inheritanceRootDescriptor;
    }

    public void setIsCascadePersist(boolean isCascadePersist) {
        this.m_isCascadePersist = isCascadePersist;
    }

    public void setIsEmbeddable() {
        this.m_descriptor.descriptorIsAggregate();
    }

    public void setJavaClass(Class javaClass) {
        this.m_javaClass = javaClass;
        this.m_descriptor.setJavaClassName(javaClass.getName());
        if (javaClass.isInterface()) {
            this.m_descriptor.setJavaInterfaceName(javaClass.getName());
        }
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy policy) {
        this.m_descriptor.setOptimisticLockingPolicy(policy);
    }

    public void setParentClass(Class parent) {
        this.m_descriptor.getInheritancePolicy().setParentClassName(parent.getName());
    }

    public void setPKClass(Class pkClass) {
        this.setPKClass(pkClass.getName());
    }

    public void setPKClass(String pkClassName) {
        CMP3Policy policy = new CMP3Policy();
        policy.setPrimaryKeyClassName(pkClassName);
        this.m_descriptor.setCMPPolicy((CMPPolicy)policy);
    }

    public void setPrimaryTable(DatabaseTable primaryTable) {
        this.addTable(primaryTable);
        this.m_primaryTable = primaryTable;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.m_descriptor.setReadOnly();
        }
        this.m_hasReadOnly = true;
    }

    public void setSequenceNumberField(DatabaseField field) {
        this.m_descriptor.setSequenceNumberField(field);
    }

    public void setSequenceNumberName(String name) {
        this.m_descriptor.setSequenceNumberName(name);
    }

    public void setSingleTableInheritanceStrategy() {
        this.m_descriptor.getInheritancePolicy().setSingleTableStrategy();
    }

    public void setUsesCascadedOptimisticLocking(Boolean usesCascadedOptimisticLocking) {
        this.m_usesCascadedOptimisticLocking = usesCascadedOptimisticLocking;
    }

    public void setUsesPropertyAccess(boolean usesPropertyAccess) {
        this.m_usesPropertyAccess = usesPropertyAccess;
    }

    public void setXMLAccess(String xmlAccess) {
        this.m_xmlAccess = xmlAccess;
    }

    public void setXMLCatalog(String xmlCatalog) {
        this.m_xmlCatalog = xmlCatalog;
    }

    public void setXMLSchema(String xmlSchema) {
        this.m_xmlSchema = xmlSchema;
    }

    public boolean usesCascadedOptimisticLocking() {
        return this.m_usesCascadedOptimisticLocking != null && this.m_usesCascadedOptimisticLocking != false;
    }

    public boolean usesJoinedInheritanceStrategy() {
        return this.m_descriptor.getInheritancePolicy().isJoinedStrategy();
    }

    public boolean usesOptimisticLocking() {
        return this.m_descriptor.usesOptimisticLocking();
    }

    public boolean usesPropertyAccess() {
        return this.m_usesPropertyAccess;
    }

    public boolean usesSingleTableInheritanceStrategy() {
        return !this.usesJoinedInheritanceStrategy();
    }

    public boolean usesVersionColumnOptimisticLocking() {
        return this.m_usesCascadedOptimisticLocking != null;
    }

    public void validatePKClassId(String attributeName, Type type) {
        if (this.m_pkClassIDs.containsKey(attributeName)) {
            Type expectedType = this.m_pkClassIDs.get(attributeName);
            if (type == expectedType) {
                this.m_pkClassIDs.remove(attributeName);
            } else {
                throw ValidationException.invalidCompositePKAttribute((Class)this.getJavaClass(), (String)this.getPKClassName(), (String)attributeName, (Type)expectedType, (Type)type);
            }
        }
    }
}

