/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class MappingAccessor
extends MetadataAccessor {
    private AccessMethodsMetadata m_accessMethods;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();

    protected MappingAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected MappingAccessor(Annotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    protected String getGetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getGetMethodName() != null) {
            return this.m_accessMethods.getGetMethodName();
        }
        return this.getAccessibleObjectName();
    }

    protected int getMappingJoinFetchType(Enum joinFetchType) {
        if (joinFetchType == null) {
            return 0;
        }
        if (joinFetchType.name().equals(JoinFetchType.INNER.name())) {
            return 1;
        }
        return 2;
    }

    public Class getRawClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor accessor = this.getProject().getAccessor(this.getReferenceClassName());
        if (accessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit((String)this.getReferenceClassName());
        }
        return accessor.getDescriptor();
    }

    protected String getSetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getSetMethodName() != null) {
            return this.m_accessMethods.getSetMethodName();
        }
        return ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_accessMethods, accessibleObject);
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    protected void processProperties(DatabaseMapping mapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata property : this.getProperties()) {
                this.processProperty(mapping, property);
            }
        } else {
            Object property;
            Object properties = this.getAnnotation(Properties.class);
            if (properties != null) {
                for (Annotation property2 : (Annotation[])MetadataHelper.invokeMethod("value", properties)) {
                    this.processProperty(mapping, new PropertyMetadata(property2, this.getAccessibleObject()));
                }
            }
            if ((property = this.getAnnotation(Property.class)) != null) {
                this.processProperty(mapping, new PropertyMetadata((Annotation)property, this.getAccessibleObject()));
            }
        }
    }

    protected void processProperty(DatabaseMapping mapping, PropertyMetadata property) {
        if (property.shouldOverride(this.m_properties.get(property.getName()))) {
            this.m_properties.put(property.getName(), property);
            mapping.getProperties().put(property.getName(), property.getConvertedValue());
        }
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethods) {
        this.m_accessMethods = accessMethods;
    }

    protected void setAccessorMethods(DatabaseMapping mapping) {
        if (this.usesPropertyAccess(this.getDescriptor())) {
            mapping.setGetMethodName(this.getGetMethodName());
            mapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setIndirectionPolicy(CollectionMapping mapping, String mapKey, boolean usesIndirection) {
        Class rawClass = this.getRawClass();
        if (usesIndirection) {
            if (rawClass == Map.class) {
                mapping.useTransparentMap(mapKey);
            } else if (rawClass == List.class) {
                mapping.useTransparentList();
            } else if (rawClass == Collection.class) {
                mapping.useTransparentCollection();
                mapping.setContainerPolicy((ContainerPolicy)new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (rawClass == Set.class) {
                mapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), rawClass);
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass == Map.class) {
                mapping.useMapClass(Hashtable.class, mapKey);
            } else if (rawClass == Set.class) {
                mapping.useCollectionClass(HashSet.class);
            } else if (rawClass == List.class || rawClass == Collection.class) {
                mapping.useCollectionClass(Vector.class);
            } else if (mapKey == null || mapKey.equals("")) {
                mapping.useCollectionClass(rawClass);
            } else {
                mapping.useMapClass(rawClass, mapKey);
            }
        }
    }

    public boolean usesPropertyAccess(MetadataDescriptor descriptor) {
        if (this.m_accessMethods == null) {
            return descriptor.usesPropertyAccess();
        }
        return true;
    }
}

