/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class StructConverterMetadata
extends AbstractConverterMetadata {
    private String m_converter;

    public StructConverterMetadata() {
        super("<struct-converter>");
    }

    public StructConverterMetadata(Annotation structConverter, MetadataAccessibleObject accessibleObject) {
        super(structConverter, accessibleObject);
        this.setConverter((String)MetadataHelper.invokeMethod("converter", structConverter));
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof StructConverterMetadata) {
            StructConverterMetadata structConverter = (StructConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), structConverter.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_converter, structConverter.getConverter());
        }
        return false;
    }

    public String getConverter() {
        return this.m_converter;
    }

    public String getConverterClassName() {
        if (this.getConverter().equals("JGEOMETRY")) {
            return "org.eclipse.persistence.platform.database.oracle.converters.JGeometryConverter";
        }
        return this.getConverter();
    }

    public boolean isStructConverter() {
        return true;
    }

    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        if (mapping.isAbstractDirectMapping()) {
            AbstractDirectMapping directMapping = (AbstractDirectMapping)mapping;
            directMapping.setFieldType(2002);
            directMapping.setConverter(null);
            directMapping.setConverterClassName(null);
        } else if (!mapping.isDirectCollectionMapping() && !mapping.isDirectMapMapping()) {
            throw ValidationException.invalidMappingForStructConverter((String)this.getName(), (DatabaseMapping)mapping);
        }
    }

    public void setConverter(String converter) {
        this.m_converter = converter;
    }
}

