/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.JPAQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedQueryMetadata
extends ORMetadata {
    private List<QueryHintMetadata> m_hints = new ArrayList<QueryHintMetadata>();
    private String m_name;
    private String m_query;

    public NamedQueryMetadata() {
        super("<named-query>");
    }

    protected NamedQueryMetadata(String xmlElement) {
        super(xmlElement);
    }

    public NamedQueryMetadata(Annotation namedQuery, MetadataAccessibleObject accessibleObject) {
        super(namedQuery, accessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", namedQuery);
        this.m_query = (String)MetadataHelper.invokeMethod("query", namedQuery);
        for (Annotation hint : (Annotation[])MetadataHelper.invokeMethod("hints", namedQuery)) {
            this.m_hints.add(new QueryHintMetadata(hint, accessibleObject));
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedQueryMetadata) {
            NamedQueryMetadata query = (NamedQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, query.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_query, query.getQuery())) {
                return false;
            }
            return this.valuesMatch(this.m_hints, query.getHints());
        }
        return false;
    }

    public List<QueryHintMetadata> getHints() {
        return this.m_hints;
    }

    @Override
    public String getIdentifier() {
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void process(AbstractSession session, ClassLoader loader) {
        try {
            HashMap<String, String> hints = this.processQueryHints(session);
            session.addJPAQuery((DatabaseQuery)new JPAQuery(this.getName(), this.getQuery(), hints));
        }
        catch (Exception exception) {
            throw ValidationException.errorProcessingNamedQuery(this.getClass(), (String)this.getName(), (Exception)exception);
        }
    }

    protected HashMap<String, String> processQueryHints(AbstractSession session) {
        HashMap<String, String> hints = new HashMap<String, String>();
        for (QueryHintMetadata hint : this.m_hints) {
            QueryHintsHandler.verify(hint.getName(), hint.getValue(), this.m_name, session);
            hints.put(hint.getName(), hint.getValue());
        }
        return hints;
    }

    public void setHints(List<QueryHintMetadata> hints) {
        this.m_hints = hints;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }
}

