/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsMappingProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Project;

public class XMLEntityMappingsReader {
    public static final String ORM_XSD = "javax/persistence/orm_1_0.xsd";
    public static final String ORM_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ECLIPSELINK_ORM_XSD = "xsd/eclipselink_orm_1_0.xsd";
    public static final String ECLIPSELINK_ORM_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static XMLContext m_ormProject;
    private static XMLContext m_eclipseLinkOrmProject;

    protected static XMLEntityMappings read(Reader reader1, Reader reader2, ClassLoader classLoader) {
        XMLEntityMappings xmlEntityMappings;
        if (m_ormProject == null) {
            m_ormProject = new XMLContext((Project)new XMLEntityMappingsMappingProject(ORM_NAMESPACE, ORM_XSD));
            m_eclipseLinkOrmProject = new XMLContext((Project)new XMLEntityMappingsMappingProject(ECLIPSELINK_ORM_NAMESPACE, ECLIPSELINK_ORM_XSD));
        }
        try {
            XMLUnmarshaller unmarshaller = m_ormProject.createUnmarshaller();
            unmarshaller.setValidationMode(3);
            xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader1);
        }
        catch (Exception e) {
            try {
                XMLUnmarshaller unmarshaller = m_eclipseLinkOrmProject.createUnmarshaller();
                unmarshaller.setValidationMode(3);
                xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader2);
            }
            catch (Exception ee) {
                throw new RuntimeException(ee);
            }
        }
        return xmlEntityMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEntityMappings read(URL url, ClassLoader classLoader) throws IOException {
        InputStreamReader reader1 = null;
        InputStreamReader reader2 = null;
        try {
            try {
                reader1 = new InputStreamReader(url.openStream(), "UTF-8");
                reader2 = new InputStreamReader(url.openStream(), "UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                throw ValidationException.fatalErrorOccurred((Exception)exception);
            }
            XMLEntityMappings entityMappings = XMLEntityMappingsReader.read(reader1, reader2, classLoader);
            entityMappings.setMappingFile(url);
            XMLEntityMappings xMLEntityMappings = entityMappings;
            return xMLEntityMappings;
        }
        finally {
            try {
                if (reader1 != null) {
                    reader1.close();
                }
                if (reader2 != null) {
                    reader2.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
    }
}

