/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;

public class SDODataFactory
implements DataFactory {
    private HelperContext aHelperContext;

    public SDODataFactory() {
    }

    public SDODataFactory(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public DataObject create(String uri, String typeName) {
        Type sdoType = this.getHelperContext().getTypeHelper().getType(uri, typeName);
        if (sdoType != null) {
            return this.create(sdoType);
        }
        throw new IllegalArgumentException((Throwable)SDOException.typeNotFound((String)uri, (String)typeName));
    }

    public DataObject create(Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException((Throwable)SDOException.typeNotFoundForInterface(null));
        }
        Type type = this.getHelperContext().getTypeHelper().getType(interfaceClass);
        if (type != null && type.getInstanceClass() != null) {
            return this.create(type);
        }
        throw new IllegalArgumentException((Throwable)SDOException.typeNotFoundForInterface((String)interfaceClass.getName()));
    }

    public DataObject create(Type type) {
        if (type.isAbstract() || type.isDataType()) {
            throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForType((String)type.getURI(), (String)type.getName()));
        }
        Class typedDataObjectClass = ((SDOType)type).getInstanceClass();
        if (typedDataObjectClass != null) {
            try {
                Class implClass = ((SDOType)type).getImplClass();
                if (implClass != null) {
                    SDODataObject theDataObject = (SDODataObject)implClass.newInstance();
                    theDataObject._setType(type);
                    theDataObject._setHelperContext(this.getHelperContext());
                    return theDataObject;
                }
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForClass((Exception)e, (String)typedDataObjectClass.getName(), (String)type.getURI(), (String)type.getName()));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException((Throwable)SDOException.errorCreatingDataObjectForClass((Exception)e, (String)typedDataObjectClass.getName(), (String)type.getURI(), (String)type.getName()));
            }
        }
        SDODataObject dataObject = new SDODataObject();
        dataObject._setType(type);
        dataObject._setHelperContext(this.getHelperContext());
        return dataObject;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

