/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDODataHelper
implements DataHelper {
    private HelperContext aHelperContext;

    public SDODataHelper() {
    }

    public SDODataHelper(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    private XMLConversionManager getXMLConversionManager() {
        return ((SDOXMLHelper)this.getHelperContext().getXMLHelper()).getXmlConversionManager();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (null == timeZone) {
            this.getXMLConversionManager().setTimeZone(TimeZone.getTimeZone("GMT"));
        } else {
            this.getXMLConversionManager().setTimeZone(timeZone);
        }
    }

    public void setTimeZoneQualified(boolean timeZoneQualified) {
        this.getXMLConversionManager().setTimeZoneQualified(timeZoneQualified);
    }

    public Date toDate(String dateString) {
        Calendar c = this.toCalendar(dateString);
        return c.getTime();
    }

    public Calendar toCalendar(String dateString) {
        if (dateString == null) {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError(null));
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        if (Pattern.matches("(^--0[1-9]-(([0-2][0-9])|(3[0-1])))|(^--1[0-2]-(([0-2][0-9])|(3[0-1])))", dateString)) {
            int _case = 1;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("(^----(([0-2][0-9])|(3[0-1])))", dateString)) {
            int _case = 2;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("--((0[1-9])|(1[0-2]))--", dateString)) {
            int _case = 1;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}-((0[0-9])|(1[0-2]))", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}-((0[0-9])|(1[0-2]))-(([0-2][0-9])|(3[0-1]))", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}-((0[0-9])|(1[0-2]))-(([0-2][0-9])|(3[0-1]))T(([0-1][0-9])|(2[0-4]))(:[0-5][0-9]){2}((.[0-9]{3})|)", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-T:.", c);
        } else if (Pattern.matches("(([0-1][0-9])|(2[0-4]))(:[0-5][0-9]){2}((.[0-9]{3})|)", dateString)) {
            int _case = 3;
            this.iterDateString(dateString, _case, ":.", c);
        } else if (Pattern.matches("[Pp][0-9]+[Yy][0-9]+[Mm][0-9]+[Dd][Tt][0-9]+[Hh][0-9]+[Mm][0-9]+.[0-9]{1,3}[Ss]", dateString)) {
            int _case = 0;
            this.iterDateStringDur(dateString, _case, "PYMDTHS", c);
        } else {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError(null));
        }
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        return c;
    }

    public Calendar toCalendar(String dateString, Locale locale) {
        if (dateString == null) {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError(null));
        }
        Calendar c = null;
        c = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        c.clear();
        if (Pattern.matches("(^--0[1-9]-(([0-2][0-9])|(3[0-1])))|(^--1[0-2]-(([0-2][0-9])|(3[0-1])))", dateString)) {
            int _case = 1;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("(^----(([0-2][0-9])|(3[0-1])))", dateString)) {
            int _case = 2;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("--((0[1-9])|(1[0-2]))--", dateString)) {
            int _case = 1;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}-((0[0-9])|(1[0-2]))", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}-((0[0-9])|(1[0-2]))-(([0-2][0-9])|(3[0-1]))", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-", c);
        } else if (Pattern.matches("[0-9]{4}-((0[0-9])|(1[0-2]))-(([0-2][0-9])|(3[0-1]))T(([0-1][0-9])|(2[0-4]))(:[0-5][0-9]){2}((.[0-9]{3})|)", dateString)) {
            int _case = 0;
            this.iterDateString(dateString, _case, "-T:.", c);
        } else if (Pattern.matches("(([0-1][0-9])|(2[0-4]))(:[0-5][0-9]){2}((.[0-9]{3})|)", dateString)) {
            int _case = 3;
            this.iterDateString(dateString, _case, ":.", c);
        } else if (Pattern.matches("[Pp][0-9]+[Yy][0-9]+[Mm][0-9]+[Dd][Tt][0-9]+[Hh][0-9]+[Mm][0-9]+.[0-9]{1,3}[Ss]", dateString)) {
            int _case = 0;
            this.iterDateStringDur(dateString, _case, "PYMDTHS", c);
        } else {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError(null));
        }
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        return c;
    }

    public String toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.DATE_TIME_QNAME);
    }

    public String toDuration(Date date) {
        if (date == null) {
            return null;
        }
        Calendar outPut = Calendar.getInstance();
        outPut.setTime(date);
        outPut.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.toDuration(outPut);
    }

    public String toTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.TIME_QNAME);
    }

    public String toDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_DAY_QNAME);
    }

    public String toMonth(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_MONTH_QNAME);
    }

    public String toMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_MONTH_DAY_QNAME);
    }

    public String toYear(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_YEAR_QNAME);
    }

    public String toYearMonth(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_YEAR_MONTH_QNAME);
    }

    public String toYearMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.DATE_QNAME);
    }

    public String toDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.DATE_TIME_QNAME);
    }

    public String toDuration(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        StringBuffer dur = new StringBuffer();
        dur.append("P");
        dur.append(calendar.get(1));
        dur.append("Y");
        dur.append(calendar.get(2) + 1);
        dur.append("M");
        dur.append(calendar.get(5));
        dur.append("DT");
        dur.append(calendar.get(10));
        dur.append("H");
        dur.append(calendar.get(12));
        dur.append("M");
        float s = calendar.get(13) * 1000 + calendar.get(14);
        dur.append(s / 1000.0f);
        dur.append("S");
        return dur.toString();
    }

    public String toTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.TIME_QNAME);
    }

    public String toDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_DAY_QNAME);
    }

    public String toMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_MONTH_QNAME);
    }

    public String toMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_MONTH_DAY_QNAME);
    }

    public String toYear(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_YEAR_QNAME);
    }

    public String toYearMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_YEAR_MONTH_QNAME);
    }

    public String toYearMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.DATE_QNAME);
    }

    private void setCalendar(Calendar c, int i, int data) {
        switch (i) {
            case 0: {
                c.set(1, data);
                break;
            }
            case 1: {
                c.set(2, data - 1);
                break;
            }
            case 2: {
                c.set(5, data);
                break;
            }
            case 3: {
                c.set(10, data);
                break;
            }
            case 4: {
                c.set(12, data);
                break;
            }
            case 5: {
                c.set(13, data);
                break;
            }
            case 6: {
                c.set(14, data);
            }
        }
    }

    private void iterDateString(String dateString, int _case, String pattern, Calendar c) {
        StringTokenizer tokn = new StringTokenizer(dateString, pattern);
        while (tokn.hasMoreTokens()) {
            int data = Integer.parseInt(tokn.nextToken());
            this.setCalendar(c, _case, data);
            ++_case;
        }
    }

    private void iterDateStringDur(String dateString, int _case, String pattern, Calendar c) {
        StringTokenizer tokn = new StringTokenizer(dateString, pattern);
        while (tokn.hasMoreTokens()) {
            if (_case < 5) {
                int data = Integer.parseInt(tokn.nextToken());
                this.setCalendar(c, _case, data);
            } else {
                String secMec = tokn.nextToken();
                int data = Integer.parseInt(secMec.substring(0, 2));
                this.setCalendar(c, _case, data);
                double da = Double.parseDouble(secMec);
                int mec = (int)(da * 1000.0 - (double)(data * 1000));
                this.setCalendar(c, _case + 1, mec);
            }
            ++_case;
        }
    }

    public Object convertValue(Object value, Class convertClass, QName schemaType) {
        return this.getXMLConversionManager().convertObject(value, convertClass, schemaType);
    }

    public Object convertFromStringValue(String value, Class convertClass) {
        if (convertClass == ClassConstants.UTILDATE) {
            return this.toDate(value);
        }
        if (convertClass == ClassConstants.CALENDAR) {
            return this.toCalendar(value);
        }
        return this.getXMLConversionManager().convertObject((Object)value, convertClass);
    }

    public Object convertFromStringValue(String value, Type sdoType) {
        return this.convertFromStringValue(value, sdoType, null);
    }

    public Object convertFromStringValue(String value, Type sdoType, QName schemaType) {
        Class convertClass = ((SDOTypeHelper)this.getHelperContext().getTypeHelper()).getJavaWrapperTypeForSDOType(sdoType);
        if (convertClass != null) {
            if (schemaType == null) {
                return ((SDODataHelper)this.getHelperContext().getDataHelper()).convertFromStringValue(value, convertClass);
            }
            return ((SDODataHelper)this.getHelperContext().getDataHelper()).convertFromStringValue(value, convertClass, schemaType);
        }
        return value;
    }

    public Object convertFromStringValue(String value, Class convertClass, QName schemaType) {
        if (convertClass == ClassConstants.UTILDATE) {
            return this.toDate(value);
        }
        if (convertClass == ClassConstants.CALENDAR) {
            return this.toCalendar(value);
        }
        return this.getXMLConversionManager().convertObject((Object)value, convertClass, schemaType);
    }

    public String convertToStringValue(Object value, Type sdoType) {
        return this.convertToStringValue(value, sdoType, null);
    }

    private String convertToStringValue(Object value, Type sdoType, QName xsdType) {
        if (value.getClass() == ClassConstants.CALENDAR) {
            if (sdoType.equals(SDOConstants.SDO_DATETIME)) {
                return this.toDateTime((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_TIME)) {
                return this.toTime((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DAY)) {
                return this.toDay((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DURATION)) {
                return this.toDuration((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTH)) {
                return this.toMonth((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTHDAY)) {
                return this.toMonthDay((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEAR)) {
                return this.toYear((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTH)) {
                return this.toYearMonth((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTHDAY)) {
                return this.toYearMonthDay((Calendar)value);
            }
        } else if (value.getClass() == ClassConstants.UTILDATE) {
            if (sdoType.equals(SDOConstants.SDO_DATETIME)) {
                return this.toDateTime((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_TIME)) {
                return this.toTime((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DAY)) {
                return this.toDay((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DURATION)) {
                return this.toDuration((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTH)) {
                return this.toMonth((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTHDAY)) {
                return this.toMonthDay((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEAR)) {
                return this.toYear((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTH)) {
                return this.toYearMonth((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTHDAY)) {
                return this.toYearMonthDay((Date)value);
            }
        } else if (value.getClass().getName().equals("javax.activation.DataHandler")) {
            try {
                Class binaryDataHelper = PrivilegedAccessHelper.getClassForName((String)"org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper");
                Method getHelperMethod = PrivilegedAccessHelper.getMethod((Class)binaryDataHelper, (String)"getXMLBinaryDataHelper", (Class[])new Class[0], (boolean)false);
                Method stringToDataHandlerMethod = PrivilegedAccessHelper.getMethod((Class)binaryDataHelper, (String)"stringFromDataHandler", (Class[])new Class[]{Object.class, QName.class, AbstractSession.class}, (boolean)false);
                Object helper = PrivilegedAccessHelper.invokeMethod((Method)getHelperMethod, (Object)binaryDataHelper, (Object[])new Object[0]);
                String result = (String)PrivilegedAccessHelper.invokeMethod((Method)stringToDataHandlerMethod, (Object)helper, (Object[])new Object[]{value, xsdType, ((SDOXMLHelper)this.getHelperContext().getXMLHelper()).getXmlContext().getSession(0)});
                return result;
            }
            catch (Exception ex) {
                return (String)this.getXMLConversionManager().convertObject(value, ClassConstants.STRING, xsdType);
            }
        }
        return (String)this.getXMLConversionManager().convertObject(value, ClassConstants.STRING, xsdType);
    }

    public Object convert(Type type, Object value) {
        Class convertClass = type.isDataType() ? type.getInstanceClass() : ((SDOType)type).getImplClass();
        if (value.getClass() == ClassConstants.STRING) {
            return this.convertFromStringValue((String)value, type);
        }
        if (convertClass == ClassConstants.STRING) {
            return this.convertToStringValue(value, type);
        }
        try {
            return this.getXMLConversionManager().convertObject(value, convertClass);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError((Exception)((Object)e)));
        }
    }

    public Object convert(Property property, Object value) {
        if (null == property) {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError(null));
        }
        Type convertType = property.getType();
        if (property.isMany()) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof List)) {
                throw new IllegalArgumentException((Throwable)SDOException.conversionError(null));
            }
            List theList = (List)value;
            Object nextItem = null;
            for (int i = 0; i < theList.size(); ++i) {
                nextItem = theList.get(i);
                theList.set(i, this.convert(convertType, nextItem));
            }
            return theList;
        }
        return this.convert(convertType, value);
    }

    public Object convertValueToClass(Property prop, Object valueToConvert, Class convertToClass) {
        try {
            if (valueToConvert == null) {
                return null;
            }
            if (convertToClass == ClassConstants.STRING) {
                return this.convertToStringValue(valueToConvert, prop.getType(), ((SDOProperty)prop).getXsdType());
            }
            SDOProperty sdoProp = (SDOProperty)prop;
            DatabaseMapping xmlMapping = sdoProp.getXmlMapping();
            if (xmlMapping != null && xmlMapping.isDirectToFieldMapping() && sdoProp.getXsdType() != null) {
                return this.getXMLConversionManager().convertObject(valueToConvert, convertToClass, sdoProp.getXsdType());
            }
            return this.getXMLConversionManager().convertObject(valueToConvert, convertToClass);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException((Throwable)SDOException.conversionError((Exception)((Object)e)));
        }
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

