/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOCSUnmarshalListener;
import org.eclipse.persistence.sdo.helper.SDOUnmappedContentHandler;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDOUnmarshalListener
extends SDOCSUnmarshalListener {
    private List changeSummaries;

    public SDOUnmarshalListener(HelperContext aContext) {
        super(aContext);
        this.initialize();
    }

    public void beforeUnmarshal(Object target, Object parent) {
        super.beforeUnmarshal(target, parent);
    }

    public void afterUnmarshal(Object target, Object parent) {
        SDODataObject targetDataObject;
        try {
            targetDataObject = (SDODataObject)target;
        }
        catch (ClassCastException ccex) {
            ((SDOChangeSummary)target).setRootDataObject((DataObject)parent);
            this.changeSummaries.add(target);
            return;
        }
        if (targetDataObject.getType().isSequenced()) {
            ((SDOSequence)targetDataObject.getSequence()).afterUnmarshal();
        }
        if (parent == null) {
            SDOChangeSummary nextCS = null;
            XMLUnmarshaller unmarshaller = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().createUnmarshaller();
            for (int i = 0; i < this.changeSummaries.size(); ++i) {
                nextCS = (SDOChangeSummary)this.changeSummaries.get(i);
                nextCS.setLogging(nextCS.isLoggingMapping());
                List xpaths = nextCS.getCreatedXPaths();
                String nextXPath = null;
                SDODataObject nextCreatedDO = null;
                for (int j = 0; j < xpaths.size(); ++j) {
                    nextXPath = (String)xpaths.get(j);
                    nextCreatedDO = (SDODataObject)targetDataObject.getDataObject(this.convertXPathToSDOPath(nextXPath));
                    if (nextCreatedDO == null) {
                        throw SDOException.errorProcessingXPath((String)nextXPath);
                    }
                    nextCreatedDO._setCreated(true);
                    nextCS.getOldContainers().remove(nextCreatedDO);
                }
                nextCS.setCreatedXPaths(null);
                List modifiedDoms = nextCS.getModifiedDoms();
                Element nextNode = null;
                String refValue = null;
                for (int j = 0; j < modifiedDoms.size(); ++j) {
                    nextNode = (Element)modifiedDoms.get(j);
                    refValue = nextNode.getAttributeNS("commonj.sdo", "ref");
                    if (refValue == null || refValue.length() == 0) {
                        throw SDOException.missingRefAttribute();
                    }
                    SDODataObject nextModifiedDO = (SDODataObject)targetDataObject.getDataObject(this.convertXPathToSDOPath(refValue));
                    String unsetValue = nextNode.getAttributeNS("commonj.sdo", "unset");
                    List unsetValueList = new ArrayList();
                    if (unsetValue != null && unsetValue.length() > 0) {
                        XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
                        unsetValueList = (List)xmlConversionManager.convertObject((Object)unsetValue, List.class);
                    }
                    if (nextModifiedDO != null) {
                        SDOProperty nextProp;
                        int k;
                        nextModifiedDO._setModified(true);
                        SDOCSUnmarshalListener listener = new SDOCSUnmarshalListener(nextModifiedDO.getType().getHelperContext(), true);
                        unmarshaller.setUnmarshalListener((XMLUnmarshalListener)listener);
                        unmarshaller.getProperties().put("sdoHelperContext", this.aHelperContext);
                        unmarshaller.setUnmappedContentHandlerClass(SDOUnmappedContentHandler.class);
                        Object unmarshalledNode = unmarshaller.unmarshal((Node)nextNode, nextModifiedDO.getType().getXmlDescriptor().getJavaClass());
                        DataObject unmarshalledDO = null;
                        if (unmarshalledNode instanceof XMLRoot) {
                            unmarshalledDO = (DataObject)((XMLRoot)unmarshalledNode).getObject();
                        } else if (unmarshalledNode instanceof DataObject) {
                            unmarshalledDO = (DataObject)unmarshalledNode;
                        }
                        ArrayList<Property> modifiedProps = new ArrayList<Property>();
                        NodeList children = nextNode.getChildNodes();
                        for (int p = 0; p < children.getLength(); ++p) {
                            Node n = children.item(p);
                            if (n.getNodeType() != 1) continue;
                            String propName = n.getLocalName();
                            Property nextProp2 = unmarshalledDO.getInstanceProperty(propName);
                            if (nextProp2 == null) {
                                nextProp2 = this.aHelperContext.getTypeHelper().getOpenContentProperty(n.getNamespaceURI(), propName);
                            }
                            if (modifiedProps.contains(nextProp2)) continue;
                            modifiedProps.add(nextProp2);
                        }
                        for (k = 0; k < modifiedProps.size(); ++k) {
                            Object value;
                            nextProp = (SDOProperty)modifiedProps.get(k);
                            if (!nextProp.getType().isDataType()) {
                                if (nextProp.isMany()) {
                                    List originalValue = unmarshalledDO.getList((Property)nextProp);
                                    ArrayList<DataObject> newList = new ArrayList<DataObject>();
                                    ArrayList<SDODataObject> toDelete = new ArrayList<SDODataObject>();
                                    ArrayList<Integer> indexsToDelete = new ArrayList<Integer>();
                                    for (int l = 0; l < originalValue.size(); ++l) {
                                        SDODataObject nextInList = (SDODataObject)originalValue.get(l);
                                        String sdoRef = nextInList._getSdoRef();
                                        if (sdoRef != null) {
                                            newList.add(targetDataObject.getDataObject(this.convertXPathToSDOPath(sdoRef)));
                                            continue;
                                        }
                                        toDelete.add(nextInList);
                                        indexsToDelete.add(new Integer(l));
                                        newList.add(nextInList);
                                    }
                                    ListWrapper lw = (ListWrapper)nextModifiedDO.getList(nextProp);
                                    if (indexsToDelete.size() > 0) {
                                        nextCS.pauseLogging();
                                        for (int m = 0; m < indexsToDelete.size(); ++m) {
                                            int toDeleteIndex = (Integer)indexsToDelete.get(m);
                                            SDODataObject nextToDelete = (SDODataObject)toDelete.get(m);
                                            lw.add(toDeleteIndex, nextToDelete);
                                        }
                                        nextCS.setPropertyInternal(nextModifiedDO, nextProp, lw);
                                        SDOSequence nextSeq = (SDOSequence)nextCS.getOriginalSequences().get(nextModifiedDO);
                                        nextCS.resumeLogging();
                                        nextModifiedDO._setModified(true);
                                        for (int m = indexsToDelete.size() - 1; m >= 0; --m) {
                                            int toDeleteIndex = (Integer)indexsToDelete.get(m);
                                            SDODataObject nextToDelete = (SDODataObject)toDelete.get(m);
                                            if (nextSeq != null) {
                                                nextSeq.addSettingWithoutModifyingDataObject(-1, nextProp, nextToDelete);
                                            }
                                            nextToDelete.resetChanges();
                                            lw.remove(toDeleteIndex);
                                        }
                                    }
                                    nextCS.getOriginalElements().put(lw, newList);
                                    continue;
                                }
                                value = (SDODataObject)unmarshalledDO.getDataObject((Property)nextProp);
                                if (value != null) {
                                    String sdoRef = ((SDODataObject)value)._getSdoRef();
                                    if (sdoRef != null) {
                                        nextModifiedDO._setModified(true);
                                        continue;
                                    }
                                    ((SDODataObject)value)._setChangeSummary(nextCS);
                                    nextModifiedDO._setModified(true);
                                    nextCS.pauseLogging();
                                    boolean wasSet = nextModifiedDO.isSet(nextProp);
                                    Object existingValue = nextModifiedDO.get(nextProp);
                                    Sequence nextModifiedDOSequence = nextModifiedDO.getSequence();
                                    int settingIdx = -1;
                                    if (nextModifiedDOSequence != null) {
                                        settingIdx = ((SDOSequence)nextModifiedDOSequence).getIndexForProperty(nextProp);
                                    }
                                    ((SDODataObject)value)._setContainmentPropertyName(null);
                                    ((SDODataObject)value)._setContainer(null);
                                    nextModifiedDO.set(nextProp, value);
                                    nextCS.setPropertyInternal(nextModifiedDO, nextProp, value);
                                    SDOSequence nextSeq = (SDOSequence)nextCS.getOriginalSequences().get(nextModifiedDO);
                                    if (nextSeq != null) {
                                        nextSeq.addSettingWithoutModifyingDataObject(-1, nextProp, value);
                                    }
                                    nextCS.resumeLogging();
                                    nextModifiedDO._setModified(true);
                                    ((SDODataObject)value).resetChanges();
                                    ((SDODataObject)value).delete();
                                    if (wasSet) {
                                        nextModifiedDO.set(nextProp, existingValue, false);
                                        if (settingIdx == -1) continue;
                                        ((SDOSequence)nextModifiedDO.getSequence()).addSettingWithoutModifyingDataObject(settingIdx, nextProp, existingValue);
                                        continue;
                                    }
                                    nextModifiedDO.unset(nextProp);
                                    continue;
                                }
                                nextModifiedDO._setModified(true);
                                nextCS.setPropertyInternal(nextModifiedDO, nextProp, null);
                                continue;
                            }
                            nextModifiedDO._setModified(true);
                            value = unmarshalledDO.get((Property)nextProp);
                            if (nextProp.isMany()) {
                                SDOProperty theProp = nextModifiedDO.getInstanceProperty(nextProp.getName());
                                if (theProp == null) {
                                    Property newProp = nextModifiedDO.defineOpenContentProperty(nextProp.getName(), new ArrayList(), nextProp.getType());
                                    nextModifiedDO.set(newProp, new ArrayList());
                                    theProp = newProp;
                                }
                                List lw = nextModifiedDO.getList(theProp.getName());
                                nextCS.setPropertyInternal(nextModifiedDO, theProp, lw);
                                nextCS.getOriginalElements().put(lw, ((ListWrapper)value).getCurrentElements());
                                continue;
                            }
                            nextCS.setPropertyInternal(nextModifiedDO, nextProp, value);
                        }
                        for (k = 0; k < unsetValueList.size(); ++k) {
                            nextProp = unmarshalledDO.getInstanceProperty((String)unsetValueList.get(k));
                            if (nextProp != null) {
                                Object oldValue = null;
                                if (nextProp.getType().isDataType() || nextProp.isMany()) {
                                    oldValue = unmarshalledDO.get((Property)nextProp);
                                }
                                nextModifiedDO._setModified(true);
                                nextCS.setPropertyInternal(nextModifiedDO, nextProp, oldValue);
                                nextCS.unsetPropertyInternal(nextModifiedDO, nextProp);
                                continue;
                            }
                            nextProp = nextModifiedDO.getInstanceProperty((String)unsetValueList.get(k));
                            nextModifiedDO._setModified(true);
                            nextCS.setPropertyInternal(nextModifiedDO, nextProp, null);
                            nextCS.unsetPropertyInternal(nextModifiedDO, nextProp);
                        }
                        continue;
                    }
                    throw SDOException.errorProcessingXPath((String)refValue);
                }
                nextCS.setModifiedDoms(null);
                nextCS.setDeletedXPaths(null);
            }
            this.initialize();
        }
    }

    private void initialize() {
        this.changeSummaries = new ArrayList();
    }

    private String convertXPathToSDOPath(String xpath) {
        if (xpath == null || xpath.length() < SDOConstants.SDO_CHANGESUMMARY_REF_PATH_PREFIX_LENGTH || !xpath.startsWith("#")) {
            throw SDOException.errorProcessingXPath((String)xpath);
        }
        if (xpath.equals("#/")) {
            return "/";
        }
        if (xpath.startsWith("#/")) {
            return xpath.substring(2, xpath.length());
        }
        return xpath.substring(1, xpath.length());
    }
}

