/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.EnumSet;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBEnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;
    private boolean m_usesOrdinalValues;

    public JAXBEnumTypeConverter(DatabaseMapping mapping, String enumClassName, boolean usesOrdinalValues) {
        super(mapping);
        this.m_enumClassName = enumClassName;
        this.m_usesOrdinalValues = usesOrdinalValues;
    }

    public void convertClassNamesToClasses() {
        try {
            this.m_enumClass = PrivilegedAccessHelper.getClassForName((String)this.m_enumClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        this.convertClassNamesToClasses();
        for (Enum theEnum : EnumSet.allOf(this.m_enumClass)) {
            if (this.getAttributeToFieldValues().get(theEnum) != null) continue;
            Object existingVal = this.getAttributeToFieldValues().get(theEnum.name());
            if (existingVal != null) {
                this.getAttributeToFieldValues().remove(theEnum.name());
                this.addConversionValue(existingVal, theEnum);
                continue;
            }
            if (this.m_usesOrdinalValues) {
                this.addConversionValue(theEnum.ordinal(), theEnum);
                continue;
            }
            this.addConversionValue(theEnum.name(), theEnum);
        }
        super.initialize(mapping, session);
    }

    public boolean usesOrdinalValues() {
        return this.m_usesOrdinalValues;
    }
}

