/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    private static final String ATT = "@";
    private static final String TXT = "/text()";
    private XMLDescriptor descriptor;
    private ComplexType complexType;
    private boolean hasRootElement;
    private boolean hasElementRefs;
    private Schema schema;
    private SimpleType simpleType;
    private ArrayList<String> propOrder;
    private String classNamespace;
    private String schemaTypeName;
    private TypeDefParticle compositor;
    private XmlAccessType accessType;
    private ArrayList<String> propertyNames = new ArrayList();
    private ArrayList<Property> propertyList;
    private HashMap<String, Property> properties = new HashMap();
    private Property idProperty;
    private HashMap<String, JavaClass> adaptersByClass;
    private Helper helper;

    public TypeInfo(Helper helper) {
        this.propertyList = new ArrayList();
        this.adaptersByClass = new HashMap();
        this.helper = helper;
    }

    public XMLDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(XMLDescriptor desc) {
        if (this.isIDSet()) {
            String pkFieldName = this.helper.isAnnotationPresent(this.getIDProperty().getElement(), XmlAttribute.class) ? ATT + this.getIDProperty().getSchemaName() : this.getIDProperty().getSchemaName() + TXT;
            desc.addPrimaryKeyFieldName(pkFieldName);
        }
        this.descriptor = desc;
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        schemaRef.setSchemaContext("/" + this.schemaTypeName);
        if (this.isEnumerationType() || this.propertyNames.size() == 1 && this.helper.isAnnotationPresent(this.getProperties().get(this.propertyNames.get(0)).getElement(), XmlValue.class)) {
            schemaRef.setType(2);
        }
        this.descriptor.setSchemaReference((XMLSchemaReference)schemaRef);
    }

    public ComplexType getComplexType() {
        return this.complexType;
    }

    public void setComplexType(ComplexType type) {
        this.complexType = type;
    }

    public SimpleType getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(SimpleType type) {
        this.simpleType = type;
    }

    public String[] getPropOrder() {
        if (this.propOrder == null) {
            return new String[0];
        }
        return this.propOrder.toArray(new String[this.propOrder.size()]);
    }

    public void setPropOrder(String[] order) {
        if (order.length == 0 || order[0].equals("")) {
            this.propOrder = null;
        } else {
            this.propOrder = new ArrayList(order.length);
            for (String next : order) {
                this.propOrder.add(next);
            }
        }
    }

    public String getClassNamespace() {
        return this.classNamespace;
    }

    public void setClassNamespace(String namespace) {
        this.classNamespace = namespace;
    }

    public boolean isComplexType() {
        return this.complexType != null;
    }

    public TypeDefParticle getCompositor() {
        return this.compositor;
    }

    public void setCompositor(TypeDefParticle particle) {
        this.compositor = particle;
    }

    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(XmlAccessType type) {
        this.accessType = type;
    }

    public ArrayList<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Property getIDProperty() {
        return this.idProperty;
    }

    public HashMap<String, Property> getProperties() {
        return this.properties;
    }

    public void addProperty(String name, Property property) {
        this.properties.put(name, property);
        this.propertyNames.add(name);
        this.propertyList.add(property);
        if (this.propOrder != null && property.isAttribute() && !this.propOrder.contains(property.getPropertyName())) {
            this.propOrder.add(property.getPropertyName());
        }
    }

    public void setIDProperty(Property idProperty) {
        this.idProperty = idProperty;
    }

    public void setProperties(ArrayList<Property> properties) {
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                Property next = properties.get(i);
                this.addProperty(next.getPropertyName(), next);
            }
        }
    }

    public void orderProperties(XmlAccessOrder order) {
        if (order == XmlAccessOrder.ALPHABETICAL && this.propertyNames != null) {
            Collections.sort(this.propertyNames);
        }
    }

    public boolean isEnumerationType() {
        return false;
    }

    public boolean isIDSet() {
        return this.idProperty != null;
    }

    public ArrayList<Property> getPropertyList() {
        return this.propertyList;
    }

    public String getSchemaTypeName() {
        return this.schemaTypeName;
    }

    public void setSchemaTypeName(String typeName) {
        this.schemaTypeName = typeName;
    }

    public void setSchema(Schema theSchema) {
        this.schema = theSchema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public JavaClass getAdapterClass(JavaClass boundType) {
        return this.getAdaptersByClass().get(boundType.getQualifiedName());
    }

    public JavaClass getAdapterClass(String boundTypeName) {
        return this.getAdaptersByClass().get(boundTypeName);
    }

    public HashMap<String, JavaClass> getAdaptersByClass() {
        return this.adaptersByClass;
    }

    public void addAdapterClass(JavaClass adapterClass, JavaClass boundType) {
        this.adaptersByClass.put(boundType.getQualifiedName(), adapterClass);
    }

    public void addAdapterClass(JavaClass adapterClass, String boundTypeName) {
        this.adaptersByClass.put(boundTypeName, adapterClass);
    }

    public boolean hasRootElement() {
        return this.hasRootElement;
    }

    public void setHasRootElement(boolean hasRoot) {
        this.hasRootElement = hasRoot;
    }

    public boolean hasElementRefs() {
        return this.hasElementRefs;
    }

    public void setHasElementRefs(boolean hasRefs) {
        this.hasElementRefs = hasRefs;
    }
}

