/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class NonSynchronizedSubVector
extends NonSynchronizedVector {
    private AbstractList l;
    private int offset;
    private int size;

    public NonSynchronizedSubVector(AbstractList abstractList, int n, int n2) {
        super(0);
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > abstractList.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        this.l = abstractList;
        this.offset = n;
        this.size = n2 - n;
    }

    public Object set(int n, Object object) {
        return this.l.set(n + this.offset, object);
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public Object elementAt(int n) {
        return this.get(n);
    }

    public Object firstElement() {
        return this.get(0);
    }

    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    public int indexOf(Object object, int n) {
        int n2 = this.size();
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, int n) {
        int n2 = this.size();
        if (n >= n2) {
            throw new IndexOutOfBoundsException(n + " >= " + n2);
        }
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public Object get(int n) {
        return this.l.get(n + this.offset);
    }

    public int size() {
        return this.size;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.l.add(n + this.offset, object);
        ++this.size;
        ++this.modCount;
    }

    public Object remove(int n) {
        Object e = this.l.remove(n + this.offset);
        --this.size;
        ++this.modCount;
        return e;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        this.l.addAll(this.offset + n, collection);
        this.size += n2;
        ++this.modCount;
        return true;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < NonSynchronizedSubVector.this.size();
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedSubVector.this.elementCount) {
                    return NonSynchronizedSubVector.this.get(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(final int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return new ListIterator(){
            private ListIterator i;
            {
                this.i = NonSynchronizedSubVector.this.l.listIterator(n + NonSynchronizedSubVector.this.offset);
            }

            public boolean hasNext() {
                return this.nextIndex() < NonSynchronizedSubVector.this.size;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.i.nextIndex() - NonSynchronizedSubVector.this.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - NonSynchronizedSubVector.this.offset;
            }

            public void remove() {
                this.i.remove();
                NonSynchronizedSubVector.this.size--;
                NonSynchronizedSubVector.this.modCount++;
            }

            public void set(Object object) {
                this.i.set(object);
            }

            public void add(Object object) {
                this.i.add(object);
                NonSynchronizedSubVector.this.size++;
                NonSynchronizedSubVector.this.modCount++;
            }
        };
    }
}

