/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.internal.weaving.TransformerFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerSetupImpl {
    protected MetadataProcessor processor = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected Map predeployProperties = null;
    protected int factoryCount = 0;
    protected ServerSession session = null;
    protected boolean isInContainerMode = false;
    protected boolean isSessionLoadedFromSessionsXML = false;
    protected Boolean enableWeaving = null;
    protected boolean isWeavingStatic = false;
    protected SecurableObjectHolder securableObjectHolder = new SecurableObjectHolder();
    protected PersistenceInitializationHelper persistenceInitializationHelper = null;
    public static final String STATE_INITIAL = "Initial";
    public static final String STATE_PREDEPLOYED = "Predeployed";
    public static final String STATE_DEPLOYED = "Deployed";
    public static final String STATE_PREDEPLOY_FAILED = "PredeployFailed";
    public static final String STATE_DEPLOY_FAILED = "DeployFailed";
    public static final String STATE_UNDEPLOYED = "Undeployed";
    protected String state = "Initial";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionFromGlobalSessionManager() {
        if (this.session != null) {
            try {
                if (this.session.isConnected()) {
                    this.session.logout();
                }
            }
            finally {
                SessionManager.getManager().getSessions().remove(this.session.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession deploy(ClassLoader classLoader, Map map) {
        ServerSession serverSession;
        if (this.state != STATE_PREDEPLOYED && this.state != STATE_DEPLOYED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state));
        }
        this.session.log(1, "properties", "deploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        List<StructConverter> list = null;
        try {
            Map map2 = EntityManagerFactoryProvider.mergeMaps(map, this.predeployProperties);
            EntityManagerFactoryProvider.translateOldProperties(map2, this.session);
            if (this.state == STATE_PREDEPLOYED) {
                serverSession = this.session;
                synchronized (serverSession) {
                    if (this.state == STATE_PREDEPLOYED) {
                        try {
                            this.session.getProject().convertClassNamesToClasses(classLoader);
                            if (!this.isSessionLoadedFromSessionsXML) {
                                this.processor.setClassLoader(classLoader);
                                this.processor.addEntityListeners();
                                this.processor.addNamedQueries();
                                this.processor.processCustomizers();
                                list = this.processor.getStructConverters();
                                this.processor = null;
                            }
                            this.initServerSession(map2);
                            if (this.session.getIntegrityChecker().hasErrors()) {
                                this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                            }
                            this.session.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
                            this.state = STATE_DEPLOYED;
                        }
                        catch (RuntimeException runtimeException) {
                            this.state = STATE_DEPLOY_FAILED;
                            throw new PersistenceException((Throwable)EntityManagerSetupException.deployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), runtimeException));
                        }
                    }
                }
            }
            if (!this.session.isConnected()) {
                serverSession = this.session;
                synchronized (serverSession) {
                    if (!this.session.isConnected()) {
                        this.session.setProperties(map2);
                        this.updateServerSession(map2, classLoader);
                        if (this.isValidationOnly(map2, false)) {
                            this.session.initializeDescriptors();
                        } else {
                            if (this.isSessionLoadedFromSessionsXML) {
                                if (!this.session.isConnected()) {
                                    this.session.login();
                                }
                            } else {
                                EntityManagerFactoryProvider.login(this.session, map2);
                            }
                            if (!this.isSessionLoadedFromSessionsXML) {
                                this.addStructConverters(this.session, list);
                            }
                            EntityManagerFactoryProvider.generateDDL(this.session, map2);
                        }
                    }
                }
            }
            serverSession = this.session;
        }
        catch (Exception exception) {
            try {
                PersistenceException persistenceException = null;
                if (exception instanceof PersistenceException) {
                    persistenceException = (PersistenceException)exception;
                    persistenceException = new PersistenceException((Throwable)exception);
                } else {
                    persistenceException = new PersistenceException((Throwable)exception);
                }
                this.session.logThrowable(7, "ejb", exception);
                throw persistenceException;
            }
            catch (Throwable throwable) {
                this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                throw throwable;
            }
        }
        this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        return serverSession;
    }

    protected void addProjectToSession(ServerSession serverSession, Project project) {
        DatasourcePlatform datasourcePlatform = (DatasourcePlatform)serverSession.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform datasourcePlatform2 = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!datasourcePlatform.hasDefaultSequence() && datasourcePlatform2.hasDefaultSequence()) {
            datasourcePlatform.setDefaultSequence(datasourcePlatform2.getDefaultSequence());
        }
        if (datasourcePlatform.getSequences() == null || datasourcePlatform.getSequences().isEmpty()) {
            if (datasourcePlatform2.getSequences() != null && !datasourcePlatform2.getSequences().isEmpty()) {
                datasourcePlatform.setSequences(datasourcePlatform2.getSequences());
            }
        } else if (datasourcePlatform2.getSequences() != null && !datasourcePlatform2.getSequences().isEmpty()) {
            for (Sequence sequence : datasourcePlatform2.getSequences().values()) {
                if (datasourcePlatform.getSequences().containsKey(sequence.getName())) continue;
                datasourcePlatform.addSequence(sequence);
            }
        }
        serverSession.addDescriptors(project);
    }

    protected void addSessionToGlobalSessionManager() {
        AbstractSession abstractSession = (AbstractSession)SessionManager.getManager().getSessions().get(this.session.getName());
        if (abstractSession != null) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.attemptedRedeployWithoutClose(this.session.getName()));
        }
        SessionManager.getManager().addSession(this.session);
    }

    public void addStructConverters(Session session, List<StructConverter> list) {
        for (StructConverter structConverter : list) {
            if (session.getPlatform().getTypeConverters().get(structConverter.getJavaType()) != null) {
                throw ValidationException.twoStructConvertersAddedForSameClass(structConverter.getJavaType().getName());
            }
            session.getPlatform().addStructConverter(structConverter);
        }
    }

    protected void assignCMP3Policy() {
        Project project = this.session.getProject();
        for (ClassDescriptor classDescriptor : project.getDescriptors().values()) {
            if (classDescriptor.getCMPPolicy() != null) continue;
            classDescriptor.setCMPPolicy(new CMP3Policy());
        }
    }

    protected boolean updateServerPlatform(Map map, ClassLoader classLoader) {
        String string = PropertiesHandler.getPropertyValueLogDebug("eclipselink.target-server", map, this.session);
        if (string == null) {
            return false;
        }
        ServerPlatform serverPlatform = this.session.getServerPlatform();
        String string2 = serverPlatform.getClass().getName();
        if (string2.equals(string)) {
            return false;
        }
        ServerPlatform serverPlatform2 = null;
        Class clazz = EntityManagerSetupImpl.findClassForProperty(string, "eclipselink.target-server", classLoader);
        try {
            Constructor constructor = clazz.getConstructor(DatabaseSession.class);
            serverPlatform2 = (ServerPlatform)constructor.newInstance(this.session);
        }
        catch (Exception exception) {
            if (ExternalTransactionController.class.isAssignableFrom(clazz)) {
                if (serverPlatform.getClass().equals(CustomServerPlatform.class)) {
                    CustomServerPlatform customServerPlatform = (CustomServerPlatform)serverPlatform;
                    if (!clazz.equals(customServerPlatform.getExternalTransactionControllerClass())) {
                        customServerPlatform.setExternalTransactionControllerClass(clazz);
                    }
                } else {
                    CustomServerPlatform customServerPlatform = new CustomServerPlatform(this.session);
                    customServerPlatform.setExternalTransactionControllerClass(clazz);
                    serverPlatform2 = customServerPlatform;
                }
            }
            throw EntityManagerSetupException.failedToInstantiateServerPlatform(string, "eclipselink.target-server", exception);
        }
        if (serverPlatform2 != null) {
            this.session.setServerPlatform(serverPlatform2);
            return true;
        }
        return false;
    }

    protected void updateLoggers(Map map, boolean bl, boolean bl2, ClassLoader classLoader) {
        block17: {
            Object object;
            Object object2;
            String string = PropertiesHandler.getPropertyValueLogDebug("eclipselink.logging.logger", map, this.session);
            SessionLog sessionLog = null;
            SessionLog sessionLog2 = null;
            if (string != null) {
                object2 = this.session.getSessionLog();
                if (string.equals("ServerLogger")) {
                    object = this.session.getServerPlatform();
                    sessionLog = object.getServerLog();
                    sessionLog2 = object.getServerLog();
                } else if (!object2.getClass().getName().equals(string)) {
                    object = EntityManagerSetupImpl.findClassForProperty(string, "eclipselink.logging.logger", classLoader);
                    try {
                        sessionLog = (SessionLog)((Class)object).newInstance();
                        sessionLog2 = (SessionLog)((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        throw EntityManagerSetupException.failedToInstantiateLogger(string, "eclipselink.logging.logger", exception);
                    }
                }
            } else if (bl) {
                object2 = this.session.getServerPlatform();
                sessionLog = object2.getServerLog();
                sessionLog2 = object2.getServerLog();
            }
            if (sessionLog != null && sessionLog2 != null) {
                AbstractSessionLog.setLog(sessionLog);
                this.session.setSessionLog(sessionLog2);
            } else if (bl2) {
                this.session.getSessionLog().setSession(this.session);
            }
            this.initOrUpdateLogging(map, AbstractSessionLog.getLog());
            this.initOrUpdateLogging(map, this.session.getSessionLog());
            object2 = (String)map.get("eclipselink.logging.file");
            if (object2 != null) {
                if (!((String)object2).trim().equals("")) {
                    try {
                        if (sessionLog2 == null) break block17;
                        if (sessionLog2 instanceof AbstractSessionLog) {
                            object = new FileOutputStream((String)object2);
                            ((AbstractSessionLog)sessionLog2).setWriter((OutputStream)object);
                            break block17;
                        }
                        object = new FileWriter((String)object2);
                        sessionLog2.setWriter((Writer)object);
                    }
                    catch (IOException iOException) {
                        this.session.handleException(ValidationException.invalidLoggingFile((String)object2, iOException));
                    }
                } else {
                    this.session.handleException(ValidationException.invalidLoggingFile());
                }
            }
        }
    }

    protected void updateProfiler(Map map, ClassLoader classLoader) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.profiler", map, this.session);
        if (string == null) {
            ((ServerPlatformBase)this.session.getServerPlatform()).configureProfiler(this.session);
        } else {
            if (string.equals("NoProfiler")) {
                this.session.setProfiler(null);
                return;
            }
            if (string.equals("QueryMonitor")) {
                this.session.setProfiler(null);
                QueryMonitor.shouldMonitor = true;
                return;
            }
            if (string.equals("PerformanceProfiler")) {
                this.session.setProfiler(new PerformanceProfiler());
                return;
            }
            String string2 = null;
            if (this.session.getProfiler() != null && (string2 = this.session.getProfiler().getClass().getName()).equals(string)) {
                return;
            }
            try {
                Class clazz = EntityManagerSetupImpl.findClassForProperty(string, "eclipselink.profiler", classLoader);
                SessionProfiler sessionProfiler = (SessionProfiler)EntityManagerSetupImpl.buildObjectForClass(clazz, SessionProfiler.class);
                if (sessionProfiler != null) {
                    this.session.setProfiler(sessionProfiler);
                } else {
                    this.session.handleException(ValidationException.invalidProfilerClass(string));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(string, illegalAccessException));
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(string, privilegedActionException));
            }
            catch (InstantiationException instantiationException) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(string, instantiationException));
            }
        }
    }

    protected static Class findClass(String string, ClassLoader classLoader) throws ClassNotFoundException, PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
        }
        return PrivilegedAccessHelper.getClassForName(string, true, classLoader);
    }

    protected static Class findClassForProperty(String string, String string2, ClassLoader classLoader) {
        try {
            return EntityManagerSetupImpl.findClass(string, classLoader);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw EntityManagerSetupException.classNotFoundForProperty(string, string2, privilegedActionException.getException());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw EntityManagerSetupException.classNotFoundForProperty(string, string2, classNotFoundException);
        }
    }

    protected static Object buildObjectForClass(Class clazz, Class clazz2) throws IllegalAccessException, PrivilegedActionException, InstantiationException {
        if (clazz != null && Helper.classImplementsInterface(clazz, clazz2)) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
            }
            return PrivilegedAccessHelper.newInstanceFromClass(clazz);
        }
        return null;
    }

    protected void updateDescriptorCacheSettings(Map map, ClassLoader classLoader) {
        String string;
        Object object;
        Map map2 = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.type.", map, this.session);
        Map map3 = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.size.", map, this.session);
        Map map4 = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.shared.", map, this.session);
        if (map2.isEmpty() && map3.isEmpty() && map4.isEmpty()) {
            return;
        }
        String string2 = (String)map2.remove("default");
        if (string2 != null) {
            object = EntityManagerSetupImpl.findClassForProperty(string2, "eclipselink.cache.type.default", classLoader);
            this.session.getProject().setDefaultIdentityMapClass((Class)object);
        }
        if ((object = (String)map3.remove("default")) != null) {
            int n = Integer.parseInt((String)object);
            this.session.getProject().setDefaultIdentityMapSize(n);
        }
        if ((string = (String)map4.remove("default")) != null) {
            boolean bl = Boolean.parseBoolean(string);
            this.session.getProject().setDefaultIsIsolated(!bl);
        }
        Iterator iterator = this.session.getDescriptors().values().iterator();
        while (!(!iterator.hasNext() || map2.isEmpty() && map3.isEmpty() && map4.isEmpty())) {
            String string3;
            Object object2;
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            if (classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor()) continue;
            String string4 = classDescriptor.getAlias();
            String string5 = classDescriptor.getJavaClass().getName();
            String string6 = string4;
            String string7 = (String)map2.remove(string6);
            if (string7 == null) {
                string6 = string5;
                string7 = (String)map2.remove(string6);
            }
            if (string7 != null) {
                object2 = EntityManagerSetupImpl.findClassForProperty(string7, "eclipselink.cache.type." + string6, classLoader);
                classDescriptor.setIdentityMapClass((Class)object2);
            }
            if ((object2 = (String)map3.remove(string6 = string4)) == null) {
                string6 = string5;
                object2 = (String)map3.remove(string6);
            }
            if (object2 != null) {
                int n = Integer.parseInt((String)object2);
                classDescriptor.setIdentityMapSize(n);
            }
            if ((string3 = (String)map4.remove(string6 = string4)) == null) {
                string6 = string5;
                string3 = (String)map4.remove(string6);
            }
            if (string3 == null) continue;
            boolean bl = Boolean.parseBoolean(string3);
            classDescriptor.setIsIsolated(!bl);
        }
    }

    protected void updateConnectionPolicy(Map map) {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", map, this.session);
        if (string != null) {
            this.session.getDefaultConnectionPolicy().setIsLazy(Boolean.parseBoolean(string));
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(map, this.session, true)) != null) {
            this.session.getDefaultConnectionPolicy().setExclusiveMode(exclusiveMode);
        }
    }

    public static ConnectionPolicy.ExclusiveMode getConnectionPolicyExclusiveModeFromProperties(Map map, AbstractSession abstractSession, boolean bl) {
        String string = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.exclusive-connection.mode", map, abstractSession, bl);
        if (string != null) {
            if (string == "Isolated") {
                return ConnectionPolicy.ExclusiveMode.Isolated;
            }
            if (string == "Always") {
                return ConnectionPolicy.ExclusiveMode.Always;
            }
            return ConnectionPolicy.ExclusiveMode.Transactional;
        }
        return null;
    }

    public synchronized ClassTransformer predeploy(PersistenceUnitInfo persistenceUnitInfo, Map map) {
        ClassLoader classLoader = null;
        if (this.state == STATE_DEPLOY_FAILED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state));
        }
        if (this.state == STATE_PREDEPLOYED || this.state == STATE_DEPLOYED) {
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            ++this.factoryCount;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            return null;
        }
        if (this.state == STATE_INITIAL || this.state == STATE_UNDEPLOYED) {
            this.persistenceUnitInfo = persistenceUnitInfo;
        }
        try {
            Object object;
            Object object2;
            this.predeployProperties = EntityManagerFactoryProvider.mergeMaps(map, this.persistenceUnitInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(this.predeployProperties, null);
            String string = (String)this.predeployProperties.get("eclipselink.sessions-xml");
            String string2 = (String)this.predeployProperties.get("eclipselink.session-name");
            if (string != null) {
                this.isSessionLoadedFromSessionsXML = true;
            }
            this.session = new ServerSession(new Project(new DatabaseLogin()));
            this.setServerSessionName(this.predeployProperties);
            ClassLoader classLoader2 = this.persistenceUnitInfo.getClassLoader();
            this.updateServerPlatform(this.predeployProperties, classLoader2);
            this.updateLoggers(this.predeployProperties, true, false, classLoader2);
            this.updatePessimisticLockTimeout(this.predeployProperties);
            if (!this.isInContainerMode && this.state == STATE_UNDEPLOYED) {
                classLoader = classLoader2;
            } else {
                object2 = this.session.getServerPlatform().getNewTempClassLoader(persistenceUnitInfo);
                classLoader = ((JPAClassLoaderHolder)object2).getClassLoader();
                if (!((JPAClassLoaderHolder)object2).isTempClassLoader()) {
                    this.enableWeaving = Boolean.FALSE;
                }
            }
            this.updateProfiler(this.predeployProperties, classLoader2);
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            if (this.isSessionLoadedFromSessionsXML) {
                this.session.log(1, "properties", "loading_session_xml", string, string2);
                if (string2 == null) {
                    throw new PersistenceException((Throwable)EntityManagerSetupException.sessionNameNeedBeSpecified(persistenceUnitInfo.getPersistenceUnitName(), string));
                }
                object2 = new XMLSessionConfigLoader(string);
                object = new SessionManager().getSession((XMLSessionConfigLoader)object2, string2, classLoader, false, false);
                this.session.log(1, "properties", "sessions_xml_path_where_session_load_from", ((XMLSessionConfigLoader)object2).getSessionName(), ((XMLSessionConfigLoader)object2).getResourcePath());
                if (object == null) {
                    throw new PersistenceException((Throwable)ValidationException.noSessionFound(string2, string));
                }
                if (!object.isServerSession()) {
                    throw new PersistenceException((Throwable)EntityManagerSetupException.sessionLoadedFromSessionsXMLMustBeServerSession(persistenceUnitInfo.getPersistenceUnitName(), (String)this.predeployProperties.get("eclipselink.sessions-xml"), object));
                }
                this.session = (ServerSession)object;
                this.setServerSessionName(this.predeployProperties);
                this.updateServerPlatform(this.predeployProperties, classLoader);
                this.updateLoggers(this.predeployProperties, true, false, classLoader);
            }
            EntityManagerFactoryProvider.warnOldProperties(this.predeployProperties, this.session);
            this.session.getPlatform().setConversionManager(new JPAConversionManager());
            object2 = null;
            object = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", this.predeployProperties, this.session);
            if (object != null) {
                object2 = PersistenceUnitTransactionType.valueOf((String)object);
            } else if (this.persistenceUnitInfo != null) {
                object2 = this.persistenceUnitInfo.getTransactionType();
            }
            if (!this.isValidationOnly(this.predeployProperties, false) && this.persistenceUnitInfo != null && object2 == PersistenceUnitTransactionType.JTA && this.predeployProperties.get("javax.persistence.jtaDataSource") == null && this.persistenceUnitInfo.getJtaDataSource() == null) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource(this.persistenceUnitInfo.getPersistenceUnitName()));
            }
            if (this.state == STATE_INITIAL || this.state == STATE_UNDEPLOYED) {
                if (null == this.enableWeaving) {
                    this.enableWeaving = Boolean.TRUE;
                }
                this.isWeavingStatic = false;
                String string3 = this.getConfigPropertyAsString("eclipselink.weaving");
                if (string3 != null && string3.equalsIgnoreCase("false")) {
                    this.enableWeaving = Boolean.FALSE;
                } else if (string3 != null && string3.equalsIgnoreCase("static")) {
                    this.isWeavingStatic = true;
                }
            }
            boolean bl = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.orm.throw.exceptions", this.predeployProperties, "true", this.session));
            ClassTransformer classTransformer = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (this.enableWeaving.booleanValue()) {
                bl2 = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.changetracking", this.predeployProperties, "true", this.session));
                bl3 = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.lazy", this.predeployProperties, "true", this.session));
                bl4 = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.eager", this.predeployProperties, "false", this.session));
                bl5 = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.fetchgroups", this.predeployProperties, "true", this.session));
                bl6 = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.internal", this.predeployProperties, "true", this.session));
            }
            if (!this.isSessionLoadedFromSessionsXML) {
                this.processor = new MetadataProcessor(this.persistenceUnitInfo, this.session, classLoader, this.enableWeaving, bl4);
                PersistenceUnitProcessor.processORMetadata(this.processor, bl);
                if (this.session.getIntegrityChecker().hasErrors()) {
                    this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                }
                if (this.enableWeaving.booleanValue()) {
                    Collection<Class> collection = PersistenceUnitProcessor.buildEntityList(this.processor.getProject(), classLoader);
                    classTransformer = TransformerFactory.createTransformerAndModifyProject(this.session, collection, classLoader, bl3, bl2, bl5, bl6);
                }
            } else if (this.enableWeaving.booleanValue()) {
                ArrayList arrayList = new ArrayList(this.session.getProject().getDescriptors().keySet());
                classTransformer = TransformerFactory.createTransformerAndModifyProject(this.session, arrayList, classLoader, bl3, bl2, bl5, bl6);
            }
            if (this.state != STATE_INITIAL && this.state != STATE_UNDEPLOYED || this.isInContainerMode()) {
                ++this.factoryCount;
            }
            this.state = STATE_PREDEPLOYED;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            if (this.isWeavingStatic) {
                return null;
            }
            return classTransformer;
        }
        catch (RuntimeException runtimeException) {
            this.state = STATE_PREDEPLOY_FAILED;
            this.session = null;
            throw new PersistenceException((Throwable)EntityManagerSetupException.predeployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), runtimeException));
        }
    }

    public String getConfigPropertyAsString(String string, String string2) {
        return EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(string, this.predeployProperties, string2, this.session);
    }

    public String getConfigPropertyAsString(String string) {
        return EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(string, this.predeployProperties, this.session);
    }

    public String getDeployedSessionName() {
        return this.session != null ? this.session.getName() : null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public boolean isValidationOnly(Map map) {
        return this.isValidationOnly(map, true);
    }

    protected boolean isValidationOnly(Map map, boolean bl) {
        String string;
        if (bl) {
            map = this.mergeWithExistingMap(map);
        }
        if ((string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.validation-only", map, this.session)) != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public boolean shouldGetSessionOnCreateFactory(Map map) {
        map = this.mergeWithExistingMap(map);
        return this.isValidationOnly(map, false);
    }

    protected Map mergeWithExistingMap(Map map) {
        if (this.predeployProperties != null) {
            return EntityManagerFactoryProvider.mergeMaps(map, this.predeployProperties);
        }
        if (this.persistenceUnitInfo != null) {
            return EntityManagerFactoryProvider.mergeMaps(map, this.persistenceUnitInfo.getProperties());
        }
        return map;
    }

    public boolean isInContainerMode() {
        return this.isInContainerMode;
    }

    protected void updateLogins(Map map) {
        Cloneable cloneable;
        String string;
        DatabaseLogin databaseLogin = this.session.getLogin();
        String string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.user", map, this.session);
        String string3 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.password", map, this.session);
        if (string2 != null) {
            databaseLogin.setUserName(string2);
        }
        if (string3 != null) {
            databaseLogin.setPassword(this.securableObjectHolder.getSecurableObject().decryptPassword(string3));
        }
        if ((string = PropertiesHandler.getPropertyValueLogDebug("eclipselink.target-database", map, this.session)) != null) {
            databaseLogin.setPlatformClassName(string, this.persistenceUnitInfo.getClassLoader());
        }
        PersistenceUnitTransactionType persistenceUnitTransactionType = this.persistenceUnitInfo.getTransactionType();
        String string4 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", map, this.session);
        if (string4 != null) {
            persistenceUnitTransactionType = PersistenceUnitTransactionType.valueOf((String)string4);
        }
        DataSource dataSource = this.getDatasourceFromProperties(map, "javax.persistence.jtaDataSource", this.persistenceUnitInfo.getJtaDataSource());
        DataSource dataSource2 = this.getDatasourceFromProperties(map, "javax.persistence.nonJtaDataSource", this.persistenceUnitInfo.getNonJtaDataSource());
        if (this.isValidationOnly(map, false) && persistenceUnitTransactionType == PersistenceUnitTransactionType.JTA && dataSource == null) {
            this.updateLoginDefaultConnector(databaseLogin, map);
            return;
        }
        if (this.session.getProject().usesSequencing()) {
            this.session.getSequencingControl().setShouldUseSeparateConnection(dataSource2 != null);
        }
        databaseLogin.setUsesExternalTransactionController(persistenceUnitTransactionType == PersistenceUnitTransactionType.JTA);
        DataSource dataSource3 = null;
        DataSource dataSource4 = null;
        if (databaseLogin.shouldUseExternalTransactionController()) {
            dataSource3 = dataSource;
            dataSource4 = dataSource2;
        } else {
            if (dataSource != null) {
                this.session.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (dataSource2 != null) {
                dataSource3 = dataSource2;
            } else {
                this.updateLoginDefaultConnector(databaseLogin, map);
                return;
            }
        }
        if (!(databaseLogin.getConnector() instanceof JNDIConnector)) {
            cloneable = dataSource3 instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)dataSource3).getName()) : new JNDIConnector(dataSource3);
            databaseLogin.setConnector((Connector)cloneable);
            databaseLogin.setUsesExternalConnectionPooling(true);
        }
        if (dataSource4 != null) {
            cloneable = (DatasourceLogin)databaseLogin.clone();
            ((DatasourceLogin)cloneable).dontUseExternalTransactionController();
            JNDIConnector jNDIConnector = dataSource4 instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)dataSource4).getName()) : new JNDIConnector(dataSource4);
            ((DatasourceLogin)cloneable).setConnector(jNDIConnector);
            this.session.setReadConnectionPool((Login)((Object)cloneable));
        }
    }

    protected DataSource getDatasourceFromProperties(Map map, String string, DataSource dataSource) {
        Object object = EntityManagerFactoryProvider.getConfigPropertyLogDebug(string, map, this.session);
        if (object == null) {
            return dataSource;
        }
        if (object instanceof String) {
            return new DataSourceImpl((String)object, null, null, null);
        }
        if (!(object instanceof DataSource)) {
            this.session.log(6, "properties", "invalid_datasource_property_value", string, object);
            return dataSource;
        }
        return (DataSource)object;
    }

    protected void updateLoginDefaultConnector(DatasourceLogin datasourceLogin, Map map) {
        if (datasourceLogin.getConnector() instanceof DefaultConnector) {
            DatabaseLogin databaseLogin = (DatabaseLogin)datasourceLogin;
            String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.driver", map, this.session);
            String string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.url", map, this.session);
            if (string2 != null) {
                databaseLogin.setConnectionString(string2);
            }
            if (string != null) {
                databaseLogin.setDriverClassName(string);
            }
        }
    }

    protected void updatePools(Map map) {
        String string;
        String string2;
        if (!this.session.getDefaultConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.write-connections.min", map, this.session);
            if (string2 != null) {
                this.session.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(string2));
            }
            if ((string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.write-connections.max", map, this.session)) != null) {
                this.session.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(string));
            }
        }
        if (!this.session.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            boolean bl;
            boolean bl2;
            String string3;
            string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.min", map, this.session);
            if (string2 != null) {
                this.session.getReadConnectionPool().setMinNumberOfConnections(Integer.parseInt(string2));
            }
            if ((string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.max", map, this.session)) != null) {
                this.session.getReadConnectionPool().setMaxNumberOfConnections(Integer.parseInt(string));
            }
            if ((string3 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.shared", map, this.session)) != null && (bl2 = Boolean.parseBoolean(string3)) != (bl = this.session.getReadConnectionPool() instanceof ReadConnectionPool)) {
                Login login = this.session.getReadConnectionPool().getLogin();
                int n = this.session.getReadConnectionPool().getMinNumberOfConnections();
                int n2 = this.session.getReadConnectionPool().getMaxNumberOfConnections();
                if (bl2) {
                    this.session.useReadConnectionPool(n, n2);
                } else {
                    this.session.useExclusiveReadConnectionPool(n, n2);
                }
                this.session.getReadConnectionPool().setLogin(login);
            }
        }
    }

    protected void initServerSession(Map map) {
        this.assignCMP3Policy();
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-name", map, this.session);
        if (string != null && !string.equals(this.session.getName())) {
            this.session.setName(string);
        }
        this.addSessionToGlobalSessionManager();
    }

    protected void setServerSessionName(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.session-name", map);
        if (string == null) {
            string = this.persistenceUnitInfo.getPersistenceUnitRootUrl() != null ? this.persistenceUnitInfo.getPersistenceUnitRootUrl().toString() + "-" + this.persistenceUnitInfo.getPersistenceUnitName() : this.persistenceUnitInfo.getPersistenceUnitName();
        }
        this.session.setName(string);
    }

    protected void updateServerSession(Map map, ClassLoader classLoader) {
        if (this.session == null || this.session.isConnected()) {
            return;
        }
        boolean bl = this.updateServerPlatform(map, classLoader);
        boolean bl2 = this.updateSessionName(map);
        this.updateLoggers(map, bl, bl2, classLoader);
        this.updateProfiler(map, classLoader);
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.bind-parameters", map, this.session);
        if (string != null) {
            this.session.getPlatform().setShouldBindAllParameters(Boolean.parseBoolean(string));
        }
        this.updateLogins(map);
        if (!this.session.getLogin().shouldUseExternalTransactionController()) {
            this.session.getServerPlatform().disableJTA();
        }
        this.setSessionEventListener(map, classLoader);
        this.setExceptionHandler(map, classLoader);
        this.updatePools(map);
        if (!this.isSessionLoadedFromSessionsXML) {
            this.updateDescriptorCacheSettings(map, classLoader);
        }
        this.updateConnectionPolicy(map);
        this.updateBatchWritingSetting(map);
        this.updateNativeSQLSetting(map);
        this.updateUppercaseSetting(map);
        this.updateCacheStatementSettings(map);
        this.updateTemporalMutableSetting(map);
        this.updateAllowZeroIdSetting(map);
        this.processDescriptorCustomizers(map, classLoader);
        this.processSessionCustomizer(map, classLoader);
        this.setDescriptorNamedQueries(map);
    }

    public void setIsInContainerMode(boolean bl) {
        this.isInContainerMode = bl;
    }

    protected void processSessionCustomizer(Map map, ClassLoader classLoader) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.customizer", map, this.session);
        if (string == null) {
            return;
        }
        Class clazz = EntityManagerSetupImpl.findClassForProperty(string, "eclipselink.session.customizer", classLoader);
        try {
            SessionCustomizer sessionCustomizer = (SessionCustomizer)clazz.newInstance();
            sessionCustomizer.customize(this.session);
        }
        catch (Exception exception) {
            throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.session.customizer", string, exception);
        }
    }

    protected void initOrUpdateLogging(Map map, SessionLog sessionLog) {
        String string;
        String string2;
        Object object;
        Object object2;
        Map map2;
        String string3 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.logging.level", map, this.session);
        if (string3 != null) {
            sessionLog.setLevel(AbstractSessionLog.translateStringToLoggingLevel(string3));
        }
        if (!(map2 = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.logging.level.", map, this.session)).isEmpty()) {
            object2 = map2.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                string2 = (String)object.getKey();
                string = (String)object.getValue();
                sessionLog.setLevel(AbstractSessionLog.translateStringToLoggingLevel(string), string2);
            }
        }
        if ((object2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.timestamp", map, this.session)) != null) {
            sessionLog.setShouldPrintDate(Boolean.parseBoolean((String)object2));
        }
        if ((object = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.thread", map, this.session)) != null) {
            sessionLog.setShouldPrintThread(Boolean.parseBoolean((String)object));
        }
        if ((string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.session", map, this.session)) != null) {
            sessionLog.setShouldPrintSession(Boolean.parseBoolean(string2));
        }
        if ((string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.exceptions", map, this.session)) != null) {
            sessionLog.setShouldLogExceptionStackTrace(Boolean.parseBoolean(string));
        }
    }

    protected boolean updateSessionName(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-name", map, this.session);
        if (string == null || string.equals(this.session.getName())) {
            return false;
        }
        this.removeSessionFromGlobalSessionManager();
        this.session.setName(string);
        this.addSessionToGlobalSessionManager();
        return true;
    }

    protected void processDescriptorCustomizers(Map map, ClassLoader classLoader) {
        Map map2 = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.descriptor.customizer.", map, this.session);
        if (map2.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map2.entrySet()) {
            Object object;
            String string = (String)entry.getKey();
            ClassDescriptor classDescriptor = this.session.getDescriptorForAlias(string);
            if (classDescriptor == null) {
                try {
                    object = EntityManagerSetupImpl.findClass(string, classLoader);
                    classDescriptor = this.session.getDescriptor((Class)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (classDescriptor == null) continue;
            object = (String)entry.getValue();
            Class clazz = EntityManagerSetupImpl.findClassForProperty((String)object, "eclipselink.descriptor.customizer." + string, classLoader);
            try {
                DescriptorCustomizer descriptorCustomizer = (DescriptorCustomizer)clazz.newInstance();
                descriptorCustomizer.customize(classDescriptor);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + string, (String)object, exception);
            }
        }
    }

    public boolean isInitial() {
        return this.state == STATE_INITIAL;
    }

    public boolean isPredeployed() {
        return this.state == STATE_PREDEPLOYED;
    }

    public boolean isDeployed() {
        return this.state == STATE_DEPLOYED;
    }

    public boolean isUndeployed() {
        return this.state == STATE_UNDEPLOYED;
    }

    public boolean isPredeployFailed() {
        return this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean isDeployFailed() {
        return this.state == STATE_DEPLOY_FAILED;
    }

    public int getFactoryCount() {
        return this.factoryCount;
    }

    public boolean shouldRedeploy() {
        return this.state == STATE_UNDEPLOYED || this.state == STATE_PREDEPLOY_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeploy() {
        block13: {
            block12: {
                if (this.state == STATE_INITIAL || this.state == STATE_PREDEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
                    return;
                }
                this.session.log(1, "properties", "undeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                try {
                    --this.factoryCount;
                    if (this.factoryCount <= 0) break block12;
                }
                catch (Throwable throwable) {
                    this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                    if (this.state == STATE_UNDEPLOYED) {
                        this.session = null;
                    }
                    throw throwable;
                }
                this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                if (this.state == STATE_UNDEPLOYED) {
                    this.session = null;
                }
                return;
            }
            this.state = STATE_UNDEPLOYED;
            this.removeSessionFromGlobalSessionManager();
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                String string;
                String string2 = string = PersistenceUnitProcessor.buildPersistenceUnitName(this.getPersistenceUnitInfo().getPersistenceUnitRootUrl(), this.getPersistenceUnitInfo().getPersistenceUnitName());
                if (this.predeployProperties.get("eclipselink.session-name") != null) {
                    string2 = string + this.predeployProperties.get("eclipselink.session-name");
                }
                EntityManagerFactoryProvider.emSetupImpls.remove(string2);
                if (--EntityManagerFactoryProvider.PUIUsageCount <= 0) {
                    EntityManagerFactoryProvider.persistenceUnits.remove(string);
                }
            }
            if (null == this.persistenceInitializationHelper) break block13;
            this.persistenceInitializationHelper.unsetInitializer();
        }
        this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        if (this.state == STATE_UNDEPLOYED) {
            this.session = null;
        }
    }

    protected void setSessionEventListener(Map map, ClassLoader classLoader) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-event-listener", map, this.session);
        if (string != null) {
            Class clazz = EntityManagerSetupImpl.findClassForProperty(string, "eclipselink.session-event-listener", classLoader);
            try {
                SessionEventListener sessionEventListener = (SessionEventListener)EntityManagerSetupImpl.buildObjectForClass(clazz, SessionEventListener.class);
                if (sessionEventListener != null) {
                    this.session.getEventManager().getListeners().add(sessionEventListener);
                } else {
                    this.session.handleException(ValidationException.invalidSessionEventListenerClass(string));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(string, illegalAccessException));
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(string, privilegedActionException));
            }
            catch (InstantiationException instantiationException) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(string, instantiationException));
            }
        }
    }

    protected void setExceptionHandler(Map map, ClassLoader classLoader) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.exception-handler", map, this.session);
        if (string != null) {
            Class clazz = EntityManagerSetupImpl.findClassForProperty(string, "eclipselink.exception-handler", classLoader);
            try {
                ExceptionHandler exceptionHandler = (ExceptionHandler)EntityManagerSetupImpl.buildObjectForClass(clazz, ExceptionHandler.class);
                if (exceptionHandler != null) {
                    this.session.setExceptionHandler(exceptionHandler);
                } else {
                    this.session.handleException(ValidationException.invalidExceptionHandlerClass(string));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(string, illegalAccessException));
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(string, privilegedActionException));
            }
            catch (InstantiationException instantiationException) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(string, instantiationException));
            }
        }
    }

    protected void updateBatchWritingSetting(Map map) {
        String string;
        String string2 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.batch-writing", map, this.session);
        if (string2 != null) {
            this.session.getPlatform().setUsesBatchWriting(string2 != "None");
            if (string2 == "JDBC") {
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (string2 == "Buffered") {
                this.session.getPlatform().setUsesJDBCBatchWriting(false);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (string2 == "Oracle-JDBC") {
                this.session.getPlatform().setUsesNativeBatchWriting(true);
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
            }
        }
        if ((string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.batch-writing.size", map, this.session)) != null) {
            try {
                this.session.getPlatform().setMaxBatchWritingSize(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.session.handleException(ValidationException.invalidValueForProperty(string, "eclipselink.jdbc.batch-writing.size", numberFormatException));
            }
        }
    }

    protected void updateNativeSQLSetting(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.native-sql", map, this.session);
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().useNativeSQL();
            } else if (string.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().dontUseNativeSQL();
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForSettingNativeSQL(string));
            }
        }
    }

    protected void updateUppercaseSetting(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.uppercase-columns", map, this.session);
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
            } else if (string.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(string, "eclipselink.jdbc.uppercase-columns"));
            }
        }
    }

    protected void updatePessimisticLockTimeout(Map map) {
        String string = PropertiesHandler.getPropertyValueLogDebug("javax.persistence.lock.timeout", map, this.session);
        if (string != null) {
            try {
                this.session.setPessimisticLockTimeoutDefault(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.session.handleException(ValidationException.invalidValueForProperty(string, "javax.persistence.lock.timeout", numberFormatException));
            }
        }
    }

    protected void updateCacheStatementSettings(Map map) {
        String string;
        String string2 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements", map, this.session);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                if (this.session.getConnectionPools().size() > 0) {
                    this.session.getProject().getLogin().setShouldCacheAllStatements(true);
                } else {
                    this.session.log(6, "properties", "persistence_unit_ignores_statments_cache_setting", new Object[]{null});
                }
            } else if (string2.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldCacheAllStatements(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForEnableStatmentsCached(string2));
            }
        }
        if ((string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements.size", map, this.session)) != null) {
            try {
                this.session.getProject().getLogin().setStatementCacheSize(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.session.handleException(ValidationException.invalidCacheStatementsSize(string, numberFormatException.getMessage()));
            }
        }
    }

    protected void updateAllowZeroIdSetting(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.allow-zero-id", map, this.session);
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                Helper.isZeroValidPrimaryKey = true;
            } else if (string.equalsIgnoreCase("false")) {
                Helper.isZeroValidPrimaryKey = false;
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(string, "eclipselink.allow-zero-id"));
            }
        }
    }

    protected void updateTemporalMutableSetting(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.temporal.mutable", map, this.session);
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                this.session.getProject().setDefaultTemporalMutable(true);
            } else if (string.equalsIgnoreCase("false")) {
                this.session.getProject().setDefaultTemporalMutable(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(string, "eclipselink.temporal.mutable"));
            }
        }
    }

    protected void setDescriptorNamedQueries(Map map) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.include.descriptor.queries", map, this.session);
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                this.session.copyDescriptorNamedQueries(false);
            } else if (!string.equalsIgnoreCase("false")) {
                this.session.handleException(ValidationException.invalidBooleanValueForAddingNamedQueries(string));
            }
        }
    }

    public PersistenceInitializationHelper getPersistenceInitializationHelper() {
        return this.persistenceInitializationHelper;
    }

    public void setPersistenceInitializationHelper(PersistenceInitializationHelper persistenceInitializationHelper) {
        this.persistenceInitializationHelper = persistenceInitializationHelper;
    }
}

