/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class MetadataHelper {
    public static final String JPA_ORM_FILE = "META-INF/orm.xml";
    public static final String ECLIPSELINK_ORM_FILE = "META-INF/eclipselink-orm.xml";

    static Class getClassForName(String string, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.unableToLoadClass(string, privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.unableToLoadClass(string, classNotFoundException);
        }
    }

    static Object getClassInstance(Class clazz) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.errorInstantiatingClass(clazz, privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ValidationException.errorInstantiatingClass(clazz, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw ValidationException.errorInstantiatingClass(clazz, instantiationException);
        }
    }

    static Object getClassInstance(String string, ClassLoader classLoader) {
        return MetadataHelper.getClassInstance(MetadataHelper.getClassForName(string, classLoader));
    }

    public static String getName(String string, String string2, String string3, MetadataLogger metadataLogger, Object object) {
        if (string != null && !string.equals("")) {
            return string;
        }
        if (string2 == null || string2.equals("")) {
            return "";
        }
        metadataLogger.logConfigMessage(string3, object, (Object)string2);
        return string2;
    }

    public static Integer getValue(Integer n, Integer n2) {
        if (n == null) {
            return n2;
        }
        return n;
    }

    public static String getValue(String string, String string2) {
        if (string != null && !string.equals("")) {
            return string;
        }
        return string2;
    }

    static Object invokeMethod(String string, Object object) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(object.getClass(), string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EntityManagerSetupException.methodInvocationFailed(method, object, noSuchMethodException);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, object);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, object, exception);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw EntityManagerSetupException.methodInvocationFailed(method, object, invocationTargetException);
            }
        }
        return null;
    }
}

