/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.MapKey;
import javax.persistence.OrderBy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAccessor
extends RelationshipAccessor {
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private String m_mapKey;
    private String m_mappedBy;
    private String m_orderBy;
    private JoinTableMetadata m_joinTable;

    protected CollectionAccessor(String string) {
        super(string);
    }

    protected CollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object t;
        Object t2;
        String string = this.m_mappedBy = annotation == null ? "" : (String)MetadataHelper.invokeMethod("mappedBy", annotation);
        if (this.isAnnotationPresent(JoinTable.class)) {
            this.m_joinTable = new JoinTableMetadata((Annotation)this.getAnnotation(JoinTable.class), metadataAccessibleObject);
        }
        if ((t2 = this.getAnnotation(OrderBy.class)) != null) {
            this.m_orderBy = (String)MetadataHelper.invokeMethod("value", t2);
        }
        if ((t = this.getAnnotation(MapKey.class)) != null) {
            this.m_mapKey = (String)MetadataHelper.invokeMethod("name", t);
        }
    }

    protected void addManyToManyRelationKeyFields(List<JoinColumnMetadata> list, ManyToManyMapping manyToManyMapping, String string, MetadataDescriptor metadataDescriptor, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = "metadata_default_source_pk_column";
            string2 = "metadata_default_source_fk_column";
        } else {
            string3 = "metadata_default_target_pk_column";
            string2 = "metadata_default_target_fk_column";
        }
        for (JoinColumnMetadata joinColumnMetadata : list) {
            String string4 = metadataDescriptor.getPrimaryKeyFieldName();
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string4, string3));
            databaseField.setTable(metadataDescriptor.getPrimaryKeyTable());
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            String string5 = string + "_" + string4;
            databaseField2.setName(this.getName(databaseField2, string5, string2));
            databaseField2.setTable(manyToManyMapping.getRelationTable());
            if (bl) {
                manyToManyMapping.addSourceRelationKeyField(databaseField2, databaseField);
                continue;
            }
            manyToManyMapping.addTargetRelationKeyField(databaseField2, databaseField);
        }
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"LAZY");
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    public String getMapKey() {
        return this.m_mapKey;
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity(this.getAttributeName(), this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    public boolean isMapCollectionAccessor() {
        return this.getRawClass().equals(Map.class);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_joinTable, metadataAccessibleObject);
    }

    @Override
    public void process() {
        if (!this.getAccessibleObject().isSupportedCollectionClass(this.getDescriptor())) {
            throw ValidationException.invalidCollectionTypeForRelationship(this.getJavaClass(), this.getRawClass(), this.getAttributeName());
        }
    }

    protected void process(CollectionMapping collectionMapping) {
        collectionMapping.setIsReadOnly(false);
        collectionMapping.setIsLazy(this.isLazy());
        collectionMapping.setIsPrivateOwned(this.isPrivateOwned());
        collectionMapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        collectionMapping.setAttributeName(this.getAttributeName());
        collectionMapping.setReferenceClassName(this.getReferenceClassName());
        this.setAccessorMethods(collectionMapping);
        this.processCascadeTypes(collectionMapping);
        this.processOrderBy(collectionMapping);
        String string = this.processMapKey(collectionMapping);
        this.setIndirectionPolicy(collectionMapping, string, this.usesIndirection());
        this.processReturnInsertAndUpdate();
    }

    protected void processJoinTable(ManyToManyMapping manyToManyMapping) {
        if (this.m_joinTable == null) {
            this.m_joinTable = new JoinTableMetadata(null, this.getAccessibleObject());
        }
        String string = this.getDescriptor().getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(this.m_joinTable, string);
        manyToManyMapping.setRelationTable(this.m_joinTable.getDatabaseTable());
        String string2 = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.getDescriptor().getAlias();
        this.addManyToManyRelationKeyFields(this.processJoinColumns(this.m_joinTable.getJoinColumns(), this.getOwningDescriptor()), manyToManyMapping, string2, this.getOwningDescriptor(), true);
        String string3 = this.getAttributeName();
        this.addManyToManyRelationKeyFields(this.processJoinColumns(this.m_joinTable.getInverseJoinColumns(), this.getReferenceDescriptor()), manyToManyMapping, string3, this.getReferenceDescriptor(), false);
    }

    protected String processMapKey(CollectionMapping collectionMapping) {
        String string = null;
        if (this.isMapCollectionAccessor()) {
            MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
            if (this.m_mapKey != null && !this.m_mapKey.equals("") || !metadataDescriptor.hasCompositePrimaryKey()) {
                String string2 = metadataDescriptor.getIdAttributeName();
                this.getLogger();
                String string3 = this.getName(this.m_mapKey, string2, "metadata_default_map_key_attribute_name");
                MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(string3);
                if (mappingAccessor == null) {
                    throw ValidationException.couldNotFindMapKey(string3, metadataDescriptor.getJavaClass(), collectionMapping);
                }
                string = mappingAccessor.getAccessibleObjectName();
            }
        }
        return string;
    }

    protected void processOrderBy(CollectionMapping collectionMapping) {
        block10: {
            if (this.m_orderBy == null) break block10;
            MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
            if (this.m_orderBy.equals("")) {
                List<String> list = metadataDescriptor.getIdOrderByAttributeNames();
                if (metadataDescriptor.hasEmbeddedIdAttribute()) {
                    String string = metadataDescriptor.getEmbeddedIdAttributeName();
                    for (String string2 : list) {
                        collectionMapping.addAggregateOrderBy(string, string2, false);
                    }
                } else {
                    for (String string : list) {
                        collectionMapping.addOrderBy(string, false);
                    }
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.m_orderBy, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken());
                    String string3 = stringTokenizer2.nextToken();
                    MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(string3);
                    if (mappingAccessor == null) {
                        throw ValidationException.invalidOrderByValue(string3, metadataDescriptor.getJavaClass(), this.getAccessibleObjectName(), this.getJavaClass());
                    }
                    String string4 = mappingAccessor.getAttributeName();
                    String string5 = string = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : ASCENDING;
                    if (mappingAccessor.isEmbedded()) {
                        for (String string6 : metadataDescriptor.getOrderByAttributeNames()) {
                            collectionMapping.addAggregateOrderBy(string4, string6, string.equals(DESCENDING));
                        }
                        continue;
                    }
                    collectionMapping.addOrderBy(string4, string.equals(DESCENDING));
                }
            }
        }
    }

    public void setJoinTable(JoinTableMetadata joinTableMetadata) {
        this.m_joinTable = joinTableMetadata;
    }

    public void setMapKey(String string) {
        this.m_mapKey = string;
    }

    public void setMappedBy(String string) {
        this.m_mappedBy = string;
    }

    public void setOrderBy(String string) {
        this.m_orderBy = string;
    }
}

