/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class MappingAccessor
extends MetadataAccessor {
    private AccessMethodsMetadata m_accessMethods;
    private ClassAccessor m_classAccessor;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();

    protected MappingAccessor(String string) {
        super(string);
    }

    protected MappingAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
        this.m_classAccessor = classAccessor;
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    protected String getGetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getGetMethodName() != null) {
            return this.m_accessMethods.getGetMethodName();
        }
        return this.getAccessibleObjectName();
    }

    protected int getMappingJoinFetchType(Enum enum_) {
        if (enum_ == null) {
            return 0;
        }
        if (enum_.name().equals(JoinFetchType.INNER.name())) {
            return 1;
        }
        return 2;
    }

    public Class getRawClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor classAccessor = this.getProject().getAccessor(this.getReferenceClassName());
        if (classAccessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit(this.getReferenceClassName());
        }
        return classAccessor.getDescriptor();
    }

    protected String getSetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getSetMethodName() != null) {
            return this.m_accessMethods.getSetMethodName();
        }
        return ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert() {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public void initXMLMappingAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        this.initXMLAccessor(classAccessor.getDescriptor(), classAccessor.getProject());
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_accessMethods, metadataAccessibleObject);
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    protected void processProperties(DatabaseMapping databaseMapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata propertyMetadata : this.getProperties()) {
                this.processProperty(databaseMapping, propertyMetadata);
            }
        } else {
            Object object;
            Object t = this.getAnnotation(Properties.class);
            if (t != null) {
                object = (Annotation[])MetadataHelper.invokeMethod("value", t);
                int n = ((T)object).length;
                for (int i = 0; i < n; ++i) {
                    Object t2 = object[i];
                    this.processProperty(databaseMapping, new PropertyMetadata((Annotation)t2, this.getAccessibleObject()));
                }
            }
            if ((object = this.getAnnotation(Property.class)) != null) {
                this.processProperty(databaseMapping, new PropertyMetadata((Annotation)object, this.getAccessibleObject()));
            }
        }
    }

    protected void processProperty(DatabaseMapping databaseMapping, PropertyMetadata propertyMetadata) {
        if (propertyMetadata.shouldOverride(this.m_properties.get(propertyMetadata.getName()))) {
            this.m_properties.put(propertyMetadata.getName(), propertyMetadata);
            databaseMapping.getProperties().put(propertyMetadata.getName(), propertyMetadata.getConvertedValue());
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethodsMetadata) {
        this.m_accessMethods = accessMethodsMetadata;
    }

    protected void setAccessorMethods(DatabaseMapping databaseMapping) {
        if (this.usesPropertyAccess(this.getDescriptor())) {
            databaseMapping.setGetMethodName(this.getGetMethodName());
            databaseMapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
    }

    public void setIndirectionPolicy(CollectionMapping collectionMapping, String string, boolean bl) {
        Class clazz = this.getRawClass();
        if (bl) {
            if (clazz == Map.class) {
                collectionMapping.useTransparentMap(string);
            } else if (clazz == List.class) {
                collectionMapping.useTransparentList();
            } else if (clazz == Collection.class) {
                collectionMapping.useTransparentCollection();
                collectionMapping.setContainerPolicy(new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (clazz == Set.class) {
                collectionMapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), clazz);
            }
        } else {
            collectionMapping.dontUseIndirection();
            if (clazz == Map.class) {
                collectionMapping.useMapClass(Hashtable.class, string);
            } else if (clazz == Set.class) {
                collectionMapping.useCollectionClass(HashSet.class);
            } else if (clazz == List.class) {
                collectionMapping.useCollectionClass(Vector.class);
            } else if (clazz == Collection.class) {
                collectionMapping.setContainerPolicy(new CollectionContainerPolicy(Vector.class));
            } else if (string == null || string.equals("")) {
                collectionMapping.useCollectionClass(clazz);
            } else {
                collectionMapping.useMapClass(clazz, string);
            }
        }
    }

    public boolean usesPropertyAccess(MetadataDescriptor metadataDescriptor) {
        if (this.hasAccess()) {
            return this.hasPropertyAccess();
        }
        return this.m_accessMethods == null ? this.m_classAccessor.usesPropertyAccess() : true;
    }
}

