/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CascadeTypes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MappingAccessor {
    private boolean m_privateOwned;
    private CascadeTypes m_cascadeTypes;
    protected Class m_referenceClass;
    private Class m_targetEntity;
    private Enum m_fetch;
    private Enum m_joinFetch;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private String m_targetEntityName;

    protected RelationshipAccessor(String string) {
        super(string);
    }

    protected RelationshipAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object object;
        this.m_fetch = annotation == null ? this.getDefaultFetchType() : (Enum)MetadataHelper.invokeMethod("fetch", annotation);
        this.m_targetEntity = annotation == null ? Void.TYPE : (Class)MetadataHelper.invokeMethod("targetEntity", annotation);
        this.m_cascadeTypes = annotation == null ? null : new CascadeTypes((Enum[])MetadataHelper.invokeMethod("cascade", annotation), metadataAccessibleObject);
        Object t = this.getAnnotation(JoinFetch.class);
        if (t != null) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", t);
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        Object t2 = this.getAnnotation(JoinColumns.class);
        if (t2 != null) {
            object = (Annotation[])MetadataHelper.invokeMethod("value", t2);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                Object t3 = object[i];
                this.m_joinColumns.add(new JoinColumnMetadata((Annotation)t3, metadataAccessibleObject));
            }
        }
        if ((object = this.getAnnotation(JoinColumn.class)) != null) {
            this.m_joinColumns.add(new JoinColumnMetadata((Annotation)object, metadataAccessibleObject));
        }
    }

    public CascadeTypes getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    @Override
    public abstract Enum getDefaultFetchType();

    public Enum getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    protected abstract String getLoggingContext();

    protected DatabaseMapping getOwningMapping(String string) {
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        DatabaseMapping databaseMapping = metadataDescriptor.getMappingForAttributeName(string, this);
        if (databaseMapping == null) {
            throw ValidationException.noMappedByAttributeFound(metadataDescriptor.getJavaClass(), string, this.getJavaClass(), this.getAttributeName());
        }
        return databaseMapping;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor metadataDescriptor;
        try {
            metadataDescriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            metadataDescriptor = null;
        }
        if (metadataDescriptor == null || metadataDescriptor.isEmbeddable() || metadataDescriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship(this.getJavaClass(), this.getReferenceClass(), this.getAnnotatedElement());
        }
        return metadataDescriptor;
    }

    public Class getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_joinColumns, metadataAccessibleObject);
        this.initXMLObject(this.m_cascadeTypes, metadataAccessibleObject);
        this.m_targetEntity = this.initXMLClassName(this.m_targetEntityName);
    }

    public boolean isLazy() {
        Enum enum_ = this.getFetch();
        if (enum_ == null) {
            enum_ = this.getDefaultFetchType();
        }
        return enum_.name().equals(FetchType.LAZY.name());
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    protected void processCascadeTypes(ForeignReferenceMapping foreignReferenceMapping) {
        if (this.m_cascadeTypes != null) {
            for (Enum enum_ : this.m_cascadeTypes.getTypes()) {
                this.setCascadeType(enum_, foreignReferenceMapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !foreignReferenceMapping.isCascadePersist()) {
            this.setCascadeType((Enum)CascadeType.PERSIST, foreignReferenceMapping);
        }
    }

    protected List<JoinColumnMetadata> processJoinColumns() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(this.m_joinColumns, this.getReferenceDescriptor());
    }

    protected List<JoinColumnMetadata> processJoinColumns(List<JoinColumnMetadata> list, MetadataDescriptor metadataDescriptor) {
        if (list.isEmpty()) {
            if (metadataDescriptor.hasCompositePrimaryKey()) {
                for (String object : metadataDescriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumnMetadata = new JoinColumnMetadata();
                    joinColumnMetadata.setReferencedColumnName(object);
                    joinColumnMetadata.setName(object);
                    list.add(joinColumnMetadata);
                }
            } else {
                list.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumnMetadata : list) {
                joinColumnMetadata.setReferencedColumnName(metadataDescriptor.getPrimaryKeyJoinColumnAssociation(joinColumnMetadata.getReferencedColumnName()));
            }
        }
        if (metadataDescriptor.hasCompositePrimaryKey()) {
            if (list.size() != metadataDescriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumnMetadata : list) {
                if (!joinColumnMetadata.isPrimaryKeyFieldNotSpecified() && !joinColumnMetadata.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
        }
        return list;
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.hasColumn()) {
                throw ValidationException.invalidColumnAnnotationOnRelationship(this.getJavaClass(), this.getAttributeName());
            }
            if (this.hasConvert()) {
                throw ValidationException.invalidMappingForConverter(this.getJavaClass(), this.getAttributeName());
            }
            if (!(this.getTargetEntity() == ValueHolderInterface.class || this.getTargetEntity() == Void.TYPE && this.getReferenceClass().getName().equalsIgnoreCase(ValueHolderInterface.class.getName()))) {
                this.process();
            }
            this.setIsProcessed();
        }
    }

    protected void processUnidirectionalOneToManyTargetForeignKeyRelationship(UnidirectionalOneToManyMapping unidirectionalOneToManyMapping) {
        String string = this.getDescriptor().getPrimaryKeyFieldName();
        String string2 = this.getUpperCaseAttributeName() + "_" + string;
        for (JoinColumnMetadata joinColumnMetadata : this.processJoinColumns()) {
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string, "metadata_default_pk_column"));
            databaseField.setTable(this.getDescriptor().getPrimaryKeyTable());
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, string2, "metadata_default_fk_column"));
            if (databaseField2.getTableName().equals("")) {
                databaseField2.setTable(this.getReferenceDescriptor().getPrimaryTable());
            }
            unidirectionalOneToManyMapping.addTargetForeignKeyField(databaseField2, databaseField);
            if (!databaseField2.isReadOnly()) continue;
            unidirectionalOneToManyMapping.setIsReadOnly(true);
        }
    }

    @Override
    protected void setAccessorMethods(DatabaseMapping databaseMapping) {
        super.setAccessorMethods(databaseMapping);
        ((ForeignReferenceMapping)databaseMapping).setRequiresTransientWeavedFields(this.usesPropertyAccess(this.getDescriptor()) && !this.getClassAccessor().usesPropertyAccess());
    }

    protected void setCascadeType(Enum enum_, ForeignReferenceMapping foreignReferenceMapping) {
        if (enum_.name().equals(CascadeType.ALL.name())) {
            foreignReferenceMapping.setCascadeAll(true);
        } else if (enum_.name().equals(CascadeType.MERGE.name())) {
            foreignReferenceMapping.setCascadeMerge(true);
        } else if (enum_.name().equals(CascadeType.PERSIST.name())) {
            foreignReferenceMapping.setCascadePersist(true);
        } else if (enum_.name().equals(CascadeType.REFRESH.name())) {
            foreignReferenceMapping.setCascadeRefresh(true);
        } else if (enum_.name().equals(CascadeType.REMOVE.name())) {
            foreignReferenceMapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(CascadeTypes cascadeTypes) {
        this.m_cascadeTypes = cascadeTypes;
    }

    public void setFetch(Enum enum_) {
        this.m_fetch = enum_;
    }

    public void setJoinColumns(List<JoinColumnMetadata> list) {
        this.m_joinColumns = list;
    }

    public void setJoinFetch(Enum enum_) {
        this.m_joinFetch = enum_;
    }

    public void setPrivateOwned(String string) {
        this.m_privateOwned = true;
    }

    public void setTargetEntity(Class clazz) {
        this.m_targetEntity = clazz;
    }

    public void setTargetEntityName(String string) {
        this.m_targetEntityName = string;
    }

    public boolean usesIndirection() {
        if (this.getProject().weaveEager()) {
            return true;
        }
        return this.isLazy();
    }
}

