/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.SortDirectionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class OrderByItemNode
extends Node {
    private SortDirectionNode direction = null;
    private Node orderByItem = null;

    public void validate(ParseTreeContext parseTreeContext) {
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        if (this.orderByItem != null) {
            this.orderByItem.validate(parseTreeContext);
            Object object = this.orderByItem.getType();
            this.setType(object);
            if (!typeHelper.isOrderableType(object)) {
                throw JPQLException.expectedOrderableOrderByItem(parseTreeContext.getQueryInfo(), this.orderByItem.getLine(), this.orderByItem.getColumn(), this.orderByItem.getAsString(), typeHelper.getTypeName(object));
            }
        }
    }

    public Expression generateExpression(GenerationContext generationContext) {
        boolean bl = generationContext.shouldCheckSelectNodeBeforeResolving();
        ((SelectGenerationContext)generationContext).checkSelectNodeBeforeResolving(true);
        Expression expression = this.getOrderByItem().generateExpression(generationContext);
        expression = this.getDirection().addToExpression(expression, generationContext);
        ((SelectGenerationContext)generationContext).checkSelectNodeBeforeResolving(bl);
        return expression;
    }

    public SortDirectionNode getDirection() {
        if (this.direction == null) {
            this.setDirection(new SortDirectionNode());
        }
        return this.direction;
    }

    public Node getOrderByItem() {
        return this.orderByItem;
    }

    public void setDirection(SortDirectionNode sortDirectionNode) {
        this.direction = sortDirectionNode;
    }

    public void setOrderByItem(Node node) {
        this.orderByItem = node;
    }
}

