/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionImpl;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;

public class EntityTransactionWrapper
extends TransactionWrapperImpl
implements TransactionWrapper {
    protected EntityTransactionImpl entityTransaction;

    public EntityTransactionWrapper(EntityManagerImpl entityManagerImpl) {
        super(entityManagerImpl);
    }

    public Object checkForTransaction(boolean bl) {
        if (this.entityTransaction != null && this.entityTransaction.isActive()) {
            return this.entityTransaction;
        }
        if (bl) {
            this.throwCheckTransactionFailedException();
        }
        return null;
    }

    public EntityManagerImpl getEntityManager() {
        return this.entityManager;
    }

    public EntityTransaction getTransaction() {
        if (this.entityTransaction == null) {
            this.entityTransaction = new EntityTransactionImpl(this);
        }
        return this.entityTransaction;
    }

    public void registerUnitOfWorkWithTxn(UnitOfWorkImpl unitOfWorkImpl) {
        throw new TransactionRequiredException(ExceptionLocalization.buildMessage("join_trans_called_on_entity_trans"));
    }

    public void setRollbackOnlyInternal() {
        if (this.getTransaction().isActive()) {
            this.getTransaction().setRollbackOnly();
        }
    }

    public boolean shouldFlushBeforeQuery(UnitOfWorkImpl unitOfWorkImpl) {
        return true;
    }

    protected void throwCheckTransactionFailedException() {
        throw new TransactionRequiredException(TransactionException.transactionNotActive().getMessage());
    }
}

