/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXUnmarshaller
implements PlatformUnmarshaller {
    private static final String VALIDATING = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int validationMode;
    private Object[] schemas;
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private XMLUnmarshaller xmlUnmarshaller;
    private XMLParser xmlParser;
    private boolean isResultAlwaysXMLRoot;
    private SAXParserFactory saxParserFactory;

    public SAXUnmarshaller(XMLUnmarshaller xMLUnmarshaller) throws XMLMarshalException {
        try {
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.saxParserFactory.setNamespaceAware(true);
            this.saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.saxParser = this.saxParserFactory.newSAXParser();
            this.xmlReader = new XMLReader(this.saxParser.getXMLReader());
            DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
            this.xmlReader.setErrorHandler(defaultErrorHandler);
            this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
            this.xmlParser.setNamespaceAware(true);
            this.xmlParser.setValidationMode(0);
            this.xmlUnmarshaller = xMLUnmarshaller;
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(exception);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.xmlReader.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
        this.xmlParser.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
        this.xmlParser.setErrorHandler(errorHandler);
    }

    public int getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(int n) {
        try {
            this.validationMode = n;
            this.xmlParser.setValidationMode(n);
            switch (n) {
                case 0: {
                    this.xmlReader.setFeature(VALIDATING, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(VALIDATING, true);
                    break;
                }
                case 3: {
                    try {
                        this.xmlReader.setFeature(VALIDATING, true);
                        this.saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
                        this.saxParser.setProperty(SCHEMA_SOURCE, this.schemas);
                        break;
                    }
                    catch (Exception exception) {
                        this.xmlReader.setFeature(VALIDATING, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWhitespacePreserving(boolean bl) {
        this.xmlParser.setWhitespacePreserving(bl);
    }

    public void setSchemas(Object[] objectArray) {
        this.schemas = objectArray;
    }

    public void setSchema(Schema schema) {
        this.saxParserFactory.setSchema(schema);
        try {
            this.saxParser = this.saxParserFactory.newSAXParser();
            XMLReader xMLReader = new XMLReader(this.saxParser.getXMLReader());
            xMLReader.setFeature(VALIDATING, this.xmlReader.getFeature(VALIDATING));
            xMLReader.setEntityResolver(this.xmlReader.getEntityResolver());
            xMLReader.setErrorHandler(this.xmlReader.getErrorHandler());
            this.xmlReader = xMLReader;
            this.xmlParser.setXMLSchema(schema);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(exception);
        }
    }

    public Schema getSchema() {
        return this.saxParserFactory.getSchema();
    }

    public Object unmarshal(File file) {
        try {
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element element = this.xmlParser.parse(file).getDocumentElement();
                return this.unmarshal(element);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.unmarshal(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw XMLMarshalException.unmarshalException(fileNotFoundException);
        }
    }

    public Object unmarshal(File file, Class clazz) {
        try {
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element element = this.xmlParser.parse(file).getDocumentElement();
                return this.unmarshal(element, clazz);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.unmarshal(fileInputStream, clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw XMLMarshalException.unmarshalException(fileNotFoundException);
        }
    }

    public Object unmarshal(InputStream inputStream) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element element = this.xmlParser.parse(inputStream).getDocumentElement();
            return this.unmarshal(element);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource);
    }

    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element element = this.xmlParser.parse(inputStream).getDocumentElement();
            return this.unmarshal(element, clazz);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, clazz);
    }

    public Object unmarshal(InputSource inputSource) {
        try {
            XMLContext xMLContext = this.xmlUnmarshaller.getXMLContext();
            if (xMLContext.hasDocumentPreservation()) {
                Element element = this.xmlParser.parse(inputSource).getDocumentElement();
                return this.unmarshal(element);
            }
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(xMLContext);
            sAXUnmarshallerHandler.setXMLReader(this.xmlReader);
            sAXUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(sAXUnmarshallerHandler);
            this.xmlReader.parse(inputSource);
            sAXUnmarshallerHandler.resolveReferences();
            return sAXUnmarshallerHandler.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(InputSource inputSource, XMLReader xMLReader) {
        try {
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            sAXUnmarshallerHandler.setXMLReader(xMLReader);
            sAXUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            xMLReader.setContentHandler(sAXUnmarshallerHandler);
            xMLReader.parse(inputSource);
            sAXUnmarshallerHandler.resolveReferences();
            return sAXUnmarshallerHandler.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        XMLContext xMLContext = this.xmlUnmarshaller.getXMLContext();
        if (xMLContext.hasDocumentPreservation()) {
            Element element = this.xmlParser.parse(inputSource).getDocumentElement();
            return this.unmarshal(element, clazz);
        }
        boolean bl = XMLConversionManager.getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xMLDescriptor = null;
        AbstractSession abstractSession = null;
        if (bl) {
            unmarshalRecord = new XMLRootRecord(clazz);
            unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
        } else {
            abstractSession = xMLContext.getReadSession(clazz);
            xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord(abstractSession);
        }
        try {
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            try {
                this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            this.xmlReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
        this.xmlUnmarshaller.resolveReferences(abstractSession);
        if (bl) {
            return unmarshalRecord.getCurrentObject();
        }
        return xMLDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLReader xMLReader) {
        UnmarshalRecord unmarshalRecord;
        boolean bl = XMLConversionManager.getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xMLDescriptor = null;
        AbstractSession abstractSession = null;
        if (bl) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            abstractSession = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord(abstractSession);
        }
        try {
            unmarshalRecord.setXMLReader(xMLReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            xMLReader.setContentHandler(unmarshalRecord);
            try {
                unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
        this.xmlUnmarshaller.resolveReferences(abstractSession);
        if (bl) {
            return unmarshalRecord.getCurrentObject();
        }
        return xMLDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    public Object unmarshal(Node node) {
        DOMReader dOMReader = new DOMReader();
        return this.unmarshal(dOMReader, node);
    }

    public Object unmarshal(DOMReader dOMReader, Node node) {
        try {
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            dOMReader.setContentHandler(sAXUnmarshallerHandler);
            sAXUnmarshallerHandler.setXMLReader(dOMReader);
            sAXUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            dOMReader.parse(node);
            sAXUnmarshallerHandler.resolveReferences();
            return sAXUnmarshallerHandler.getObject();
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(Node node, Class clazz) {
        DOMReader dOMReader = new DOMReader();
        return this.unmarshal(dOMReader, node, clazz);
    }

    public Object unmarshal(DOMReader dOMReader, Node node, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean bl = XMLConversionManager.getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xMLDescriptor = null;
        AbstractSession abstractSession = null;
        if (bl) {
            unmarshalRecord = new XMLRootRecord(clazz);
            unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
        } else {
            abstractSession = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord(abstractSession);
        }
        try {
            unmarshalRecord.setXMLReader(dOMReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            dOMReader.setContentHandler(unmarshalRecord);
            dOMReader.setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            dOMReader.parse(node);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
        this.xmlUnmarshaller.resolveReferences(abstractSession);
        if (bl) {
            return unmarshalRecord.getCurrentObject();
        }
        return xMLDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    public Object unmarshal(Reader reader) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element element = this.xmlParser.parse(reader).getDocumentElement();
            return this.unmarshal(element);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource);
    }

    public Object unmarshal(Reader reader, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element element = this.xmlParser.parse(reader).getDocumentElement();
            return this.unmarshal(element, clazz);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, clazz);
    }

    public Object unmarshal(Source source) {
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            XMLReader xMLReader = null;
            if (sAXSource.getXMLReader() != null) {
                xMLReader = new XMLReader(sAXSource.getXMLReader());
            }
            if (null == xMLReader) {
                return this.unmarshal(sAXSource.getInputSource());
            }
            return this.unmarshal(sAXSource.getInputSource(), xMLReader);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            return this.unmarshal(dOMSource.getNode());
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader());
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream());
            }
            return this.unmarshal(streamSource.getSystemId());
        }
        XMLUnmarshallerHandler xMLUnmarshallerHandler = this.xmlUnmarshaller.getUnmarshallerHandler();
        XMLTransformer xMLTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        SAXResult sAXResult = new SAXResult(xMLUnmarshallerHandler);
        xMLTransformer.transform(source, (Result)sAXResult);
        return xMLUnmarshallerHandler.getResult();
    }

    public Object unmarshal(Source source, Class clazz) {
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            XMLReader xMLReader = null;
            if (sAXSource.getXMLReader() == null) {
                xMLReader = new XMLReader(sAXSource.getXMLReader());
            }
            if (null == sAXSource.getXMLReader()) {
                return this.unmarshal(sAXSource.getInputSource(), clazz);
            }
            return this.unmarshal(sAXSource.getInputSource(), clazz, xMLReader);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            return this.unmarshal(dOMSource.getNode(), clazz);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader(), clazz);
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream(), clazz);
            }
            return this.unmarshal(streamSource.getSystemId(), clazz);
        }
        DOMResult dOMResult = new DOMResult();
        XMLTransformer xMLTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        xMLTransformer.transform(source, (Result)dOMResult);
        return this.unmarshal(dOMResult.getNode(), clazz);
    }

    public Object unmarshal(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        boolean bl = false;
        try {
            Object object = this.unmarshal(inputStream);
            return object;
        }
        catch (RuntimeException runtimeException) {
            bl = true;
            throw runtimeException;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (bl) break block11;
                    throw XMLMarshalException.unmarshalException(iOException);
                }
            }
        }
    }

    public Object unmarshal(URL uRL, Class clazz) {
        try {
            InputStream inputStream = uRL.openStream();
            Object object = this.unmarshal(inputStream, clazz);
            inputStream.close();
            return object;
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
    }

    public Object unmarshal(String string) {
        try {
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            sAXUnmarshallerHandler.setXMLReader(this.xmlReader);
            sAXUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(sAXUnmarshallerHandler);
            this.xmlReader.parse(string);
            sAXUnmarshallerHandler.resolveReferences();
            return sAXUnmarshallerHandler.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(String string, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean bl = XMLConversionManager.getDefaultJavaTypes().get(clazz) != null;
        XMLDescriptor xMLDescriptor = null;
        AbstractSession abstractSession = null;
        if (bl) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            abstractSession = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord(abstractSession);
        }
        try {
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            try {
                unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            this.xmlReader.parse(string);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
        this.xmlUnmarshaller.resolveReferences(abstractSession);
        if (bl) {
            return unmarshalRecord.getCurrentObject();
        }
        return xMLDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    private EclipseLinkException convertSAXException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception != null) {
            if (EclipseLinkException.class.isAssignableFrom(exception.getClass())) {
                return (EclipseLinkException)exception;
            }
            return XMLMarshalException.unmarshalException(exception);
        }
        return XMLMarshalException.unmarshalException(sAXException);
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    public void setResultAlwaysXMLRoot(boolean bl) {
        this.isResultAlwaysXMLRoot = bl;
    }
}

