/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.converters.Converter;

public class DirectMapContainerPolicy
extends InterfaceContainerPolicy {
    protected DatabaseField keyField;
    protected DatabaseField valueField;
    protected Converter keyConverter;
    protected Converter valueConverter;

    public DirectMapContainerPolicy() {
    }

    public DirectMapContainerPolicy(Class clazz) {
        super(clazz);
    }

    public boolean addInto(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        try {
            ((Map)object3).put(object, object2);
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object, object3, classCastException);
        }
        return true;
    }

    public boolean addInto(Object object, Object object2, AbstractSession abstractSession) {
        throw ValidationException.operationNotSupported("addInto(Object element, Object container, Session session)");
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession abstractSession) {
        Map map = (Map)this.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AbstractRecord abstractRecord = (AbstractRecord)enumeration.nextElement();
            Object object = abstractRecord.get(this.keyField);
            Object object2 = abstractRecord.get(this.valueField);
            if (this.getKeyConverter() != null) {
                object = this.getKeyConverter().convertDataValueToObjectValue(object, abstractSession);
            }
            if (this.getValueConverter() != null) {
                object2 = this.getValueConverter().convertDataValueToObjectValue(object2, abstractSession);
            }
            if (object == null) continue;
            map.put(object, object2);
        }
        return map;
    }

    public void clear(Object object) {
        try {
            ((Map)object).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object, "clear()");
        }
    }

    public boolean compareContainers(Object object, Object object2) {
        if (this.sizeFor(object) != this.sizeFor(object2)) {
            return false;
        }
        Object object3 = this.iteratorFor(object);
        while (this.hasNext(object3)) {
            Object object4 = this.next(object3);
            if (((Map)object).get(object4).equals(((Map)object2).get(object4))) continue;
            return false;
        }
        return true;
    }

    public boolean compareKeys(Object object, AbstractSession abstractSession) {
        if (((UnitOfWorkImpl)abstractSession).isClassReadOnly(object.getClass())) {
            return true;
        }
        Object object2 = ((UnitOfWorkImpl)abstractSession).getBackupClone(object, this.getElementDescriptor());
        return this.keyFrom(object2, abstractSession).equals(this.keyFrom(object, abstractSession));
    }

    protected boolean contains(Object object, Object object2) {
        return ((Map)object2).containsValue(object);
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public boolean isDirectMapPolicy() {
        return true;
    }

    public Object iteratorFor(Object object) {
        if (((Map)object).keySet() == null) {
            return null;
        }
        return ((Map)object).keySet().iterator();
    }

    public Object iteratorForValue(Object object) {
        if (((Map)object).values() == null) {
            return null;
        }
        return ((Map)object).values().iterator();
    }

    public boolean removeFrom(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        try {
            Object var5_5 = null;
            var5_5 = object != null ? ((Map)object3).remove(object) : ((Map)object3).remove(this.keyFrom(object2, abstractSession));
            return var5_5 != null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object3, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object object, Object object2, AbstractSession abstractSession) {
        boolean bl = false;
        Vector vector = new Vector(1);
        try {
            for (Object k : ((Map)object2).keySet()) {
                if (((Map)object2).get(k) != object) continue;
                vector.addElement(k);
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < vector.size(); ++i) {
                    ((Map)object2).remove(vector.elementAt(i));
                }
            }
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object2, "remove(Object element)");
        }
    }

    public void setKeyField(DatabaseField databaseField) {
        this.keyField = databaseField;
    }

    public void setValueField(DatabaseField databaseField) {
        this.valueField = databaseField;
    }

    public int sizeFor(Object object) {
        return ((Map)object).size();
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, AbstractSession abstractSession, Object object3) {
        Object object4;
        if (abstractSession.isUnitOfWork() && !this.keyFrom(object4 = ((UnitOfWorkImpl)abstractSession).getBackupClone(object, this.getElementDescriptor()), abstractSession).equals(this.keyFrom(object, abstractSession))) {
            this.removeFrom(object4, object2, abstractSession);
            this.addInto(object3, object2, abstractSession);
        }
    }

    public boolean isValidContainer(Object object) {
        return object instanceof Map;
    }

    public Object valueFromKey(Object object, Object object2) {
        return ((Map)object2).get(object);
    }

    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(Converter converter) {
        this.keyConverter = converter;
    }

    public void setValueConverter(Converter converter) {
        this.valueConverter = converter;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }
}

