/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Comparator;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class SortedCollectionContainerPolicy
extends CollectionContainerPolicy {
    protected Comparator m_comparator = null;
    protected Class comparatorClass = null;
    protected String comparatorClassName = null;

    public SortedCollectionContainerPolicy() {
    }

    public SortedCollectionContainerPolicy(Class clazz) {
        super(clazz);
    }

    public SortedCollectionContainerPolicy(String string) {
        super(string);
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public void setComparatorClass(Class clazz) {
        if (!Helper.classImplementsInterface(clazz, Comparator.class)) {
            throw ValidationException.invalidComparatorClass(clazz.getName());
        }
        this.m_comparator = (Comparator)Helper.getInstanceFromClass(clazz);
        this.comparatorClass = clazz;
    }

    public void setComparatorClassName(String string) {
        this.comparatorClassName = string;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public Class getComparatorClass() {
        return this.comparatorClass;
    }

    public String getComparatorClassName() {
        if (this.m_comparator != null) {
            return this.m_comparator.getClass().getName();
        }
        if (this.comparatorClass != null) {
            return this.comparatorClass.getName();
        }
        if (this.comparatorClassName != null) {
            return this.comparatorClassName;
        }
        return null;
    }

    public Object containerInstance() {
        try {
            if (this.m_comparator == null && this.comparatorClass != null) {
                if (Helper.classImplementsInterface(this.comparatorClass, Comparator.class)) {
                    this.m_comparator = (Comparator)Helper.getInstanceFromClass(this.comparatorClass);
                } else {
                    throw ValidationException.invalidComparatorClass(this.comparatorClass.getName());
                }
            }
            if (this.m_comparator != null) {
                Object[] objectArray = new Object[]{this.m_comparator};
                Class[] classArray = new Class[]{Comparator.class};
                Constructor constructor = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), classArray, false));
                        return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, objectArray));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), privilegedActionException.getException());
                    }
                }
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), classArray, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, objectArray);
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.m_comparator != null) return;
        if (this.comparatorClass == null) {
            if (this.comparatorClassName == null) return;
            Class clazz = Helper.getClassFromClasseName(this.comparatorClassName, classLoader);
            if (!Helper.classImplementsInterface(clazz, Comparator.class)) throw ValidationException.invalidComparatorClass(this.comparatorClassName);
            this.m_comparator = (Comparator)Helper.getInstanceFromClass(clazz);
            return;
        } else {
            if (!Helper.classImplementsInterface(this.comparatorClass, Comparator.class)) throw ValidationException.invalidComparatorClass(this.comparatorClass.getName());
            this.m_comparator = (Comparator)Helper.getInstanceFromClass(this.comparatorClass);
        }
    }
}

