/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;

public class JavaFieldImpl
implements JavaField {
    protected Field jField;

    public JavaFieldImpl(Field field) {
        this.jField = field;
    }

    public JavaAnnotation getAnnotation(JavaClass javaClass) {
        Class clazz;
        if (javaClass != null && this.jField.isAnnotationPresent(clazz = ((JavaClassImpl)javaClass).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jField.getAnnotation(clazz));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotationArray;
        ArrayList<JavaAnnotationImpl> arrayList = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotationArray = this.jField.getAnnotations()) {
            arrayList.add(new JavaAnnotationImpl(annotation));
        }
        return arrayList;
    }

    public int getModifiers() {
        return this.jField.getModifiers();
    }

    public String getName() {
        return this.jField.getName();
    }

    public JavaClass getOwningClass() {
        return new JavaClassImpl(this.jField.getDeclaringClass());
    }

    public JavaClass getResolvedType() {
        Class<?> clazz = this.jField.getType();
        Type type = this.jField.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new JavaClassImpl(parameterizedType, (Class)parameterizedType.getRawType());
        }
        return new JavaClassImpl(clazz);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jField.isSynthetic();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isEnumConstant() {
        return this.jField.isEnumConstant();
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass javaClass) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

