/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;

public class JavaMethodImpl
implements JavaMethod {
    protected Method jMethod;

    public JavaMethodImpl(Method method) {
        this.jMethod = method;
    }

    public Collection getActualTypeArguments() {
        Type[] typeArray;
        ArrayList<JavaClassImpl> arrayList = new ArrayList<JavaClassImpl>();
        for (Type type : typeArray = this.jMethod.getGenericParameterTypes()) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                arrayList.add(new JavaClassImpl(parameterizedType, parameterizedType.getClass()));
                continue;
            }
            if (!(type instanceof Class)) continue;
            arrayList.add(new JavaClassImpl((Class)type));
        }
        return arrayList;
    }

    public JavaAnnotation getAnnotation(JavaClass javaClass) {
        Class clazz;
        if (javaClass != null && this.jMethod.isAnnotationPresent(clazz = ((JavaClassImpl)javaClass).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jMethod.getAnnotation(clazz));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotationArray;
        ArrayList<JavaAnnotationImpl> arrayList = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotationArray = this.jMethod.getAnnotations()) {
            arrayList.add(new JavaAnnotationImpl(annotation));
        }
        return arrayList;
    }

    public String getName() {
        return this.jMethod.getName();
    }

    public JavaClass[] getParameterTypes() {
        Class<?>[] classArray = this.jMethod.getParameterTypes();
        JavaClass[] javaClassArray = new JavaClass[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            javaClassArray[i] = new JavaClassImpl(classArray[i]);
        }
        return javaClassArray;
    }

    public JavaClass getResolvedType() {
        return new JavaClassImpl(this.jMethod.getReturnType());
    }

    public JavaClass getReturnType() {
        Type type = this.jMethod.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new JavaClassImpl(parameterizedType, this.jMethod.getReturnType());
        }
        return new JavaClassImpl(this.jMethod.getReturnType());
    }

    public boolean hasActualTypeArguments() {
        Type[] typeArray;
        for (Type type : typeArray = this.jMethod.getGenericParameterTypes()) {
            if (!(type instanceof ParameterizedType)) continue;
            return true;
        }
        return false;
    }

    public int getModifiers() {
        return this.jMethod.getModifiers();
    }

    public JavaClass getOwningClass() {
        return new JavaClassImpl(this.jMethod.getDeclaringClass());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jMethod.isSynthetic();
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass javaClass) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

