/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentBuilder
implements ContentHandler {
    protected Document document;
    protected Stack nodes = new Stack();
    protected XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
    protected Map namespaceDeclarations;
    protected StrBuffer stringBuffer = new StrBuffer();

    public SAXDocumentBuilder() {
        this.namespaceDeclarations = new HashMap();
    }

    public Document getDocument() {
        return this.document;
    }

    public Document getInitializedDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = this.xmlPlatform.createDocument();
                this.nodes.push(this.document);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.document = this.xmlPlatform.createDocument();
            this.nodes.push(this.document);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endDocument() throws SAXException {
        this.nodes.pop();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string.equals("") && string2.equals("")) {
            return;
        }
        if (this.namespaceDeclarations == null) {
            this.namespaceDeclarations = new HashMap();
        }
        this.namespaceDeclarations.put(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (null != string && "".equals(string)) {
            string = null;
        }
        Element element = this.getInitializedDocument().createElementNS(string, string3);
        Node node = (Node)this.nodes.peek();
        if (this.stringBuffer.length() > 0 && this.nodes.size() != 1) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            node.appendChild(text);
            this.stringBuffer.reset();
        }
        this.appendChildNode(node, element);
        this.nodes.push(element);
        if (this.namespaceDeclarations != null) {
            for (String string4 : this.namespaceDeclarations.keySet()) {
                String string5 = (String)this.namespaceDeclarations.get(string4);
                this.addNamespaceDeclaration(element, string4, string5);
            }
            this.namespaceDeclarations = null;
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string4;
            string4 = attributes.getURI(i);
            if (null != string4 && "".equals(string4)) {
                string4 = null;
            }
            element.setAttributeNS(string4, attributes.getQName(i), attributes.getValue(i));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Element element = (Element)this.nodes.pop();
        if (this.stringBuffer.length() > 0) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            element.appendChild(text);
            this.stringBuffer.reset();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stringBuffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        ProcessingInstruction processingInstruction = this.getInitializedDocument().createProcessingInstruction(string, string2);
        Node node = (Node)this.nodes.peek();
        node.appendChild(processingInstruction);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    protected void addNamespaceDeclaration(Element element, String string, String string2) {
        if (string.equals("")) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
        } else {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
    }

    public void appendChildNode(Node node, Node node2) {
        node.appendChild(node2);
    }
}

