/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDODataFactoryDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;

public class SDOHelperContext
implements HelperContext {
    protected CopyHelper copyHelper;
    protected DataFactory dataFactory;
    protected DataHelper dataHelper;
    protected EqualityHelper equalityHelper;
    protected XMLHelper xmlHelper;
    protected TypeHelper typeHelper;
    protected XSDHelper xsdHelper;
    private static ConcurrentHashMap<Object, HelperContext> helperContexts = new ConcurrentHashMap();
    private static WeakHashMap<ClassLoader, HelperContext> userSetHelperContexts = new WeakHashMap();
    private static String OC4J_CLASSLOADER_NAME = "oracle";
    private static String WLS_CLASSLOADER_NAME = "weblogic";
    private static MBeanServer wlsMBeanServer = null;
    private static ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_RUNTIME_SERVICE = "RuntimeService";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_APP_RUNTIMES = "ApplicationRuntimes";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD = "ExecuteThread";
    private static final String WLS_MBEAN_SERVER = "MBeanServer";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME = "ApplicationName";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final String WLS_ACTIVE_VERSION_STATE = "ActiveVersionState";
    private static final Class[] PARAMETER_TYPES = new Class[0];

    public SDOHelperContext() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SDOHelperContext(ClassLoader classLoader) {
        this.initialize(classLoader);
    }

    protected void initialize(ClassLoader classLoader) {
        this.copyHelper = new SDOCopyHelper(this);
        this.dataFactory = new SDODataFactoryDelegate(this);
        this.dataHelper = new SDODataHelper(this);
        this.equalityHelper = new SDOEqualityHelper(this);
        this.xmlHelper = new SDOXMLHelperDelegate(this, classLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public void reset() {
        ((SDOTypeHelper)this.getTypeHelper()).reset();
        ((SDOXMLHelper)this.getXMLHelper()).reset();
        ((SDOXSDHelper)this.getXSDHelper()).reset();
    }

    public CopyHelper getCopyHelper() {
        return this.copyHelper;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public DataHelper getDataHelper() {
        return this.dataHelper;
    }

    public EqualityHelper getEqualityHelper() {
        return this.equalityHelper;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public XMLHelper getXMLHelper() {
        return this.xmlHelper;
    }

    public XSDHelper getXSDHelper() {
        return this.xsdHelper;
    }

    public ExternalizableDelegator.Resolvable createResolvable() {
        return new SDOResolvable(this);
    }

    public ExternalizableDelegator.Resolvable createResolvable(Object object) {
        return new SDOResolvable(object, this);
    }

    public static void putHelperContext(ClassLoader classLoader, HelperContext helperContext) {
        if (classLoader == null || helperContext == null) {
            return;
        }
        userSetHelperContexts.put(classLoader, helperContext);
    }

    public static void removeHelperContext(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        userSetHelperContexts.remove(classLoader);
    }

    public static HelperContext getHelperContext() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HelperContext helperContext = userSetHelperContexts.get(classLoader);
        if (helperContext != null) {
            return helperContext;
        }
        Object object = SDOHelperContext.getDelegateMapKey(classLoader);
        helperContext = helperContexts.get(object);
        if (helperContext == null) {
            helperContext = new SDOHelperContext();
            HelperContext helperContext2 = helperContexts.putIfAbsent(object, helperContext);
            if (helperContext2 != null) {
                helperContext = helperContext2;
            }
            if (object.getClass() == ClassConstants.STRING) {
                helperContexts.put(classLoader, helperContext);
            }
            SDOHelperContext.addNotificationListener(object);
        }
        return helperContext;
    }

    private static void resetHelperContext(Object object) {
        HelperContext helperContext = helperContexts.get(object);
        if (helperContext != null) {
            helperContexts.remove(object);
        }
    }

    private static Object getDelegateMapKey(ClassLoader classLoader) {
        Object object;
        String string = classLoader.getClass().getName();
        Object object2 = classLoader;
        if (string.startsWith(OC4J_CLASSLOADER_NAME)) {
            if (classLoader.getParent() != null && (classLoader.toString().indexOf(".web.") != -1 || classLoader.toString().indexOf(".wrappers") != -1)) {
                classLoader = classLoader.getParent();
            }
            object2 = classLoader;
        } else if (string.contains(WLS_CLASSLOADER_NAME) && (object = SDOHelperContext.getExecuteThread()) != null) {
            try {
                Method method = PrivilegedAccessHelper.getPublicMethod(object.getClass(), WLS_APPLICATION_NAME_GET_METHOD_NAME, PARAMETER_TYPES, false);
                object2 = PrivilegedAccessHelper.invokeMethod(method, object);
                if (object2 == null) {
                    object2 = classLoader;
                }
            }
            catch (Exception exception) {
                throw SDOException.errorInvokingWLSMethodReflectively(WLS_APPLICATION_NAME_GET_METHOD_NAME, WLS_EXECUTE_THREAD, exception);
            }
        }
        return object2;
    }

    private static MBeanServer getWLSMBeanServer() {
        if (wlsMBeanServer == null) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
                try {
                    wlsMBeanServer = (MBeanServer)initialContext.lookup(WLS_ENV_CONTEXT_LOOKUP);
                }
                catch (NamingException namingException) {
                    try {
                        wlsMBeanServer = (MBeanServer)initialContext.lookup(WLS_CONTEXT_LOOKUP);
                    }
                    catch (NamingException namingException2) {
                        throw SDOException.errorPerformingWLSLookup(WLS_MBEAN_SERVER, namingException2);
                    }
                }
            }
            catch (NamingException namingException) {
                throw SDOException.errorCreatingWLSInitialContext(namingException);
            }
        }
        return wlsMBeanServer;
    }

    private static Object getExecuteThread() {
        if (SDOHelperContext.getWLSMBeanServer() != null) {
            if (wlsThreadPoolRuntime == null) {
                ObjectName objectName = null;
                ObjectName objectName2 = null;
                try {
                    objectName = new ObjectName(WLS_SERVICE_KEY);
                }
                catch (Exception exception) {
                    throw SDOException.errorGettingWLSObjectName("RuntimeService [com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean]", exception);
                }
                try {
                    objectName2 = (ObjectName)wlsMBeanServer.getAttribute(objectName, WLS_SERVER_RUNTIME);
                }
                catch (Exception exception) {
                    throw SDOException.errorGettingWLSObjectName(WLS_SERVER_RUNTIME, exception);
                }
                try {
                    wlsThreadPoolRuntime = (ObjectName)wlsMBeanServer.getAttribute(objectName2, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception exception) {
                    throw SDOException.errorGettingWLSObjectName(WLS_THREADPOOL_RUNTIME, exception);
                }
            }
            try {
                return wlsMBeanServer.invoke(wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
            }
            catch (Exception exception) {
                throw SDOException.errorInvokingWLSMethodReflectively(WLS_EXECUTE_THREAD_GET_METHOD_NAME, WLS_THREADPOOL_RUNTIME, exception);
            }
        }
        return null;
    }

    private static void addNotificationListener(Object object) {
        if (Thread.currentThread().getContextClassLoader().getClass().getName().contains(WLS_CLASSLOADER_NAME) && SDOHelperContext.getWLSMBeanServer() != null) {
            try {
                ObjectName objectName = new ObjectName(WLS_SERVICE_KEY);
                ObjectName objectName2 = (ObjectName)wlsMBeanServer.getAttribute(objectName, WLS_SERVER_RUNTIME);
                ObjectName[] objectNameArray = (ObjectName[])wlsMBeanServer.getAttribute(objectName2, WLS_APP_RUNTIMES);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    try {
                        ObjectName objectName3 = objectNameArray[i];
                        Object object2 = wlsMBeanServer.getAttribute(objectName3, WLS_APPLICATION_NAME);
                        if (object2 == null || !object2.toString().equals(object)) continue;
                        wlsMBeanServer.addNotificationListener(objectName3, new MyNotificationListener(object2.toString()), null, null);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void makeDefaultContext() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object object = SDOHelperContext.getDelegateMapKey(classLoader);
        helperContexts.put(object, this);
    }

    private static class MyNotificationListener
    implements NotificationListener {
        Object mapKey;

        public MyNotificationListener(Object object) {
            this.mapKey = object;
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof AttributeChangeNotification) {
                try {
                    AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
                    if (attributeChangeNotification.getAttributeName().equals(SDOHelperContext.WLS_ACTIVE_VERSION_STATE) && attributeChangeNotification.getNewValue().equals(new Integer(0))) {
                        SDOHelperContext.resetHelperContext(this.mapKey);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

