/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.weaving.AbstractStaticWeaveOutputHandler;
import org.eclipse.persistence.internal.weaving.StaticWeaveDirectoryOutputHandler;
import org.eclipse.persistence.internal.weaving.StaticWeaveJAROutputHandler;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveClassTransformer;

public class StaticWeaveProcessor {
    private URL source;
    private URL target;
    private URL persistenceInfo;
    private Writer logWriter;
    private ClassLoader classLoader;
    private int logLevel = 8;
    private static final int NUMBER_OF_BYTES = 1024;

    public StaticWeaveProcessor(String string, String string2) throws MalformedURLException {
        if (string != null) {
            this.source = new File(string).toURL();
        }
        if (string2 != null) {
            this.target = new File(string2).toURL();
        }
    }

    public StaticWeaveProcessor(File file, File file2) throws MalformedURLException {
        this.source = file.toURL();
        this.target = file2.toURL();
    }

    public StaticWeaveProcessor(URL uRL, URL uRL2) {
        this.source = uRL;
        this.target = uRL2;
    }

    public void setLog(Writer writer) {
        this.logWriter = writer;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPersistenceInfo(URL uRL) {
        this.persistenceInfo = uRL;
    }

    public void setPersistenceInfo(String string) throws MalformedURLException {
        if (string != null) {
            this.persistenceInfo = new File(string).toURL();
        }
    }

    public void setPersistenceInfo(File file) throws MalformedURLException {
        if (file != null) {
            this.persistenceInfo = file.toURL();
        }
    }

    public void performWeaving() throws URISyntaxException, MalformedURLException, IOException {
        this.preProcess();
        this.process();
    }

    private void preProcess() throws URISyntaxException, MalformedURLException {
        AbstractSessionLog.getLog().setLevel(this.logLevel);
        if (this.logWriter != null) {
            ((DefaultSessionLog)AbstractSessionLog.getLog()).setWriter(this.logWriter);
        }
        if (!new File(Helper.toURI(this.source)).exists()) {
            throw StaticWeaveException.missingSource();
        }
        URI uRI = Helper.toURI(this.target);
        if (this.isDirectory(this.source) && uRI.toString().endsWith(".jar")) {
            AbstractSessionLog.getLog().log(6, ToStringLocalization.buildMessage("staticweave_processor_unknown_outcome", new Object[]{null}));
        }
        if (!this.isDirectory(this.source) && this.target.toString().equals(this.source.toString())) {
            throw StaticWeaveException.weaveInplaceForJar(this.source.toString());
        }
        if (!new File(uRI).exists() && !uRI.toString().endsWith(".jar")) {
            new File(uRI).mkdirs();
            this.target = new File(uRI).toURL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException, URISyntaxException {
        AbstractStaticWeaveOutputHandler abstractStaticWeaveOutputHandler = this.isDirectory(this.target) ? new StaticWeaveDirectoryOutputHandler(this.source, this.target) : new StaticWeaveJAROutputHandler(new JarOutputStream(new FileOutputStream(new File(Helper.toURI(this.target)))));
        this.classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        this.classLoader = new URLClassLoader(this.getURLs(), this.classLoader);
        StaticWeaveClassTransformer staticWeaveClassTransformer = null;
        staticWeaveClassTransformer = this.persistenceInfo != null ? new StaticWeaveClassTransformer(this.persistenceInfo, this.classLoader, this.logWriter, this.logLevel) : new StaticWeaveClassTransformer(this.source, this.classLoader, this.logWriter, this.logLevel);
        Archive archive = new ArchiveFactoryImpl().createArchive(this.source);
        Iterator<String> iterator = archive.getEntries();
        while (iterator.hasNext()) {
            String string = iterator.next();
            InputStream inputStream = archive.getEntry(string);
            abstractStaticWeaveOutputHandler.addDirEntry(StaticWeaveProcessor.getDirectoryFromEntryName(string));
            JarEntry jarEntry = new JarEntry(string);
            if (!string.endsWith(".class")) {
                abstractStaticWeaveOutputHandler.addEntry(inputStream, jarEntry);
                continue;
            }
            String string2 = PersistenceUnitProcessor.buildClassNameFromEntryString(string);
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                Class<?> clazz = this.classLoader.loadClass(string2);
                if (clazz == null) {
                    abstractStaticWeaveOutputHandler.addEntry(inputStream, jarEntry);
                    continue;
                }
                InputStream inputStream2 = this.classLoader.getResourceAsStream(string);
                if (inputStream2 != null) {
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray3 = new byte[1024];
                        int n = inputStream2.read(byArray3, 0, 1024);
                        while (n >= 0) {
                            byteArrayOutputStream.write(byArray3, 0, n);
                            n = inputStream2.read(byArray3, 0, 1024);
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                    finally {
                        byteArrayOutputStream.close();
                    }
                } else {
                    abstractStaticWeaveOutputHandler.addEntry(inputStream, jarEntry);
                    continue;
                }
                byArray2 = staticWeaveClassTransformer.transform(string2.replace('.', '/'), clazz, byArray);
                if (byArray2 != null) {
                    abstractStaticWeaveOutputHandler.addEntry(jarEntry, byArray2);
                    continue;
                }
                abstractStaticWeaveOutputHandler.addEntry(inputStream, jarEntry);
            }
            catch (IllegalClassFormatException illegalClassFormatException) {
                AbstractSessionLog.getLog().logThrowable(6, illegalClassFormatException);
                abstractStaticWeaveOutputHandler.addEntry(inputStream, jarEntry);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AbstractSessionLog.getLog().logThrowable(6, classNotFoundException);
                abstractStaticWeaveOutputHandler.addEntry(inputStream, jarEntry);
            }
            finally {
                inputStream.close();
            }
        }
        abstractStaticWeaveOutputHandler.closeOutputStream();
    }

    public static String getDirectoryFromEntryName(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        if (string.lastIndexOf("/") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("/")) + File.separator;
        }
        return string2;
    }

    private boolean isDirectory(URL uRL) throws URISyntaxException {
        File file = new File(Helper.toURI(uRL));
        return file.isDirectory();
    }

    private URL[] getURLs() {
        if (this.source != null && this.persistenceInfo != null) {
            return new URL[]{this.persistenceInfo, this.source};
        }
        if (this.source != null) {
            return new URL[]{this.source};
        }
        if (this.persistenceInfo != null) {
            return new URL[]{this.persistenceInfo};
        }
        return new URL[0];
    }
}

