/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWClassIndicatorFieldPolicy
extends MWAbstractClassIndicatorPolicy {
    private volatile boolean classNameIsIndicator;
    public static final String CLASS_NAME_IS_INDICATOR_PROPERTY = "classNameIsIndicator";
    private volatile transient MWTypeDeclaration indicatorType;
    public static final String INDICATOR_TYPE_PROPERTY = "indicatorType";
    private Collection classIndicatorValues;
    public static final String CLASS_INDICATOR_VALUES_COLLECTION = "classIndicatorValues";
    private volatile Class legacyIndicatorType;
    private volatile ConversionManager conversionManager;
    public static Class[] ALLOWED_INDICATOR_TYPES = new Class[]{String.class, Integer.class, Boolean.class, Long.class};
    public static Class DEFAULT_INDICATOR_TYPE = String.class;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClassIndicatorFieldPolicy.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractClassIndicatorPolicy.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(CLASS_NAME_IS_INDICATOR_PROPERTY, "class-name-is-indicator/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(INDICATOR_TYPE_PROPERTY);
        xMLCompositeObjectMapping.setReferenceClass(MWTypeDeclaration.class);
        xMLCompositeObjectMapping.setXPath("indicator-type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(CLASS_INDICATOR_VALUES_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getIndicatorValuesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setIndicatorValuesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWClassIndicatorValue.class);
        xMLCompositeCollectionMapping.setXPath("class-indicator-values/class-indicator-value");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    protected MWClassIndicatorFieldPolicy() {
    }

    protected MWClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent) {
        this(parent, NullIterator.instance());
    }

    protected MWClassIndicatorFieldPolicy(MWClassIndicatorPolicy.Parent parent, Iterator iterator) {
        super(parent);
        this.setDescriptorsAvailableForIndicatorDictionary(iterator);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.indicatorType = new MWTypeDeclaration((MWModel)this, this.typeFor(DEFAULT_INDICATOR_TYPE));
        this.classIndicatorValues = new Vector();
        this.classNameIsIndicator = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.classIndicatorValues;
        synchronized (collection) {
            list.addAll(this.classIndicatorValues);
        }
        if (this.indicatorType != null) {
            list.add(this.indicatorType);
        }
    }

    public String getType() {
        return "fieldClassIndicatorPolicy";
    }

    public abstract MWDataField getField();

    public MWClassIndicatorValue addIndicator(Object object, MWMappingDescriptor mWMappingDescriptor) {
        MWClassIndicatorValue mWClassIndicatorValue = new MWClassIndicatorValue(this, mWMappingDescriptor, object);
        this.classIndicatorValues.add(mWClassIndicatorValue);
        this.fireItemAdded(CLASS_INDICATOR_VALUES_COLLECTION, mWClassIndicatorValue);
        return mWClassIndicatorValue;
    }

    public void removeIndicator(MWClassIndicatorValue mWClassIndicatorValue) {
        this.removeItemFromCollection(mWClassIndicatorValue, this.classIndicatorValues, CLASS_INDICATOR_VALUES_COLLECTION);
    }

    public void removeIndicatorFor(MWDescriptor mWDescriptor) {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (mWClassIndicatorValue.getDescriptorValue() != mWDescriptor) continue;
            this.removeIndicator(mWClassIndicatorValue);
            return;
        }
    }

    public void setClassNameIsIndicator(boolean bl) {
        boolean bl2 = this.classNameIsIndicator;
        this.classNameIsIndicator = bl;
        if (bl2 != bl) {
            if (bl) {
                this.setIndicatorType(null);
            } else {
                this.setIndicatorType(new MWTypeDeclaration((MWModel)this, this.typeNamed(DEFAULT_INDICATOR_TYPE.getName())));
                this.setDescriptorsAvailableForIndicatorDictionary(((MWDescriptorInheritancePolicy)this.getParent()).getAllDescriptorsAvailableForIndicatorDictionary().iterator());
            }
        }
        this.firePropertyChanged(CLASS_NAME_IS_INDICATOR_PROPERTY, bl2, bl);
    }

    public void setIndicatorType(MWTypeDeclaration mWTypeDeclaration) {
        MWTypeDeclaration mWTypeDeclaration2 = this.getIndicatorType();
        this.indicatorType = mWTypeDeclaration;
        this.convertValues();
        this.firePropertyChanged(INDICATOR_TYPE_PROPERTY, mWTypeDeclaration2, mWTypeDeclaration);
    }

    public boolean classNameIsIndicator() {
        return this.classNameIsIndicator;
    }

    public Object buildIndicatorValueFromString(String string) {
        try {
            Class clazz = ClassTools.classForTypeDeclaration(this.getIndicatorType().typeName(), this.getIndicatorType().getDimensionality());
            return this.getConversionManager().convertObject((Object)string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ConversionException.couldNotBeConverted((Object)string, null);
        }
    }

    public void clearIndicatorValues() {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            this.removeIndicator(mWClassIndicatorValue);
        }
    }

    public void convertValues() {
        if (this.getIndicatorType() == null) {
            this.clearIndicatorValues();
        }
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            Object object = mWClassIndicatorValue.getIndicatorValue();
            if (object == null) continue;
            try {
                Object object2 = this.getConversionManager().convertObject(object, ClassTools.classForTypeDeclaration(this.getIndicatorType().typeName(), this.getIndicatorType().getDimensionality()));
                mWClassIndicatorValue.setIndicatorValue(object2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            catch (ConversionException conversionException) {
                mWClassIndicatorValue.setIndicatorValue(null);
            }
        }
    }

    public MWClassIndicatorValue getClassIndicatorValueForDescriptor(MWMappingDescriptor mWMappingDescriptor) {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (!mWClassIndicatorValue.getDescriptorValue().equals(mWMappingDescriptor)) continue;
            return mWClassIndicatorValue;
        }
        return null;
    }

    public Iterator classIndicatorValues() {
        return new CloneIterator(this.classIndicatorValues);
    }

    public int classIndicatorValuesSize() {
        return this.classIndicatorValues.size();
    }

    public ConversionManager getConversionManager() {
        if (this.conversionManager == null) {
            this.conversionManager = new ConversionManager();
        }
        return this.conversionManager;
    }

    public MWDescriptor getDescriptorForIndicator(Object object) {
        Iterator iterator = this.includedClassIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (mWClassIndicatorValue.getIndicatorValue() == null || !mWClassIndicatorValue.getIndicatorValue().equals(object)) continue;
            return mWClassIndicatorValue.getDescriptorValue();
        }
        return null;
    }

    public Object getIndicatorForDescriptor(MWMappingDescriptor mWMappingDescriptor) {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (!mWClassIndicatorValue.getDescriptorValue().equals(mWMappingDescriptor)) continue;
            return mWClassIndicatorValue.getIndicatorValue();
        }
        return null;
    }

    public MWTypeDeclaration getIndicatorType() {
        return this.indicatorType;
    }

    public Iterator includedClassIndicatorValues() {
        return this.getIndicatorValuesForTopLink().iterator();
    }

    public boolean isRepeatedIndicatorValue(Object object) {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            Object object2 = ((MWClassIndicatorValue)iterator.next()).getIndicatorValue();
            if (object2 == null || !object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public void rebuildClassIndicatorValues(Collection collection) {
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (collection.contains(mWClassIndicatorValue.getDescriptorValue())) continue;
            this.removeIndicator(mWClassIndicatorValue);
        }
        this.setDescriptorsAvailableForIndicatorDictionary(collection.iterator());
    }

    public void setDescriptorsAvailableForIndicatorDictionary(Iterator iterator) {
        if (this.classNameIsIndicator()) {
            this.setIndicatorType(null);
            return;
        }
        while (iterator.hasNext()) {
            MWMappingDescriptor mWMappingDescriptor = (MWMappingDescriptor)iterator.next();
            if (this.getClassIndicatorValueForDescriptor(mWMappingDescriptor) != null) continue;
            this.addIndicator(null, mWMappingDescriptor);
        }
    }

    public void setDescriptorsAvailableForIndicatorDictionaryForTopLink(Iterator iterator) {
        if (this.classNameIsIndicator()) {
            this.setIndicatorType(null);
            return;
        }
        while (iterator.hasNext()) {
            MWMappingDescriptor mWMappingDescriptor = (MWMappingDescriptor)iterator.next();
            if (this.getClassIndicatorValueForDescriptor(mWMappingDescriptor) != null) continue;
            MWClassIndicatorValue mWClassIndicatorValue = this.addIndicator(null, mWMappingDescriptor);
            mWClassIndicatorValue.setInclude(false);
        }
    }

    public void resetDescriptorAvailableForIndication(Iterator iterator) {
        Iterator iterator2 = this.classIndicatorValues();
        while (iterator2.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator2.next();
            this.removeIndicator(mWClassIndicatorValue);
        }
        this.setDescriptorsAvailableForIndicatorDictionary(iterator);
    }

    protected abstract boolean fieldSpecified();

    public void checkClassIndicatorField(List list) {
        if (!this.fieldSpecified()) {
            list.add(this.buildProblem("0054"));
        }
    }

    public void adjustRuntimeInheritancePolicy(InheritancePolicy inheritancePolicy) {
        Iterator iterator = this.includedClassIndicatorValues();
        while (iterator.hasNext()) {
            Object object = ((MWClassIndicatorValue)iterator.next()).getIndicatorValue();
            if (object == null) continue;
            inheritancePolicy.addClassNameIndicator(this.getDescriptorForIndicator(object).getMWClass().fullName(), object);
        }
        inheritancePolicy.setShouldUseClassNameAsIndicator(this.classNameIsIndicator());
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        this.convertValues();
    }

    private List getIndicatorValuesForTopLink() {
        ArrayList<MWClassIndicatorValue> arrayList = new ArrayList<MWClassIndicatorValue>();
        Iterator iterator = this.classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (!mWClassIndicatorValue.isInclude()) continue;
            arrayList.add(mWClassIndicatorValue);
        }
        return arrayList;
    }

    private void setIndicatorValuesForTopLink(List list) {
        this.classIndicatorValues = list;
    }
}

