/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCachingPolicy;

public final class MWProjectDefaultCacheExpiry
extends MWModel
implements MWCacheExpiry {
    private MWProjectDefaultCacheExpiry() {
    }

    MWProjectDefaultCacheExpiry(MWCachingPolicy mWCachingPolicy) {
        super(mWCachingPolicy);
    }

    private MWCacheExpiry getProjectCacheExpiry() {
        return this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheExpiry();
    }

    public Date getDailyExpiryTime() {
        return this.getProjectCacheExpiry().getDailyExpiryTime();
    }

    private boolean newExpiryTimeDifferent(Date date) {
        Date date2 = this.getDailyExpiryTime();
        return date.getHours() != date2.getHours() || date.getMinutes() != date2.getMinutes() || date.getSeconds() != date2.getSeconds();
    }

    public void setDailyExpiryTime(Date date) {
        if (this.newExpiryTimeDifferent(date)) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setDailyExpiryTime(date);
        }
    }

    public void setDailyExpiryTime(Calendar calendar) {
        if (this.valuesAreDifferent(calendar.getTime(), this.getDailyExpiryTime())) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setDailyExpiryTime(calendar);
        }
    }

    public String getExpiryType() {
        return this.getProjectCacheExpiry().getExpiryType();
    }

    public void setExpiryType(String string) {
        if (this.valuesAreDifferent(string, this.getExpiryType())) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setExpiryType(string);
        }
    }

    public boolean getUpdateReadTimeOnUpdate() {
        return this.getProjectCacheExpiry().getUpdateReadTimeOnUpdate();
    }

    public void setUpdateReadTimeOnUpdate(boolean bl) {
        if (bl != this.getUpdateReadTimeOnUpdate()) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setUpdateReadTimeOnUpdate(bl);
        }
    }

    public Long getTimeToLiveExpiry() {
        return this.getProjectCacheExpiry().getTimeToLiveExpiry();
    }

    public void setTimeToLiveExpiry(Long l) {
        if (l != this.getTimeToLiveExpiry()) {
            this.getCachingPolicy().setUseProjectDefaultCacheExpiry(false);
            this.getCachingPolicy().getCacheExpiry().setTimeToLiveExpiry(l);
        }
    }

    private MWDescriptorCachingPolicy getCachingPolicy() {
        return (MWDescriptorCachingPolicy)this.getParent();
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        if (this.getExpiryType() != "No Expiry") {
            if (this.getExpiryType() == "Daily Expiry") {
                Date date = this.getDailyExpiryTime();
                classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(date.getHours(), date.getMinutes(), date.getSeconds(), 0));
            } else if (this.getExpiryType() == "Time to Live Expiry") {
                classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(this.getTimeToLiveExpiry().longValue()));
            }
        }
    }

    public MWCacheExpiry getPersistedPolicy() {
        return null;
    }
}

