/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalReturningPolicyInsertFieldReturnOnlyFlag;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalReturningPolicy
extends MWReturningPolicy {
    private Collection updateFieldHandles;
    private MWHandle.NodeReferenceScrubber updateFieldScrubber;

    private MWRelationalReturningPolicy() {
    }

    MWRelationalReturningPolicy(MWRelationalClassDescriptor mWRelationalClassDescriptor) {
        super(mWRelationalClassDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.updateFieldHandles = new Vector();
    }

    public MWRelationalReturningPolicyInsertFieldReturnOnlyFlag addInsertFieldReadOnlyFlag(MWColumn mWColumn) {
        MWRelationalReturningPolicyInsertFieldReturnOnlyFlag mWRelationalReturningPolicyInsertFieldReturnOnlyFlag = new MWRelationalReturningPolicyInsertFieldReturnOnlyFlag(this, mWColumn);
        this.addInsertFieldReadOnlyFlag(mWRelationalReturningPolicyInsertFieldReturnOnlyFlag);
        return mWRelationalReturningPolicyInsertFieldReturnOnlyFlag;
    }

    private Iterator updateFieldHandles() {
        return new CloneIterator(this.updateFieldHandles){

            protected void remove(Object object) {
                MWRelationalReturningPolicy.this.removeUpdateFieldHandle((MWColumnHandle)object);
            }
        };
    }

    void removeUpdateFieldHandle(MWColumnHandle mWColumnHandle) {
        this.updateFieldHandles.remove(mWColumnHandle);
        this.fireItemRemoved("updateFields", mWColumnHandle.getColumn());
    }

    public Iterator updateFields() {
        return new TransformationIterator(this.updateFieldHandles()){

            protected Object transform(Object object) {
                return ((MWColumnHandle)object).getColumn();
            }
        };
    }

    public int updateFieldsSize() {
        return this.updateFieldHandles.size();
    }

    public void addUpdateField(MWColumn mWColumn) {
        if (CollectionTools.contains(this.updateFields(), (Object)mWColumn)) {
            throw new IllegalArgumentException(mWColumn.toString());
        }
        this.updateFieldHandles.add(new MWColumnHandle(this, mWColumn, this.updateFieldScrubber()));
        this.fireItemAdded("updateFields", mWColumn);
    }

    public void removeUpdateField(MWDataField mWDataField) {
        this.removeUpdateField((MWColumn)mWDataField);
    }

    public void removeUpdateField(MWColumn mWColumn) {
        Iterator iterator = this.updateFields();
        while (iterator.hasNext()) {
            if (iterator.next() != mWColumn) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWColumn.toString());
    }

    private MWRelationalClassDescriptor relationalDescriptor() {
        return (MWRelationalClassDescriptor)this.getParent();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkPlatformForNativeReturningSupport(list);
        this.checkUpdateFields(list);
        this.checkSequenceColumn(list);
        this.checkOneToOneForeignKey(list);
    }

    private void checkPlatformForNativeReturningSupport(List list) {
        if (!this.getProject().getDatabase().getDatabasePlatform().supportsNativeReturning()) {
            list.add(this.buildProblem("0347"));
        }
    }

    private void checkUpdateFields(List list) {
        Iterator iterator = this.updateFields();
        while (iterator.hasNext()) {
            MWDataField mWDataField = (MWDataField)iterator.next();
            if (CollectionTools.contains(this.relationalDescriptor().allAssociatedColumns(), (Object)mWDataField)) continue;
            list.add(this.buildProblem("0331", mWDataField.fieldName()));
        }
    }

    private void checkSequenceColumn(List list) {
        MWColumn mWColumn = ((MWTableDescriptor)this.getOwningDescriptor()).getSequenceNumberColumn();
        if (CollectionTools.contains(this.updateFields(), (Object)mWColumn)) {
            list.add(this.buildProblem("0333", mWColumn.qualifiedName()));
        }
        if (CollectionTools.contains(this.insertFields(), (Object)mWColumn)) {
            list.add(this.buildProblem("0332", mWColumn.qualifiedName()));
        }
    }

    private void checkOneToOneForeignKey(List list) {
        Iterator iterator = this.getProject().allMappings();
        while (iterator.hasNext()) {
            MWOneToOneMapping mWOneToOneMapping;
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (!mWMapping.isOneToOneMapping() || (mWOneToOneMapping = (MWOneToOneMapping)mWMapping).getReference() == null || !mWOneToOneMapping.getReference().isForeignKeyReference()) continue;
            Iterator iterator2 = mWOneToOneMapping.getReference().columnPairs();
            while (iterator2.hasNext()) {
                MWColumn mWColumn = ((MWColumnPair)iterator2.next()).getSourceColumn();
                if (CollectionTools.contains(this.updateFields(), (Object)mWColumn)) {
                    list.add(this.buildProblem("0339", mWColumn.qualifiedName(), mWOneToOneMapping.getName()));
                }
                if (!CollectionTools.contains(this.insertFields(), (Object)mWColumn)) continue;
                list.add(this.buildProblem("0338", mWColumn.qualifiedName(), mWOneToOneMapping.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.updateFieldHandles;
        synchronized (collection) {
            list.addAll(this.updateFieldHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber updateFieldScrubber() {
        if (this.updateFieldScrubber == null) {
            this.updateFieldScrubber = this.buildUpdateFieldScrubber();
        }
        return this.updateFieldScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildUpdateFieldScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalReturningPolicy.this.removeUpdateFieldHandle((MWColumnHandle)mWHandle);
            }

            public String toString() {
                return "MWRelationalReturningPolicy.buildUpdateFieldScrubber()";
            }
        };
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalReturningPolicy.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("insertFieldReturnOnlyFlags");
        xMLCompositeCollectionMapping.setReferenceClass(MWRelationalReturningPolicyInsertFieldReturnOnlyFlag.class);
        xMLCompositeCollectionMapping.setGetMethodName("getInsertFieldReturnOnlyFlagsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setInsertFieldReturnOnlyFlagsForTopLink");
        xMLCompositeCollectionMapping.setXPath("insert-field-read-only-flags/insert-field-read-only-flag");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("updateFieldHandles");
        xMLCompositeCollectionMapping2.setGetMethodName("getUpdateFieldHandlesForTopLink");
        xMLCompositeCollectionMapping2.setSetMethodName("setUpdateFieldHandlesForTopLink");
        xMLCompositeCollectionMapping2.setReferenceClass(MWColumnHandle.class);
        xMLCompositeCollectionMapping2.setXPath("update-field-handles/column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUpdateFieldHandlesForTopLink() {
        Collection collection = this.updateFieldHandles;
        synchronized (collection) {
            return new TreeSet(this.updateFieldHandles);
        }
    }

    private void setUpdateFieldHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWColumnHandle)iterator.next()).setScrubber(this.updateFieldScrubber());
        }
        this.updateFieldHandles = collection;
    }
}

