/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnPairHandle
extends MWHandle {
    private volatile MWColumnPair columnPair;
    private volatile String tableName;
    private volatile String referenceName;
    private volatile String columnPairName;

    private MWColumnPairHandle() {
    }

    public MWColumnPairHandle(MWModel mWModel, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
    }

    public MWColumnPairHandle(MWModel mWModel, MWColumnPair mWColumnPair, MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        super(mWModel, nodeReferenceScrubber);
        this.columnPair = mWColumnPair;
    }

    public MWColumnPair getColumnPair() {
        return this.columnPair;
    }

    public void setColumnPair(MWColumnPair mWColumnPair) {
        this.columnPair = mWColumnPair;
    }

    protected Node node() {
        return this.getColumnPair();
    }

    public int compareTo(Object object) {
        return this.columnPair.compareTo(((MWColumnPairHandle)object).columnPair);
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.columnPair == null) {
            stringBuffer.append("null");
        } else {
            this.columnPair.toString(stringBuffer);
        }
    }

    public MWColumnPairHandle setScrubber(MWHandle.NodeReferenceScrubber nodeReferenceScrubber) {
        this.setScrubberInternal(nodeReferenceScrubber);
        return this;
    }

    public void postProjectBuild() {
        MWReference mWReference;
        MWTable mWTable;
        super.postProjectBuild();
        if (this.tableName != null && this.referenceName != null && this.columnPairName != null && (mWTable = this.getDatabase().tableNamed(this.tableName)) != null && (mWReference = mWTable.referenceNamed(this.referenceName)) != null) {
            this.columnPair = mWReference.columnPairNamed(this.columnPairName);
        }
        this.tableName = null;
        this.referenceName = null;
        this.columnPairName = null;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWColumnPairHandle.class);
        xMLDescriptor.addDirectMapping("tableName", "getTableNameForTopLink", "setTableNameForTopLink", "table-name/text()");
        xMLDescriptor.addDirectMapping("referenceName", "getReferenceNameForTopLink", "setReferenceNameForTopLink", "reference-name/text()");
        xMLDescriptor.addDirectMapping("columnPairName", "getColumnPairNameForTopLink", "setColumnPairNameForTopLink", "column-pair-name/text()");
        return xMLDescriptor;
    }

    private String getTableNameForTopLink() {
        return this.columnPair == null ? null : this.columnPair.sourceTable().getName();
    }

    private void setTableNameForTopLink(String string) {
        this.tableName = string;
    }

    private String getReferenceNameForTopLink() {
        return this.columnPair == null ? null : this.columnPair.getReference().getName();
    }

    private void setReferenceNameForTopLink(String string) {
        this.referenceName = string;
    }

    private String getColumnPairNameForTopLink() {
        return this.columnPair == null ? null : this.columnPair.getName();
    }

    private void setColumnPairNameForTopLink(String string) {
        this.columnPairName = string;
    }
}

