/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullValuePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDefaultNullValuePolicy
extends MWModel
implements MWNullValuePolicy {
    private volatile String nullValue;
    private volatile MWTypeDeclaration nullValueType;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDefaultNullValuePolicy.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("nullValueType");
        xMLCompositeObjectMapping.setReferenceClass(MWTypeDeclaration.class);
        xMLCompositeObjectMapping.setXPath("null-value-type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("nullValue", "null-value/text()");
        xMLDirectMapping.setNullValue((Object)"");
        return xMLDescriptor;
    }

    private MWDefaultNullValuePolicy() {
    }

    public MWDefaultNullValuePolicy(MWModel mWModel) {
        super(mWModel);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.nullValueType = new MWTypeDeclaration((MWModel)this, this.typeFor(String.class));
        this.nullValue = "";
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.nullValueType);
    }

    public boolean usesNullValue() {
        return true;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String string) {
        String string2 = this.nullValue;
        this.nullValue = string;
        this.firePropertyChanged("nullValue", string2, string);
    }

    public MWTypeDeclaration getNullValueType() {
        return this.nullValueType;
    }

    public void setNullValueType(MWTypeDeclaration mWTypeDeclaration) {
        if (mWTypeDeclaration == null) {
            throw new NullPointerException();
        }
        MWTypeDeclaration mWTypeDeclaration2 = this.getNullValueType();
        this.nullValueType = mWTypeDeclaration;
        this.firePropertyChanged("nullValueType", mWTypeDeclaration2, mWTypeDeclaration);
    }

    public void adjustRuntimeMapping(AbstractDirectMapping abstractDirectMapping) {
        abstractDirectMapping.setNullValue(this.nullValue());
    }

    protected Object nullValue() {
        if (this.nullValue == null || this.getNullValueType() == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getNullValueType().typeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ConversionManager conversionManager = ConversionManager.getDefaultManager();
        try {
            return conversionManager.convertObject((Object)this.nullValue, clazz);
        }
        catch (ConversionException conversionException) {
            return null;
        }
    }

    public MWNullValuePolicy getValueForTopLink() {
        return this;
    }
}

