/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWJoinFetchableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMappingHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWAbstractReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractTableReferenceMapping
extends MWAbstractReferenceMapping
implements MWTableReferenceMapping,
MWIndirectableMapping,
MWJoinFetchableMapping {
    private MWReferenceHandle referenceHandle;
    private volatile boolean maintainsBidirectionalRelationship;
    public static final String MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY = "maintainsBidirectionalRelationship";
    private MWMappingHandle relationshipPartnerMappingHandle;
    public static final String RELATIONSHIP_PARTNER_MAPPING_PROPERTY = "relationshipPartnerMapping";
    private volatile MWJoinFetchableMapping.JoinFetchOption joinFetchOption;
    private static TopLinkOptionSet joinFetchOptions;
    private volatile boolean batchReading;

    protected MWAbstractTableReferenceMapping() {
    }

    protected MWAbstractTableReferenceMapping(MWRelationalClassDescriptor mWRelationalClassDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWRelationalClassDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.referenceHandle = new MWReferenceHandle(this, this.buildReferenceScrubber());
        this.relationshipPartnerMappingHandle = new MWMappingHandle(this, this.buildRelationshipPartnerMappingScrubber());
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
    }

    public MWJoinFetchableMapping.JoinFetchOption getJoinFetchOption() {
        if (this.joinFetchOption == null) {
            this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
        }
        return this.joinFetchOption;
    }

    public void setJoinFetchOption(MWJoinFetchableMapping.JoinFetchOption joinFetchOption) {
        MWJoinFetchableMapping.JoinFetchOption joinFetchOption2 = this.joinFetchOption;
        this.joinFetchOption = joinFetchOption;
        this.firePropertyChanged("joinFetchOption", joinFetchOption2, this.joinFetchOption);
    }

    public void setJoinFetchOption(String string) {
        this.setJoinFetchOption((MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption(string));
    }

    public MWReference getReference() {
        return this.referenceHandle.getReference();
    }

    public void setReference(MWReference mWReference) {
        MWReference mWReference2 = this.getReference();
        this.referenceHandle.setReference(mWReference);
        this.firePropertyChanged("reference", mWReference2, mWReference);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public boolean maintainsBidirectionalRelationship() {
        return this.maintainsBidirectionalRelationship;
    }

    public void setMaintainsBidirectionalRelationship(boolean bl) {
        boolean bl2 = this.maintainsBidirectionalRelationship;
        this.maintainsBidirectionalRelationship = bl;
        this.firePropertyChanged(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, bl2, bl);
        if (!bl) {
            this.setRelationshipPartnerMapping(null);
        }
    }

    public MWMapping getRelationshipPartnerMapping() {
        return this.relationshipPartnerMappingHandle.getMapping();
    }

    public Collection getRelationshipPartnerMappingChoices() {
        if (this.getReferenceDescriptor() == null) {
            return Collections.EMPTY_SET;
        }
        Collection collection = CollectionTools.collection(this.getReferenceDescriptor().mappings());
        collection.remove(this);
        return collection;
    }

    public void setRelationshipPartnerMapping(MWMapping mWMapping) {
        MWMapping mWMapping2 = this.getRelationshipPartnerMapping();
        this.relationshipPartnerMappingHandle.setMapping(mWMapping);
        this.firePropertyChanged(RELATIONSHIP_PARTNER_MAPPING_PROPERTY, mWMapping2, mWMapping);
    }

    public void setReferenceDescriptor(MWDescriptor mWDescriptor) {
        if (this.getReferenceDescriptor() != mWDescriptor) {
            this.setRelationshipPartnerMapping(null);
        }
        super.setReferenceDescriptor(mWDescriptor);
    }

    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor mWDescriptor) {
        return ((MWRelationalDescriptor)((Object)mWDescriptor)).isTableDescriptor();
    }

    public boolean usesBatchReading() {
        return this.batchReading;
    }

    public void setUsesBatchReading(boolean bl) {
        boolean bl2 = this.batchReading;
        this.batchReading = bl;
        this.firePropertyChanged("usesBatchReading", bl2, bl);
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public void automap() {
        super.automap();
        this.automapTableReference();
        this.automapIndirection();
    }

    protected void automapTableReference() {
        if (this.getReference() != null) {
            return;
        }
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (mWRelationalDescriptor == null) {
            return;
        }
        Set set = this.buildCandidateReferences();
        if (set.isEmpty()) {
            return;
        }
        Set set2 = CollectionTools.set(this.getParentRelationalDescriptor().associatedTables());
        Set set3 = CollectionTools.set(mWRelationalDescriptor.associatedTables());
        for (MWReference mWReference : set) {
            MWTable mWTable = mWReference.getSourceTable();
            MWTable mWTable2 = mWReference.getTargetTable();
            if ((!set2.contains(mWTable) || !set3.contains(mWTable2)) && (!set2.contains(mWTable2) || !set3.contains(mWTable))) continue;
            this.setReference(mWReference);
            break;
        }
    }

    protected abstract Set buildCandidateReferences();

    protected Set buildCandidateTargetReferences() {
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (mWRelationalDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> hashSet = new HashSet<MWReference>();
        Set set = CollectionTools.set(this.getParentRelationalDescriptor().candidateTablesIncludingInherited());
        Iterator iterator = mWRelationalDescriptor.associatedTablesIncludingInherited();
        while (iterator.hasNext()) {
            MWTable mWTable = (MWTable)iterator.next();
            Iterator iterator2 = mWTable.references();
            while (iterator2.hasNext()) {
                MWReference mWReference = (MWReference)iterator2.next();
                if (!set.contains(mWReference.getTargetTable())) continue;
                hashSet.add(mWReference);
            }
        }
        return hashSet;
    }

    protected Set buildCandidateSourceReferences() {
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (mWRelationalDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> hashSet = new HashSet<MWReference>();
        Set set = CollectionTools.set(mWRelationalDescriptor.associatedTables());
        Iterator iterator = this.getParentRelationalDescriptor().candidateTables();
        while (iterator.hasNext()) {
            MWTable mWTable = (MWTable)iterator.next();
            Iterator iterator2 = mWTable.references();
            while (iterator2.hasNext()) {
                MWReference mWReference = (MWReference)iterator2.next();
                if (!set.contains(mWReference.getTargetTable())) continue;
                hashSet.add(mWReference);
            }
        }
        return hashSet;
    }

    protected void automapIndirection() {
        if (this.getInstanceVariable().isValueHolder()) {
            this.setUseValueHolderIndirection();
        }
    }

    public Iterator candidateReferences() {
        return this.buildCandidateReferences().iterator();
    }

    public boolean referenceIsCandidate(MWReference mWReference) {
        return this.buildCandidateReferences().contains(mWReference);
    }

    public boolean isTraversableForBatchReadAttribute() {
        return true;
    }

    public boolean isValidForBatchReadAttribute() {
        return true;
    }

    public boolean isTraversableForJoinedAttribute() {
        return true;
    }

    public boolean isValidForJoinedAttribute() {
        return true;
    }

    protected abstract boolean fieldIsWritten(MWColumnPair var1);

    public boolean isTableReferenceMapping() {
        return true;
    }

    public boolean isManyToManyMapping() {
        return false;
    }

    public boolean isOneToManyMapping() {
        return false;
    }

    public boolean isQueryable() {
        return true;
    }

    public boolean allowsChildren() {
        return true;
    }

    public boolean allowsOuterJoin() {
        return this.allowsChildren();
    }

    public boolean isLeaf(Filter filter) {
        return this.subQueryableElements(filter).size() == 0;
    }

    public List subQueryableElements(Filter filter) {
        List list = new ArrayList();
        if (this.getReferenceDescriptor() != null) {
            list = ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).getQueryables(filter);
            Collections.sort(list, DEFAULT_COMPARATOR);
        }
        return list;
    }

    public MWQueryable subQueryableElementAt(int n, Filter filter) {
        return (MWQueryable)this.subQueryableElements(filter).get(n);
    }

    public boolean isTraversableForQueryExpression() {
        return true;
    }

    public boolean isValidForQueryExpression() {
        return true;
    }

    public boolean isTraversableForReportQueryAttribute() {
        return true;
    }

    public void initializeFromMWAbstractTableReferenceMapping(MWAbstractTableReferenceMapping mWAbstractTableReferenceMapping) {
        super.initializeFromMWAbstractTableReferenceMapping(mWAbstractTableReferenceMapping);
        this.setReference(mWAbstractTableReferenceMapping.getReference());
        this.setMaintainsBidirectionalRelationship(mWAbstractTableReferenceMapping.maintainsBidirectionalRelationship());
        this.setRelationshipPartnerMapping(mWAbstractTableReferenceMapping.getRelationshipPartnerMapping());
        this.setUsesBatchReading(mWAbstractTableReferenceMapping.usesBatchReading());
    }

    public void initializeFromMWRelationalDirectContainerMapping(MWRelationalDirectContainerMapping mWRelationalDirectContainerMapping) {
        super.initializeFromMWRelationalDirectContainerMapping(mWRelationalDirectContainerMapping);
        this.setReference(mWRelationalDirectContainerMapping.getReference());
        this.setUsesBatchReading(mWRelationalDirectContainerMapping.usesBatchReading());
    }

    public boolean isValidRelationshipPartner() {
        return true;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.referenceHandle);
        list.add(this.relationshipPartnerMappingHandle);
    }

    private MWHandle.NodeReferenceScrubber buildRelationshipPartnerMappingScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWAbstractTableReferenceMapping.this.setRelationshipPartnerMapping(null);
            }

            public String toString() {
                return "MWAbstractTableReferenceMapping.buildRelationshipPartnerMappingScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWAbstractTableReferenceMapping.this.setReference(null);
            }

            public String toString() {
                return "MWAbstractTableReferenceMapping.buildReferenceScrubber()";
            }
        };
    }

    public void descriptorUnmapped(Collection collection) {
        super.descriptorUnmapped(collection);
        if (this.getRelationshipPartnerMapping() != null && collection.contains(this.getRelationshipPartnerMapping())) {
            this.setRelationshipPartnerMapping(null);
        }
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
        super.mappingReplaced(mWMapping, mWMapping2);
        if (mWMapping == this.getRelationshipPartnerMapping()) {
            this.setRelationshipPartnerMapping(mWMapping2);
        }
    }

    public boolean sourceReferenceFieldsAreFromSourceDescriptorTables() {
        return false;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkReference(list);
        this.addInvalidRelationshipPartnerProblemTo(list);
        this.addHasNonMutualRelationshipPartnerProblemTo(list);
    }

    protected String referenceDescriptorInvalidProblemString() {
        return "0467";
    }

    private void checkReference(List list) {
        if (this.getReference() == null) {
            list.add(this.buildProblem("0460"));
            return;
        }
        if (!this.referenceIsCandidate(this.getReference())) {
            list.add(this.buildProblem("0461"));
        }
    }

    private void addInvalidRelationshipPartnerProblemTo(List list) {
        if (!this.maintainsBidirectionalRelationship()) {
            return;
        }
        if (this.getRelationshipPartnerMapping() == null) {
            list.add(this.buildProblem("0464"));
        } else if (!this.getRelationshipPartnerMapping().isValidRelationshipPartner()) {
            list.add(this.buildProblem("0465"));
        }
    }

    private void addHasNonMutualRelationshipPartnerProblemTo(List list) {
        MWMapping mWMapping = this.getRelationshipPartnerMapping();
        if (this.maintainsBidirectionalRelationship() && mWMapping != null && (!mWMapping.maintainsBidirectionalRelationship() || mWMapping.getRelationshipPartnerMapping() != this)) {
            list.add(this.buildProblem("0466"));
        }
    }

    public DatabaseMapping runtimeMapping() {
        ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)super.runtimeMapping();
        if (this.getReference() == null) {
            return foreignReferenceMapping;
        }
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getMWClass() != null) {
            foreignReferenceMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        if (this.maintainsBidirectionalRelationship() && this.getRelationshipPartnerMapping() != null) {
            foreignReferenceMapping.setRelationshipPartnerAttributeName(this.getRelationshipPartnerMapping().getInstanceVariable().getName());
        }
        this.joinFetchOption.setMWOptionOnTopLinkObject(foreignReferenceMapping);
        foreignReferenceMapping.setUsesBatchReading(this.usesBatchReading());
        return foreignReferenceMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractTableReferenceMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, "maintains-bidirectional-relationship/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("relationshipPartnerMappingHandle");
        xMLCompositeObjectMapping.setGetMethodName("getRelationshipPartnerMappingHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setRelationshipPartnerMappingHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWMappingHandle.class);
        xMLCompositeObjectMapping.setXPath("relationship-partner-mapping-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("referenceHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWReferenceHandle.class);
        xMLCompositeObjectMapping2.setXPath("reference-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("joinFetchOption");
        xMLDirectMapping2.setXPath("join-fetch-option/text()");
        xMLDirectMapping2.setNullValue((Object)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE"));
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    private MWMappingHandle getRelationshipPartnerMappingHandleForTopLink() {
        return this.relationshipPartnerMappingHandle.getMapping() == null ? null : this.relationshipPartnerMappingHandle;
    }

    private void setRelationshipPartnerMappingHandleForTopLink(MWMappingHandle mWMappingHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildRelationshipPartnerMappingScrubber();
        this.relationshipPartnerMappingHandle = mWMappingHandle == null ? new MWMappingHandle(this, nodeReferenceScrubber) : mWMappingHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWReferenceHandle getReferenceHandleForTopLink() {
        return this.referenceHandle.getReference() == null ? null : this.referenceHandle;
    }

    private void setReferenceHandleForTopLink(MWReferenceHandle mWReferenceHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildReferenceScrubber();
        this.referenceHandle = mWReferenceHandle == null ? new MWReferenceHandle(this, nodeReferenceScrubber) : mWReferenceHandle.setScrubber(nodeReferenceScrubber);
    }

    protected void setJoinFetchingForToplink(String string) {
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption(string);
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractTableReferenceMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(MAINTAINS_BIDIRECTIONAL_RELATIONSHIP_PROPERTY, "maintains-bidirectional-relationship/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("relationshipPartnerMappingHandle");
        xMLCompositeObjectMapping.setGetMethodName("getRelationshipPartnerMappingHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setRelationshipPartnerMappingHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWMappingHandle.class);
        xMLCompositeObjectMapping.setXPath("relationship-partner-mapping-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("referenceHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWReferenceHandle.class);
        xMLCompositeObjectMapping2.setXPath("reference-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    protected void legacy60PostBuild(DescriptorEvent descriptorEvent) {
        super.legacy60PostBuild(descriptorEvent);
        if (this.joinFetchOption == null) {
            this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
        }
    }

    public TopLinkOptionSet joinFetchOptions() {
        if (joinFetchOptions == null) {
            joinFetchOptions = MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions();
        }
        return joinFetchOptions;
    }

    protected static class ColumnPairAggregateRuntimeFieldNameGenerator
    implements AggregateRuntimeFieldNameGenerator {
        MWAbstractTableReferenceMapping mapping;
        private MWColumnPair columnPair;
        private boolean source;

        ColumnPairAggregateRuntimeFieldNameGenerator(MWAbstractTableReferenceMapping mWAbstractTableReferenceMapping, MWColumnPair mWColumnPair, boolean bl) {
            this.mapping = mWAbstractTableReferenceMapping;
            this.columnPair = mWColumnPair;
            this.source = bl;
        }

        public boolean fieldIsWritten() {
            return this.mapping.fieldIsWritten(this.columnPair);
        }

        public String fieldNameForRuntime() {
            MWColumn mWColumn = this.source ? this.columnPair.getSourceColumn() : this.columnPair.getTargetColumn();
            return mWColumn.getName() + "_IN_REFERENCE_" + this.mapping.getReference().getName();
        }

        public AggregateFieldDescription fullFieldDescription() {
            final MWColumn mWColumn = this.source ? this.columnPair.getSourceColumn() : this.columnPair.getTargetColumn();
            return new AggregateFieldDescription(){

                public String getMessageKey() {
                    return "AGGREGATE_FIELD_DESCRIPTION_FOR_REFERENCE";
                }

                public Object[] getMessageArguments() {
                    return new Object[]{mWColumn.getName(), ColumnPairAggregateRuntimeFieldNameGenerator.this.mapping.getReference().getName()};
                }
            };
        }

        public MWDescriptor owningDescriptor() {
            throw new UnsupportedOperationException();
        }
    }
}

