/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWManyToManyMapping
extends MWCollectionMapping {
    private MWReferenceHandle targetReferenceHandle;
    public static final String TARGET_REFERENCE_PROPERTY = "targetReference";
    private MWTableHandle relationTableHandle;
    public static final String RELATION_TABLE_PROPERTY = "relationTable";

    private MWManyToManyMapping() {
    }

    MWManyToManyMapping(MWRelationalClassDescriptor mWRelationalClassDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWRelationalClassDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.targetReferenceHandle = new MWReferenceHandle(this, this.buildTargetReferenceScrubber());
        this.relationTableHandle = new MWTableHandle(this, this.buildRelationTableScrubber());
    }

    public MWTable getRelationTable() {
        return this.relationTableHandle.getTable();
    }

    public void setRelationTable(MWTable mWTable) {
        MWTable mWTable2 = this.relationTableHandle.getTable();
        this.relationTableHandle.setTable(mWTable);
        this.firePropertyChanged(RELATION_TABLE_PROPERTY, mWTable2, mWTable);
    }

    public void setSourceReference(MWReference mWReference) {
        this.setReference(mWReference);
    }

    public MWReference getSourceReference() {
        return this.getReference();
    }

    public MWReference getTargetReference() {
        return this.targetReferenceHandle.getReference();
    }

    public void setTargetReference(MWReference mWReference) {
        MWReference mWReference2 = this.getTargetReference();
        this.targetReferenceHandle.setReference(mWReference);
        this.firePropertyChanged(TARGET_REFERENCE_PROPERTY, mWReference2, mWReference);
    }

    public boolean isManyToManyMapping() {
        return true;
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWManyToManyMapping(this);
    }

    public MWManyToManyMapping asMWManyToManyMapping() {
        return this;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.targetReferenceHandle);
        list.add(this.relationTableHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTargetReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWManyToManyMapping.this.setTargetReference(null);
            }

            public String toString() {
                return "MWManyToManyMapping.buildTargetReferenceScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildRelationTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWManyToManyMapping.this.setRelationTable(null);
            }

            public String toString() {
                return "MWManyToManyMapping.buildRelationTableScrubber()";
            }
        };
    }

    public String iconKey() {
        return "mapping.manyToMany";
    }

    public void automap() {
        super.automap();
        this.automapRelationTable();
        this.automapSourceReference();
        this.automapTargetReference();
    }

    protected void automapTableReference() {
    }

    private void automapRelationTable() {
        if (this.getRelationTable() != null) {
            return;
        }
        Iterator iterator = this.candidateRelationTables();
        if (iterator.hasNext()) {
            this.setRelationTable((MWTable)iterator.next());
        }
    }

    private void automapSourceReference() {
        if (this.getSourceReference() != null) {
            return;
        }
        Iterator iterator = this.candidateRelationTableSourceReferences();
        if (iterator.hasNext()) {
            this.setSourceReference((MWReference)iterator.next());
        }
    }

    private void automapTargetReference() {
        if (this.getTargetReference() != null) {
            return;
        }
        Iterator iterator = this.candidateRelationTableTargetReferences();
        if (iterator.hasNext()) {
            this.setTargetReference((MWReference)iterator.next());
        }
    }

    protected Set buildCandidateReferences() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.buildCandidateRelationTableSourceReferences());
        hashSet.addAll(this.buildCandidateRelationTableTargetReferences());
        return hashSet;
    }

    public Iterator candidateRelationTables() {
        MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)this.getParentDescriptor();
        MWTableDescriptor mWTableDescriptor2 = (MWTableDescriptor)this.getReferenceDescriptor();
        if (mWTableDescriptor2 == null) {
            return this.getProject().getDatabase().tables();
        }
        Set set = CollectionTools.set(mWTableDescriptor.associatedTables());
        Set set2 = CollectionTools.set(mWTableDescriptor2.associatedTables());
        ArrayList<MWTable> arrayList = new ArrayList<MWTable>();
        Iterator iterator = this.unmappedTables();
        while (iterator.hasNext()) {
            MWTable mWTable = (MWTable)iterator.next();
            if (!this.tableIsPossibleRelationTable(mWTable, set, set2)) continue;
            arrayList.add(mWTable);
        }
        return arrayList.iterator();
    }

    private Set buildCandidateRelationTableSourceReferences() {
        MWTable mWTable = this.getRelationTable();
        if (mWTable == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> hashSet = new HashSet<MWReference>();
        Set set = CollectionTools.set(this.getParentRelationalDescriptor().candidateTablesIncludingInherited());
        Iterator iterator = mWTable.references();
        while (iterator.hasNext()) {
            MWReference mWReference = (MWReference)iterator.next();
            if (!set.contains(mWReference.getTargetTable())) continue;
            hashSet.add(mWReference);
        }
        return hashSet;
    }

    public Iterator candidateRelationTableSourceReferences() {
        return this.buildCandidateRelationTableSourceReferences().iterator();
    }

    private Set buildCandidateRelationTableTargetReferences() {
        MWTable mWTable = this.getRelationTable();
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (mWTable == null || mWRelationalDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> hashSet = new HashSet<MWReference>();
        Set set = CollectionTools.set(mWRelationalDescriptor.candidateTablesIncludingInherited());
        Iterator iterator = mWTable.references();
        while (iterator.hasNext()) {
            MWReference mWReference = (MWReference)iterator.next();
            if (!set.contains(mWReference.getTargetTable())) continue;
            hashSet.add(mWReference);
        }
        return hashSet;
    }

    public Iterator candidateRelationTableTargetReferences() {
        return this.buildCandidateRelationTableTargetReferences().iterator();
    }

    public boolean tableIsPossibleRelationTable(MWTable mWTable) {
        return CollectionTools.contains(this.candidateRelationTables(), (Object)mWTable);
    }

    private Iterator unmappedTables() {
        Set set = CollectionTools.set(this.getDatabase().tables());
        Iterator iterator = this.getProject().descriptors();
        while (iterator.hasNext()) {
            MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)iterator.next();
            CollectionTools.removeAll((Collection)set, mWRelationalDescriptor.associatedTables());
        }
        return set.iterator();
    }

    private boolean tableIsPossibleRelationTable(MWTable mWTable, Set set, Set set2) {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = mWTable.references();
        while (iterator.hasNext()) {
            MWReference mWReference = (MWReference)iterator.next();
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl && set.contains(mWReference.getTargetTable())) {
                bl3 = true;
            }
            if (!bl2 && set2.contains(mWReference.getTargetTable())) {
                bl4 = true;
            }
            if (!bl3 && !bl4) continue;
            boolean bl5 = true;
            Iterator iterator2 = mWReference.columnPairs();
            while (iterator2.hasNext()) {
                MWColumnPair mWColumnPair = (MWColumnPair)iterator2.next();
                MWColumn mWColumn = mWColumnPair.getTargetColumn();
                bl5 &= mWColumn.isUnique();
            }
            if (bl5) {
                if (bl3) {
                    bl = true;
                }
                if (bl4) {
                    bl2 = true;
                }
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.addRelationTableNotSpecifiedProblemTo(list);
        this.addRelationTableNotDedicatedProblemTo(list);
        this.addSourceReferenceNotSpecifiedProblemTo(list);
        this.addTargetReferenceNotSpecifiedProblemTo(list);
    }

    private void addRelationTableNotSpecifiedProblemTo(List list) {
        if (this.getRelationTable() == null) {
            list.add(this.buildProblem("0480"));
        }
    }

    private void addRelationTableNotDedicatedProblemTo(List list) {
        if (this.isReadOnly()) {
            return;
        }
        Iterator iterator = ((MWRelationalProject)this.getProject()).allWriteableManyToManyMappings();
        while (iterator.hasNext()) {
            MWManyToManyMapping mWManyToManyMapping = (MWManyToManyMapping)iterator.next();
            if (mWManyToManyMapping == this || mWManyToManyMapping.getRelationTable() != this.getRelationTable() || mWManyToManyMapping.getParentRelationalDescriptor().getPrimaryTable() == null || mWManyToManyMapping.getParentRelationalDescriptor().getPrimaryTable() == this.getParentRelationalDescriptor().getPrimaryTable()) continue;
            list.add(this.buildProblem("0481"));
        }
    }

    private void addSourceReferenceNotSpecifiedProblemTo(List list) {
        if (this.getSourceReference() == null) {
            list.add(this.buildProblem("0482"));
        }
    }

    private void addTargetReferenceNotSpecifiedProblemTo(List list) {
        if (this.getTargetReference() == null) {
            list.add(this.buildProblem("0483"));
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new ManyToManyMapping();
    }

    public DatabaseMapping runtimeMapping() {
        MWColumn mWColumn;
        MWColumn mWColumn2;
        MWColumnPair mWColumnPair;
        Iterator iterator;
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)super.runtimeMapping();
        MWTable mWTable = this.getRelationTable();
        if (mWTable != null) {
            manyToManyMapping.setRelationTableName(mWTable.getName());
        }
        if (this.getSourceReference() != null) {
            iterator = this.getSourceReference().columnPairs();
            while (iterator.hasNext()) {
                mWColumnPair = (MWColumnPair)iterator.next();
                mWColumn2 = mWColumnPair.getSourceColumn();
                mWColumn = mWColumnPair.getTargetColumn();
                if (mWColumn2 == null || mWColumn == null) continue;
                if (!this.parentDescriptorIsAggregate()) {
                    manyToManyMapping.addSourceRelationKeyFieldName(mWColumn2.qualifiedName(), mWColumn.qualifiedName());
                    continue;
                }
                manyToManyMapping.addSourceRelationKeyFieldName(mWColumn2.qualifiedName(), this.getName() + "->" + mWColumn.getName() + "_IN_REFERENCE_" + this.getSourceReference().getName());
            }
        }
        if (this.getTargetReference() != null) {
            iterator = this.getTargetReference().columnPairs();
            while (iterator.hasNext()) {
                mWColumnPair = (MWColumnPair)iterator.next();
                mWColumn2 = mWColumnPair.getSourceColumn();
                mWColumn = mWColumnPair.getTargetColumn();
                if (mWColumn2 == null || mWColumn == null) continue;
                manyToManyMapping.addTargetRelationKeyFieldName(mWColumn2.qualifiedName(), mWColumn.qualifiedName());
            }
        }
        return manyToManyMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWManyToManyMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWCollectionMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("relationTableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getRelationTableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setRelationTableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("relation-table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("targetReferenceHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getTargetReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setTargetReferenceHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWReferenceHandle.class);
        xMLCompositeObjectMapping2.setXPath("target-reference-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWTableHandle getRelationTableHandleForTopLink() {
        return this.relationTableHandle.getTable() == null ? null : this.relationTableHandle;
    }

    private void setRelationTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildRelationTableScrubber();
        this.relationTableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWReferenceHandle getTargetReferenceHandleForTopLink() {
        return this.targetReferenceHandle.getReference() == null ? null : this.targetReferenceHandle;
    }

    private void setTargetReferenceHandleForTopLink(MWReferenceHandle mWReferenceHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTargetReferenceScrubber();
        this.targetReferenceHandle = mWReferenceHandle == null ? new MWReferenceHandle(this, nodeReferenceScrubber) : mWReferenceHandle.setScrubber(nodeReferenceScrubber);
    }
}

