/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWJoinFetchableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;

public abstract class MWRelationalDirectContainerMapping
extends MWDirectContainerMapping
implements MWTableReferenceMapping,
MWIndirectableContainerMapping,
MWJoinFetchableMapping {
    private MWTableHandle targetTableHandle;
    public static final String TARGET_TABLE_PROPERTY = "targetTable";
    private MWColumnHandle directValueColumnHandle;
    public static final String DIRECT_VALUE_COLUMN_PROPERTY = "directValueColumn";
    private volatile MWJoinFetchableMapping.JoinFetchOption joinFetchOption;
    private static TopLinkOptionSet joinFetchOptions;
    private MWReferenceHandle referenceHandle;
    private volatile String indirectionType;
    private volatile boolean batchReading;
    private static final PartialStringMatcher COLUMN_NAME_MATCHER;

    protected MWRelationalDirectContainerMapping() {
    }

    public MWRelationalDirectContainerMapping(MWMappingDescriptor mWMappingDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWMappingDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.directValueColumnHandle = new MWColumnHandle(this, this.buildDirectValueColumnScrubber());
        this.referenceHandle = new MWReferenceHandle(this, this.buildReferenceScrubber());
        this.targetTableHandle = new MWTableHandle(this, this.buildTargetTableScrubber());
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (mWClassAttribute.isEjb20Attribute() || !mWClassAttribute.isValueHolder()) {
            this.setUseTransparentIndirection();
        } else {
            this.setUseValueHolderIndirection();
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.directValueColumnHandle);
        list.add(this.referenceHandle);
        list.add(this.targetTableHandle);
    }

    private MWHandle.NodeReferenceScrubber buildDirectValueColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalDirectContainerMapping.this.setDirectValueColumn(null);
            }

            public String toString() {
                return "MWRelationalDirectContainerMapping.buildDirectValueColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalDirectContainerMapping.this.setReference(null);
            }

            public String toString() {
                return "MWRelationalDirectContainerMapping.buildReferenceScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildTargetTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWRelationalDirectContainerMapping.this.setTargetTable(null);
            }

            public String toString() {
                return "MWRelationalDirectContainerMapping.buildTargetTableScrubber()";
            }
        };
    }

    public void initializeFromMWRelationalDirectContainerMapping(MWRelationalDirectContainerMapping mWRelationalDirectContainerMapping) {
        super.initializeFromMWRelationalDirectContainerMapping(mWRelationalDirectContainerMapping);
        this.setTargetTable(mWRelationalDirectContainerMapping.getTargetTable());
        this.setDirectValueColumn(mWRelationalDirectContainerMapping.getDirectValueColumn());
        this.setReference(mWRelationalDirectContainerMapping.getReference());
        this.setTargetTable(mWRelationalDirectContainerMapping.getTargetTable());
        this.setUsesBatchReading(mWRelationalDirectContainerMapping.usesBatchReading());
    }

    public void initializeFromMWAbstractTableReferenceMapping(MWAbstractTableReferenceMapping mWAbstractTableReferenceMapping) {
        super.initializeFromMWAbstractTableReferenceMapping(mWAbstractTableReferenceMapping);
        this.setReference(mWAbstractTableReferenceMapping.getReference());
        this.setUsesBatchReading(mWAbstractTableReferenceMapping.usesBatchReading());
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping mWIndirectableMapping) {
        super.initializeFromMWIndirectableMapping(mWIndirectableMapping);
        if (mWIndirectableMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (mWIndirectableMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping mWIndirectableContainerMapping) {
        super.initializeFromMWIndirectableContainerMapping(mWIndirectableContainerMapping);
        if (mWIndirectableContainerMapping.usesTransparentIndirection()) {
            this.setUseTransparentIndirection();
        }
    }

    protected MWTypeConversionConverter buildTypeConversionConverter() {
        return new MWRelationalTypeConversionConverter(this);
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public MWTable getTargetTable() {
        return this.targetTableHandle.getTable();
    }

    public void setTargetTable(MWTable mWTable) {
        MWTable mWTable2 = this.targetTableHandle.getTable();
        this.targetTableHandle.setTable(mWTable);
        this.firePropertyChanged(TARGET_TABLE_PROPERTY, mWTable2, mWTable);
        if (mWTable2 != mWTable) {
            this.setDirectFieldsNull();
        }
    }

    protected void setDirectFieldsNull() {
        this.setDirectValueColumn(null);
    }

    public MWColumn getDirectValueColumn() {
        return this.directValueColumnHandle.getColumn();
    }

    public void setDirectValueColumn(MWColumn mWColumn) {
        this.checkColumn(mWColumn);
        MWColumn mWColumn2 = this.directValueColumnHandle.getColumn();
        this.directValueColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(DIRECT_VALUE_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    protected void checkColumn(MWColumn mWColumn) {
        if (mWColumn == null) {
            return;
        }
        if (this.getTargetTable() == null) {
            throw new IllegalStateException("The target table must be set first");
        }
        if (this.getTargetTable().columnNamed(mWColumn.getName()) == null) {
            throw new IllegalArgumentException("The field must be in the target table");
        }
    }

    public MWJoinFetchableMapping.JoinFetchOption getJoinFetchOption() {
        if (this.joinFetchOption == null) {
            this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
        }
        return this.joinFetchOption;
    }

    public void setJoinFetchOption(MWJoinFetchableMapping.JoinFetchOption joinFetchOption) {
        MWJoinFetchableMapping.JoinFetchOption joinFetchOption2 = this.joinFetchOption;
        this.joinFetchOption = joinFetchOption;
        this.firePropertyChanged("joinFetchOption", joinFetchOption2, this.joinFetchOption);
    }

    public void setJoinFetchOption(String string) {
        this.setJoinFetchOption((MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption(string));
    }

    public MWReference getReference() {
        return this.referenceHandle.getReference();
    }

    public void setReference(MWReference mWReference) {
        MWReference mWReference2 = this.getReference();
        this.referenceHandle.setReference(mWReference);
        this.firePropertyChanged("reference", mWReference2, mWReference);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public boolean usesNoIndirection() {
        return this.indirectionType == "no-indirection";
    }

    public boolean usesValueHolderIndirection() {
        return this.indirectionType == "value-holder-indirection";
    }

    public boolean usesTransparentIndirection() {
        return this.indirectionType == "transparentIndirection";
    }

    public void setUseNoIndirection() {
        this.setIndirectionType("no-indirection");
    }

    public void setUseValueHolderIndirection() {
        this.setIndirectionType("value-holder-indirection");
    }

    public void setUseTransparentIndirection() {
        this.setIndirectionType("transparentIndirection");
    }

    private void setIndirectionType(String string) {
        String string2 = this.indirectionType;
        this.indirectionType = string;
        this.firePropertyChanged("indirection", string2, string);
    }

    public boolean usesBatchReading() {
        return this.batchReading;
    }

    public void setUsesBatchReading(boolean bl) {
        boolean bl2 = this.batchReading;
        this.batchReading = bl;
        this.firePropertyChanged("usesBatchReading", bl2, bl);
    }

    public boolean allowsChildren() {
        return false;
    }

    public boolean allowsOuterJoin() {
        return this.allowsChildren();
    }

    public boolean isLeaf(Filter filter) {
        return true;
    }

    public boolean usesAnyOf() {
        return true;
    }

    public boolean isValidForReadAllQueryOrderable() {
        return false;
    }

    public boolean isTraversableForBatchReadAttribute() {
        return true;
    }

    public boolean isValidForBatchReadAttribute() {
        return true;
    }

    public boolean isTraversableForJoinedAttribute() {
        return true;
    }

    public boolean isValidForJoinedAttribute() {
        return true;
    }

    public boolean isTraversableForQueryExpression() {
        return true;
    }

    public boolean isValidForQueryExpression() {
        return true;
    }

    public boolean referenceIsCandidate(MWReference mWReference) {
        return this.getTargetTable() != null && mWReference.getSourceTable() == this.getTargetTable() && CollectionTools.contains(this.getParentRelationalDescriptor().candidateTables(), (Object)mWReference.getTargetTable());
    }

    public Iterator candidateReferences() {
        return this.buildCandidateReferences().iterator();
    }

    public Collection buildCandidateReferences() {
        HashSet hashSet = new HashSet();
        boolean bl = !this.parentDescriptorIsAggregate();
        MWColumn mWColumn = this.getDirectValueColumn();
        if (mWColumn != null && bl) {
            MWTable mWTable = mWColumn.getTable();
            MWTable mWTable2 = ((MWTableDescriptor)this.getParentDescriptor()).getPrimaryTable();
            if (mWTable2 != null) {
                CollectionTools.addAll(hashSet, mWTable.referencesBetween(mWTable2));
            }
        } else {
            Iterator iterator = this.getDatabase().tables();
            while (iterator.hasNext()) {
                MWTable mWTable = (MWTable)iterator.next();
                if (bl) {
                    MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)this.getParentDescriptor();
                    Iterator iterator2 = mWTableDescriptor.candidateTables();
                    while (iterator2.hasNext()) {
                        MWTable mWTable3 = (MWTable)iterator2.next();
                        CollectionTools.addAll(hashSet, mWTable.referencesTo(mWTable3));
                    }
                    continue;
                }
                CollectionTools.addAll(hashSet, mWTable.references());
            }
        }
        return hashSet;
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new DirectCollectionMapping();
    }

    public void addWrittenFieldsTo(Collection collection) {
    }

    public void automap() {
        super.automap();
        this.automapIndirection();
        this.automapReference();
        this.automapDirectValueColumn();
    }

    public void automapIndirection() {
        if (this.getInstanceVariable().isValueHolder()) {
            this.setUseValueHolderIndirection();
        }
    }

    private void automapReference() {
        if (this.getReference() != null || this.parentDescriptorIsAggregate()) {
            return;
        }
        Collection collection = this.buildCandidateReferences();
        if (collection.isEmpty()) {
            return;
        }
        MWReference mWReference = this.findReasonableReference(collection);
        this.setTargetTable(mWReference.getSourceTable());
        this.setReference(mWReference);
    }

    private MWReference findReasonableReference(Collection collection) {
        MWReference mWReference = null;
        for (MWReference mWReference2 : collection) {
            if (mWReference == null) {
                mWReference = mWReference2;
            }
            MWTable mWTable = mWReference2.getSourceTable();
            int n = mWReference2.columnPairsSize();
            if (mWTable.columnsSize() - n != this.automapNonPrimaryKeyColumnsSize()) continue;
            mWReference = mWReference2;
            break;
        }
        return mWReference;
    }

    protected abstract int automapNonPrimaryKeyColumnsSize();

    private void automapDirectValueColumn() {
        if (this.getDirectValueColumn() != null || this.getReference() == null) {
            return;
        }
        StringHolder[] stringHolderArray = ColumnStringHolder.buildHolders(this.candidateDirectValueColumns());
        PartialStringMatcher.StringHolderScore stringHolderScore = COLUMN_NAME_MATCHER.match(this.getName().toLowerCase(), stringHolderArray);
        if (stringHolderScore.getScore() > 0.5) {
            this.setDirectValueColumn(((ColumnStringHolder)stringHolderScore.getStringHolder()).getColumn());
        }
    }

    private Iterator candidateDirectValueColumns() {
        return this.getReference().getSourceTable().columns();
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection collection = super.buildAggregateFieldNameGenerators();
        if (this.getReference() != null) {
            Iterator iterator = this.getReference().columnPairs();
            while (iterator.hasNext()) {
                collection.add(new ColumnPairAggregateRuntimeFieldNameGenerator(this, (MWColumnPair)iterator.next()));
            }
        }
        return collection;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkDirectValueColumn(list);
        this.checkReference(list);
        this.checkValueHolderInstanceVariable(list);
        this.checkNonValueHolderInstanceVariable(list);
        this.checkTransparentIndirection(list);
    }

    private void checkDirectValueColumn(List list) {
        if (this.parentDescriptorIsAggregate()) {
            return;
        }
        if (this.getDirectValueColumn() == null) {
            list.add(this.buildProblem("0410"));
        }
    }

    private void checkReference(List list) {
        if (this.getReference() == null) {
            list.add(this.buildProblem("0460"));
        } else if (!this.referenceIsCandidate(this.getReference())) {
            list.add(this.buildProblem("0461"));
        }
    }

    private void checkValueHolderInstanceVariable(List list) {
        if (this.getInstanceVariable().isValueHolder() && !this.usesValueHolderIndirection()) {
            list.add(this.buildProblem("0550"));
        }
    }

    private void checkNonValueHolderInstanceVariable(List list) {
        if (!this.getProject().usesWeaving() && !this.getInstanceVariable().isValueHolder() && this.usesValueHolderIndirection()) {
            list.add(this.buildProblem("0551"));
        }
    }

    private void checkTransparentIndirection(List list) {
        MWClass mWClass;
        if (this.usesTransparentIndirection() && (mWClass = this.conatinerPolicyClass()) != null && !mWClass.mightBeAssignableToIndirectContainer()) {
            list.add(this.buildProblem("0560"));
        }
    }

    protected abstract MWClass conatinerPolicyClass();

    public DatabaseMapping runtimeMapping() {
        DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)super.runtimeMapping();
        if (this.getDirectValueColumn() != null) {
            directCollectionMapping.setDirectFieldName(this.getDirectValueColumn().qualifiedName());
        }
        directCollectionMapping.setValueConverter(this.getConverter().runtimeConverter((DatabaseMapping)directCollectionMapping));
        if (this.usesValueHolderIndirection()) {
            directCollectionMapping.setIndirectionPolicy((IndirectionPolicy)new BasicIndirectionPolicy());
        } else if (this.usesTransparentIndirection()) {
            directCollectionMapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        } else {
            directCollectionMapping.setIndirectionPolicy((IndirectionPolicy)new NoIndirectionPolicy());
        }
        this.joinFetchOption.setMWOptionOnTopLinkObject(directCollectionMapping);
        directCollectionMapping.setUsesBatchReading(this.usesBatchReading());
        MWReference mWReference = this.getReference();
        if (mWReference != null) {
            directCollectionMapping.setReferenceTableName(mWReference.getSourceTable().getName());
            Iterator iterator = mWReference.columnPairs();
            while (iterator.hasNext()) {
                MWColumnPair mWColumnPair = (MWColumnPair)iterator.next();
                if (mWColumnPair.getSourceColumn() == null || mWColumnPair.getTargetColumn() == null) continue;
                if (!this.parentDescriptorIsAggregate()) {
                    directCollectionMapping.addReferenceKeyFieldName(mWColumnPair.getSourceColumn().qualifiedName(), mWColumnPair.getTargetColumn().qualifiedName());
                    continue;
                }
                directCollectionMapping.addReferenceKeyFieldName(mWColumnPair.getSourceColumn().qualifiedName(), this.getName() + "->" + mWColumnPair.getTargetColumn().getName() + "_IN_REFERENCE_" + this.getReference().getName());
            }
        }
        return directCollectionMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalDirectContainerMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDirectContainerMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("targetTableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getTargetTableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTargetTableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("target-table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("directValueColumnHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getDirectValueColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setDirectValueColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping2.setXPath("direct-value-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("referenceHandle");
        xMLCompositeObjectMapping3.setGetMethodName("getReferenceHandleForTopLink");
        xMLCompositeObjectMapping3.setSetMethodName("setReferenceHandleForTopLink");
        xMLCompositeObjectMapping3.setReferenceClass(MWReferenceHandle.class);
        xMLCompositeObjectMapping3.setXPath("reference-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("joinFetchOption");
        xMLDirectMapping.setXPath("join-fetch-option/text()");
        xMLDirectMapping.setNullValue((Object)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE"));
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        objectTypeConverter2.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        objectTypeConverter2.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        objectTypeConverter2.addConversionValue((Object)"transparentIndirection", (Object)"transparentIndirection");
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("indirectionType");
        xMLDirectMapping2.setXPath("indirection-type/text()");
        xMLDirectMapping2.setNullValue((Object)"no-indirection");
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter2);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalDirectContainerMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDirectContainerMapping.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("targetTableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getTargetTableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTargetTableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("target-table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("directValueColumnHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getDirectValueColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setDirectValueColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping2.setXPath("direct-value-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("referenceHandle");
        xMLCompositeObjectMapping3.setGetMethodName("getReferenceHandleForTopLink");
        xMLCompositeObjectMapping3.setSetMethodName("setReferenceHandleForTopLink");
        xMLCompositeObjectMapping3.setReferenceClass(MWReferenceHandle.class);
        xMLCompositeObjectMapping3.setXPath("reference-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        objectTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        objectTypeConverter.addConversionValue((Object)"transparentIndirection", (Object)"transparentIndirection");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("indirectionType");
        xMLDirectMapping.setXPath("indirection-type/text()");
        xMLDirectMapping.setNullValue((Object)"no-indirection");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("batchReading", "uses-batch-reading/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    protected void legacy60PostBuild(DescriptorEvent descriptorEvent) {
        super.legacy60PostBuild(descriptorEvent);
        this.joinFetchOption = (MWJoinFetchableMapping.JoinFetchOption)MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().topLinkOptionForMWModelOption("NONE");
    }

    private MWTableHandle getTargetTableHandleForTopLink() {
        return this.targetTableHandle.getTable() == null ? null : this.targetTableHandle;
    }

    private void setTargetTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTargetTableScrubber();
        this.targetTableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWColumnHandle getDirectValueColumnHandleForTopLink() {
        return this.directValueColumnHandle.getColumn() == null ? null : this.directValueColumnHandle;
    }

    private void setDirectValueColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildDirectValueColumnScrubber();
        this.directValueColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWReferenceHandle getReferenceHandleForTopLink() {
        return this.referenceHandle.getReference() == null ? null : this.referenceHandle;
    }

    private void setReferenceHandleForTopLink(MWReferenceHandle mWReferenceHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildReferenceScrubber();
        this.referenceHandle = mWReferenceHandle == null ? new MWReferenceHandle(this, nodeReferenceScrubber) : mWReferenceHandle.setScrubber(nodeReferenceScrubber);
    }

    public TopLinkOptionSet joinFetchOptions() {
        if (joinFetchOptions == null) {
            joinFetchOptions = MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions();
        }
        return joinFetchOptions;
    }

    static {
        COLUMN_NAME_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);
    }

    private static class ColumnPairAggregateRuntimeFieldNameGenerator
    implements AggregateRuntimeFieldNameGenerator {
        MWRelationalDirectContainerMapping mapping;
        private MWColumnPair columnPair;

        ColumnPairAggregateRuntimeFieldNameGenerator(MWRelationalDirectContainerMapping mWRelationalDirectContainerMapping, MWColumnPair mWColumnPair) {
            this.mapping = mWRelationalDirectContainerMapping;
            this.columnPair = mWColumnPair;
        }

        public boolean fieldIsWritten() {
            return false;
        }

        public String fieldNameForRuntime() {
            return this.columnPair.getTargetColumn().getName() + "_IN_REFERENCE_" + this.mapping.getReference().getName();
        }

        public AggregateFieldDescription fullFieldDescription() {
            final MWColumn mWColumn = this.columnPair.getTargetColumn();
            return new AggregateFieldDescription(){

                public String getMessageKey() {
                    return "AGGREGATE_FIELD_DESCRIPTION_FOR_REFERENCE";
                }

                public Object[] getMessageArguments() {
                    return new Object[]{mWColumn.getName(), ColumnPairAggregateRuntimeFieldNameGenerator.this.mapping.getReference().getName()};
                }
            };
        }

        public MWDescriptor owningDescriptor() {
            throw new UnsupportedOperationException();
        }
    }
}

