/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWLiteralArgument
extends MWArgument {
    private volatile MWTypeDeclaration type;
    public static final String TYPE_PROPERTY = "type";
    private volatile String value;
    public static final String VALUE_PROPERTY = "value";

    private MWLiteralArgument() {
    }

    MWLiteralArgument(MWBasicExpression mWBasicExpression, MWTypeDeclaration mWTypeDeclaration, String string) {
        super(mWBasicExpression);
        this.type = mWTypeDeclaration;
        this.value = string;
    }

    MWLiteralArgument(MWBasicExpression mWBasicExpression) {
        super(mWBasicExpression);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.type = new MWTypeDeclaration((MWModel)this, this.typeNamed("java.lang.String"));
        this.value = "";
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.type);
    }

    private MWBasicExpression getBasicExpression() {
        return (MWBasicExpression)this.getParent();
    }

    public String getType() {
        return "literal";
    }

    public void operatorTypeChanged() {
        if (this.getBasicExpression().operatorIsStringType()) {
            this.setType(new MWTypeDeclaration((MWModel)this, this.typeNamed("java.lang.String")));
        }
    }

    public MWTypeDeclaration getLiteralType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void undoChange(String string, Object object, Object object2) {
        if (string == TYPE_PROPERTY) {
            this.setType((MWTypeDeclaration)object);
        } else if (string == VALUE_PROPERTY) {
            this.setValue((String)object);
        }
    }

    public void setType(MWTypeDeclaration mWTypeDeclaration) {
        MWTypeDeclaration mWTypeDeclaration2 = this.getLiteralType();
        this.type = mWTypeDeclaration;
        this.firePropertyChanged(TYPE_PROPERTY, mWTypeDeclaration2, this.getLiteralType());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, TYPE_PROPERTY, mWTypeDeclaration2, mWTypeDeclaration);
    }

    public void setValue(String string) {
        Object object = this.getValue();
        this.value = string;
        this.firePropertyChanged(VALUE_PROPERTY, object, this.getValue());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, VALUE_PROPERTY, object, string);
    }

    public String displayString() {
        return "\"" + this.getValue() + "\"";
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append("type = ");
        stringBuffer.append(this.getLiteralType().typeName());
        stringBuffer.append(", value = ");
        stringBuffer.append(this.getValue());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWLiteralArgument.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWArgument.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(TYPE_PROPERTY);
        xMLCompositeObjectMapping.setReferenceClass(MWTypeDeclaration.class);
        xMLCompositeObjectMapping.setXPath(TYPE_PROPERTY);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(VALUE_PROPERTY, "value/text()");
        xMLDirectMapping.setNullValue((Object)"");
        return xMLDescriptor;
    }

    Expression runtimeExpression(ExpressionBuilder expressionBuilder) {
        return new ConstantExpression(this.value(), (Expression)expressionBuilder);
    }

    private Object value() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getLiteralType().typeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ConversionManager conversionManager = ConversionManager.getDefaultManager();
        try {
            return conversionManager.convertObject((Object)this.value, clazz);
        }
        catch (ConversionException conversionException) {
            return null;
        }
    }

    static MWLiteralArgument convertFromRuntime(MWBasicExpression mWBasicExpression, ConstantExpression constantExpression) {
        Object object = constantExpression.getValue();
        MWClass mWClass = mWBasicExpression.typeNamed(object.getClass().getName());
        MWLiteralArgument mWLiteralArgument = new MWLiteralArgument(mWBasicExpression);
        mWLiteralArgument.setType(new MWTypeDeclaration((MWModel)mWLiteralArgument, mWClass));
        mWLiteralArgument.setValue((String)object);
        return mWLiteralArgument;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getLiteralType().typeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ConversionManager conversionManager = ConversionManager.getDefaultManager();
        try {
            conversionManager.convertObject((Object)this.value, clazz);
        }
        catch (ConversionException conversionException) {
            list.add(this.buildProblemForConversionException(clazz));
        }
    }

    private Problem buildProblemForConversionException(Class clazz) {
        String string = clazz.getName();
        String string2 = this.getBasicExpression().getIndex();
        String string3 = this.getBasicExpression().getParentQuery().getName();
        if (clazz == Boolean.class) {
            return this.buildProblem("0263", string2, string3, string);
        }
        if (clazz == Character.class) {
            return this.buildProblem("0264", string2, string3, string);
        }
        if (clazz == Short.class) {
            return this.buildProblem("0265", new Object[]{string2, string3, string, NumberFormat.getInstance().format(-32768L), NumberFormat.getInstance().format(32767L)});
        }
        if (clazz == Byte.class) {
            return this.buildProblem("0262", new Object[]{string2, string3, string, NumberFormat.getInstance().format(-128L), NumberFormat.getInstance().format(127L)});
        }
        if (clazz == Float.class) {
            return this.buildProblem("0265", new Object[]{string2, string3, string, NumberFormat.getInstance().format(1.4E-45f), NumberFormat.getInstance().format(3.4028234663852886E38)});
        }
        if (clazz == Double.class) {
            return this.buildProblem("0265", new Object[]{string2, string3, string, NumberFormat.getInstance().format(Double.MIN_VALUE), NumberFormat.getInstance().format(Double.MAX_VALUE)});
        }
        if (clazz == Integer.class) {
            return this.buildProblem("0265", new Object[]{string2, string3, string, NumberFormat.getInstance().format(Integer.MIN_VALUE), NumberFormat.getInstance().format(Integer.MAX_VALUE)});
        }
        if (clazz == Long.class) {
            return this.buildProblem("0265", new Object[]{string2, string3, string, NumberFormat.getInstance().format(Long.MIN_VALUE), NumberFormat.getInstance().format(Long.MAX_VALUE)});
        }
        if (clazz == String.class) {
            return this.buildProblem("0266", string2, string3, string);
        }
        if (clazz == BigDecimal.class) {
            return this.buildProblem("0267", string2, string3, string);
        }
        if (clazz == BigInteger.class) {
            return this.buildProblem("0268", string2, string3, string);
        }
        if (clazz == Date.class) {
            return this.buildProblem("0269", string2, string3, string);
        }
        if (clazz == Time.class) {
            return this.buildProblem("0211", string2, string3, string);
        }
        if (clazz == Timestamp.class) {
            return this.buildProblem("0212", string2, string3, string);
        }
        if (clazz == java.util.Date.class) {
            return this.buildProblem("0213", string2, string3, string);
        }
        if (clazz == Calendar.class) {
            return this.buildProblem("0214", string2, string3, string);
        }
        if (clazz == byte[].class || clazz == Byte[].class) {
            return this.buildProblem("0215", string2, string3, string);
        }
        if (clazz == char[].class || clazz == Character[].class) {
            return this.buildProblem("0216", string2, string3, string);
        }
        return this.buildProblem("0217", string2, string3);
    }
}

