/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSObject;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;

public abstract class AbstractNamedSchemaComponent
extends AbstractSchemaComponent
implements MWNamedSchemaComponent {
    private volatile String name;
    private volatile String namespaceUrl;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(AbstractNamedSchemaComponent.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(AbstractSchemaComponent.class);
        xMLDescriptor.addDirectMapping("name", "name/text()");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("namespaceUrl", "namespace-url/text()")).setNullValue((Object)"");
        return xMLDescriptor;
    }

    protected AbstractNamedSchemaComponent() {
    }

    protected AbstractNamedSchemaComponent(MWModel mWModel, String string) {
        super(mWModel);
        this.name = string;
    }

    protected AbstractNamedSchemaComponent(MWModel mWModel, String string, String string2) {
        this(mWModel, string);
        this.namespaceUrl = string2;
    }

    protected void initialize() {
        super.initialize();
        this.namespaceUrl = "";
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceUrl() {
        return this.namespaceUrl;
    }

    public MWNamespace getTargetNamespace() {
        return this.getParentNamespace();
    }

    public Iterator namedComponentChain() {
        return new ChainIterator(this){

            protected Object nextLink(Object object) {
                return ((MWNamedSchemaComponent)object).parentNamedComponent();
            }
        };
    }

    public boolean directlyOwns(MWNamedSchemaComponent mWNamedSchemaComponent) {
        return this.directlyOwnedComponents().contains(mWNamedSchemaComponent);
    }

    public void addDirectlyOwnedComponentsTo(Collection collection) {
    }

    private Collection directlyOwnedComponents() {
        HashBag hashBag = new HashBag();
        this.addDirectlyOwnedComponentsTo(hashBag);
        return hashBag;
    }

    public String qName() {
        String string = this.getName();
        String string2 = this.getSchema().namespacePrefixForUrl(this.getNamespaceUrl());
        if (string2 != null && !string2.equals("")) {
            string = string2 + ":" + string;
        }
        return string;
    }

    protected void reloadInternal(XSObject xSObject) {
        super.reloadInternal(xSObject);
        if (xSObject instanceof XSParticleDecl) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)xSObject;
            this.reloadName(xSParticleDecl.getTerm().getName(), xSParticleDecl.getTerm().getNamespace());
        } else {
            this.reloadName(xSObject.getName(), xSObject.getNamespace());
        }
    }

    protected void reloadName(String string, String string2) {
        this.name = string;
        this.namespaceUrl = string2 != null ? string2 : "";
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("name = " + this.name);
    }
}

