/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.AbstractCLExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalClass;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CLExternalClassDescription
implements ExternalClassDescription {
    private final String name;
    private final String classpathEntry;
    private final AbstractCLExternalClassRepository repository;
    private ExternalClass externalClass;

    CLExternalClassDescription(String string, String string2, AbstractCLExternalClassRepository abstractCLExternalClassRepository) {
        this.name = string;
        this.classpathEntry = string2;
        this.repository = abstractCLExternalClassRepository;
    }

    CLExternalClassDescription(String string, AbstractCLExternalClassRepository abstractCLExternalClassRepository) {
        this(string, "", abstractCLExternalClassRepository);
    }

    public int getArrayDepth() {
        return ClassTools.arrayDepthForClassNamed(this.name);
    }

    public String getAdditionalInfo() {
        return this.classpathEntry;
    }

    public String getElementTypeName() {
        return ClassTools.elementTypeNameForClassNamed(this.name);
    }

    public synchronized ExternalClass getExternalClass() throws ExternalClassNotFoundException {
        if (this.externalClass == null) {
            this.externalClass = this.buildExternalClass();
        }
        return this.externalClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynthetic() {
        return ClassTools.classNamedIsAnonymous(this.name);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionFor(Class clazz) {
        return this.repository.getClassDescriptionFor(clazz);
    }

    private ExternalClass buildExternalClass() throws ExternalClassNotFoundException {
        if (this.getArrayDepth() != 0) {
            throw new IllegalStateException();
        }
        return new CLExternalClass(this.repository.loadClass(this.name), this);
    }
}

