/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeToJavaTypeDeclarationMapping;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclarationToJDBCTypeMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JDBCTypeRepository
extends AbstractNodeModel {
    private Collection jdbcTypes;
    public static final String JDBC_TYPES_COLLECTION = "jdbcTypes";
    private static final int[] DEFAULT_UNUSED_JDBC_TYPE_CODES = new int[]{0};
    private JDBCType defaultJDBCType;
    public static final String DEFAULT_JDBC_TYPE_PROPERTY = "defaultJDBCType";
    private static final int DEFAULT_DEFAULT_JDBC_TYPE_CODE = 12;
    private Collection jdbcTypeToJavaTypeDeclarationMappings;
    public static final String JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION = "jdbcTypeToJavaTypeDeclarationMappings";
    private Collection javaTypeDeclarationToJDBCTypeMappings;
    public static final String JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION = "javaTypeDeclarationToJDBCTypeMappings";
    private static final boolean JDK16 = JDBCTypeRepository.jdkIsVersion("1.6");

    private static boolean jdkIsVersion(String string) {
        return System.getProperty("java.version").indexOf(string) != -1;
    }

    JDBCTypeRepository(DatabasePlatformRepository databasePlatformRepository, Node node) throws CorruptXMLException {
        super(databasePlatformRepository);
        this.read(node);
    }

    JDBCTypeRepository(DatabasePlatformRepository databasePlatformRepository) {
        super(databasePlatformRepository);
        this.initializeDefaults();
    }

    protected void initialize() {
        super.initialize();
        this.jdbcTypes = new Vector();
        this.jdbcTypeToJavaTypeDeclarationMappings = new Vector();
        this.javaTypeDeclarationToJDBCTypeMappings = new Vector();
    }

    private void initializeDefaults() {
        this.initializeDefaultJDBCTypes();
        this.defaultJDBCType = this.jdbcTypeForCode(12);
        this.initializeDefaultJDBCToJavaMappings();
        if (!JDK16) {
            this.checkJDBCTypeToJavaTypeDeclarationMappings();
        }
        this.initializeDefaultJavaToJDBCMappings();
    }

    private void checkJDBCTypeToJavaTypeDeclarationMappings() {
        if (this.jdbcTypeToJavaTypeDeclarationMappings.size() != this.jdbcTypes.size()) {
            throw new IllegalStateException("the JDBC type mappings were not initialized properly");
        }
    }

    private void initializeDefaultJDBCTypes() {
        Field[] fieldArray = Types.class.getDeclaredFields();
        int n = fieldArray.length;
        while (n-- > 0) {
            int n2;
            String string = fieldArray[n].getName();
            try {
                n2 = (Integer)fieldArray[n].get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            if (CollectionTools.contains(DEFAULT_UNUSED_JDBC_TYPE_CODES, n2)) continue;
            this.checkJDBCType(string, n2);
            this.jdbcTypes.add(new JDBCType(this, string, n2));
        }
    }

    private void initializeDefaultJDBCToJavaMappings() {
        this.addJDBCToJavaMapping(2003, Array.class);
        this.addJDBCToJavaMapping(-5, Long.TYPE);
        this.addJDBCToJavaMapping(-2, Byte.TYPE, 1);
        this.addJDBCToJavaMapping(-7, Boolean.TYPE);
        this.addJDBCToJavaMapping(2004, Blob.class);
        this.addJDBCToJavaMapping(16, Boolean.TYPE);
        this.addJDBCToJavaMapping(1, String.class);
        this.addJDBCToJavaMapping(2005, Clob.class);
        this.addJDBCToJavaMapping(70, URL.class);
        this.addJDBCToJavaMapping(91, Date.class);
        this.addJDBCToJavaMapping(3, BigDecimal.class);
        this.addJDBCToJavaMapping(2001, Object.class);
        this.addJDBCToJavaMapping(8, Double.TYPE);
        this.addJDBCToJavaMapping(6, Double.TYPE);
        this.addJDBCToJavaMapping(4, Integer.TYPE);
        this.addJDBCToJavaMapping(2000, Object.class);
        this.addJDBCToJavaMapping(-4, Byte.TYPE, 1);
        this.addJDBCToJavaMapping(-1, String.class);
        this.addJDBCToJavaMapping(2, BigDecimal.class);
        this.addJDBCToJavaMapping(1111, Object.class);
        this.addJDBCToJavaMapping(7, Float.TYPE);
        this.addJDBCToJavaMapping(2006, Ref.class);
        this.addJDBCToJavaMapping(5, Short.TYPE);
        this.addJDBCToJavaMapping(2002, Struct.class);
        this.addJDBCToJavaMapping(92, Time.class);
        this.addJDBCToJavaMapping(93, Timestamp.class);
        this.addJDBCToJavaMapping(-6, Byte.TYPE);
        this.addJDBCToJavaMapping(-3, Byte.TYPE, 1);
        this.addJDBCToJavaMapping(12, String.class);
    }

    private void addJDBCToJavaMapping(int n, Class clazz) {
        this.addJDBCToJavaMapping(n, clazz, 0);
    }

    private void addJDBCToJavaMapping(int n, Class clazz, int n2) {
        JDBCType jDBCType = this.jdbcTypeForCode(n);
        this.checkJDBCToJavaMapping(jDBCType);
        this.jdbcTypeToJavaTypeDeclarationMappings.add(new JDBCTypeToJavaTypeDeclarationMapping(this, jDBCType, clazz.getName(), n2));
    }

    private void initializeDefaultJavaToJDBCMappings() {
        this.addJavaToJDBCMapping(String.class, 12);
        this.addJavaToJDBCMapping(Boolean.TYPE, 16);
        this.addJavaToJDBCMapping(Boolean.class, 16);
        this.addJavaToJDBCMapping(Character.TYPE, 1);
        this.addJavaToJDBCMapping(Character.class, 1);
        this.addJavaToJDBCMapping(Byte.TYPE, -6);
        this.addJavaToJDBCMapping(Byte.class, -6);
        this.addJavaToJDBCMapping(Short.TYPE, 5);
        this.addJavaToJDBCMapping(Short.class, 5);
        this.addJavaToJDBCMapping(Integer.TYPE, 4);
        this.addJavaToJDBCMapping(Integer.class, 4);
        this.addJavaToJDBCMapping(Long.TYPE, -5);
        this.addJavaToJDBCMapping(Long.class, -5);
        this.addJavaToJDBCMapping(Float.TYPE, 7);
        this.addJavaToJDBCMapping(Float.class, 7);
        this.addJavaToJDBCMapping(Double.TYPE, 8);
        this.addJavaToJDBCMapping(Double.class, 8);
        this.addJavaToJDBCMapping(Number.class, 2);
        this.addJavaToJDBCMapping(BigDecimal.class, 2);
        this.addJavaToJDBCMapping(BigInteger.class, 2);
        this.addJavaToJDBCMapping(java.util.Date.class, 91);
        this.addJavaToJDBCMapping(Date.class, 91);
        this.addJavaToJDBCMapping(Time.class, 92);
        this.addJavaToJDBCMapping(Timestamp.class, 93);
        this.addJavaToJDBCMapping(Calendar.class, 93);
        this.addJavaToJDBCMapping(Blob.class, 2004);
        this.addJavaToJDBCMapping(Clob.class, 2005);
        this.addJavaToJDBCMapping(Array.class, 2003);
        this.addJavaToJDBCMapping(Struct.class, 2002);
        this.addJavaToJDBCMapping(Ref.class, 2006);
        this.addJavaToJDBCMapping(URL.class, 70);
        this.addJavaToJDBCMapping(Byte.TYPE, 1, -3);
        this.addJavaToJDBCMapping(Character.TYPE, 1, 12);
        this.addJavaToJDBCMapping(Class.class, 12);
    }

    private void addJavaToJDBCMapping(Class clazz, int n) {
        this.addJavaToJDBCMapping(clazz, 0, n);
    }

    private void addJavaToJDBCMapping(Class clazz, int n, int n2) {
        String string = clazz.getName();
        this.checkJavaToJDBCMapping(string, n);
        this.javaTypeDeclarationToJDBCTypeMappings.add(new JavaTypeDeclarationToJDBCTypeMapping(this, string, n, this.jdbcTypeForCode(n2)));
    }

    private DatabasePlatformRepository getPlatformRepository() {
        return (DatabasePlatformRepository)this.getParent();
    }

    public Iterator jdbcTypes() {
        return new CloneIterator(this.jdbcTypes){

            protected void remove(Object object) {
                JDBCTypeRepository.this.removeJDBCType((JDBCType)object);
            }
        };
    }

    public int jdbcTypesSize() {
        return this.jdbcTypes.size();
    }

    public JDBCType addJDBCType(String string, int n) {
        this.checkJDBCType(string, n);
        return this.addJDBCType(new JDBCType(this, string, n));
    }

    private JDBCType addJDBCType(JDBCType jDBCType) {
        this.addItemToCollection(jDBCType, this.jdbcTypes, JDBC_TYPES_COLLECTION);
        this.jdbcTypeAdded(jDBCType);
        return jDBCType;
    }

    private void jdbcTypeAdded(JDBCType jDBCType) {
        this.addJDBCTypeToJavaTypeDeclarationMapping(jDBCType, Object.class.getName(), 0);
        this.getPlatformRepository().jdbcTypeAdded(jDBCType);
    }

    public void removeJDBCType(JDBCType jDBCType) {
        if (jDBCType == this.defaultJDBCType) {
            throw new IllegalArgumentException("the default JDBC type may not be removed: " + jDBCType);
        }
        this.removeItemFromCollection(jDBCType, this.jdbcTypes, JDBC_TYPES_COLLECTION);
        this.jdbcTypeRemoved(jDBCType);
    }

    private void jdbcTypeRemoved(JDBCType jDBCType) {
        Iterator iterator = this.jdbcTypeToJavaTypeDeclarationMappings();
        while (iterator.hasNext()) {
            if (((JDBCTypeToJavaTypeDeclarationMapping)iterator.next()).getJDBCType() != jDBCType) continue;
            iterator.remove();
            break;
        }
        iterator = this.javaTypeDeclarationToJDBCTypeMappings();
        while (iterator.hasNext()) {
            JavaTypeDeclarationToJDBCTypeMapping javaTypeDeclarationToJDBCTypeMapping = (JavaTypeDeclarationToJDBCTypeMapping)iterator.next();
            if (javaTypeDeclarationToJDBCTypeMapping.getJDBCType() != jDBCType) continue;
            javaTypeDeclarationToJDBCTypeMapping.setJDBCType(this.defaultJDBCType);
        }
        this.getPlatformRepository().nodeRemoved(jDBCType);
    }

    public void removeJDBCTypes(Collection collection) {
        if (collection.contains(this.defaultJDBCType)) {
            throw new IllegalArgumentException("the default JDBC type may not be removed: " + this.defaultJDBCType);
        }
        this.removeItemsFromCollection(collection, this.jdbcTypes, JDBC_TYPES_COLLECTION);
        this.jdbcTypesRemoved(collection);
    }

    private void jdbcTypesRemoved(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.jdbcTypeRemoved((JDBCType)iterator.next());
        }
    }

    public void removeJDBCTypes(Iterator iterator) {
        this.removeJDBCTypes(CollectionTools.collection(iterator));
    }

    public JDBCType getDefaultJDBCType() {
        return this.defaultJDBCType;
    }

    public void setDefaultJDBCType(JDBCType jDBCType) {
        if (jDBCType == null) {
            throw new NullPointerException();
        }
        JDBCType jDBCType2 = this.defaultJDBCType;
        this.defaultJDBCType = jDBCType;
        this.firePropertyChanged(DEFAULT_JDBC_TYPE_PROPERTY, jDBCType2, jDBCType);
    }

    public Iterator jdbcTypeToJavaTypeDeclarationMappings() {
        return new CloneIterator(this.jdbcTypeToJavaTypeDeclarationMappings){

            protected void remove(Object object) {
                JDBCTypeRepository.this.removeJDBCTypeToJavaTypeDeclarationMapping((JDBCTypeToJavaTypeDeclarationMapping)object);
            }
        };
    }

    public int jdbcTypeToJavaTypeDeclarationMappingsSize() {
        return this.jdbcTypeToJavaTypeDeclarationMappings.size();
    }

    public JDBCTypeToJavaTypeDeclarationMapping addJDBCTypeToJavaTypeDeclarationMapping(JDBCType jDBCType, String string, int n) {
        this.checkJDBCToJavaMapping(jDBCType);
        return this.addJDBCTypeToJavaTypeDeclarationMapping(new JDBCTypeToJavaTypeDeclarationMapping(this, jDBCType, string, n));
    }

    private JDBCTypeToJavaTypeDeclarationMapping addJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping) {
        this.addItemToCollection(jDBCTypeToJavaTypeDeclarationMapping, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
        return jDBCTypeToJavaTypeDeclarationMapping;
    }

    public void removeJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping) {
        this.removeItemFromCollection(jDBCTypeToJavaTypeDeclarationMapping, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
    }

    public void removeJDBCTypeToJavaTypeDeclarationMappings(Collection collection) {
        this.removeItemsFromCollection(collection, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
    }

    public void removeJDBCTypeToJavaTypeDeclarationMappings(Iterator iterator) {
        this.removeItemsFromCollection(iterator, this.jdbcTypeToJavaTypeDeclarationMappings, JDBC_TYPE_TO_JAVA_TYPE_DECLARATION_MAPPINGS_COLLECTION);
    }

    public Iterator javaTypeDeclarationToJDBCTypeMappings() {
        return new CloneIterator(this.javaTypeDeclarationToJDBCTypeMappings){

            protected void remove(Object object) {
                JDBCTypeRepository.this.removeJavaTypeDeclarationToJDBCTypeMapping((JavaTypeDeclarationToJDBCTypeMapping)object);
            }
        };
    }

    public int javaTypeDeclarationToJDBCTypeMappingsSize() {
        return this.javaTypeDeclarationToJDBCTypeMappings.size();
    }

    public JavaTypeDeclarationToJDBCTypeMapping addJavaTypeDeclarationToJDBCTypeMapping(String string, int n, JDBCType jDBCType) {
        this.checkJavaToJDBCMapping(string, n);
        return this.addJavaTypeDeclarationToJDBCTypeMapping(new JavaTypeDeclarationToJDBCTypeMapping(this, string, n, jDBCType));
    }

    private JavaTypeDeclarationToJDBCTypeMapping addJavaTypeDeclarationToJDBCTypeMapping(JavaTypeDeclarationToJDBCTypeMapping javaTypeDeclarationToJDBCTypeMapping) {
        this.addItemToCollection(javaTypeDeclarationToJDBCTypeMapping, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
        return javaTypeDeclarationToJDBCTypeMapping;
    }

    public void removeJavaTypeDeclarationToJDBCTypeMapping(JavaTypeDeclarationToJDBCTypeMapping javaTypeDeclarationToJDBCTypeMapping) {
        this.removeItemFromCollection(javaTypeDeclarationToJDBCTypeMapping, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
    }

    public void removeJavaTypeDeclarationToJDBCTypeMappings(Collection collection) {
        this.removeItemsFromCollection(collection, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
    }

    public void removeJavaTypeDeclarationToJDBCTypeMappings(Iterator iterator) {
        this.removeItemsFromCollection(iterator, this.javaTypeDeclarationToJDBCTypeMappings, JAVA_TYPE_DECLARATION_TO_JDBC_TYPE_MAPPINGS_COLLECTION);
    }

    public JDBCType jdbcTypeForCode(int n) {
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            for (JDBCType jDBCType : this.jdbcTypes) {
                if (jDBCType.getCode() != n) continue;
                return jDBCType;
            }
            throw new IllegalArgumentException("missing JDBC type for code: " + n);
        }
    }

    JDBCType jdbcTypeNamed(String string) {
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            for (JDBCType jDBCType : this.jdbcTypes) {
                if (!jDBCType.getName().equals(string)) continue;
                return jDBCType;
            }
            throw new IllegalArgumentException("missing JDBC type named: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jdbcTypeCanBeMappedToJavaTypeDeclaration(JDBCType jDBCType) {
        Collection collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            Iterator iterator = this.jdbcTypeToJavaTypeDeclarationMappings.iterator();
            while (iterator.hasNext()) {
                if (!((JDBCTypeToJavaTypeDeclarationMapping)iterator.next()).maps(jDBCType)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean javaTypeDeclarationCanBeMappedToJDBCType(String string, int n) {
        Collection collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            Iterator iterator = this.javaTypeDeclarationToJDBCTypeMappings.iterator();
            while (iterator.hasNext()) {
                if (!((JavaTypeDeclarationToJDBCTypeMapping)iterator.next()).maps(string, n)) continue;
                return true;
            }
            return false;
        }
    }

    JDBCType jdbcTypeForJavaTypeDeclaration(String string, int n) {
        Collection collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            for (JavaTypeDeclarationToJDBCTypeMapping javaTypeDeclarationToJDBCTypeMapping : this.javaTypeDeclarationToJDBCTypeMappings) {
                if (!javaTypeDeclarationToJDBCTypeMapping.maps(string, n)) continue;
                return javaTypeDeclarationToJDBCTypeMapping.getJDBCType();
            }
            throw new IllegalArgumentException("missing JDBC type mapping for Java type declaration: " + string + this.brackets(n));
        }
    }

    JavaTypeDeclaration javaTypeDeclarationFor(JDBCType jDBCType) {
        Collection collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            for (JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping : this.jdbcTypeToJavaTypeDeclarationMappings) {
                if (!jDBCTypeToJavaTypeDeclarationMapping.maps(jDBCType)) continue;
                return jDBCTypeToJavaTypeDeclarationMapping.getJavaTypeDeclaration();
            }
            throw new IllegalArgumentException("missing Java type declaration mapping for JDBC type: " + jDBCType);
        }
    }

    JavaTypeDeclaration javaTypeDeclarationForJDBCTypeCode(int n) {
        return this.javaTypeDeclarationFor(this.jdbcTypeForCode(n));
    }

    private Iterator jdbcTypeNames() {
        return new TransformationIterator(this.jdbcTypes()){

            protected Object transform(Object object) {
                return ((JDBCType)object).getName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            list.addAll(this.jdbcTypes);
        }
        collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            list.addAll(this.jdbcTypeToJavaTypeDeclarationMappings);
        }
        collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            list.addAll(this.javaTypeDeclarationToJDBCTypeMappings);
        }
    }

    private void checkJDBCType(JDBCType jDBCType) {
        this.checkJDBCType(jDBCType.getName(), jDBCType.getCode());
    }

    private void checkJDBCType(String string, int n) {
        this.checkJDBCTypeName(string);
        this.checkJDBCTypeCode(n);
    }

    void checkJDBCTypeName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (CollectionTools.contains(this.jdbcTypeNames(), (Object)string)) {
            throw new IllegalArgumentException("duplicate JDBC type name: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkJDBCTypeCode(int n) {
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            Iterator iterator = this.jdbcTypes.iterator();
            while (iterator.hasNext()) {
                if (((JDBCType)iterator.next()).getCode() != n) continue;
                throw new IllegalArgumentException("duplicate JDBC type code: " + n);
            }
        }
    }

    private void checkJDBCToJavaMapping(JDBCType jDBCType) {
        if (this.jdbcTypeCanBeMappedToJavaTypeDeclaration(jDBCType)) {
            throw new IllegalArgumentException("duplicate mapping: " + jDBCType.getName());
        }
    }

    private void checkJavaToJDBCMapping(String string, int n) {
        if (this.javaTypeDeclarationCanBeMappedToJDBCType(string, n)) {
            throw new IllegalArgumentException("duplicate mapping: " + string + this.brackets(n));
        }
    }

    private void checkJavaToJDBCMapping(JavaTypeDeclaration javaTypeDeclaration) {
        this.checkJavaToJDBCMapping(javaTypeDeclaration.getJavaClassName(), javaTypeDeclaration.getArrayDepth());
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw new CorruptXMLException("missing node");
        }
        this.readJDBCTypeNodes(XMLTools.child(node, "jdbc-types"));
        if (this.jdbcTypes.isEmpty()) {
            throw new CorruptXMLException("the JDBC type repository is empty");
        }
        String string = XMLTools.childTextContent(node, "default-jdbc-type", null);
        try {
            this.defaultJDBCType = this.jdbcTypeNamed(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CorruptXMLException("default JDBC type", illegalArgumentException);
        }
        this.readJDBCToJavaMappingNodes(XMLTools.child(node, "jdbc-type-to-java-type-declaration-mappings"));
        if (this.jdbcTypeToJavaTypeDeclarationMappings.size() != this.jdbcTypes.size()) {
            throw new CorruptXMLException("all the JDBC types must be mapped to Java type declarations");
        }
        this.readJavaToJDBCMappingNodes(XMLTools.child(node, "java-type-declaration-to-jdbc-type-mappings"));
    }

    private void readJDBCTypeNodes(Node node) throws CorruptXMLException {
        Node[] nodeArray = XMLTools.children(node, "jdbc-type");
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            JDBCType jDBCType = new JDBCType(this, nodeArray[i]);
            try {
                this.checkJDBCType(jDBCType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CorruptXMLException(illegalArgumentException);
            }
            this.jdbcTypes.add(jDBCType);
        }
    }

    private void readJDBCToJavaMappingNodes(Node node) throws CorruptXMLException {
        Node[] nodeArray = XMLTools.children(node, "jdbc-type-to-java-type-declaration-mapping");
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping = new JDBCTypeToJavaTypeDeclarationMapping(this, nodeArray[i]);
            try {
                this.checkJDBCToJavaMapping(jDBCTypeToJavaTypeDeclarationMapping.getJDBCType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CorruptXMLException(illegalArgumentException);
            }
            this.jdbcTypeToJavaTypeDeclarationMappings.add(jDBCTypeToJavaTypeDeclarationMapping);
        }
    }

    private void readJavaToJDBCMappingNodes(Node node) throws CorruptXMLException {
        Node[] nodeArray = XMLTools.children(node, "java-type-declaration-to-jdbc-type-mapping");
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            JavaTypeDeclarationToJDBCTypeMapping javaTypeDeclarationToJDBCTypeMapping = new JavaTypeDeclarationToJDBCTypeMapping(this, nodeArray[i]);
            try {
                this.checkJavaToJDBCMapping(javaTypeDeclarationToJDBCTypeMapping.getJavaTypeDeclaration());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CorruptXMLException(illegalArgumentException);
            }
            this.javaTypeDeclarationToJDBCTypeMappings.add(javaTypeDeclarationToJDBCTypeMapping);
        }
    }

    void write(Node node) {
        Document document = node.getOwnerDocument();
        XMLTools.addSimpleTextNode(node, "default-jdbc-type", this.defaultJDBCType.getName());
        this.writeJDBCTypeNodes(node.appendChild(document.createElement("jdbc-types")));
        this.writeJDBCToJavaMappingNodes(node.appendChild(document.createElement("jdbc-type-to-java-type-declaration-mappings")));
        this.writeJavaToJDBCMappingNodes(node.appendChild(document.createElement("java-type-declaration-to-jdbc-type-mappings")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJDBCTypeNodes(Node node) {
        Document document = node.getOwnerDocument();
        Collection collection = this.jdbcTypes;
        synchronized (collection) {
            Iterator iterator = new TreeSet(this.jdbcTypes).iterator();
            while (iterator.hasNext()) {
                Element element = document.createElement("jdbc-type");
                node.appendChild(element);
                ((JDBCType)iterator.next()).write(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJDBCToJavaMappingNodes(Node node) {
        Document document = node.getOwnerDocument();
        Collection collection = this.jdbcTypeToJavaTypeDeclarationMappings;
        synchronized (collection) {
            Iterator iterator = new TreeSet(this.jdbcTypeToJavaTypeDeclarationMappings).iterator();
            while (iterator.hasNext()) {
                Element element = document.createElement("jdbc-type-to-java-type-declaration-mapping");
                node.appendChild(element);
                ((JDBCTypeToJavaTypeDeclarationMapping)iterator.next()).write(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaToJDBCMappingNodes(Node node) {
        Document document = node.getOwnerDocument();
        Collection collection = this.javaTypeDeclarationToJDBCTypeMappings;
        synchronized (collection) {
            Iterator iterator = new TreeSet(this.javaTypeDeclarationToJDBCTypeMappings).iterator();
            while (iterator.hasNext()) {
                Element element = document.createElement("java-type-declaration-to-jdbc-type-mapping");
                node.appendChild(element);
                ((JavaTypeDeclarationToJDBCTypeMapping)iterator.next()).write(element);
            }
        }
    }

    private String brackets(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public String displayString() {
        return "";
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.jdbcTypes.size() + " JDBC types");
    }
}

