/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class Classpath
implements Serializable {
    private final Entry[] entries;
    private static final long serialVersionUID = 1L;

    public static Classpath bootClasspath() {
        return new Classpath(System.getProperty("sun.boot.class.path"));
    }

    public static Classpath javaExtensionClasspath() {
        File[] fileArray = Classpath.javaExtensionDirectories();
        int n = fileArray.length;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            File file = fileArray[i];
            if (!file.isDirectory()) continue;
            Classpath.addJarFileNamesTo(file, arrayList);
        }
        return new Classpath(arrayList);
    }

    public static Classpath javaClasspath() {
        return new Classpath(System.getProperty("java.class.path"));
    }

    public static Classpath completeClasspath() {
        return new Classpath(new Classpath[]{Classpath.bootClasspath(), Classpath.javaExtensionClasspath(), Classpath.javaClasspath()});
    }

    public static Classpath classpathFor(Class clazz) {
        return new Classpath(Classpath.locationFor(clazz));
    }

    public static String convertToClassName(String string) {
        String string2 = FileTools.stripExtension(string);
        string2 = string2.replace('/', '.');
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '.');
        }
        return string2;
    }

    public static String convertToClassName(File file) {
        return Classpath.convertToClassName(file.getPath());
    }

    public static Class convertToClass(String string) throws ClassNotFoundException {
        return Class.forName(Classpath.convertToClassName(string));
    }

    public static Class convertToClass(File file) throws ClassNotFoundException {
        return Classpath.convertToClass(file.getPath());
    }

    public static String convertToArchiveEntryNameBase(String string) {
        return string.replace('.', '/');
    }

    public static String convertToArchiveEntryNameBase(Class clazz) {
        return Classpath.convertToArchiveEntryNameBase(clazz.getName());
    }

    public static String convertToArchiveClassFileEntryName(String string) {
        return Classpath.convertToArchiveEntryNameBase(string) + ".class";
    }

    public static String convertToArchiveClassFileEntryName(Class clazz) {
        return Classpath.convertToArchiveClassFileEntryName(clazz.getName());
    }

    public static String convertToFileNameBase(String string) {
        return string.replace('.', File.separatorChar);
    }

    public static String convertToFileNameBase(Class clazz) {
        return Classpath.convertToFileNameBase(clazz.getName());
    }

    public static String convertToClassFileName(String string) {
        return Classpath.convertToFileNameBase(string) + ".class";
    }

    public static String convertToClassFileName(Class clazz) {
        return Classpath.convertToClassFileName(clazz.getName());
    }

    public static File convertToClassFile(String string) {
        return new File(Classpath.convertToClassFileName(string));
    }

    public static File convertToClassFile(Class clazz) {
        return Classpath.convertToClassFile(clazz.getName());
    }

    public static String convertToJavaFileName(String string) {
        return Classpath.convertToFileNameBase(string) + ".java";
    }

    public static String convertToJavaFileName(Class clazz) {
        return Classpath.convertToJavaFileName(clazz.getName());
    }

    public static File convertToJavaFile(String string) {
        return new File(Classpath.convertToJavaFileName(string));
    }

    public static File convertToJavaFile(Class clazz) {
        return Classpath.convertToJavaFile(clazz.getName());
    }

    public static String convertToResourceName(Class clazz) {
        return '/' + Classpath.convertToArchiveClassFileEntryName(clazz);
    }

    public static URL convertToResource(Class clazz) {
        return clazz.getResource(Classpath.convertToResourceName(clazz));
    }

    public static boolean fileNameIsArchive(String string) {
        String string2 = FileTools.extension(string).toLowerCase();
        return string2.equals(".jar") || string2.equals(".zip");
    }

    public static boolean fileIsArchive(File file) {
        return Classpath.fileNameIsArchive(file.getName());
    }

    public static String rtJarName() {
        return Classpath.locationFor(Object.class);
    }

    public static String locationFor(Class clazz) {
        String string;
        URL uRL = Classpath.convertToResource(clazz);
        try {
            string = FileTools.buildFile(uRL).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        String string2 = uRL.getProtocol().toLowerCase();
        if (string2.equals("jar")) {
            return string.substring(0, string.indexOf(33));
        }
        if (string2.equals("file")) {
            return string.substring(0, string.length() - Classpath.convertToClassFileName(clazz).length() - 1);
        }
        throw new IllegalStateException(uRL.toString());
    }

    public static File[] javaExtensionDirectories() {
        return Classpath.convertToFiles(Classpath.javaExtensionDirectoryNames());
    }

    public static String[] javaExtensionDirectoryNames() {
        return System.getProperty("java.ext.dirs").split(File.pathSeparator);
    }

    private static File[] convertToFiles(String[] stringArray) {
        File[] fileArray = new File[stringArray.length];
        int n = stringArray.length;
        while (n-- > 0) {
            fileArray[n] = new File(stringArray[n]);
        }
        return fileArray;
    }

    private static void addJarFileNamesTo(File file, List list) {
        File[] fileArray = Classpath.jarFilesIn(file);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            list.add(FileTools.canonicalFile(fileArray[i]).getPath());
        }
    }

    private static File[] jarFilesIn(File file) {
        return file.listFiles(Classpath.jarFileFilter());
    }

    private static FileFilter jarFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return FileTools.extension(file.getName()).toLowerCase().equals(".jar");
            }
        };
    }

    private Classpath(Entry[] entryArray) {
        this.entries = entryArray;
    }

    public Classpath(String[] stringArray) {
        this(Classpath.buildEntries(stringArray));
    }

    private static Entry[] buildEntries(String[] stringArray) {
        int n = stringArray.length;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null || string.length() == 0) continue;
            arrayList.add(new Entry(string));
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    public Classpath(String string) {
        this(string.split(File.pathSeparator));
    }

    public Classpath(List list) {
        this(list.toArray(new String[list.size()]));
    }

    public Classpath(Classpath[] classpathArray) {
        this(Classpath.consolidateEntries(classpathArray));
    }

    private static Entry[] consolidateEntries(Classpath[] classpathArray) {
        int n = classpathArray.length;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            CollectionTools.addAll(arrayList, (Object[])classpathArray[i].getEntries());
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public String path() {
        Entry[] entryArray = this.entries;
        int n = entryArray.length - 1;
        if (n == -1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(2000);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(entryArray[i].fileName());
            stringBuffer.append(File.pathSeparatorChar);
        }
        stringBuffer.append(entryArray[n].fileName());
        return stringBuffer.toString();
    }

    public Entry entryForFileNamed(String string) {
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            if (!entryArray[i].file().getName().equals(string)) continue;
            return entryArray[i];
        }
        return null;
    }

    public Entry entryForClassNamed(String string) {
        String string2 = Classpath.convertToClassFileName(string);
        String string3 = Classpath.convertToArchiveClassFileEntryName(string);
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            if (!entryArray[i].contains(string2, string3)) continue;
            return entryArray[i];
        }
        return null;
    }

    public String[] classNames() {
        return this.classNames(Filter.NULL_INSTANCE);
    }

    public String[] classNames(Filter filter) {
        HashSet hashSet = new HashSet(10000);
        this.addClassNamesTo(hashSet, filter);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void addClassNamesTo(Collection collection) {
        this.addClassNamesTo(collection, Filter.NULL_INSTANCE);
    }

    public void addClassNamesTo(Collection collection, Filter filter) {
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            entryArray[i].addClassNamesTo(collection, filter);
        }
    }

    public Iterator classNamesStream() {
        return this.classNamesStream(Filter.NULL_INSTANCE);
    }

    public Iterator classNamesStream(Filter filter) {
        return new CompositeIterator(this.entryClassNamesStreams(filter));
    }

    private Iterator entryClassNamesStreams(final Filter filter) {
        return new TransformationIterator(new ArrayIterator(this.entries)){

            protected Object transform(Object object) {
                return ((Entry)object).classNamesStream(filter);
            }
        };
    }

    public Classpath compressed() {
        return new Classpath((Entry[])CollectionTools.removeDuplicateElements(this.entries));
    }

    public URL[] urls() {
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            uRLArray[i] = entryArray[i].url();
        }
        return uRLArray;
    }

    public static class Entry
    implements Serializable {
        private final String fileName;
        private final File file;
        private final File canonicalFile;
        private static final long serialVersionUID = 1L;

        Entry(String string) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("'fileName' must be non-empty");
            }
            this.fileName = string;
            this.file = new File(string);
            this.canonicalFile = FileTools.canonicalFile(this.file);
        }

        public String fileName() {
            return this.fileName;
        }

        public File file() {
            return this.file;
        }

        public File canonicalFile() {
            return this.canonicalFile;
        }

        public String canonicalFileName() {
            return this.canonicalFile.getAbsolutePath();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return ((Entry)object).canonicalFile.equals(this.canonicalFile);
        }

        public int hashCode() {
            return this.canonicalFile.hashCode();
        }

        public URL url() {
            try {
                return this.canonicalFile.toURL();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public boolean contains(Class clazz) {
            return this.contains(clazz.getName());
        }

        public boolean contains(String string) {
            return this.contains(Classpath.convertToClassFileName(string), Classpath.convertToArchiveClassFileEntryName(string));
        }

        boolean contains(String string, String string2) {
            if (!this.canonicalFile.exists()) {
                return false;
            }
            if (this.canonicalFile.isDirectory() && new File(this.canonicalFile, string).exists()) {
                return true;
            }
            return Classpath.fileIsArchive(this.canonicalFile) && this.archiveContainsEntry(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean archiveContainsEntry(String string) {
            ZipFile zipFile = null;
            ZipEntry zipEntry = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
                zipEntry = zipFile.getEntry(string);
            }
            catch (IOException iOException) {
                zipEntry = null;
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    zipEntry = null;
                }
            }
            return zipEntry != null;
        }

        public String[] classNames() {
            return this.classNames(Filter.NULL_INSTANCE);
        }

        public String[] classNames(Filter filter) {
            ArrayList arrayList = new ArrayList(2000);
            this.addClassNamesTo(arrayList, filter);
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public void addClassNamesTo(Collection collection) {
            this.addClassNamesTo(collection, Filter.NULL_INSTANCE);
        }

        public void addClassNamesTo(Collection collection, Filter filter) {
            if (this.canonicalFile.exists()) {
                if (this.canonicalFile.isDirectory()) {
                    this.addClassNamesForDirectoryTo(collection, filter);
                } else if (Classpath.fileIsArchive(this.canonicalFile)) {
                    this.addClassNamesForArchiveTo(collection, filter);
                }
            }
        }

        private void addClassNamesForDirectoryTo(Collection collection, Filter filter) {
            int n = this.canonicalFile.getAbsolutePath().length() + 1;
            Iterator iterator = this.classFilesForDirectory();
            while (iterator.hasNext()) {
                String string = Classpath.convertToClassName(((File)iterator.next()).getAbsolutePath().substring(n));
                if (!filter.accept(string)) continue;
                collection.add(string);
            }
        }

        private Iterator classFilesForDirectory() {
            return new FilteringIterator(FileTools.filesInTree(this.canonicalFile)){

                protected boolean accept(Object object) {
                    return Entry.this.fileNameMightBeForClassFile(((File)object).getName());
                }
            };
        }

        private void addClassNamesForArchiveTo(Collection collection, Filter filter) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
            }
            catch (IOException iOException) {
                return;
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!this.fileNameMightBeForClassFile(string2) || !filter.accept(string = Classpath.convertToClassName(string2))) continue;
                collection.add(string);
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                return;
            }
        }

        boolean fileNameMightBeForClassFile(String string) {
            return FileTools.extension(string).toLowerCase().equals(".class") && string.indexOf(32) == -1;
        }

        public Iterator classNamesStream() {
            return this.classNamesStream(Filter.NULL_INSTANCE);
        }

        public Iterator classNamesStream(Filter filter) {
            if (this.canonicalFile.exists()) {
                if (this.canonicalFile.isDirectory()) {
                    return this.classNamesForDirectory(filter);
                }
                if (Classpath.fileIsArchive(this.canonicalFile)) {
                    return this.classNamesForArchive(filter);
                }
            }
            return NullIterator.instance();
        }

        private Iterator classNamesForDirectory(Filter filter) {
            return new FilteringIterator(this.classNamesForDirectory(), filter);
        }

        private Iterator classNamesForDirectory() {
            final int n = this.canonicalFile.getAbsolutePath().length() + 1;
            return new TransformationIterator(this.classFilesForDirectory()){

                protected Object transform(Object object) {
                    return Classpath.convertToClassName(((File)object).getAbsolutePath().substring(n));
                }
            };
        }

        private Iterator classNamesForArchive(Filter filter) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
            }
            catch (IOException iOException) {
                return NullIterator.instance();
            }
            HashSet<String> hashSet = new HashSet<String>(zipFile.size());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!this.fileNameMightBeForClassFile(string2) || !filter.accept(string = Classpath.convertToClassName(string2))) continue;
                hashSet.add(string);
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                return NullIterator.instance();
            }
            return hashSet.iterator();
        }
    }
}

