/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.utility.Bag;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.Range;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public final class CollectionTools {
    private static final Random RANDOM = new Random();

    public static Object[] add(Object[] objectArray, Object object) {
        int n = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n + 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        return objectArray2;
    }

    public static Object[] add(Object[] objectArray, int n, Object object) {
        int n2 = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2 + 1);
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        objectArray2[n] = object;
        if (n2 > n) {
            System.arraycopy(objectArray, n, objectArray2, n + 1, n2 - n);
        }
        return objectArray2;
    }

    public static char[] add(char[] cArray, char c) {
        int n = cArray.length;
        char[] cArray2 = new char[n + 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        cArray2[n] = c;
        return cArray2;
    }

    public static char[] add(char[] cArray, int n, char c) {
        int n2 = cArray.length;
        char[] cArray2 = new char[n2 + 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        cArray2[n] = c;
        System.arraycopy(cArray, n, cArray2, n + 1, n2 - n);
        return cArray2;
    }

    public static int[] add(int[] nArray, int n) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        return nArray2;
    }

    public static int[] add(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        nArray2[n] = n2;
        System.arraycopy(nArray, n, nArray2, n + 1, n3 - n);
        return nArray2;
    }

    public static boolean addAll(Collection collection, Iterator iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static boolean addAll(Collection collection, Object[] objectArray) {
        boolean bl = false;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            bl |= collection.add(objectArray[i]);
        }
        return bl;
    }

    public static Object[] addAll(Object[] objectArray, Collection collection) {
        int n = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length + collection.size());
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        int n2 = n;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            objectArray2[n2] = iterator.next();
            ++n2;
        }
        return objectArray2;
    }

    public static Object[] addAll(Object[] objectArray, Iterator iterator) {
        return CollectionTools.addAll(objectArray, CollectionTools.list(iterator));
    }

    public static Object[] addAll(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        Object[] objectArray3 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n + n2);
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }

    public static Object[] addAll(Object[] objectArray, int n, Object[] objectArray2) {
        int n2 = objectArray.length;
        int n3 = objectArray2.length;
        Object[] objectArray3 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2 + n3);
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n3);
        System.arraycopy(objectArray, n, objectArray3, n + n3, n2 - n);
        return objectArray3;
    }

    public static char[] addAll(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        int n2 = cArray2.length;
        char[] cArray3 = new char[n + n2];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, n2);
        return cArray3;
    }

    public static char[] addAll(char[] cArray, int n, char[] cArray2) {
        int n2 = cArray.length;
        int n3 = cArray2.length;
        char[] cArray3 = new char[n2 + n3];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, n3);
        System.arraycopy(cArray, n, cArray3, n + n3, n2 - n);
        return cArray3;
    }

    public static int[] addAll(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n + n2];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, n2);
        return nArray3;
    }

    public static int[] addAll(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, n3);
        System.arraycopy(nArray, n, nArray3, n + n3, n2 - n);
        return nArray3;
    }

    public static Object[] array(Iterator iterator) {
        return CollectionTools.list(iterator).toArray();
    }

    public static Object[] array(Iterator iterator, Object[] objectArray) {
        return CollectionTools.list(iterator).toArray(objectArray);
    }

    public static Bag bag(Enumeration enumeration) {
        HashBag hashBag = new HashBag();
        while (enumeration.hasMoreElements()) {
            hashBag.add(enumeration.nextElement());
        }
        return hashBag;
    }

    public static Bag bag(Iterator iterator) {
        HashBag hashBag = new HashBag();
        while (iterator.hasNext()) {
            hashBag.add(iterator.next());
        }
        return hashBag;
    }

    public static Bag bag(Object[] objectArray) {
        HashBag hashBag = new HashBag(objectArray.length);
        int n = objectArray.length;
        while (n-- > 0) {
            hashBag.add(objectArray[n]);
        }
        return hashBag;
    }

    public static Collection collection(Enumeration enumeration) {
        return CollectionTools.bag(enumeration);
    }

    public static Collection collection(Iterator iterator) {
        return CollectionTools.bag(iterator);
    }

    public static Collection collection(Object[] objectArray) {
        return CollectionTools.bag(objectArray);
    }

    public static boolean contains(Enumeration enumeration, Object object) {
        if (object == null) {
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
        } else {
            while (enumeration.hasMoreElements()) {
                if (!object.equals(enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Iterator iterator, Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        if (object == null) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n] != null) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (!object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(char[] cArray, char c) {
        int n = cArray.length;
        while (n-- > 0) {
            if (cArray[n] != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] nArray, int n) {
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection collection, Object[] objectArray) {
        int n = objectArray.length;
        while (n-- > 0) {
            if (collection.contains(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Iterator iterator, Collection collection) {
        return CollectionTools.collection(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator iterator, Iterator iterator2) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), iterator2);
    }

    public static boolean containsAll(Iterator iterator, Object[] objectArray) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), objectArray);
    }

    public static boolean containsAll(Object[] objectArray, Collection collection) {
        return CollectionTools.containsAll(objectArray, collection.iterator());
    }

    public static boolean containsAll(Object[] objectArray, Iterator iterator) {
        while (iterator.hasNext()) {
            if (CollectionTools.contains(objectArray, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray2.length;
        while (n-- > 0) {
            if (CollectionTools.contains(objectArray, objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] cArray, char[] cArray2) {
        int n = cArray2.length;
        while (n-- > 0) {
            if (CollectionTools.contains(cArray, cArray2[n])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int[] nArray, int[] nArray2) {
        int n = nArray2.length;
        while (n-- > 0) {
            if (CollectionTools.contains(nArray, nArray2[n])) continue;
            return false;
        }
        return true;
    }

    public static int diffEnd(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.diffEnd(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }

    public static int diffEnd(List list, List list2) {
        int n;
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return Math.max(n2, n) - 1;
        }
        int n3 = n2 - 1;
        while (n3 > -1) {
            Object e = list.get(n3);
            if (e == null) {
                if (list2.get(n3) == null) {
                    --n3;
                    continue;
                }
                return n3;
            }
            if (e.equals(list2.get(n3))) {
                --n3;
                continue;
            }
            return n3;
        }
        return n3;
    }

    public static Range diffRange(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.diffRange(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }

    public static Range diffRange(List list, List list2) {
        int n = CollectionTools.diffEnd(list, list2);
        if (n == -1) {
            return new Range(list.size(), n);
        }
        return new Range(CollectionTools.diffStart(list, list2), n);
    }

    public static int diffStart(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.diffStart(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }

    public static int diffStart(List list, List list2) {
        int n = Math.min(list.size(), list2.size());
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e == null) {
                if (list2.get(n2) == null) {
                    ++n2;
                    continue;
                }
                return n2;
            }
            if (e.equals(list2.get(n2))) {
                ++n2;
                continue;
            }
            return n2;
        }
        return n2;
    }

    public static boolean equals(ListIterator listIterator, ListIterator listIterator2) {
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public static Object get(ListIterator listIterator, int n) {
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (listIterator.previousIndex() != n) continue;
            return e;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n) + ':' + String.valueOf(listIterator.previousIndex()));
    }

    public static boolean identical(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        int n2 = n;
        while (n2-- > 0) {
            if (objectArray[n2] == objectArray2[n2]) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(ListIterator listIterator, ListIterator listIterator2) {
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            if (listIterator.next() == listIterator2.next()) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public static int identityDiffEnd(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.identityDiffEnd(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }

    public static int identityDiffEnd(List list, List list2) {
        int n;
        int n2;
        int n3 = list.size();
        if (n3 != (n2 = list2.size())) {
            return Math.max(n3, n2) - 1;
        }
        for (n = n3 - 1; n > -1; --n) {
            if (list.get(n) == list2.get(n)) {
                continue;
            }
            return n;
        }
        return n;
    }

    public static Range identityDiffRange(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.identityDiffRange(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }

    public static Range identityDiffRange(List list, List list2) {
        int n = CollectionTools.identityDiffEnd(list, list2);
        if (n == -1) {
            return new Range(list.size(), n);
        }
        return new Range(CollectionTools.identityDiffStart(list, list2), n);
    }

    public static int identityDiffStart(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.identityDiffStart(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }

    public static int identityDiffStart(List list, List list2) {
        int n;
        int n2 = Math.min(list.size(), list2.size());
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == list2.get(n)) {
                continue;
            }
            return n;
        }
        return n;
    }

    public static int indexOf(ListIterator listIterator, Object object) {
        if (object == null) {
            int n = 0;
            while (listIterator.hasNext()) {
                if (listIterator.next() == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (listIterator.hasNext()) {
                if (object.equals(listIterator.next())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        int n = objectArray.length;
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] cArray, char c) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int insertionIndexOf(List list, Comparable comparable) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (comparable.compareTo(list.get(i)) >= 0) continue;
            return i;
        }
        return n;
    }

    public static int insertionIndexOf(List list, Object object, Comparator comparator) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (comparator.compare(object, list.get(i)) >= 0) continue;
            return i;
        }
        return n;
    }

    public static int insertionIndexOf(Object[] objectArray, Comparable comparable) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (comparable.compareTo(objectArray[i]) >= 0) continue;
            return i;
        }
        return n;
    }

    public static int insertionIndexOf(Object[] objectArray, Object object, Comparator comparator) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (comparator.compare(object, objectArray[i]) >= 0) continue;
            return i;
        }
        return n;
    }

    public static Iterator iterator(Object[] objectArray) {
        return new ArrayIterator(objectArray);
    }

    public static int lastIndexOf(ListIterator listIterator, Object object) {
        return CollectionTools.list(listIterator).lastIndexOf(object);
    }

    public static int lastIndexOf(Object[] objectArray, Object object) {
        int n = objectArray.length;
        if (object == null) {
            int n2 = n;
            while (n2-- > 0) {
                if (objectArray[n2] != null) continue;
                return n2;
            }
        } else {
            int n3 = n;
            while (n3-- > 0) {
                if (!object.equals(objectArray[n3])) continue;
                return n3;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, char c) {
        int n = cArray.length;
        while (n-- > 0) {
            if (cArray[n] != c) continue;
            return n;
        }
        return -1;
    }

    public static int lastIndexOf(int[] nArray, int n) {
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    public static List list(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static List list(Object[] objectArray) {
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public static ListIterator listIterator(Object[] objectArray) {
        return CollectionTools.listIterator(objectArray, 0);
    }

    public static ListIterator listIterator(Object[] objectArray, int n) {
        return Arrays.asList(objectArray).listIterator(n);
    }

    public static char max(char[] cArray) {
        int n = cArray.length;
        if (n == 0) {
            throw new IndexOutOfBoundsException();
        }
        char c = cArray[0];
        for (int i = 1; i < n; ++i) {
            char c2 = cArray[i];
            if (c2 <= c) continue;
            c = c2;
        }
        return c;
    }

    public static int max(int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static char min(char[] cArray) {
        int n = cArray.length;
        if (n == 0) {
            throw new IndexOutOfBoundsException();
        }
        char c = cArray[0];
        for (int i = 1; i < n; ++i) {
            char c2 = cArray[i];
            if (c2 >= c) continue;
            c = c2;
        }
        return c;
    }

    public static int min(int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static Object[] replaceAll(Object[] objectArray, Object object, Object object2) {
        if (object == null) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n] != null) continue;
                objectArray[n] = object2;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (!object.equals(objectArray[n])) continue;
                objectArray[n] = object2;
            }
        }
        return objectArray;
    }

    public static int[] replaceAll(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        while (n3-- > 0) {
            if (nArray[n3] != n) continue;
            nArray[n3] = n2;
        }
        return nArray;
    }

    public static char[] replaceAll(char[] cArray, char c, char c2) {
        int n = cArray.length;
        while (n-- > 0) {
            if (cArray[n] != c) continue;
            cArray[n] = c2;
        }
        return cArray;
    }

    public static Object[] remove(Object[] objectArray, Object object) {
        int n = CollectionTools.indexOf(objectArray, object);
        int n2 = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2 - 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, n2 - n - 1);
        return objectArray2;
    }

    public static char[] remove(char[] cArray, char c) {
        int n = CollectionTools.indexOf(cArray, c);
        int n2 = cArray.length;
        char[] cArray2 = new char[n2 - 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        System.arraycopy(cArray, n + 1, cArray2, n, n2 - n - 1);
        return cArray2;
    }

    public static int[] remove(int[] nArray, int n) {
        int n2 = CollectionTools.indexOf(nArray, n);
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 - 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        System.arraycopy(nArray, n2 + 1, nArray2, n2, n3 - n2 - 1);
        return nArray2;
    }

    public static boolean removeAll(Collection collection, Iterator iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.remove(iterator.next());
        }
        return bl;
    }

    public static boolean removeAll(Collection collection, Object[] objectArray) {
        boolean bl = false;
        int n = objectArray.length;
        while (n-- > 0) {
            bl |= collection.remove(objectArray[n]);
        }
        return bl;
    }

    public static Object[] removeAll(Object[] objectArray, Collection collection) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        while (n-- > 0) {
            Object object = objectArray[n];
            if (!collection.contains(object)) continue;
            objectArray2 = CollectionTools.remove(objectArray2, object);
        }
        return objectArray2;
    }

    public static Object[] removeAll(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.removeAll(objectArray, CollectionTools.bag(objectArray2));
    }

    public static char[] removeAll(char[] cArray, char[] cArray2) {
        char[] cArray3 = cArray;
        int n = cArray.length;
        while (n-- > 0) {
            char c = cArray[n];
            if (!CollectionTools.contains(cArray2, c)) continue;
            cArray3 = CollectionTools.remove(cArray3, c);
        }
        return cArray3;
    }

    public static int[] removeAll(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        int n = nArray.length;
        while (n-- > 0) {
            int n2 = nArray[n];
            if (!CollectionTools.contains(nArray2, n2)) continue;
            nArray3 = CollectionTools.remove(nArray3, n2);
        }
        return nArray3;
    }

    public static boolean removeAllOccurrences(Collection collection, Object object) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                bl = true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    public static Object[] removeAllOccurrences(Object[] objectArray, Object object) {
        Object[] objectArray2 = objectArray;
        if (object == null) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n] != null) continue;
                objectArray2 = CollectionTools.remove(objectArray2, null);
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (!object.equals(objectArray[n])) continue;
                objectArray2 = CollectionTools.remove(objectArray2, object);
            }
        }
        return objectArray2;
    }

    public static char[] removeAllOccurrences(char[] cArray, char c) {
        char[] cArray2 = cArray;
        int n = cArray.length;
        while (n-- > 0) {
            if (cArray[n] != c) continue;
            cArray2 = CollectionTools.remove(cArray2, c);
        }
        return cArray2;
    }

    public static int[] removeAllOccurrences(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            nArray2 = CollectionTools.remove(nArray2, n);
        }
        return nArray2;
    }

    public static Object[] removeDuplicateElements(Object[] objectArray) {
        List list = CollectionTools.removeDuplicateElements(Arrays.asList(objectArray));
        return list.toArray((Object[])Array.newInstance(objectArray.getClass().getComponentType(), list.size()));
    }

    public static List removeDuplicateElements(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        HashSet hashSet = new HashSet(list.size());
        for (Object e : list) {
            if (!hashSet.add(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static boolean retainAll(Collection collection, Iterator iterator) {
        return collection.retainAll(CollectionTools.collection(iterator));
    }

    public static boolean retainAll(Collection collection, Object[] objectArray) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CollectionTools.contains(objectArray, iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static Object[] retainAll(Object[] objectArray, Collection collection) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        while (n-- > 0) {
            Object object = objectArray[n];
            if (collection.contains(object)) continue;
            objectArray2 = CollectionTools.remove(objectArray2, object);
        }
        return objectArray2;
    }

    public static Object[] retainAll(Object[] objectArray, Object[] objectArray2) {
        return CollectionTools.retainAll(objectArray, CollectionTools.bag(objectArray2));
    }

    public static char[] retainAll(char[] cArray, char[] cArray2) {
        char[] cArray3 = cArray;
        int n = cArray.length;
        while (n-- > 0) {
            char c = cArray[n];
            if (CollectionTools.contains(cArray2, c)) continue;
            cArray3 = CollectionTools.remove(cArray3, c);
        }
        return cArray3;
    }

    public static int[] retainAll(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        int n = nArray.length;
        while (n-- > 0) {
            int n2 = nArray[n];
            if (CollectionTools.contains(nArray2, n2)) continue;
            nArray3 = CollectionTools.remove(nArray3, n2);
        }
        return nArray3;
    }

    public static Object[] reverse(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        int n3 = n >> 1;
        int n4 = n - 1;
        while (n2 < n3) {
            CollectionTools.swap(objectArray, n2, n4);
            ++n2;
            --n4;
        }
        return objectArray;
    }

    public static char[] reverse(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        int n3 = n >> 1;
        int n4 = n - 1;
        while (n2 < n3) {
            CollectionTools.swap(cArray, n2, n4);
            ++n2;
            --n4;
        }
        return cArray;
    }

    public static int[] reverse(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = n >> 1;
        int n4 = n - 1;
        while (n2 < n3) {
            CollectionTools.swap(nArray, n2, n4);
            ++n2;
            --n4;
        }
        return nArray;
    }

    public static List reverseList(Iterator iterator) {
        return CollectionTools.reverse(CollectionTools.list(iterator));
    }

    public static Object[] rotate(Object[] objectArray) {
        return CollectionTools.rotate(objectArray, 1);
    }

    public static Object[] rotate(Object[] objectArray, int n) {
        int n2 = objectArray.length;
        if (n2 == 0) {
            return objectArray;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return objectArray;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            Object object = objectArray[n3];
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                Object object2 = objectArray[n5];
                objectArray[n5] = object;
                object = object2;
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
        return objectArray;
    }

    public static char[] rotate(char[] cArray) {
        return CollectionTools.rotate(cArray, 1);
    }

    public static char[] rotate(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n2 == 0) {
            return cArray;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return cArray;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            char c = cArray[n3];
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                char c2 = cArray[n5];
                cArray[n5] = c;
                c = c2;
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
        return cArray;
    }

    public static int[] rotate(int[] nArray) {
        return CollectionTools.rotate(nArray, 1);
    }

    public static int[] rotate(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 == 0) {
            return nArray;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return nArray;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            int n5 = nArray[n3];
            int n6 = n3;
            do {
                if ((n6 += n) >= n2) {
                    n6 -= n2;
                }
                int n7 = nArray[n6];
                nArray[n6] = n5;
                n5 = n7;
                ++n4;
            } while (n6 != n3);
            ++n3;
        }
        return nArray;
    }

    public static Set set(Iterator iterator) {
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static Set set(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length);
        int n = objectArray.length;
        while (n-- > 0) {
            hashSet.add(objectArray[n]);
        }
        return hashSet;
    }

    public static Object[] shuffle(Object[] objectArray) {
        return CollectionTools.shuffle(objectArray, RANDOM);
    }

    public static Object[] shuffle(Object[] objectArray, Random random) {
        int n = objectArray.length;
        while (n-- > 0) {
            CollectionTools.swap(objectArray, n, random.nextInt(n));
        }
        return objectArray;
    }

    public static char[] shuffle(char[] cArray) {
        return CollectionTools.shuffle(cArray, RANDOM);
    }

    public static char[] shuffle(char[] cArray, Random random) {
        int n = cArray.length;
        while (n-- > 0) {
            CollectionTools.swap(cArray, n, random.nextInt(n));
        }
        return cArray;
    }

    public static int[] shuffle(int[] nArray) {
        return CollectionTools.shuffle(nArray, RANDOM);
    }

    public static int[] shuffle(int[] nArray, Random random) {
        int n = nArray.length;
        while (n-- > 0) {
            CollectionTools.swap(nArray, n, random.nextInt(n));
        }
        return nArray;
    }

    public static Iterator singletonIterator(Object object) {
        return new SingleElementIterator(object);
    }

    public static int size(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static SortedSet sortedSet(Iterator iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static SortedSet sortedSet(Iterator iterator, Comparator comparator) {
        TreeSet treeSet = new TreeSet(comparator);
        treeSet.addAll(CollectionTools.list(iterator));
        return treeSet;
    }

    public static SortedSet sortedSet(Object[] objectArray) {
        return CollectionTools.sortedSet(objectArray, null);
    }

    public static SortedSet sortedSet(Object[] objectArray, Comparator comparator) {
        TreeSet<Object> treeSet = new TreeSet<Object>(comparator);
        treeSet.addAll(Arrays.asList(objectArray));
        return treeSet;
    }

    public static Object[] swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
        return objectArray;
    }

    public static char[] swap(char[] cArray, int n, int n2) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
        return cArray;
    }

    public static int[] swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
        return nArray;
    }

    public static Vector vector(Iterator iterator) {
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public static Vector vector(Object[] objectArray) {
        int n = objectArray.length;
        Vector<Object> vector = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }

    public static List copy(List list, List list2) {
        Collections.copy(list, list2);
        return list;
    }

    public static List fill(List list, Object object) {
        Collections.fill(list, object);
        return list;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static List rotate(List list) {
        return CollectionTools.rotate(list, 1);
    }

    public static List rotate(List list, int n) {
        Collections.rotate(list, n);
        return list;
    }

    public static List shuffle(List list) {
        Collections.shuffle(list);
        return list;
    }

    public static List shuffle(List list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static List sort(List list) {
        Collections.sort(list);
        return list;
    }

    public static List sort(List list, Comparator comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static List sort(Iterator iterator) {
        List list = CollectionTools.list(iterator);
        Collections.sort(list);
        return list;
    }

    public static List sort(Iterator iterator, Comparator comparator) {
        List list = CollectionTools.list(iterator);
        Collections.sort(list, comparator);
        return list;
    }

    public static List swap(List list, int n, int n2) {
        Collections.swap(list, n, n2);
        return list;
    }

    public static boolean[] fill(boolean[] blArray, boolean bl) {
        Arrays.fill(blArray, bl);
        return blArray;
    }

    public static boolean[] fill(boolean[] blArray, int n, int n2, boolean bl) {
        Arrays.fill(blArray, n, n2, bl);
        return blArray;
    }

    public static byte[] fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, by);
        return byArray;
    }

    public static byte[] fill(byte[] byArray, int n, int n2, byte by) {
        Arrays.fill(byArray, n, n2, by);
        return byArray;
    }

    public static char[] fill(char[] cArray, char c) {
        Arrays.fill(cArray, c);
        return cArray;
    }

    public static char[] fill(char[] cArray, int n, int n2, char c) {
        Arrays.fill(cArray, n, n2, c);
        return cArray;
    }

    public static double[] fill(double[] dArray, double d) {
        Arrays.fill(dArray, d);
        return dArray;
    }

    public static double[] fill(double[] dArray, int n, int n2, double d) {
        Arrays.fill(dArray, n, n2, d);
        return dArray;
    }

    public static float[] fill(float[] fArray, float f) {
        Arrays.fill(fArray, f);
        return fArray;
    }

    public static float[] fill(float[] fArray, int n, int n2, float f) {
        Arrays.fill(fArray, n, n2, f);
        return fArray;
    }

    public static int[] fill(int[] nArray, int n) {
        Arrays.fill(nArray, n);
        return nArray;
    }

    public static int[] fill(int[] nArray, int n, int n2, int n3) {
        Arrays.fill(nArray, n, n2, n3);
        return nArray;
    }

    public static Object[] fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, object);
        return objectArray;
    }

    public static Object[] fill(Object[] objectArray, int n, int n2, Object object) {
        Arrays.fill(objectArray, n, n2, object);
        return objectArray;
    }

    public static long[] fill(long[] lArray, long l) {
        Arrays.fill(lArray, l);
        return lArray;
    }

    public static long[] fill(long[] lArray, int n, int n2, long l) {
        Arrays.fill(lArray, n, n2, l);
        return lArray;
    }

    public static short[] fill(short[] sArray, short s) {
        Arrays.fill(sArray, s);
        return sArray;
    }

    public static short[] fill(short[] sArray, int n, int n2, short s) {
        Arrays.fill(sArray, n, n2, s);
        return sArray;
    }

    public static byte[] sort(byte[] byArray) {
        Arrays.sort(byArray);
        return byArray;
    }

    public static byte[] sort(byte[] byArray, int n, int n2) {
        Arrays.sort(byArray, n, n2);
        return byArray;
    }

    public static char[] sort(char[] cArray) {
        Arrays.sort(cArray);
        return cArray;
    }

    public static char[] sort(char[] cArray, int n, int n2) {
        Arrays.sort(cArray, n, n2);
        return cArray;
    }

    public static double[] sort(double[] dArray) {
        Arrays.sort(dArray);
        return dArray;
    }

    public static double[] sort(double[] dArray, int n, int n2) {
        Arrays.sort(dArray, n, n2);
        return dArray;
    }

    public static float[] sort(float[] fArray) {
        Arrays.sort(fArray);
        return fArray;
    }

    public static float[] sort(float[] fArray, int n, int n2) {
        Arrays.sort(fArray, n, n2);
        return fArray;
    }

    public static int[] sort(int[] nArray) {
        Arrays.sort(nArray);
        return nArray;
    }

    public static int[] sort(int[] nArray, int n, int n2) {
        Arrays.sort(nArray, n, n2);
        return nArray;
    }

    public static Object[] sort(Object[] objectArray) {
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static Object[] sort(Object[] objectArray, Comparator comparator) {
        Arrays.sort(objectArray, comparator);
        return objectArray;
    }

    public static Object[] sort(Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray, n, n2);
        return objectArray;
    }

    public static Object[] sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        Arrays.sort(objectArray, n, n2, comparator);
        return objectArray;
    }

    public static long[] sort(long[] lArray) {
        Arrays.sort(lArray);
        return lArray;
    }

    public static long[] sort(long[] lArray, int n, int n2) {
        Arrays.sort(lArray, n, n2);
        return lArray;
    }

    public static short[] sort(short[] sArray) {
        Arrays.sort(sArray);
        return sArray;
    }

    public static short[] sort(short[] sArray, int n, int n2) {
        Arrays.sort(sArray, n, n2);
        return sArray;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

