/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClass;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class AttributePool {
    private ClassFile classFile;
    private short count;
    private Attribute[] attributes;
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    AttributePool(ClassFileDataInputStream classFileDataInputStream, ClassFile classFile) throws IOException {
        this.classFile = classFile;
        this.initialize(classFileDataInputStream);
    }

    private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        Attribute[] attributeArray = this.attributes = new Attribute[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            attributeArray[s2] = Attribute.read(classFileDataInputStream, this);
        }
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        if (s == 0) {
            return;
        }
        indentingPrintWriter.print("Attribute Pool (count: ");
        indentingPrintWriter.print(s);
        indentingPrintWriter.println(')');
        indentingPrintWriter.indent();
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            attributeArray[s2].displayStringOn(indentingPrintWriter);
        }
        indentingPrintWriter.undent();
    }

    public InnerClass innerClassNamed(String string) {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            InnerClass innerClass = attributeArray[s2].innerClassNamed(string);
            if (innerClass == null) continue;
            return innerClass;
        }
        throw new IllegalArgumentException(string);
    }

    public Object fieldConstantValue() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            Object object = attributeArray[s2].fieldConstantValue();
            if (object == null) continue;
            return object;
        }
        throw new IllegalStateException();
    }

    public void printFieldInitializationClauseOn(PrintWriter printWriter) {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            attributeArray[s2].printFieldInitializationClauseOn(printWriter);
        }
    }

    public String[] exceptionClassNames() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String[] stringArray = attributeArray[s2].exceptionClassNames();
            if (stringArray == null) continue;
            return stringArray;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String declaringClassName() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String string = attributeArray[s2].declaringClassName();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String nestedClassName() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String string = attributeArray[s2].nestedClassName();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public short nestedClassAccessFlags() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            short s3 = attributeArray[s2].nestedClassAccessFlags();
            if (s3 == 0) continue;
            return s3;
        }
        return 0;
    }

    public String[] nestedClassNames() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String[] stringArray = attributeArray[s2].nestedClassNames();
            if (stringArray == null) continue;
            return stringArray;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] declaredMemberClassNames() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String[] stringArray = attributeArray[s2].declaredMemberClassNames();
            if (stringArray == null) continue;
            return stringArray;
        }
        return EMPTY_STRING_ARRAY;
    }

    public void printThrowsClauseOn(PrintWriter printWriter) {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            attributeArray[s2].printThrowsClauseOn(printWriter);
        }
    }

    public boolean isDeprecated() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!attributeArray[s2].isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public boolean isSynthetic() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!attributeArray[s2].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    public boolean isNestedClass() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!attributeArray[s2].isNestedClass()) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberClass() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!attributeArray[s2].isMemberClass()) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalClass() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!attributeArray[s2].isLocalClass()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnonymousClass() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!attributeArray[s2].isAnonymousClass()) continue;
            return true;
        }
        return false;
    }

    public String sourceFileName() {
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String string = attributeArray[s2].sourceFileName();
            if (string == null) continue;
            return string;
        }
        return EMPTY_STRING;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public ConstantPool constantPool() {
        return this.classFile.getConstantPool();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        Attribute[] attributeArray = this.attributes;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            attributeArray[s2].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public Attribute get(short s) {
        return this.attributes[s];
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " attribute(s))";
    }
}

